/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletMetadataIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(TabletMetadataIT.class);
    private static final int NUM_TSERVERS = 3;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration conf) {
        cfg.setNumTservers(3);
    }

    @Test
    public void getLiveTServersTest() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            while (c.instanceOperations().getTabletServers().size() != 3) {
                log.info("Waiting for tservers to start up...");
                UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            Set servers = TabletMetadata.getLiveTServers((ClientContext)((ClientContext)c));
            Assertions.assertEquals((int)3, (int)servers.size());
            this.getCluster().killProcess(ServerType.TABLET_SERVER, (ProcessReference)((Collection)this.getCluster().getProcesses().get(ServerType.TABLET_SERVER)).iterator().next());
            while (c.instanceOperations().getTabletServers().size() == 3) {
                log.info("Waiting for a tserver to die...");
                UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            servers = TabletMetadata.getLiveTServers((ClientContext)((ClientContext)c));
            Assertions.assertEquals((int)2, (int)servers.size());
        }
    }
}

