/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.manager.thrift.ManagerState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.manager.state.CurrentState;
import org.apache.accumulo.server.manager.state.MergeInfo;
import org.apache.accumulo.server.manager.state.MetaDataTableScanner;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletStateChangeIteratorIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(TabletStateChangeIteratorIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(3L);
    }

    @Test
    public void test() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        try (final AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(TabletStateChangeIteratorIT.getClientProps()).build();){
            String[] tables = this.getUniqueNames(6);
            String t1 = tables[0];
            String t2 = tables[1];
            final String t3 = tables[2];
            String metaCopy1 = tables[3];
            String metaCopy2 = tables[4];
            String metaCopy3 = tables[5];
            this.createTable(client, t1, true);
            this.createTable(client, t2, false);
            this.createTable(client, t3, true);
            this.copyTable(client, MetadataTable.NAME, metaCopy1);
            State state = new State(client);
            int tabletsInFlux = this.findTabletsNeedingAttention(client, metaCopy1, state);
            while (tabletsInFlux > 0) {
                log.debug("Waiting for {} tablets for {}", (Object)tabletsInFlux, (Object)metaCopy1);
                UtilWaitThread.sleep((long)500L);
                this.copyTable(client, MetadataTable.NAME, metaCopy1);
                tabletsInFlux = this.findTabletsNeedingAttention(client, metaCopy1, state);
            }
            Assertions.assertEquals((int)0, (int)this.findTabletsNeedingAttention(client, metaCopy1, state), (String)"No tables should need attention");
            this.copyTable(client, metaCopy1, metaCopy2);
            this.copyTable(client, metaCopy1, metaCopy3);
            this.removeLocation(client, metaCopy1, t3);
            Assertions.assertEquals((int)2, (int)this.findTabletsNeedingAttention(client, metaCopy1, state), (String)"Should have two tablets without a loc");
            this.reassignLocation(client, metaCopy2, t3);
            Assertions.assertEquals((int)1, (int)this.findTabletsNeedingAttention(client, metaCopy2, state), (String)"Should have one tablet that needs to be unassigned");
            state = new State(client){

                @Override
                public Collection<MergeInfo> merges() {
                    TableId tableIdToModify = TableId.of((String)((String)client.tableOperations().tableIdMap().get(t3)));
                    return Collections.singletonList(new MergeInfo(new KeyExtent(tableIdToModify, null, null), MergeInfo.Operation.MERGE));
                }
            };
            Assertions.assertEquals((int)1, (int)this.findTabletsNeedingAttention(client, metaCopy2, state), (String)"Should have 2 tablets that need to be chopped or unassigned");
            state = new State(client);
            this.addDuplicateLocation(client, metaCopy3, t3);
            Assertions.assertEquals((int)1, (int)this.findTabletsNeedingAttention(client, metaCopy3, state), (String)"Should have 1 tablet that needs a metadata repair");
            this.dropTables(client, t1, t2, t3, metaCopy1, metaCopy2, metaCopy3);
        }
    }

    private void addDuplicateLocation(AccumuloClient client, String table, String tableNameToModify) throws TableNotFoundException, MutationsRejectedException {
        TableId tableIdToModify = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableNameToModify)));
        Mutation m = new Mutation(new KeyExtent(tableIdToModify, null, null).toMetaRow());
        m.put(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, new Text("1234567"), new Value((CharSequence)"fake:9005"));
        try (BatchWriter bw = client.createBatchWriter(table);){
            bw.addMutation(m);
        }
    }

    private void reassignLocation(AccumuloClient client, String table, String tableNameToModify) throws TableNotFoundException, MutationsRejectedException {
        TableId tableIdToModify = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableNameToModify)));
        try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
            scanner.setRange(new KeyExtent(tableIdToModify, null, null).toMetaRange());
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            Map.Entry entry = (Map.Entry)scanner.iterator().next();
            Mutation m = new Mutation(((Key)entry.getKey()).getRow());
            m.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier(), ((Key)entry.getKey()).getTimestamp());
            m.put(((Key)entry.getKey()).getColumnFamily(), new Text("1234567"), ((Key)entry.getKey()).getTimestamp() + 1L, new Value((CharSequence)"fake:9005"));
            try (BatchWriter bw = client.createBatchWriter(table);){
                bw.addMutation(m);
            }
        }
    }

    private void removeLocation(AccumuloClient client, String table, String tableNameToModify) throws TableNotFoundException, MutationsRejectedException {
        TableId tableIdToModify = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableNameToModify)));
        BatchDeleter deleter = client.createBatchDeleter(table, Authorizations.EMPTY, 1);
        deleter.setRanges(Collections.singleton(new KeyExtent(tableIdToModify, null, null).toMetaRange()));
        deleter.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        deleter.delete();
        deleter.close();
    }

    private int findTabletsNeedingAttention(AccumuloClient client, String table, State state) throws TableNotFoundException {
        int results = 0;
        ArrayList<Key> resultList = new ArrayList<Key>();
        try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
            MetaDataTableScanner.configureScanner((ScannerBase)scanner, (CurrentState)state);
            log.debug("Current state = {}", (Object)state);
            scanner.updateScanIteratorOption("tabletChange", "debug", "1");
            for (Map.Entry e : scanner) {
                if (e == null) continue;
                ++results;
                resultList.add((Key)e.getKey());
            }
        }
        log.debug("Tablets in flux: {}", resultList);
        return results;
    }

    private void createTable(AccumuloClient client, String t, boolean online) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, TableExistsException {
        TreeSet<Text> partitionKeys = new TreeSet<Text>();
        partitionKeys.add(new Text("some split"));
        NewTableConfiguration ntc = new NewTableConfiguration().withSplits(partitionKeys);
        client.tableOperations().create(t, ntc);
        client.tableOperations().online(t, true);
        if (!online) {
            client.tableOperations().offline(t, true);
        }
    }

    private void copyTable(AccumuloClient client, String source, String copy) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        try {
            this.dropTables(client, copy);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        log.info("Gathering rows to copy {} ", (Object)source);
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        try (Scanner scanner = client.createScanner(source, Authorizations.EMPTY);){
            RowIterator rows = new RowIterator((Iterable)new IsolatedScanner(scanner));
            while (rows.hasNext()) {
                Iterator row = rows.next();
                Mutation m = null;
                while (row.hasNext()) {
                    Map.Entry entry = (Map.Entry)row.next();
                    Key k = (Key)entry.getKey();
                    if (m == null) {
                        m = new Mutation(k.getRow());
                    }
                    m.put(k.getColumnFamily(), k.getColumnQualifier(), k.getColumnVisibilityParsed(), k.getTimestamp(), (Value)entry.getValue());
                }
                mutations.add(m);
            }
        }
        log.debug("Gathered {} rows to create copy {}", (Object)mutations.size(), (Object)copy);
        Assertions.assertEquals((int)7, (int)mutations.size(), (String)"Metadata should have 7 rows (1 repl + 2 for each table)");
        client.tableOperations().create(copy);
        try (BatchWriter writer = client.createBatchWriter(copy);){
            for (Mutation m : mutations) {
                writer.addMutation(m);
            }
        }
        log.info("Finished creating copy " + copy);
    }

    private void dropTables(AccumuloClient client, String ... tables) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        for (String t : tables) {
            client.tableOperations().delete(t);
        }
    }

    private static class State
    implements CurrentState {
        final ClientContext context;
        private Set<TServerInstance> tservers;
        private Set<TableId> onlineTables;

        State(AccumuloClient client) {
            this.context = (ClientContext)client;
        }

        public Set<TServerInstance> onlineTabletServers() {
            HashSet<TServerInstance> tservers = new HashSet<TServerInstance>();
            for (String tserver : this.context.instanceOperations().getTabletServers()) {
                try {
                    ServiceLock.ServiceLockPath zPath = ServiceLock.path((String)(ZooUtil.getRoot((InstanceId)this.context.instanceOperations().getInstanceId()) + "/tservers/" + tserver));
                    long sessionId = ServiceLock.getSessionId((ZooCache)this.context.getZooCache(), (ServiceLock.ServiceLockPath)zPath);
                    tservers.add(new TServerInstance(tserver, sessionId));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.tservers = Collections.unmodifiableSet(tservers);
            return tservers;
        }

        public Set<TableId> onlineTables() {
            Set onlineTables = this.context.getTableIdToNameMap().keySet();
            this.onlineTables = Sets.filter(onlineTables, tableId -> this.context.getTableState(tableId) == TableState.ONLINE);
            return this.onlineTables;
        }

        public Collection<MergeInfo> merges() {
            return Collections.emptySet();
        }

        public Set<KeyExtent> migrationsSnapshot() {
            return Collections.emptySet();
        }

        public Set<TServerInstance> shutdownServers() {
            return Collections.emptySet();
        }

        public ManagerState getManagerState() {
            return ManagerState.NORMAL;
        }

        public String toString() {
            return "tservers: " + this.tservers + " onlineTables: " + this.onlineTables;
        }
    }
}

