/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="MiniClusterOnly")
public class ThriftMaxFrameSizeIT {
    private ThriftServerType serverType;
    private static final int CONFIGURED_MAX_FRAME_SIZE = 0x2000000;

    protected abstract class TestMaxFrameSize
    extends ConfigurableMacBase {
        protected TestMaxFrameSize() {
        }

        @Override
        protected Duration defaultTimeout() {
            return Duration.ofMinutes(2L);
        }

        @Override
        public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
            cfg.setNumTservers(1);
            cfg.setProperty(Property.GENERAL_RPC_SERVER_TYPE, ThriftMaxFrameSizeIT.this.serverType.name());
            String maxFrameSizeStr = Integer.toString(0x2000000);
            cfg.setProperty(Property.RPC_MAX_MESSAGE_SIZE, maxFrameSizeStr);
            if (ThriftMaxFrameSizeIT.this.serverType == ThriftServerType.SSL) {
                TestMaxFrameSize.configureForSsl(cfg, TestMaxFrameSize.getSslDir(TestMaxFrameSize.createTestDir(this.getClass().getName() + "_" + this.testName())));
            }
        }

        private void testWithSpecificSize(int testSize) throws Exception {
            try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(this.cluster.getClientProperties()).build();){
                String table = this.getUniqueNames(1)[0] + "_" + ThriftMaxFrameSizeIT.this.serverType.name();
                ReadWriteIT.ingest(accumuloClient, 1, 1, testSize, 0, table);
                ReadWriteIT.verify(accumuloClient, 1, 1, testSize, 0, table);
            }
        }

        @Test
        public void testFrameSizeLessThanConfiguredMax() throws Exception {
            int testSize = 16384100;
            Assertions.assertTrue((testSize < 0x2000000 ? 1 : 0) != 0);
            this.testWithSpecificSize(testSize);
        }

        @Test
        public void testFrameSizeGreaterThanConfiguredMax() throws Exception {
            Assumptions.assumeFalse((boolean)(this instanceof SslNestedIT));
            int testSize = 33554532;
            Assertions.assertThrows(AssertionError.class, () -> Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(15L), () -> this.testWithSpecificSize(testSize)));
        }
    }

    @Nested
    class SslNestedIT
    extends TestMaxFrameSize {
        SslNestedIT() {
            ThriftMaxFrameSizeIT.this.serverType = ThriftServerType.SSL;
        }
    }

    @Nested
    class ThreadPoolNestedIT
    extends TestMaxFrameSize {
        ThreadPoolNestedIT() {
            ThriftMaxFrameSizeIT.this.serverType = ThriftServerType.THREADPOOL;
        }
    }

    @Nested
    class CustomHsHaNestedIT
    extends TestMaxFrameSize {
        CustomHsHaNestedIT() {
            ThriftMaxFrameSizeIT.this.serverType = ThriftServerType.CUSTOM_HS_HA;
        }
    }

    @Nested
    class ThreadedSelectorNestedIT
    extends TestMaxFrameSize {
        ThreadedSelectorNestedIT() {
            ThriftMaxFrameSizeIT.this.serverType = ThriftServerType.THREADED_SELECTOR;
        }
    }

    @Nested
    class DefaultServerNestedIT
    extends TestMaxFrameSize {
        DefaultServerNestedIT() {
            ThriftMaxFrameSizeIT.this.serverType = ThriftServerType.getDefault();
        }
    }
}

