/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.ByteArraySet;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class VisibilityIT
extends AccumuloClusterHarness {
    Authorizations origAuths = null;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @BeforeEach
    public void emptyAuths() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(VisibilityIT.getClientProps()).build();){
            this.origAuths = c.securityOperations().getUserAuthorizations(VisibilityIT.getAdminPrincipal());
        }
    }

    @AfterEach
    public void resetAuths() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(VisibilityIT.getClientProps()).build();){
            if (this.origAuths != null) {
                c.securityOperations().changeUserAuthorizations(VisibilityIT.getAdminPrincipal(), this.origAuths);
            }
        }
    }

    @Test
    public void run() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(VisibilityIT.getClientProps()).build();){
            String[] tableNames = this.getUniqueNames(2);
            String table = tableNames[0];
            c.tableOperations().create(table);
            String table2 = tableNames[1];
            c.tableOperations().create(table2);
            c.tableOperations().setProperty(table2, Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey(), "DEFLABEL");
            this.insertData(c, table);
            this.queryData(c, table);
            this.deleteData(c, table);
            this.insertDefaultData(c, table2);
            this.queryDefaultData(c, table2);
        }
    }

    private static SortedSet<String> nss(String ... labels) {
        TreeSet<String> ts = new TreeSet<String>();
        Collections.addAll(ts, labels);
        return ts;
    }

    private void mput(Mutation m, String cf, String cq, String cv, String val) {
        ColumnVisibility le = new ColumnVisibility(cv.getBytes(StandardCharsets.UTF_8));
        m.put(new Text(cf), new Text(cq), le, new Value((CharSequence)val));
    }

    private void mputDelete(Mutation m, String cf, String cq, String cv) {
        ColumnVisibility le = new ColumnVisibility(cv.getBytes(StandardCharsets.UTF_8));
        m.putDelete(new Text(cf), new Text(cq), le);
    }

    private void insertData(AccumuloClient c, String tableName) throws Exception {
        try (BatchWriter bw = c.createBatchWriter(tableName);){
            Mutation m1 = new Mutation(new Text("row1"));
            this.mput(m1, "cf1", "cq1", "", "v1");
            this.mput(m1, "cf1", "cq1", "A", "v2");
            this.mput(m1, "cf1", "cq1", "B", "v3");
            this.mput(m1, "cf1", "cq1", "A&B", "v4");
            this.mput(m1, "cf1", "cq1", "A&(L|M)", "v5");
            this.mput(m1, "cf1", "cq1", "B&(L|M)", "v6");
            this.mput(m1, "cf1", "cq1", "A&B&(L|M)", "v7");
            this.mput(m1, "cf1", "cq1", "A&B&(L)", "v8");
            this.mput(m1, "cf1", "cq1", "A&FOO", "v9");
            this.mput(m1, "cf1", "cq1", "A&FOO&(L|M)", "v10");
            this.mput(m1, "cf1", "cq1", "FOO", "v11");
            this.mput(m1, "cf1", "cq1", "(A|B)&FOO&(L|M)", "v12");
            this.mput(m1, "cf1", "cq1", "A&B&(L|M|FOO)", "v13");
            bw.addMutation(m1);
        }
    }

    private void deleteData(AccumuloClient c, String tableName) throws Exception {
        try (BatchWriter bw = c.createBatchWriter(tableName);){
            Mutation m1 = new Mutation(new Text("row1"));
            this.mputDelete(m1, "cf1", "cq1", "");
            this.mputDelete(m1, "cf1", "cq1", "A");
            this.mputDelete(m1, "cf1", "cq1", "A&B");
            this.mputDelete(m1, "cf1", "cq1", "B&(L|M)");
            this.mputDelete(m1, "cf1", "cq1", "A&B&(L)");
            this.mputDelete(m1, "cf1", "cq1", "A&FOO&(L|M)");
            this.mputDelete(m1, "cf1", "cq1", "(A|B)&FOO&(L|M)");
            this.mputDelete(m1, "cf1", "cq1", "FOO&A");
            bw.addMutation(m1);
        }
        HashMap<Set<String>, Set<String>> expected = new HashMap<Set<String>, Set<String>>();
        expected.put(VisibilityIT.nss("A", "L"), VisibilityIT.nss("v5"));
        expected.put(VisibilityIT.nss("A", "M"), VisibilityIT.nss("v5"));
        expected.put(VisibilityIT.nss("B"), VisibilityIT.nss("v3"));
        expected.put(VisibilityIT.nss("Z"), VisibilityIT.nss(new String[0]));
        expected.put(VisibilityIT.nss("A", "B", "L"), VisibilityIT.nss("v7", "v13"));
        expected.put(VisibilityIT.nss("A", "B", "M"), VisibilityIT.nss("v7", "v13"));
        expected.put(VisibilityIT.nss("A", "B", "FOO"), VisibilityIT.nss("v13"));
        expected.put(VisibilityIT.nss("FOO"), VisibilityIT.nss("v11"));
        expected.put(VisibilityIT.nss("A", "FOO"), VisibilityIT.nss("v9"));
        this.queryData(c, tableName, VisibilityIT.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityIT.nss("A", "B", "FOO", "L", "M", "Z"), expected);
    }

    private void insertDefaultData(AccumuloClient c, String tableName) throws Exception {
        try (BatchWriter bw = c.createBatchWriter(tableName);){
            Mutation m1 = new Mutation(new Text("row1"));
            this.mput(m1, "cf1", "cq1", "BASE", "v1");
            this.mput(m1, "cf1", "cq2", "DEFLABEL", "v2");
            this.mput(m1, "cf1", "cq3", "", "v3");
            bw.addMutation(m1);
        }
    }

    private static void uniqueCombos(List<Set<String>> all, Set<String> prefix, Set<String> suffix) {
        all.add(prefix);
        TreeSet<String> ss = new TreeSet<String>(suffix);
        for (String s : suffix) {
            TreeSet<String> ps = new TreeSet<String>(prefix);
            ps.add(s);
            ss.remove(s);
            VisibilityIT.uniqueCombos(all, ps, ss);
        }
    }

    private void queryData(AccumuloClient c, String tableName) throws Exception {
        HashMap<Set<String>, Set<String>> expected = new HashMap<Set<String>, Set<String>>();
        expected.put(VisibilityIT.nss(new String[0]), VisibilityIT.nss("v1"));
        expected.put(VisibilityIT.nss("A"), VisibilityIT.nss("v2"));
        expected.put(VisibilityIT.nss("A", "L"), VisibilityIT.nss("v5"));
        expected.put(VisibilityIT.nss("A", "M"), VisibilityIT.nss("v5"));
        expected.put(VisibilityIT.nss("B"), VisibilityIT.nss("v3"));
        expected.put(VisibilityIT.nss("B", "L"), VisibilityIT.nss("v6"));
        expected.put(VisibilityIT.nss("B", "M"), VisibilityIT.nss("v6"));
        expected.put(VisibilityIT.nss("Z"), VisibilityIT.nss(new String[0]));
        expected.put(VisibilityIT.nss("A", "B"), VisibilityIT.nss("v4"));
        expected.put(VisibilityIT.nss("A", "B", "L"), VisibilityIT.nss("v7", "v8", "v13"));
        expected.put(VisibilityIT.nss("A", "B", "M"), VisibilityIT.nss("v7", "v13"));
        expected.put(VisibilityIT.nss("A", "B", "FOO"), VisibilityIT.nss("v13"));
        expected.put(VisibilityIT.nss("FOO"), VisibilityIT.nss("v11"));
        expected.put(VisibilityIT.nss("A", "FOO"), VisibilityIT.nss("v9"));
        expected.put(VisibilityIT.nss("A", "FOO", "L"), VisibilityIT.nss("v10", "v12"));
        expected.put(VisibilityIT.nss("A", "FOO", "M"), VisibilityIT.nss("v10", "v12"));
        expected.put(VisibilityIT.nss("B", "FOO", "L"), VisibilityIT.nss("v12"));
        expected.put(VisibilityIT.nss("B", "FOO", "M"), VisibilityIT.nss("v12"));
        this.queryData(c, tableName, VisibilityIT.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityIT.nss("A", "B", "FOO", "L", "M", "Z"), expected);
        this.queryData(c, tableName, VisibilityIT.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityIT.nss("A", "B", "L", "M", "Z"), expected);
        this.queryData(c, tableName, VisibilityIT.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityIT.nss("A", "Z"), expected);
        this.queryData(c, tableName, VisibilityIT.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityIT.nss("Z"), expected);
        this.queryData(c, tableName, VisibilityIT.nss("A", "B", "FOO", "L", "M", "Z"), VisibilityIT.nss(new String[0]), expected);
    }

    private void queryData(AccumuloClient c, String tableName, Set<String> allAuths, Set<String> userAuths, Map<Set<String>, Set<String>> expected) throws Exception {
        c.securityOperations().changeUserAuthorizations(VisibilityIT.getAdminPrincipal(), new Authorizations((Collection)this.nbas(userAuths)));
        ArrayList<Set<String>> combos = new ArrayList<Set<String>>();
        VisibilityIT.uniqueCombos(combos, VisibilityIT.nss(new String[0]), allAuths);
        for (Set<String> set1 : combos) {
            TreeSet<String> e = new TreeSet<String>();
            for (Set<String> set2 : combos) {
                set2 = new HashSet<String>(set2);
                set2.retainAll(userAuths);
                if (!set1.containsAll(set2) || !expected.containsKey(set2)) continue;
                e.addAll((Collection<String>)expected.get(set2));
            }
            set1.retainAll(userAuths);
            this.verify(c, tableName, set1, e);
        }
    }

    private void queryDefaultData(AccumuloClient c, String tableName) throws Exception {
        c.securityOperations().changeUserAuthorizations(VisibilityIT.getAdminPrincipal(), new Authorizations(new String[]{"BASE", "DEFLABEL"}));
        try (Scanner scanner = c.createScanner(tableName, new Authorizations());){
            this.verifyDefault(scanner, 0);
        }
        scanner = c.createScanner(tableName, new Authorizations(new String[]{"BASE"}));
        try {
            this.verifyDefault(scanner, 1);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        scanner = c.createScanner(tableName, new Authorizations(new String[]{"BASE", "DEFLABEL"}));
        try {
            this.verifyDefault(scanner, 3);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private void verifyDefault(Scanner scanner, int expectedCount) throws Exception {
        int actual = Iterators.size((Iterator)scanner.iterator());
        if (actual != expectedCount) {
            throw new Exception("actual count " + actual + " != expected count " + expectedCount);
        }
    }

    private void verify(AccumuloClient c, String tableName, Set<String> auths, Set<String> expectedValues) throws Exception {
        ByteArraySet bas = this.nbas(auths);
        try {
            this.verify(c, tableName, bas, expectedValues.toArray(new String[0]));
        }
        catch (Exception e) {
            throw new Exception("Verification failed auths=" + auths + " exp=" + expectedValues, e);
        }
    }

    private ByteArraySet nbas(Set<String> auths) {
        ByteArraySet bas = new ByteArraySet();
        for (String auth : auths) {
            bas.add((Object)auth.getBytes(StandardCharsets.UTF_8));
        }
        return bas;
    }

    private void verify(AccumuloClient c, String tableName, ByteArraySet nss, String ... expected) throws Exception {
        try (Scanner scanner = c.createScanner(tableName, new Authorizations((Collection)nss));
             BatchScanner bs = c.createBatchScanner(tableName, new Authorizations((Collection)nss), 3);){
            this.verify(scanner.iterator(), expected);
            bs.setRanges(Collections.singleton(new Range()));
            this.verify(bs.iterator(), expected);
        }
    }

    private void verify(Iterator<Map.Entry<Key, Value>> iter, String ... expected) throws Exception {
        HashSet<String> valuesSeen = new HashSet<String>();
        while (iter.hasNext()) {
            Map.Entry<Key, Value> entry = iter.next();
            if (valuesSeen.contains(entry.getValue().toString())) {
                throw new Exception("Value seen twice");
            }
            valuesSeen.add(entry.getValue().toString());
        }
        for (String ev : expected) {
            if (valuesSeen.remove(ev)) continue;
            throw new Exception("Did not see expected value " + ev);
        }
        if (!valuesSeen.isEmpty()) {
            throw new Exception("Saw more values than expected " + valuesSeen);
        }
    }
}

