/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.manager.state.SetGoalState;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterControl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="SunnyDay")
public class WALSunnyDayIT
extends ConfigurableMacBase {
    private static final Text CF = new Text(new byte[0]);
    private final int TIMES_TO_COUNT = 20;
    private final int PAUSE_BETWEEN_COUNTS = 100;

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.setProperty(Property.GC_CYCLE_START, "0s");
        cfg.setProperty(Property.TSERV_WAL_MAX_SIZE, "1M");
        cfg.setProperty(Property.TSERV_WAL_REPLICATION, "1");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    int countInUse(Collection<WalStateManager.WalState> bools) {
        int result = 0;
        for (WalStateManager.WalState b : bools) {
            if (b == WalStateManager.WalState.UNREFERENCED) continue;
            ++result;
        }
        return result;
    }

    @Test
    public void test() throws Exception {
        MiniAccumuloClusterImpl mac = this.getCluster();
        MiniAccumuloClusterControl control = mac.getClusterControl();
        control.stop(ServerType.GARBAGE_COLLECTOR);
        ServerContext context = this.getServerContext();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeSomeData(c, tableName, 1, 1);
            Map<String, WalStateManager.WalState> wals = this.getWALsAndAssertCount(context, 2);
            Assertions.assertEquals((int)2, (int)this.countInUse(wals.values()), (String)"all WALs should be in use");
            this.writeSomeData(c, tableName, 1001, 50);
            Map<String, WalStateManager.WalState> walsAfterRoll = this.getWALsAndAssertCount(context, 3);
            Assertions.assertTrue((boolean)walsAfterRoll.keySet().containsAll(wals.keySet()), (String)"new WALs should be a superset of the old WALs");
            Assertions.assertEquals((int)3, (int)this.countInUse(walsAfterRoll.values()), (String)"all WALs should be in use");
            for (String table : new String[]{tableName, MetadataTable.NAME, RootTable.NAME}) {
                c.tableOperations().flush(table, null, null, true);
            }
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            Map<String, WalStateManager.WalState> walsAfterflush = this.getWALsAndAssertCount(context, 3);
            Assertions.assertEquals((int)2, (int)this.countInUse(walsAfterflush.values()), (String)"inUse should be 2");
            control.start(ServerType.GARBAGE_COLLECTOR);
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            this.getWALsAndAssertCount(context, 2);
            control.stop(ServerType.GARBAGE_COLLECTOR);
            control.stop(ServerType.TABLET_SERVER);
            Assertions.assertEquals((int)0, (int)this.cluster.exec(SetGoalState.class, new String[]{"SAFE_MODE"}).getProcess().waitFor());
            control.start(ServerType.TABLET_SERVER);
            this.getRecoveryMarkers(c);
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            Map<KeyExtent, List<String>> markers = this.getRecoveryMarkers(c);
            Assertions.assertEquals((int)1, (int)markers.size(), (String)"one tablet should have markers");
            Assertions.assertEquals((Object)"1", (Object)markers.keySet().iterator().next().tableId().canonical(), (String)"tableId of the keyExtent should be 1");
            Assertions.assertEquals((int)0, (int)this.cluster.exec(SetGoalState.class, new String[]{"NORMAL"}).getProcess().waitFor());
            this.verifySomeData(c, tableName, 50051);
            this.writeSomeData(c, tableName, 100, 100);
            Map<String, WalStateManager.WalState> walsAfterRestart = this.getWALsAndAssertCount(context, 4);
            Assertions.assertEquals((int)4, (int)this.countInUse(walsAfterRestart.values()), (String)"used WALs after restart should be 4");
            control.start(ServerType.GARBAGE_COLLECTOR);
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            Map<String, WalStateManager.WalState> walsAfterRestartAndGC = this.getWALsAndAssertCount(context, 2);
            Assertions.assertEquals((int)2, (int)this.countInUse(walsAfterRestartAndGC.values()), (String)"logs in use should be 2");
        }
    }

    private void verifySomeData(AccumuloClient c, String tableName, int expected) throws Exception {
        try (Scanner scan = c.createScanner(tableName, Authorizations.EMPTY);){
            int result = Iterators.size((Iterator)scan.iterator());
            Assertions.assertEquals((int)expected, (int)result);
        }
    }

    private void writeSomeData(AccumuloClient client, String tableName, int row, int col) throws Exception {
        try (BatchWriter bw = client.createBatchWriter(tableName);){
            byte[] rowData = new byte[10];
            byte[] cq = new byte[10];
            byte[] value = new byte[10];
            for (int r = 0; r < row; ++r) {
                random.nextBytes(rowData);
                Mutation m = new Mutation(rowData);
                for (int c = 0; c < col; ++c) {
                    random.nextBytes(cq);
                    random.nextBytes(value);
                    m.put(CF, new Text(cq), new Value(value));
                }
                bw.addMutation(m);
                if (r % 100 != 0) continue;
                bw.flush();
            }
        }
    }

    private Map<KeyExtent, List<String>> getRecoveryMarkers(AccumuloClient c) throws Exception {
        HashMap<KeyExtent, List<String>> result = new HashMap<KeyExtent, List<String>>();
        try (Scanner root = c.createScanner(RootTable.NAME, Authorizations.EMPTY);
             Scanner meta = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            root.setRange(MetadataSchema.TabletsSection.getRange());
            root.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)root);
            meta.setRange(MetadataSchema.TabletsSection.getRange());
            meta.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)meta);
            ArrayList<String> logs = new ArrayList<String>();
            Iterator both = Iterators.concat((Iterator)root.iterator(), (Iterator)meta.iterator());
            while (both.hasNext()) {
                Map.Entry entry = (Map.Entry)both.next();
                Key key = (Key)entry.getKey();
                if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.LogColumnFamily.NAME)) {
                    logs.add(key.getColumnQualifier().toString());
                }
                if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key) || logs.isEmpty()) continue;
                KeyExtent extent = KeyExtent.fromMetaPrevRow((Map.Entry)entry);
                result.put(extent, logs);
                logs = new ArrayList();
            }
        }
        return result;
    }

    private Map<String, WalStateManager.WalState> getWALsAndAssertCount(ServerContext c, int expectedCount) throws Exception {
        Map<String, WalStateManager.WalState> wals = WALSunnyDayIT._getWals(c);
        if (wals.size() == expectedCount) {
            return wals;
        }
        int waitLonger = Wait.getTimeoutFactor(e -> 1);
        for (int i = 1; i <= 20; ++i) {
            Thread.sleep(i * 100 * waitLonger);
            wals = WALSunnyDayIT._getWals(c);
            if (wals.size() != expectedCount) continue;
            return wals;
        }
        Assertions.fail((String)("Unable to get the correct number of WALs, expected " + expectedCount + " but got " + wals));
        return new HashMap<String, WalStateManager.WalState>();
    }

    static Map<String, WalStateManager.WalState> _getWals(ServerContext c) throws Exception {
        while (true) {
            try {
                HashMap<String, WalStateManager.WalState> result = new HashMap<String, WalStateManager.WalState>();
                WalStateManager wals = new WalStateManager(c);
                for (Map.Entry entry : wals.getAllState().entrySet()) {
                    result.put(((Path)entry.getKey()).toString(), (WalStateManager.WalState)entry.getValue());
                }
                return result;
            }
            catch (WalStateManager.WalMarkerException wme) {
                if (wme.getCause() instanceof KeeperException.NoNodeException) {
                    log.debug("WALs changed while reading, retrying", (Throwable)wme);
                    continue;
                }
                throw wme;
            }
            break;
        }
    }
}

