/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.Socket;
import java.time.Duration;
import java.util.Properties;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchTheWatchCountIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(WatchTheWatchCountIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(3);
    }

    @Test
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="unencrypted socket is okay for testing")
    public void test() throws Exception {
        Properties props = this.getClientProperties();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(props).build();){
            String[] tableNames;
            for (String tableName : tableNames = this.getUniqueNames(3)) {
                c.tableOperations().create(tableName);
            }
            c.tableOperations().list();
            String zooKeepers = ClientProperty.INSTANCE_ZOOKEEPERS.getValue(props);
            long MIN = 150L;
            long MAX = 250L;
            long total = 0L;
            HostAndPort hostAndPort = HostAndPort.fromString((String)zooKeepers);
            for (int i = 0; i < 5; ++i) {
                try (Socket socket = new Socket(hostAndPort.getHost(), hostAndPort.getPort());){
                    socket.getOutputStream().write("wchs\n".getBytes(), 0, 5);
                    byte[] buffer = new byte[1024];
                    int n = socket.getInputStream().read(buffer);
                    String response = new String(buffer, 0, n);
                    total = Long.parseLong(response.split(":")[1].trim());
                    log.info("Total: {}", (Object)total);
                    if (total > 150L && total < 250L) break;
                    log.debug("Expected number of watchers to be contained in ({}, {}), but actually was {}. Sleeping and retrying", new Object[]{150L, 250L, total});
                    Thread.sleep(5000L);
                    continue;
                }
            }
            Assertions.assertTrue((total > 150L && total < 250L ? 1 : 0) != 0, (String)("Expected number of watchers to be contained in (150, 250), but actually was " + total));
        }
    }
}

