/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.crypto.AESCryptoService;
import org.apache.accumulo.core.spi.crypto.GenericCryptoServiceFactory;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.WriteAheadLogIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteAheadLogEncryptedIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(WriteAheadLogEncryptedIT.class);

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        String keyPath = System.getProperty("user.dir") + "/target/mini-tests/WriteAheadLogEncryptedIT-testkeyfile";
        cfg.setProperty(Property.INSTANCE_CRYPTO_FACTORY, GenericCryptoServiceFactory.class.getName());
        cfg.setProperty(GenericCryptoServiceFactory.GENERAL_SERVICE_NAME_PROP, AESCryptoService.class.getName());
        cfg.setProperty("general.custom.crypto.key.uri", keyPath);
        WriteAheadLogIT.setupConfig(cfg, hadoopCoreSite);
        try {
            Path keyFile = new Path(keyPath);
            LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
            fs.delete(keyFile, true);
            if (fs.createNewFile(keyFile)) {
                log.info("Created keyfile at {}", (Object)keyPath);
            } else {
                log.error("Failed to create key file at {}", (Object)keyPath);
            }
            try (FSDataOutputStream out = fs.create(keyFile);){
                out.writeUTF("sixteenbytekey");
            }
        }
        catch (Exception e) {
            log.error("Exception during configure", (Throwable)e);
        }
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(WriteAheadLogEncryptedIT.getClientProps()).build();){
            WriteAheadLogIT.testWAL(c, this.getUniqueNames(1)[0]);
        }
    }
}

