/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.jupiter.api.Test;

public class WriteAheadLogIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        WriteAheadLogIT.setupConfig(cfg, hadoopCoreSite);
    }

    public static void setupConfig(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_WAL_MAX_SIZE, "2M");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1");
        cfg.setProperty(Property.GC_CYCLE_START, "1");
        cfg.setProperty(Property.MANAGER_RECOVERY_DELAY, "1s");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(WriteAheadLogIT.getClientProps()).build();){
            WriteAheadLogIT.testWAL(c, this.getUniqueNames(1)[0]);
        }
    }

    public static void testWAL(AccumuloClient c, String tableName) throws Exception {
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "750K");
        VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(WriteAheadLogIT.getClientProps(), tableName);
        TestIngest.ingest(c, params);
        VerifyIngest.verifyIngest(c, params);
        WriteAheadLogIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
        WriteAheadLogIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        VerifyIngest.verifyIngest(c, params);
    }
}

