/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.junit.jupiter.api.Test;

public class WriteLotsIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(90L);
    }

    @Test
    public void writeLots() throws Exception {
        BatchWriterConfig bwConfig = new BatchWriterConfig();
        bwConfig.setMaxMemory(0x100000L);
        bwConfig.setMaxWriteThreads(2);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(WriteLotsIT.getClientProps()).batchWriterConfig(bwConfig).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            AtomicReference ref = new AtomicReference();
            int THREADS = 5;
            ThreadPoolExecutor tpe = new ThreadPoolExecutor(0, 5, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
            int i = 0;
            while (i < 5) {
                int index = i++;
                Runnable r = () -> {
                    try {
                        TestIngest.IngestParams ingestParams = new TestIngest.IngestParams(WriteLotsIT.getClientProps(), tableName, 10000);
                        ingestParams.startRow = index * 10000;
                        TestIngest.ingest(c, ingestParams);
                    }
                    catch (Exception ex) {
                        ref.set(ex);
                    }
                };
                tpe.execute(r);
            }
            tpe.shutdown();
            tpe.awaitTermination(90L, TimeUnit.SECONDS);
            if (ref.get() != null) {
                throw (Exception)ref.get();
            }
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(WriteLotsIT.getClientProps(), tableName, 50000);
            VerifyIngest.verifyIngest(c, params);
        }
    }
}

