/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.iterators.YieldCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YieldingIterator
extends WrappingIterator {
    private static final Logger log = LoggerFactory.getLogger(YieldingIterator.class);
    private static final AtomicInteger yieldNexts = new AtomicInteger(0);
    private static final AtomicInteger yieldSeeks = new AtomicInteger(0);
    private static final AtomicInteger rebuilds = new AtomicInteger(0);
    private static final AtomicBoolean yieldNextKey = new AtomicBoolean(false);
    private static final AtomicBoolean yieldSeekKey = new AtomicBoolean(false);
    private Optional<YieldCallback<Key>> yield = Optional.empty();

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        YieldingIterator it = new YieldingIterator();
        it.setSource(this.getSource().deepCopy(env));
        return it;
    }

    public boolean hasTop() {
        return (!this.yield.isPresent() || !this.yield.orElseThrow().hasYielded()) && super.hasTop();
    }

    public void next() throws IOException {
        log.info("start YieldingIterator.next: " + this.getTopValue());
        boolean yielded = false;
        yieldNextKey.set(!yieldNextKey.get());
        if (this.yield.isPresent() && yieldNextKey.get()) {
            yielded = true;
            yieldNexts.incrementAndGet();
            this.yield.orElseThrow().yield((Object)this.getTopKey().followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME));
            log.info("end YieldingIterator.next: yielded at " + this.getTopKey());
        }
        if (!yielded) {
            super.next();
            log.info("end YieldingIterator.next: " + (String)(this.hasTop() ? this.getTopKey() + " " + this.getTopValue() : "no top"));
        }
    }

    public Value getTopValue() {
        String value = yieldNexts.get() + "," + yieldSeeks.get() + "," + rebuilds.get();
        return new Value((CharSequence)value);
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        log.info("start YieldingIterator.seek: " + this.getTopValue() + " with range " + range);
        boolean yielded = false;
        if (range.isStartKeyInclusive()) {
            log.info("resetting counters");
            this.resetCounters();
        } else {
            rebuilds.incrementAndGet();
        }
        if (range.getStartKey() != null) {
            yieldSeekKey.set(!yieldSeekKey.get());
            if (this.yield.isPresent() && yieldSeekKey.get()) {
                yielded = true;
                yieldSeeks.incrementAndGet();
                if (range.isStartKeyInclusive()) {
                    this.yield.orElseThrow().yield((Object)range.getStartKey());
                } else {
                    this.yield.orElseThrow().yield((Object)range.getStartKey().followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME));
                }
                log.info("end YieldingIterator.next: yielded at " + range.getStartKey());
            }
        }
        if (!yielded) {
            super.seek(range, columnFamilies, inclusive);
            log.info("end YieldingIterator.seek: " + (String)(this.hasTop() ? this.getTopKey() + " " + this.getTopValue() : "no top"));
        }
    }

    public void enableYielding(YieldCallback<Key> yield) {
        this.yield = Optional.of(yield);
    }

    protected void resetCounters() {
        yieldNexts.set(0);
        yieldSeeks.set(0);
        rebuilds.set(0);
        yieldNextKey.set(false);
        yieldSeekKey.set(false);
    }
}

