/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.clientImpl.thrift.ClientService;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletScanClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftProcessorTypes;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.test.performance.NullTserver;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZombieTServer {
    private static final Logger log = LoggerFactory.getLogger(ZombieTServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int port = AccumuloITBase.random.nextInt(30000) + 2000;
        ServerContext context = new ServerContext(SiteConfiguration.auto());
        ClientServiceHandler csh = new ClientServiceHandler(context, new TransactionWatcher(context));
        final ZombieTServerThriftClientHandler tch = new ZombieTServerThriftClientHandler();
        TMultiplexedProcessor muxProcessor = new TMultiplexedProcessor();
        muxProcessor.registerProcessor(ThriftClientTypes.CLIENT.getServiceName(), ThriftProcessorTypes.CLIENT.getTProcessor(ClientService.Processor.class, ClientService.Iface.class, (Object)csh, context));
        muxProcessor.registerProcessor(ThriftClientTypes.TABLET_SERVER.getServiceName(), ThriftProcessorTypes.TABLET_SERVER.getTProcessor(TabletClientService.Processor.class, TabletClientService.Iface.class, (Object)tch, context));
        muxProcessor.registerProcessor(ThriftProcessorTypes.TABLET_SERVER_SCAN.getServiceName(), ThriftProcessorTypes.TABLET_SERVER_SCAN.getTProcessor(TabletScanClientService.Processor.class, TabletScanClientService.Iface.class, (Object)tch, context));
        ServerAddress serverPort = TServerUtils.startTServer((AccumuloConfiguration)context.getConfiguration(), (ThriftServerType)ThriftServerType.CUSTOM_HS_HA, (TProcessor)muxProcessor, (String)"ZombieTServer", (String)"walking dead", (int)2, (long)ThreadPools.DEFAULT_TIMEOUT_MILLISECS, (long)1000L, (long)0xA00000L, null, null, (long)-1L, (int)context.getConfiguration().getCount(Property.RPC_BACKLOG), (MetricsInfo)context.getMetricsInfo(), (boolean)false, (HostAndPort[])new HostAndPort[]{HostAndPort.fromParts((String)"0.0.0.0", (int)port)});
        String addressString = serverPort.address.toString();
        ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(context.getZooKeeperRoot() + "/tservers/" + addressString));
        ZooReaderWriter zoo = context.getZooReaderWriter();
        zoo.putPersistentData(zLockPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        ServiceLock zlock = new ServiceLock(zoo.getZooKeeper(), zLockPath, UUID.randomUUID());
        MetricsInfo metricsInfo = context.getMetricsInfo();
        metricsInfo.addServiceTags("zombie.server", serverPort.address);
        metricsInfo.init();
        ServiceLock.LockWatcher lw = new ServiceLock.LockWatcher(){

            @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit() is a bad idea here, but okay for now, since it's a test")
            public void lostLock(ServiceLock.LockLossReason reason) {
                try {
                    tch.halt(TraceUtil.traceInfo(), null, null);
                }
                catch (Exception ex) {
                    log.error("Exception", (Throwable)ex);
                    System.exit(1);
                }
            }

            @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit() is a bad idea here, but okay for now, since it's a test")
            public void unableToMonitorLockNode(Exception e) {
                try {
                    tch.halt(TraceUtil.traceInfo(), null, null);
                }
                catch (Exception ex) {
                    log.error("Exception", (Throwable)ex);
                    System.exit(1);
                }
            }
        };
        byte[] lockContent = new ServerServices(addressString, ServerServices.Service.TSERV_CLIENT).toString().getBytes(StandardCharsets.UTF_8);
        if (zlock.tryLock(lw, lockContent)) {
            log.debug("Obtained tablet server lock {}", (Object)zlock.getLockPath());
        }
        ZombieTServerThriftClientHandler zombieTServerThriftClientHandler = tch;
        synchronized (zombieTServerThriftClientHandler) {
            while (!tch.halted) {
                tch.wait();
            }
        }
        System.exit(0);
    }

    public static class ZombieTServerThriftClientHandler
    extends NullTserver.NullTServerTabletClientHandler
    implements TabletClientService.Iface,
    TabletScanClientService.Iface {
        int statusCount = 0;
        boolean halted = false;

        @Override
        public synchronized void fastHalt(TInfo tinfo, TCredentials credentials, String lock) {
            this.halted = true;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TabletServerStatus getTabletServerStatus(TInfo tinfo, TCredentials credentials) {
            ZombieTServerThriftClientHandler zombieTServerThriftClientHandler = this;
            synchronized (zombieTServerThriftClientHandler) {
                if (this.statusCount++ < 1) {
                    TabletServerStatus result = new TabletServerStatus();
                    result.tableMap = new HashMap();
                    return result;
                }
            }
            UtilWaitThread.sleepUninterruptibly((long)Integer.MAX_VALUE, (TimeUnit)TimeUnit.DAYS);
            return null;
        }

        @Override
        public synchronized void halt(TInfo tinfo, TCredentials credentials, String lock) {
            this.halted = true;
            this.notifyAll();
        }
    }
}

