/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZookeeperRestartIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        HashMap<String, String> siteConfig = new HashMap<String, String>();
        siteConfig.put(Property.INSTANCE_ZK_TIMEOUT.getKey(), "15s");
        cfg.setSiteConfig(siteConfig);
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            c.tableOperations().create("test_ingest");
            try (BatchWriter bw = c.createBatchWriter("test_ingest");){
                Mutation m = new Mutation((CharSequence)"row");
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
            for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.ZOOKEEPER)) {
                this.cluster.killProcess(ServerType.ZOOKEEPER, proc);
            }
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            this.cluster.start();
            try (Scanner s = c.createScanner("test_ingest", Authorizations.EMPTY);){
                String actual = this.getOnlyElement(s).getKey().getRow().toString();
                Assertions.assertEquals((Object)"row", (Object)actual);
                c.tableOperations().delete("test_ingest");
            }
        }
    }
}

