/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapred;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapred.RangeInputSplit;
import org.apache.accumulo.core.client.sample.RowSampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@Deprecated(since="2.0.0")
public class AccumuloInputFormatIT
extends AccumuloClusterHarness {
    private static AssertionError e1 = null;
    private static int e1Count = 0;
    private static AssertionError e2 = null;
    private static int e2Count = 0;
    private static final SamplerConfiguration SAMPLER_CONFIG = new SamplerConfiguration(RowSampler.class.getName()).addOption("hasher", "murmur3_32").addOption("modulus", "3");

    @BeforeAll
    public static void setupClass() {
        System.setProperty("hadoop.tmp.dir", System.getProperty("user.dir") + "/target/hadoop-tmp");
    }

    @Test
    public void testMap() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            c.tableOperations().create(table);
            try (BatchWriter bw = c.createBatchWriter(table);){
                for (int i = 0; i < 100; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
                    m.put((CharSequence)"", (CharSequence)"", (CharSequence)String.format("%09x", i));
                    bw.addMutation(m);
                }
            }
            e1 = null;
            e2 = null;
            MRTester.main(table);
            Assertions.assertNull((Object)e1);
            Assertions.assertNull((Object)e2);
        }
    }

    @Test
    public void testSample() throws Exception {
        String TEST_TABLE_3 = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            c.tableOperations().create(TEST_TABLE_3, new NewTableConfiguration().enableSampling(SAMPLER_CONFIG));
            try (BatchWriter bw = c.createBatchWriter(TEST_TABLE_3);){
                for (int i = 0; i < 100; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
                    m.put((CharSequence)"", (CharSequence)"", (CharSequence)String.format("%09x", i));
                    bw.addMutation(m);
                }
            }
            MRTester.main(TEST_TABLE_3, "False", "True");
            Assertions.assertEquals((int)38, (int)e1Count);
            Assertions.assertEquals((int)1, (int)e2Count);
            e1Count = 0;
            e2Count = 0;
            MRTester.main(TEST_TABLE_3, "False", "False");
            Assertions.assertEquals((int)0, (int)e1Count);
            Assertions.assertEquals((int)0, (int)e2Count);
            e1Count = 0;
            e2Count = 0;
            MRTester.main(TEST_TABLE_3, "True", "True");
            Assertions.assertEquals((int)38, (int)e1Count);
            Assertions.assertEquals((int)1, (int)e2Count);
        }
    }

    @Test
    public void testCorrectRangeInputSplits() throws Exception {
        JobConf job = new JobConf();
        String table = this.getUniqueNames(1)[0];
        Authorizations auths = new Authorizations(new String[]{"foo"});
        Set<Pair> fetchColumns = Collections.singleton(new Pair((Object)new Text("foo"), (Object)new Text("bar")));
        boolean isolated = true;
        boolean localIters = true;
        Level level = Level.WARN;
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            accumuloClient.tableOperations().create(table);
            ClientInfo ci = AccumuloInputFormatIT.getClientInfo();
            AccumuloInputFormat.setZooKeeperInstance((JobConf)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloInputFormat.setConnectorInfo((JobConf)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            AccumuloInputFormat.setInputTableName((JobConf)job, (String)table);
            AccumuloInputFormat.setScanAuthorizations((JobConf)job, (Authorizations)auths);
            AccumuloInputFormat.setScanIsolation((JobConf)job, (boolean)isolated);
            AccumuloInputFormat.setLocalIterators((JobConf)job, (boolean)localIters);
            AccumuloInputFormat.fetchColumns((JobConf)job, fetchColumns);
            AccumuloInputFormat.setLogLevel((JobConf)job, (Level)level);
            AccumuloInputFormat aif = new AccumuloInputFormat();
            InputSplit[] splits = aif.getSplits(job, 1);
            Assertions.assertEquals((int)1, (int)splits.length);
            InputSplit split = splits[0];
            Assertions.assertEquals(RangeInputSplit.class, split.getClass());
            RangeInputSplit risplit = (RangeInputSplit)split;
            Assertions.assertEquals((Object)table, (Object)risplit.getTableName());
            Assertions.assertEquals((Object)isolated, (Object)risplit.isIsolatedScan());
            Assertions.assertEquals((Object)localIters, (Object)risplit.usesLocalIterators());
            Assertions.assertEquals(fetchColumns, (Object)risplit.getFetchedColumns());
            Assertions.assertEquals((Object)level, (Object)risplit.getLogLevel());
        }
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 1 && args.length != 3) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table> [<batchScan> <scan sample>]");
            }
            String table = args[0];
            boolean batchScan = false;
            boolean sample = false;
            if (args.length == 3) {
                batchScan = Boolean.parseBoolean(args[1]);
                sample = Boolean.parseBoolean(args[2]);
            }
            JobConf job = new JobConf(this.getConf());
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormat(AccumuloInputFormat.class);
            ClientInfo ci = AccumuloClusterHarness.getClientInfo();
            AccumuloInputFormat.setZooKeeperInstance((JobConf)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloInputFormat.setConnectorInfo((JobConf)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            AccumuloInputFormat.setInputTableName((JobConf)job, (String)table);
            AccumuloInputFormat.setBatchScan((JobConf)job, (boolean)batchScan);
            if (sample) {
                AccumuloInputFormat.setSamplerConfiguration((JobConf)job, (SamplerConfiguration)SAMPLER_CONFIG);
            }
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormat(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            return JobClient.runJob((JobConf)job).isSuccessful() ? 0 : 1;
        }

        public static void main(String ... args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        private static class TestMapper
        implements Mapper<Key, Value, Key, Value> {
            Key key = null;
            int count = 0;

            private TestMapper() {
            }

            public void map(Key k, Value v, OutputCollector<Key, Value> output, Reporter reporter) {
                try {
                    if (this.key != null) {
                        Assertions.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assertions.assertEquals((Object)k.getRow(), (Object)new Text(String.format("%09x", this.count + 1)));
                    Assertions.assertEquals((Object)new String(v.get()), (Object)String.format("%09x", this.count));
                }
                catch (AssertionError e) {
                    e1 = e;
                    ++e1Count;
                }
                this.key = new Key(k);
                ++this.count;
            }

            public void configure(JobConf job) {
            }

            public void close() {
                try {
                    Assertions.assertEquals((int)100, (int)this.count);
                }
                catch (AssertionError e) {
                    e2 = e;
                    ++e2Count;
                }
            }
        }
    }
}

