/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapred;

import com.google.common.collect.MoreCollectors;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapred.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated(since="2.0.0")
public class AccumuloOutputFormatIT
extends ConfigurableMacBase {
    private static AssertionError e1 = null;

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_SESSION_MAXIDLE, "1");
        cfg.setNumTservers(1);
    }

    @Test
    public void testMapred() throws Exception {
        Properties props = this.getClientProperties();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(props).build();){
            client.tableOperations().create(this.testName());
            JobConf job = new JobConf();
            BatchWriterConfig batchConfig = new BatchWriterConfig();
            batchConfig.setMaxLatency(0L, TimeUnit.MILLISECONDS);
            batchConfig.setMaxWriteThreads(1);
            batchConfig.setMaxMemory(Long.MAX_VALUE);
            AccumuloOutputFormat outputFormat = new AccumuloOutputFormat();
            ClientInfo ci = ClientInfo.from((Properties)props);
            AccumuloOutputFormat.setZooKeeperInstance((JobConf)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloOutputFormat.setConnectorInfo((JobConf)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            AccumuloOutputFormat.setBatchWriterOptions((JobConf)job, (BatchWriterConfig)batchConfig);
            RecordWriter writer = outputFormat.getRecordWriter(null, job, "Test", null);
            try {
                for (int i = 0; i < 3; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%08d", i)));
                    for (int j = 0; j < 3; ++j) {
                        m.put((CharSequence)"cf1", (CharSequence)("cq" + j), (CharSequence)(i + "_" + j));
                    }
                    writer.write((Object)new Text(this.testName()), (Object)m);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            client.securityOperations().revokeTablePermission("root", this.testName(), TablePermission.WRITE);
            IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> writer.close(null));
            log.info(ex.getMessage(), (Throwable)ex);
            Assertions.assertTrue((boolean)(ex.getCause() instanceof MutationsRejectedException));
        }
    }

    @Test
    public void testMR() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String instanceName = this.getCluster().getInstanceName();
            String table1 = instanceName + "_t1";
            String table2 = instanceName + "_t2";
            c.tableOperations().create(table1);
            c.tableOperations().create(table2);
            try (BatchWriter bw = c.createBatchWriter(table1);){
                for (int i = 0; i < 100; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
                    m.put((CharSequence)"", (CharSequence)"", (CharSequence)String.format("%09x", i));
                    bw.addMutation(m);
                }
            }
            MRTester.main(new String[]{"root", "testRootPassword1", table1, table2, instanceName, this.getCluster().getZooKeepers()});
            Assertions.assertNull((Object)e1);
            try (Scanner scanner = c.createScanner(table2, new Authorizations());){
                int actual = (Integer)scanner.stream().map(Map.Entry::getValue).map(Value::get).map(String::new).map(Integer::parseInt).collect(MoreCollectors.onlyElement());
                Assertions.assertEquals((int)100, (int)actual);
            }
        }
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 6) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <user> <pass> <inputtable> <outputtable> <instanceName> <zooKeepers>");
            }
            String user = args[0];
            String pass = args[1];
            String table1 = args[2];
            String table2 = args[3];
            String instanceName = args[4];
            String zooKeepers = args[5];
            JobConf job = new JobConf(this.getConf());
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormat(AccumuloInputFormat.class);
            ClientInfo info = ClientInfo.from((Properties)((Properties)Accumulo.newClientProperties().to((CharSequence)instanceName, (CharSequence)zooKeepers).as((CharSequence)user, (CharSequence)pass).build()));
            AccumuloInputFormat.setZooKeeperInstance((JobConf)job, (String)info.getInstanceName(), (String)info.getZooKeepers());
            AccumuloInputFormat.setConnectorInfo((JobConf)job, (String)info.getPrincipal(), (AuthenticationToken)info.getAuthenticationToken());
            AccumuloInputFormat.setInputTableName((JobConf)job, (String)table1);
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormat(AccumuloOutputFormat.class);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(Mutation.class);
            AccumuloOutputFormat.setZooKeeperInstance((JobConf)job, (String)info.getInstanceName(), (String)info.getZooKeepers());
            AccumuloOutputFormat.setConnectorInfo((JobConf)job, (String)info.getPrincipal(), (AuthenticationToken)info.getAuthenticationToken());
            AccumuloOutputFormat.setCreateTables((JobConf)job, (boolean)false);
            AccumuloOutputFormat.setDefaultTableName((JobConf)job, (String)table2);
            job.setNumReduceTasks(0);
            return JobClient.runJob((JobConf)job).isSuccessful() ? 0 : 1;
        }

        public static void main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        private static class TestMapper
        implements Mapper<Key, Value, Text, Mutation> {
            Key key = null;
            int count = 0;
            OutputCollector<Text, Mutation> finalOutput;

            private TestMapper() {
            }

            public void map(Key k, Value v, OutputCollector<Text, Mutation> output, Reporter reporter) {
                this.finalOutput = output;
                try {
                    if (this.key != null) {
                        Assertions.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assertions.assertEquals((Object)k.getRow(), (Object)new Text(String.format("%09x", this.count + 1)));
                    Assertions.assertEquals((Object)new String(v.get()), (Object)String.format("%09x", this.count));
                }
                catch (AssertionError e) {
                    e1 = e;
                }
                this.key = new Key(k);
                ++this.count;
            }

            public void configure(JobConf job) {
            }

            public void close() throws IOException {
                Mutation m = new Mutation((CharSequence)"total");
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)Integer.toString(this.count));
                this.finalOutput.collect((Object)new Text(), (Object)m);
            }
        }
    }
}

