/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapred;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.mapred.AccumuloRowInputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@Deprecated(since="2.0.0")
public class AccumuloRowInputFormatIT
extends AccumuloClusterHarness {
    private static final String ROW1 = "row1";
    private static final String ROW2 = "row2";
    private static final String ROW3 = "row3";
    private static final String COLF1 = "colf1";
    private static List<Map.Entry<Key, Value>> row1;
    private static List<Map.Entry<Key, Value>> row2;
    private static List<Map.Entry<Key, Value>> row3;
    private static AssertionError e1;
    private static AssertionError e2;

    @BeforeAll
    public static void prepareRows() {
        row1 = new ArrayList<Map.Entry<Key, Value>>();
        row1.add((Map.Entry<Key, Value>)new KeyValue(new Key((CharSequence)ROW1, (CharSequence)COLF1, (CharSequence)"colq1"), "v1".getBytes()));
        row1.add((Map.Entry<Key, Value>)new KeyValue(new Key((CharSequence)ROW1, (CharSequence)COLF1, (CharSequence)"colq2"), "v2".getBytes()));
        row1.add((Map.Entry<Key, Value>)new KeyValue(new Key((CharSequence)ROW1, (CharSequence)"colf2", (CharSequence)"colq3"), "v3".getBytes()));
        row2 = new ArrayList<Map.Entry<Key, Value>>();
        row2.add((Map.Entry<Key, Value>)new KeyValue(new Key((CharSequence)ROW2, (CharSequence)COLF1, (CharSequence)"colq4"), "v4".getBytes()));
        row3 = new ArrayList<Map.Entry<Key, Value>>();
        row3.add((Map.Entry<Key, Value>)new KeyValue(new Key((CharSequence)ROW3, (CharSequence)COLF1, (CharSequence)"colq5"), "v5".getBytes()));
    }

    private static void checkLists(List<Map.Entry<Key, Value>> first, Iterator<Map.Entry<Key, Value>> second) {
        int entryIndex = 0;
        while (second.hasNext()) {
            Map.Entry<Key, Value> entry = second.next();
            Assertions.assertEquals((Object)first.get(entryIndex).getKey(), (Object)entry.getKey(), (String)"Keys should be equal");
            Assertions.assertEquals((Object)first.get(entryIndex).getValue(), (Object)entry.getValue(), (String)"Values should be equal");
            ++entryIndex;
        }
    }

    private static void insertList(BatchWriter writer, List<Map.Entry<Key, Value>> list) throws MutationsRejectedException {
        for (Map.Entry<Key, Value> e : list) {
            Key key = e.getKey();
            Mutation mutation = new Mutation(key.getRow());
            ColumnVisibility colVisibility = new ColumnVisibility(key.getColumnVisibility());
            mutation.put(key.getColumnFamily(), key.getColumnQualifier(), colVisibility, key.getTimestamp(), e.getValue());
            writer.addMutation(mutation);
        }
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(AccumuloRowInputFormatIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            try (BatchWriter writer = client.createBatchWriter(tableName);){
                AccumuloRowInputFormatIT.insertList(writer, row1);
                AccumuloRowInputFormatIT.insertList(writer, row2);
                AccumuloRowInputFormatIT.insertList(writer, row3);
            }
            MRTester.main(new String[]{tableName});
            Assertions.assertNull((Object)e1);
            Assertions.assertNull((Object)e2);
        }
    }

    static {
        e1 = null;
        e2 = null;
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 1) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table>");
            }
            String table = args[0];
            JobConf job = new JobConf(this.getConf());
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormat(AccumuloRowInputFormat.class);
            ClientInfo ci = AccumuloClusterHarness.getClientInfo();
            AccumuloRowInputFormat.setZooKeeperInstance((JobConf)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloRowInputFormat.setConnectorInfo((JobConf)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            AccumuloRowInputFormat.setInputTableName((JobConf)job, (String)table);
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormat(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            return JobClient.runJob((JobConf)job).isSuccessful() ? 0 : 1;
        }

        public static void main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        public static class TestMapper
        implements Mapper<Text, PeekingIterator<Map.Entry<Key, Value>>, Key, Value> {
            int count = 0;

            public void map(Text k, PeekingIterator<Map.Entry<Key, Value>> v, OutputCollector<Key, Value> output, Reporter reporter) {
                try {
                    switch (this.count) {
                        case 0: {
                            Assertions.assertEquals((Object)new Text(AccumuloRowInputFormatIT.ROW1), (Object)k, (String)"Current key should be row1");
                            AccumuloRowInputFormatIT.checkLists(row1, v);
                            break;
                        }
                        case 1: {
                            Assertions.assertEquals((Object)new Text(AccumuloRowInputFormatIT.ROW2), (Object)k, (String)"Current key should be row2");
                            AccumuloRowInputFormatIT.checkLists(row2, v);
                            break;
                        }
                        case 2: {
                            Assertions.assertEquals((Object)new Text(AccumuloRowInputFormatIT.ROW3), (Object)k, (String)"Current key should be row3");
                            AccumuloRowInputFormatIT.checkLists(row3, v);
                            break;
                        }
                        default: {
                            Assertions.fail();
                            break;
                        }
                    }
                }
                catch (AssertionError e) {
                    e1 = e;
                }
                ++this.count;
            }

            public void configure(JobConf job) {
            }

            public void close() {
                try {
                    Assertions.assertEquals((int)3, (int)this.count);
                }
                catch (AssertionError e) {
                    e2 = e;
                }
            }
        }
    }
}

