/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapreduce;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.time.Duration;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.mapreduce.AccumuloFileOutputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.sample.RowSampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Deprecated(since="2.0.0")
public class AccumuloFileOutputFormatIT
extends AccumuloClusterHarness {
    private String PREFIX;
    private String BAD_TABLE;
    private String TEST_TABLE;
    private String EMPTY_TABLE;
    private static final SamplerConfiguration SAMPLER_CONFIG = new SamplerConfiguration(RowSampler.class.getName()).addOption("hasher", "murmur3_32").addOption("modulus", "3");
    @TempDir
    private static File tempDir;
    private static Multimap<String, AssertionError> assertionErrors;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @BeforeEach
    public void setup() throws Exception {
        this.PREFIX = this.testName() + "_";
        this.BAD_TABLE = this.PREFIX + "_mapreduce_bad_table";
        this.TEST_TABLE = this.PREFIX + "_mapreduce_test_table";
        this.EMPTY_TABLE = this.PREFIX + "_mapreduce_empty_table";
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloFileOutputFormatIT.getClientProps()).build();){
            Mutation m;
            c.tableOperations().create(this.EMPTY_TABLE);
            c.tableOperations().create(this.TEST_TABLE);
            c.tableOperations().create(this.BAD_TABLE);
            try (BatchWriter bw = c.createBatchWriter(this.TEST_TABLE);){
                m = new Mutation((CharSequence)"Key");
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                bw.addMutation(m);
            }
            bw = c.createBatchWriter(this.BAD_TABLE);
            try {
                m = new Mutation((CharSequence)"r1");
                m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"A&B");
                m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"A&B");
                m.put((CharSequence)"cf1", (CharSequence)"cq2", (CharSequence)"A&");
                bw.addMutation(m);
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
        }
    }

    @Test
    public void testEmptyWrite() throws Exception {
        this.handleWriteTests(false);
    }

    @Test
    public void testRealWrite() throws Exception {
        this.handleWriteTests(true);
    }

    private void handleWriteTests(boolean content) throws Exception {
        File f = new File(tempDir, this.testName());
        Assertions.assertTrue((boolean)f.createNewFile());
        Assertions.assertTrue((boolean)f.delete());
        MRTester.main(new String[]{content ? this.TEST_TABLE : this.EMPTY_TABLE, f.getAbsolutePath()});
        Assertions.assertTrue((boolean)f.exists());
        File[] files = f.listFiles(file -> file.getName().startsWith("part-m-"));
        Assertions.assertNotNull((Object)files);
        if (content) {
            Assertions.assertEquals((int)1, (int)files.length);
            Assertions.assertTrue((boolean)files[0].exists());
            Configuration conf = cluster.getServerContext().getHadoopConf();
            DefaultConfiguration acuconf = DefaultConfiguration.getInstance();
            FileSKVIterator sample = RFileOperations.getInstance().newReaderBuilder().forFile(files[0].toString(), (FileSystem)FileSystem.getLocal((Configuration)conf), conf, NoCryptoServiceFactory.NONE).withTableConfiguration((AccumuloConfiguration)acuconf).build().getSample(new SamplerConfigurationImpl(SAMPLER_CONFIG));
            Assertions.assertNotNull((Object)sample);
        } else {
            Assertions.assertEquals((int)0, (int)files.length);
        }
    }

    @Test
    public void writeBadVisibility() throws Exception {
        File f = new File(tempDir, this.testName());
        Assertions.assertTrue((boolean)f.createNewFile());
        Assertions.assertTrue((boolean)f.delete());
        MRTester.main(new String[]{this.BAD_TABLE, f.getAbsolutePath()});
        Assertions.assertTrue((boolean)f.exists());
        Assertions.assertEquals((int)1, (int)assertionErrors.get((Object)(this.BAD_TABLE + "_map")).size());
        Assertions.assertEquals((int)1, (int)assertionErrors.get((Object)(this.BAD_TABLE + "_cleanup")).size());
    }

    static {
        assertionErrors = ArrayListMultimap.create();
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table> <outputfile>");
            }
            String table = args[0];
            assertionErrors.put((Object)(table + "_map"), (Object)new AssertionError((Object)"Dummy_map"));
            assertionErrors.put((Object)(table + "_cleanup"), (Object)new AssertionError((Object)"Dummy_cleanup"));
            Job job = Job.getInstance((Configuration)this.getConf(), (String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis()));
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(AccumuloInputFormat.class);
            ClientInfo ci = AccumuloClusterHarness.getClientInfo();
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            AccumuloInputFormat.setInputTableName((Job)job, (String)table);
            AccumuloFileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
            AccumuloFileOutputFormat.setSampler((Job)job, (SamplerConfiguration)SAMPLER_CONFIG);
            job.setMapperClass(table.endsWith("_mapreduce_bad_table") ? BadKeyMapper.class : Mapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormatClass(AccumuloFileOutputFormat.class);
            job.getConfiguration().set("MRTester_tableName", table);
            job.setNumReduceTasks(0);
            job.waitForCompletion(true);
            return job.isSuccessful() ? 0 : 1;
        }

        public static void main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        private static class BadKeyMapper
        extends Mapper<Key, Value, Key, Value> {
            int index = 0;

            private BadKeyMapper() {
            }

            protected void map(Key key, Value value, Mapper.Context context) {
                String table = context.getConfiguration().get("MRTester_tableName");
                Assertions.assertNotNull((Object)table);
                try {
                    try {
                        context.write((Object)key, (Object)value);
                        if (this.index == 2) {
                            Assertions.fail();
                        }
                    }
                    catch (Exception e) {
                        Assertions.assertEquals((int)2, (int)this.index);
                    }
                }
                catch (AssertionError e) {
                    assertionErrors.put((Object)(table + "_map"), (Object)e);
                }
                ++this.index;
            }

            protected void cleanup(Mapper.Context context) {
                String table = context.getConfiguration().get("MRTester_tableName");
                Assertions.assertNotNull((Object)table);
                try {
                    Assertions.assertEquals((int)2, (int)this.index);
                }
                catch (AssertionError e) {
                    assertionErrors.put((Object)(table + "_cleanup"), (Object)e);
                }
            }
        }
    }
}

