/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapreduce;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.client.sample.RowSampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.clientImpl.mapreduce.BatchInputSplit;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.mapreduce.AccumuloOutputFormatIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@Deprecated(since="2.0.0")
public class AccumuloInputFormatIT
extends AccumuloClusterHarness {
    AccumuloInputFormat inputFormat;
    private static Multimap<String, AssertionError> assertionErrors = ArrayListMultimap.create();
    private static final SamplerConfiguration SAMPLER_CONFIG = new SamplerConfiguration(RowSampler.class.getName()).addOption("hasher", "murmur3_32").addOption("modulus", "3");

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
    }

    @BeforeEach
    public void before() {
        this.inputFormat = new AccumuloInputFormat();
    }

    @Test
    public void testGetSplits() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            client.tableOperations().create(table);
            this.insertData(client, table, System.currentTimeMillis());
            Job job = Job.getInstance();
            AccumuloInputFormat.setInputTableName((Job)job, (String)table);
            ClientInfo ci = AccumuloInputFormatIT.getClientInfo();
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            TreeSet<Text> splitsToAdd = new TreeSet<Text>();
            for (int i = 0; i < 10000; i += 1000) {
                splitsToAdd.add(new Text(String.format("%09d", i)));
            }
            client.tableOperations().addSplits(table, splitsToAdd);
            UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            Collection actualSplits = client.tableOperations().listSplits(table);
            List splits = this.inputFormat.getSplits((JobContext)job);
            Assertions.assertEquals((int)(actualSplits.size() + 1), (int)splits.size());
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (Text text : actualSplits) {
                ranges.add(new Range(text));
            }
            AccumuloInputFormat.setRanges((Job)job, ranges);
            splits = this.inputFormat.getSplits((JobContext)job);
            Assertions.assertEquals((int)actualSplits.size(), (int)splits.size());
            AccumuloInputFormat.setOfflineTableScan((Job)job, (boolean)true);
            Assertions.assertThrows(IOException.class, () -> this.inputFormat.getSplits((JobContext)job));
            client.tableOperations().offline(table, true);
            splits = this.inputFormat.getSplits((JobContext)job);
            Assertions.assertEquals((int)actualSplits.size(), (int)splits.size());
            ranges = new ArrayList();
            for (int i = 0; i < 5; ++i) {
                ranges.add(new Range((CharSequence)String.format("%09d", i), (CharSequence)String.format("%09d", i + 2)));
            }
            AccumuloInputFormat.setRanges((Job)job, ranges);
            splits = this.inputFormat.getSplits((JobContext)job);
            Assertions.assertEquals((int)2, (int)splits.size());
            AccumuloInputFormat.setAutoAdjustRanges((Job)job, (boolean)false);
            splits = this.inputFormat.getSplits((JobContext)job);
            Assertions.assertEquals((int)ranges.size(), (int)splits.size());
            AccumuloInputFormat.setBatchScan((Job)job, (boolean)true);
            AccumuloInputFormat.setAutoAdjustRanges((Job)job, (boolean)true);
            AccumuloInputFormat.setOfflineTableScan((Job)job, (boolean)true);
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.inputFormat.getSplits((JobContext)job));
            client.tableOperations().online(table, true);
            AccumuloInputFormat.setOfflineTableScan((Job)job, (boolean)false);
            splits = this.inputFormat.getSplits((JobContext)job);
            Assertions.assertEquals((int)2, (int)splits.size());
            AccumuloInputFormat.setScanIsolation((Job)job, (boolean)true);
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.inputFormat.getSplits((JobContext)job));
            AccumuloInputFormat.setScanIsolation((Job)job, (boolean)false);
            splits = this.inputFormat.getSplits((JobContext)job);
            Assertions.assertEquals((int)2, (int)splits.size());
            AccumuloInputFormat.setLocalIterators((Job)job, (boolean)true);
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.inputFormat.getSplits((JobContext)job));
            AccumuloInputFormat.setLocalIterators((Job)job, (boolean)false);
            client.tableOperations().online(table);
            splits = this.inputFormat.getSplits((JobContext)job);
            for (InputSplit split : splits) {
                Assertions.assertTrue((boolean)(split instanceof BatchInputSplit));
            }
            Assertions.assertEquals((int)2, (int)splits.size());
        }
    }

    private void insertData(AccumuloClient client, String tableName, long ts) throws AccumuloException, TableNotFoundException {
        try (BatchWriter bw = client.createBatchWriter(tableName);){
            for (int i = 0; i < 10000; ++i) {
                String row = String.format("%09d", i);
                Mutation m = new Mutation(new Text(row));
                m.put(new Text("cf1"), new Text("cq1"), ts, new Value((CharSequence)("" + i)));
                bw.addMutation(m);
            }
        }
    }

    @Test
    public void testMap() throws Exception {
        String TEST_TABLE_1 = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            c.tableOperations().create(TEST_TABLE_1);
            AccumuloOutputFormatIT.insertData(c, TEST_TABLE_1);
            Assertions.assertEquals((int)0, (int)MRTester.main(new String[]{TEST_TABLE_1, AccumuloInputFormat.class.getName()}));
            Assertions.assertEquals((int)1, (int)assertionErrors.get((Object)(TEST_TABLE_1 + "_map")).size());
            Assertions.assertEquals((int)1, (int)assertionErrors.get((Object)(TEST_TABLE_1 + "_cleanup")).size());
        }
    }

    @Test
    public void testSample() throws Exception {
        String TEST_TABLE_3 = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            c.tableOperations().create(TEST_TABLE_3, new NewTableConfiguration().enableSampling(SAMPLER_CONFIG));
            AccumuloOutputFormatIT.insertData(c, TEST_TABLE_3);
            Assertions.assertEquals((int)0, (int)MRTester.main(new String[]{TEST_TABLE_3, AccumuloInputFormat.class.getName(), "False", "True"}));
            Assertions.assertEquals((int)39, (int)assertionErrors.get((Object)(TEST_TABLE_3 + "_map")).size());
            Assertions.assertEquals((int)2, (int)assertionErrors.get((Object)(TEST_TABLE_3 + "_cleanup")).size());
            assertionErrors.clear();
            Assertions.assertEquals((int)0, (int)MRTester.main(new String[]{TEST_TABLE_3, AccumuloInputFormat.class.getName(), "False", "False"}));
            Assertions.assertEquals((int)1, (int)assertionErrors.get((Object)(TEST_TABLE_3 + "_map")).size());
            Assertions.assertEquals((int)1, (int)assertionErrors.get((Object)(TEST_TABLE_3 + "_cleanup")).size());
            assertionErrors.clear();
            Assertions.assertEquals((int)0, (int)MRTester.main(new String[]{TEST_TABLE_3, AccumuloInputFormat.class.getName(), "True", "True"}));
            Assertions.assertEquals((int)39, (int)assertionErrors.get((Object)(TEST_TABLE_3 + "_map")).size());
            Assertions.assertEquals((int)2, (int)assertionErrors.get((Object)(TEST_TABLE_3 + "_cleanup")).size());
        }
    }

    @Test
    public void testMapWithBatchScanner() throws Exception {
        String TEST_TABLE_2 = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            c.tableOperations().create(TEST_TABLE_2);
            AccumuloOutputFormatIT.insertData(c, TEST_TABLE_2);
            Assertions.assertEquals((int)0, (int)MRTester.main(new String[]{TEST_TABLE_2, AccumuloInputFormat.class.getName(), "True", "False"}));
            Assertions.assertEquals((int)1, (int)assertionErrors.get((Object)(TEST_TABLE_2 + "_map")).size());
            Assertions.assertEquals((int)1, (int)assertionErrors.get((Object)(TEST_TABLE_2 + "_cleanup")).size());
        }
    }

    @Test
    public void testCorrectRangeInputSplits() throws Exception {
        Job job = Job.getInstance();
        String table = this.getUniqueNames(1)[0];
        Authorizations auths = new Authorizations(new String[]{"foo"});
        Set<Pair> fetchColumns = Collections.singleton(new Pair((Object)new Text("foo"), (Object)new Text("bar")));
        boolean isolated = true;
        boolean localIters = true;
        Level level = Level.WARN;
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            accumuloClient.tableOperations().create(table);
            ClientInfo ci = AccumuloInputFormatIT.getClientInfo();
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            AccumuloInputFormat.setInputTableName((Job)job, (String)table);
            AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)auths);
            AccumuloInputFormat.setScanIsolation((Job)job, (boolean)isolated);
            AccumuloInputFormat.setLocalIterators((Job)job, (boolean)localIters);
            AccumuloInputFormat.fetchColumns((Job)job, fetchColumns);
            AccumuloInputFormat.setLogLevel((Job)job, (Level)level);
            AccumuloInputFormat aif = new AccumuloInputFormat();
            List splits = aif.getSplits((JobContext)job);
            Assertions.assertEquals((int)1, (int)splits.size());
            InputSplit split = (InputSplit)splits.get(0);
            Assertions.assertEquals(RangeInputSplit.class, split.getClass());
            RangeInputSplit risplit = (RangeInputSplit)split;
            Assertions.assertEquals((Object)table, (Object)risplit.getTableName());
            Assertions.assertEquals((Object)isolated, (Object)risplit.isIsolatedScan());
            Assertions.assertEquals((Object)localIters, (Object)risplit.usesLocalIterators());
            Assertions.assertEquals(fetchColumns, (Object)risplit.getFetchedColumns());
            Assertions.assertEquals((Object)level, (Object)risplit.getLogLevel());
        }
    }

    @Test
    public void testGetSplitsNoReadPermission() throws Exception {
        Job job = Job.getInstance();
        String table = this.getUniqueNames(1)[0];
        Authorizations auths = new Authorizations(new String[]{"foo"});
        Set<Pair> fetchColumns = Collections.singleton(new Pair((Object)new Text("foo"), (Object)new Text("bar")));
        boolean isolated = true;
        boolean localIters = true;
        Level level = Level.WARN;
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            client.tableOperations().create(table);
            client.securityOperations().revokeTablePermission(client.whoami(), table, TablePermission.READ);
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)cluster.getClientConfig());
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)AccumuloInputFormatIT.getAdminPrincipal(), (AuthenticationToken)AccumuloInputFormatIT.getAdminToken());
            AccumuloInputFormat.setInputTableName((Job)job, (String)table);
            AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)auths);
            AccumuloInputFormat.setScanIsolation((Job)job, (boolean)isolated);
            AccumuloInputFormat.setLocalIterators((Job)job, (boolean)localIters);
            AccumuloInputFormat.fetchColumns((Job)job, fetchColumns);
            AccumuloInputFormat.setLogLevel((Job)job, (Level)level);
            AccumuloInputFormat aif = new AccumuloInputFormat();
            Assertions.assertThrows(IOException.class, () -> aif.getSplits((JobContext)job));
        }
    }

    @Test
    public void testGetSplitsWithNamespaceReadPermission() throws Exception {
        Job job = Job.getInstance();
        String[] namespaceAndTable = this.getUniqueNames(2);
        String namespace = namespaceAndTable[0];
        String tableSimpleName = namespaceAndTable[1];
        String table = namespace + "." + tableSimpleName;
        Authorizations auths = new Authorizations(new String[]{"foo"});
        Set<Pair> fetchColumns = Collections.singleton(new Pair((Object)new Text("foo"), (Object)new Text("bar")));
        boolean isolated = true;
        boolean localIters = true;
        Level level = Level.WARN;
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            client.namespaceOperations().create(namespace);
            client.tableOperations().create(table);
            client.securityOperations().revokeTablePermission(client.whoami(), table, TablePermission.READ);
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)cluster.getClientConfig());
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)AccumuloInputFormatIT.getAdminPrincipal(), (AuthenticationToken)AccumuloInputFormatIT.getAdminToken());
            AccumuloInputFormat.setInputTableName((Job)job, (String)table);
            AccumuloInputFormat.setScanAuthorizations((Job)job, (Authorizations)auths);
            AccumuloInputFormat.setScanIsolation((Job)job, (boolean)true);
            AccumuloInputFormat.setLocalIterators((Job)job, (boolean)true);
            AccumuloInputFormat.fetchColumns((Job)job, fetchColumns);
            AccumuloInputFormat.setLogLevel((Job)job, (Level)level);
            AccumuloInputFormat aif = new AccumuloInputFormat();
            List splits = aif.getSplits((JobContext)job);
            Assertions.assertEquals((int)1, (int)splits.size());
        }
    }

    @Test
    public void testPartialInputSplitDelegationToConfiguration() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloInputFormatIT.getClientProps()).build();){
            c.tableOperations().create(table);
            AccumuloOutputFormatIT.insertData(c, table);
            Assertions.assertEquals((int)0, (int)MRTester.main(new String[]{table, EmptySplitsAccumuloInputFormat.class.getName()}));
            Assertions.assertEquals((int)1, (int)assertionErrors.get((Object)(table + "_map")).size());
            Assertions.assertEquals((int)1, (int)assertionErrors.get((Object)(table + "_cleanup")).size());
        }
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2 && args.length != 4) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table> <inputFormatClass> [<batchScan> <scan sample>]");
            }
            String table = args[0];
            String inputFormatClassName = args[1];
            boolean batchScan = false;
            boolean sample = false;
            if (args.length == 4) {
                batchScan = Boolean.parseBoolean(args[2]);
                sample = Boolean.parseBoolean(args[3]);
            }
            assertionErrors.put((Object)(table + "_map"), (Object)new AssertionError((Object)"Dummy_map"));
            assertionErrors.put((Object)(table + "_cleanup"), (Object)new AssertionError((Object)"Dummy_cleanup"));
            Class<?> inputFormatClass = Class.forName(inputFormatClassName);
            Job job = Job.getInstance((Configuration)this.getConf(), (String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis()));
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.getConfiguration().set("MRTester_tableName", table);
            job.setInputFormatClass(inputFormatClass);
            ClientInfo ci = AccumuloClusterHarness.getClientInfo();
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            AccumuloInputFormat.setInputTableName((Job)job, (String)table);
            AccumuloInputFormat.setBatchScan((Job)job, (boolean)batchScan);
            if (sample) {
                AccumuloInputFormat.setSamplerConfiguration((Job)job, (SamplerConfiguration)SAMPLER_CONFIG);
            }
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormatClass(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            job.waitForCompletion(true);
            return job.isSuccessful() ? 0 : 1;
        }

        public static int main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            return ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args);
        }

        private static class TestMapper
        extends Mapper<Key, Value, Key, Value> {
            Key key = null;
            int count = 0;

            private TestMapper() {
            }

            protected void map(Key k, Value v, Mapper.Context context) {
                String table = context.getConfiguration().get("MRTester_tableName");
                Assertions.assertNotNull((Object)table);
                try {
                    if (this.key != null) {
                        Assertions.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assertions.assertEquals((Object)k.getRow(), (Object)new Text(String.format("%09x", this.count + 1)));
                    Assertions.assertEquals((Object)new String(v.get()), (Object)String.format("%09x", this.count));
                }
                catch (AssertionError e) {
                    assertionErrors.put((Object)(table + "_map"), (Object)e);
                }
                this.key = new Key(k);
                ++this.count;
            }

            protected void cleanup(Mapper.Context context) {
                String table = context.getConfiguration().get("MRTester_tableName");
                Assertions.assertNotNull((Object)table);
                try {
                    Assertions.assertEquals((int)100, (int)this.count);
                }
                catch (AssertionError e) {
                    assertionErrors.put((Object)(table + "_cleanup"), (Object)e);
                }
            }
        }
    }

    public static class EmptySplitsAccumuloInputFormat
    extends AccumuloInputFormat {
        public List<InputSplit> getSplits(JobContext context) throws IOException {
            List oldSplits = super.getSplits(context);
            ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>(oldSplits.size());
            for (InputSplit oldSplit : oldSplits) {
                RangeInputSplit newSplit = new RangeInputSplit((RangeInputSplit)oldSplit);
                newSplits.add((InputSplit)newSplit);
            }
            return newSplits;
        }
    }
}

