/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapreduce;

import java.io.File;
import java.util.HashMap;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.mapreduce.AccumuloMultiTableInputFormat;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated(since="2.0.0")
public class AccumuloMultiTableInputFormatIT
extends AccumuloClusterHarness {
    private static AssertionError e1 = null;
    private static AssertionError e2 = null;

    @Test
    public void testMap() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String table1 = tableNames[0];
        String table2 = tableNames[1];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloMultiTableInputFormatIT.getClientProps()).build();){
            c.tableOperations().create(table1);
            c.tableOperations().create(table2);
            BatchWriter bw = c.createBatchWriter(table1);
            BatchWriter bw2 = c.createBatchWriter(table2);
            for (int i = 0; i < 100; ++i) {
                Mutation t1m = new Mutation(new Text(String.format("%s_%09x", table1, i + 1)));
                t1m.put((CharSequence)"", (CharSequence)"", (CharSequence)String.format("%s_%09x", table1, i));
                bw.addMutation(t1m);
                Mutation t2m = new Mutation(new Text(String.format("%s_%09x", table2, i + 1)));
                t2m.put((CharSequence)"", (CharSequence)"", (CharSequence)String.format("%s_%09x", table2, i));
                bw2.addMutation(t2m);
            }
            bw.close();
            bw2.close();
            MRTester.main(new String[]{table1, table2});
            Assertions.assertNull((Object)e1);
            Assertions.assertNull((Object)e2);
        }
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <table1> <table2>");
            }
            String table1 = args[0];
            String table2 = args[1];
            Job job = Job.getInstance((Configuration)this.getConf(), (String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis()));
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(AccumuloMultiTableInputFormat.class);
            ClientInfo ci = AccumuloClusterHarness.getClientInfo();
            AccumuloMultiTableInputFormat.setZooKeeperInstance((Job)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloMultiTableInputFormat.setConnectorInfo((Job)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            InputTableConfig tableConfig1 = new InputTableConfig();
            InputTableConfig tableConfig2 = new InputTableConfig();
            HashMap<String, InputTableConfig> configMap = new HashMap<String, InputTableConfig>();
            configMap.put(table1, tableConfig1);
            configMap.put(table2, tableConfig2);
            AccumuloMultiTableInputFormat.setInputTableConfigs((Job)job, configMap);
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormatClass(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            job.waitForCompletion(true);
            return job.isSuccessful() ? 0 : 1;
        }

        public static void main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        private static class TestMapper
        extends Mapper<Key, Value, Key, Value> {
            Key key = null;
            int count = 0;

            private TestMapper() {
            }

            protected void map(Key k, Value v, Mapper.Context context) {
                try {
                    String tableName = ((RangeInputSplit)context.getInputSplit()).getTableName();
                    if (this.key != null) {
                        Assertions.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assertions.assertEquals((Object)new Text(String.format("%s_%09x", tableName, this.count + 1)), (Object)k.getRow());
                    Assertions.assertEquals((Object)String.format("%s_%09x", tableName, this.count), (Object)new String(v.get()));
                }
                catch (AssertionError e) {
                    e1 = e;
                }
                this.key = new Key(k);
                ++this.count;
            }

            protected void cleanup(Mapper.Context context) {
                try {
                    Assertions.assertEquals((int)100, (int)this.count);
                }
                catch (AssertionError e) {
                    e2 = e;
                }
            }
        }
    }
}

