/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapreduce;

import com.google.common.collect.MoreCollectors;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated(since="2.0.0")
public class AccumuloOutputFormatIT
extends AccumuloClusterHarness {
    private static AssertionError e1 = null;

    public static void insertData(AccumuloClient client, String table) throws TableNotFoundException, MutationsRejectedException {
        try (BatchWriter bw = client.createBatchWriter(table);){
            for (int i = 0; i < 100; ++i) {
                Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)String.format("%09x", i));
                bw.addMutation(m);
            }
        }
    }

    @Test
    public void testMR() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String table1 = tableNames[0];
        String table2 = tableNames[1];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloOutputFormatIT.getClientProps()).build();){
            c.tableOperations().create(table1);
            c.tableOperations().create(table2);
            AccumuloOutputFormatIT.insertData(c, table1);
            MRTester.main(new String[]{table1, table2});
            Assertions.assertNull((Object)e1);
            try (Scanner scanner = c.createScanner(table2, new Authorizations());){
                int actual = (Integer)scanner.stream().map(Map.Entry::getValue).map(Value::get).map(String::new).map(Integer::parseInt).collect(MoreCollectors.onlyElement());
                Assertions.assertEquals((int)100, (int)actual);
            }
        }
    }

    private static class MRTester
    extends Configured
    implements Tool {
        private MRTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2) {
                throw new IllegalArgumentException("Usage : " + MRTester.class.getName() + " <inputtable> <outputtable>");
            }
            String table1 = args[0];
            String table2 = args[1];
            Job job = Job.getInstance((Configuration)this.getConf(), (String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis()));
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(AccumuloInputFormat.class);
            ClientInfo ci = AccumuloClusterHarness.getClientInfo();
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            AccumuloInputFormat.setInputTableName((Job)job, (String)table1);
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormatClass(AccumuloOutputFormat.class);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(Mutation.class);
            AccumuloOutputFormat.setZooKeeperInstance((Job)job, (String)ci.getInstanceName(), (String)ci.getZooKeepers());
            AccumuloOutputFormat.setConnectorInfo((Job)job, (String)ci.getPrincipal(), (AuthenticationToken)ci.getAuthenticationToken());
            AccumuloOutputFormat.setCreateTables((Job)job, (boolean)false);
            AccumuloOutputFormat.setDefaultTableName((Job)job, (String)table2);
            job.setNumReduceTasks(0);
            job.waitForCompletion(true);
            return job.isSuccessful() ? 0 : 1;
        }

        public static void main(String[] args) throws Exception {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new MRTester(), (String[])args));
        }

        private static class TestMapper
        extends Mapper<Key, Value, Text, Mutation> {
            Key key = null;
            int count = 0;

            private TestMapper() {
            }

            protected void map(Key k, Value v, Mapper.Context context) {
                try {
                    if (this.key != null) {
                        Assertions.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assertions.assertEquals((Object)k.getRow(), (Object)new Text(String.format("%09x", this.count + 1)));
                    Assertions.assertEquals((Object)new String(v.get()), (Object)String.format("%09x", this.count));
                }
                catch (AssertionError e) {
                    e1 = e;
                }
                this.key = new Key(k);
                ++this.count;
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                Mutation m = new Mutation((CharSequence)"total");
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)Integer.toString(this.count));
                context.write((Object)new Text(), (Object)m);
            }
        }
    }
}

