/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.mapreduce;

import com.google.common.collect.MoreCollectors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Deprecated(since="2.0.0")
public class TokenFileIT
extends AccumuloClusterHarness {
    private static AssertionError e1 = null;
    @TempDir
    private static File tempDir;

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public void testMR() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String table1 = tableNames[0];
        String table2 = tableNames[1];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(TokenFileIT.getClientProps()).build();){
            c.tableOperations().create(table1);
            c.tableOperations().create(table2);
            try (BatchWriter bw = c.createBatchWriter(table1);){
                for (int i = 0; i < 100; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%09x", i + 1)));
                    m.put((CharSequence)"", (CharSequence)"", (CharSequence)String.format("%09x", i));
                    bw.addMutation(m);
                }
            }
            File tf = new File(tempDir, "root_test.pw");
            Assertions.assertTrue((boolean)tf.createNewFile(), (String)("Failed to create file: " + tf));
            try (PrintStream out = new PrintStream(tf);){
                String outString = new Credentials(TokenFileIT.getAdminPrincipal(), TokenFileIT.getAdminToken()).serialize();
                out.println(outString);
            }
            Configuration conf = cluster.getServerContext().getHadoopConf();
            conf.set("hadoop.tmp.dir", new File(tf.getAbsolutePath()).getParent());
            conf.set("mapreduce.framework.name", "local");
            conf.set("mapreduce.cluster.local.dir", new File(System.getProperty("user.dir"), "target/mapreduce-tmp").getAbsolutePath());
            Assertions.assertEquals((int)0, (int)ToolRunner.run((Configuration)conf, (Tool)new MRTokenFileTester(), (String[])new String[]{tf.getAbsolutePath(), table1, table2}));
            if (e1 != null) {
                ((Throwable)((Object)e1)).printStackTrace();
            }
            Assertions.assertNull((Object)e1);
            try (Scanner scanner = c.createScanner(table2, new Authorizations());){
                int actual = (Integer)scanner.stream().map(Map.Entry::getValue).map(Value::get).map(String::new).map(Integer::parseInt).collect(MoreCollectors.onlyElement());
                Assertions.assertEquals((int)100, (int)actual);
            }
        }
    }

    private static class MRTokenFileTester
    extends Configured
    implements Tool {
        private MRTokenFileTester() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 3) {
                throw new IllegalArgumentException("Usage : " + MRTokenFileTester.class.getName() + " <token file> <inputtable> <outputtable>");
            }
            String user = AccumuloClusterHarness.getAdminPrincipal();
            String tokenFile = args[0];
            String table1 = args[1];
            String table2 = args[2];
            Job job = Job.getInstance((Configuration)this.getConf(), (String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis()));
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(AccumuloInputFormat.class);
            ClientInfo info = AccumuloClusterHarness.getClientInfo();
            AccumuloInputFormat.setConnectorInfo((Job)job, (String)user, (String)tokenFile);
            AccumuloInputFormat.setInputTableName((Job)job, (String)table1);
            AccumuloInputFormat.setZooKeeperInstance((Job)job, (String)info.getInstanceName(), (String)info.getZooKeepers());
            job.setMapperClass(TestMapper.class);
            job.setMapOutputKeyClass(Key.class);
            job.setMapOutputValueClass(Value.class);
            job.setOutputFormatClass(AccumuloOutputFormat.class);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(Mutation.class);
            AccumuloOutputFormat.setConnectorInfo((Job)job, (String)user, (String)tokenFile);
            AccumuloOutputFormat.setCreateTables((Job)job, (boolean)false);
            AccumuloOutputFormat.setDefaultTableName((Job)job, (String)table2);
            AccumuloOutputFormat.setZooKeeperInstance((Job)job, (String)info.getInstanceName(), (String)info.getZooKeepers());
            job.setNumReduceTasks(0);
            job.waitForCompletion(true);
            if (job.isSuccessful()) {
                return 0;
            }
            System.out.println(job.getStatus().getFailureInfo());
            return 1;
        }

        private static class TestMapper
        extends Mapper<Key, Value, Text, Mutation> {
            Key key = null;
            int count = 0;

            private TestMapper() {
            }

            protected void map(Key k, Value v, Mapper.Context context) {
                try {
                    URI[] cachedFiles;
                    try {
                        cachedFiles = context.getCacheFiles();
                    }
                    catch (IOException e) {
                        throw new AssertionError("IOException getting cache files", e);
                    }
                    Assertions.assertEquals((int)2, (int)cachedFiles.length);
                    for (Class formatClass : Arrays.asList(AccumuloInputFormat.class, AccumuloOutputFormat.class)) {
                        String formatName = formatClass.getSimpleName();
                        Assertions.assertTrue((boolean)Arrays.stream(cachedFiles).anyMatch(uri -> uri.toString().endsWith(formatName + ".tokenfile")));
                        File file = new File(formatName + ".tokenfile");
                        Assertions.assertTrue((boolean)file.exists());
                        Assertions.assertTrue((boolean)file.canRead());
                    }
                    if (this.key != null) {
                        Assertions.assertEquals((Object)this.key.getRow().toString(), (Object)new String(v.get()));
                    }
                    Assertions.assertEquals((Object)k.getRow(), (Object)new Text(String.format("%09x", this.count + 1)));
                    Assertions.assertEquals((Object)new String(v.get()), (Object)String.format("%09x", this.count));
                }
                catch (AssertionError e) {
                    e1 = e;
                }
                this.key = new Key(k);
                ++this.count;
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                Mutation m = new Mutation((CharSequence)"total");
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)Integer.toString(this.count));
                context.write((Object)new Text(), (Object)m);
            }
        }
    }
}

