/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.spi.metrics.LoggingMeterRegistryFactory;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.metrics.TestStatsDRegistryFactory;
import org.apache.accumulo.test.metrics.TestStatsDSink;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class MetricsIT
extends ConfigurableMacBase
implements MetricsProducer {
    private static TestStatsDSink sink;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @BeforeAll
    public static void before() throws Exception {
        sink = new TestStatsDSink();
    }

    @AfterAll
    public static void after() throws Exception {
        sink.close();
    }

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(2);
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.setProperty(Property.MANAGER_FATE_METRICS_MIN_UPDATE_INTERVAL, "1s");
        cfg.setProperty(Property.GENERAL_MICROMETER_ENABLED, "true");
        cfg.setProperty(Property.GENERAL_MICROMETER_JVM_METRICS_ENABLED, "true");
        cfg.setProperty("general.custom.metrics.opts.logging.step", "1s");
        String clazzList = LoggingMeterRegistryFactory.class.getName() + "," + TestStatsDRegistryFactory.class.getName();
        cfg.setProperty(Property.GENERAL_MICROMETER_FACTORY, clazzList);
        Map<String, String> sysProps = Map.of("test.meter.registry.host", "127.0.0.1", "test.meter.registry.port", Integer.toString(sink.getPort()));
        cfg.setSystemProperties(sysProps);
    }

    @Test
    public void confirmMetricsPublished() throws Exception {
        List<String> statsDMetrics;
        this.doWorkToGenerateMetrics();
        this.cluster.stop();
        Set<String> unexpectedMetrics = Set.of("accumulo.compactor.majc.stuck", "accumulo.replication.queue", "accumulo.scan.yields", "accumulo.tserver.updates.error");
        Set<String> flakyMetrics = Set.of("accumulo.fate.ops.in.progress.by.type", "accumulo.manager.balancer.migrations.needed", "accumulo.scan.busy.timeout.count", "accumulo.scan.reservation.conflict.count", "accumulo.scan.reservation.total.timer", "accumulo.scan.reservation.writeout.timer", "accumulo.scan.tablet.metadata.cache", "accumulo.server.idle");
        Map expectedMetricNames = this.getMetricFields();
        flakyMetrics.forEach(expectedMetricNames::remove);
        unexpectedMetrics.forEach(expectedMetricNames::remove);
        Assertions.assertFalse((boolean)expectedMetricNames.isEmpty());
        HashMap seenMetricNames = new HashMap();
        while (!(statsDMetrics = sink.getLines()).isEmpty() && !expectedMetricNames.isEmpty()) {
            statsDMetrics.stream().filter(line -> line.startsWith("accumulo")).map(TestStatsDSink::parseStatsDMetric).map(TestStatsDSink.Metric::getName).filter(Predicate.not(seenMetricNames::containsKey)).forEach(name -> {
                if (expectedMetricNames.containsKey(name)) {
                    seenMetricNames.put(name, (String)expectedMetricNames.remove(name));
                } else if (!flakyMetrics.contains(name)) {
                    Assertions.fail((String)("Found accumulo metric not in expectedMetricNames or flakyMetricNames: " + name));
                }
            });
        }
        Assertions.assertTrue((boolean)expectedMetricNames.isEmpty(), (String)("Did not see all expected metric names, missing: " + expectedMetricNames.values()));
    }

    private void doWorkToGenerateMetrics() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Mutation m;
            String tableName = this.getClass().getSimpleName();
            client.tableOperations().create(tableName);
            TreeSet<Text> splits = new TreeSet<Text>(List.of(new Text("5")));
            client.tableOperations().addSplits(tableName, splits);
            Thread.sleep(3000L);
            BatchWriterConfig config = new BatchWriterConfig().setMaxMemory(0L);
            try (BatchWriter writer = client.createBatchWriter(tableName, config);){
                m = new Mutation((CharSequence)"row");
                m.put((CharSequence)"cf", (CharSequence)"cq", new Value((CharSequence)"value"));
                writer.addMutation(m);
            }
            client.tableOperations().flush(tableName);
            writer = client.createBatchWriter(tableName, config);
            try {
                m = new Mutation((CharSequence)"row");
                m.put((CharSequence)"cf", (CharSequence)"cq", new Value((CharSequence)"value"));
                writer.addMutation(m);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            client.tableOperations().flush(tableName);
            writer = client.createBatchWriter(tableName, config);
            try {
                for (int i = 0; i < 10; ++i) {
                    Mutation m2 = new Mutation((CharSequence)(i + "_row"));
                    m2.put((CharSequence)"cf", (CharSequence)"cq", new Value((CharSequence)"value"));
                    writer.addMutation(m2);
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            client.tableOperations().compact(tableName, new CompactionConfig());
            try (Scanner scanner = client.createScanner(tableName);){
                scanner.forEach((k, v) -> {});
            }
            client.tableOperations().delete(tableName);
            while (client.tableOperations().exists(tableName)) {
                Thread.sleep(1000L);
            }
        }
    }

    public void registerMetrics(MeterRegistry registry) {
    }

    @Test
    public void metricTags() throws Exception {
        List<String> statsDMetrics;
        this.doWorkToGenerateMetrics();
        this.cluster.stop();
        while (!(statsDMetrics = sink.getLines()).isEmpty()) {
            statsDMetrics.stream().filter(line -> line.startsWith("accumulo")).map(TestStatsDSink::parseStatsDMetric).forEach(a -> {
                Map<String, String> t = a.getTags();
                log.trace("METRICS, name: '{}' num tags: {}, tags: {}", new Object[]{a.getName(), t.size(), t});
                Assertions.assertNotEquals((Object)"0.0.0.0", (Object)a.getTags().get("host"));
                Assertions.assertNotNull((Object)a.getTags().get("instance.name"));
                int MAX_EXPECTED_TAG_LEN = 128;
                a.getTags().forEach((k, v) -> Assertions.assertTrue((v.length() < 128 ? 1 : 0) != 0));
            });
        }
    }
}

