/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdFlavor;
import io.micrometer.statsd.StatsdMeterRegistry;
import io.micrometer.statsd.StatsdProtocol;
import java.time.Duration;
import org.apache.accumulo.core.spi.metrics.MeterRegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStatsDRegistryFactory
implements MeterRegistryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TestStatsDRegistryFactory.class);
    public static final String SERVER_HOST = "test.meter.registry.host";
    public static final String SERVER_PORT = "test.meter.registry.port";

    public MeterRegistry create(MeterRegistryFactory.InitParameters params) {
        LOG.info("starting metrics registration.");
        final String host = System.getProperty(SERVER_HOST, null);
        final String port = System.getProperty(SERVER_PORT, null);
        if (host == null || port == null) {
            throw new IllegalArgumentException("Host and Port cannot be null");
        }
        LOG.info("host: {}, port:{}", (Object)host, (Object)port);
        StatsdConfig config = new StatsdConfig(){

            public StatsdFlavor flavor() {
                return StatsdFlavor.DATADOG;
            }

            public boolean enabled() {
                return true;
            }

            public String host() {
                return host;
            }

            public int port() {
                return Integer.parseInt(port);
            }

            public StatsdProtocol protocol() {
                return StatsdProtocol.UDP;
            }

            public Duration pollingFrequency() {
                return Duration.ofSeconds(3L);
            }

            public boolean buffered() {
                return false;
            }

            public String get(String key) {
                return null;
            }
        };
        return StatsdMeterRegistry.builder((StatsdConfig)config).build();
    }
}

