/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.metrics;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.accumulo.core.util.threads.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStatsDSink
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TestStatsDSink.class);
    private final DatagramSocket sock;
    private final LinkedBlockingQueue<String> received = new LinkedBlockingQueue();

    public static Metric parseStatsDMetric(String line) {
        String[] tag;
        int idx = line.indexOf(58);
        String name = line.substring(0, idx);
        int idx2 = line.indexOf(124);
        String value = line.substring(idx + 1, idx2);
        int idx3 = line.indexOf(124, idx2 + 1);
        String type = line.substring(idx2 + 1, idx3);
        int idx4 = line.indexOf(35);
        String tags = line.substring(idx4 + 1);
        Metric m = new Metric(name, value, type);
        for (String t : tag = tags.split(",")) {
            String[] p = t.split(":");
            m.getTags().put(p[0], p[1]);
        }
        return m;
    }

    public TestStatsDSink() throws SocketException {
        this.sock = new DatagramSocket();
        int len = this.sock.getReceiveBufferSize();
        Threads.createThread((String)"test-server-thread", () -> {
            while (!this.sock.isClosed()) {
                byte[] buf = new byte[len];
                DatagramPacket packet = new DatagramPacket(buf, len);
                try {
                    this.sock.receive(packet);
                    this.received.add(new String(packet.getData(), 0, packet.getLength()));
                }
                catch (IOException e) {
                    if (this.sock.isClosed()) continue;
                    LOG.error("Error receiving packet", (Throwable)e);
                    this.sock.close();
                }
            }
        }).start();
    }

    public String getHost() {
        return this.sock.getLocalAddress().getHostAddress();
    }

    public int getPort() {
        return this.sock.getLocalPort();
    }

    public List<String> getLines() {
        ArrayList<String> metrics = new ArrayList<String>(this.received.size());
        this.received.drainTo(metrics);
        return metrics;
    }

    public String getLine() {
        return (String)this.received.remove();
    }

    @Override
    public void close() {
        this.sock.close();
    }

    public static class Metric {
        private final String name;
        private final String value;
        private final String type;
        private final Map<String, String> tags = new HashMap<String, String>();

        public Metric(String name, String value, String type) {
            this.name = name;
            this.value = value;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public String toString() {
            return "Metric [name=" + this.name + ", value=" + this.value + ", type=" + this.type + ", tags=" + this.tags + "]";
        }
    }
}

