/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.performance;

import com.beust.jcommander.Parameter;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.ClientService;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.InitialMultiScan;
import org.apache.accumulo.core.dataImpl.thrift.InitialScan;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.MapFileInfo;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.dataImpl.thrift.ScanResult;
import org.apache.accumulo.core.dataImpl.thrift.TCMResult;
import org.apache.accumulo.core.dataImpl.thrift.TColumn;
import org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation;
import org.apache.accumulo.core.dataImpl.thrift.TConditionalSession;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TMutation;
import org.apache.accumulo.core.dataImpl.thrift.TRange;
import org.apache.accumulo.core.dataImpl.thrift.TRowRange;
import org.apache.accumulo.core.dataImpl.thrift.TSummaries;
import org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest;
import org.apache.accumulo.core.dataImpl.thrift.UpdateErrors;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionQueueSummary;
import org.apache.accumulo.core.tabletserver.thrift.TDurability;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.apache.accumulo.core.tabletserver.thrift.TSamplerConfiguration;
import org.apache.accumulo.core.tabletserver.thrift.TUnloadTabletGoal;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletScanClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.manager.state.Assignment;
import org.apache.accumulo.server.manager.state.MetaDataTableScanner;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftProcessorTypes;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;

public class NullTserver {
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(NullTserver.class.getName(), args, new Object[0]);
        int zkTimeOut = (int)DefaultConfiguration.getInstance().getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT);
        SiteConfiguration siteConfig = SiteConfiguration.auto();
        ServerContext context = ServerContext.override((SiteConfiguration)siteConfig, (String)opts.iname, (String)opts.keepers, (int)zkTimeOut);
        ClientServiceHandler csh = new ClientServiceHandler(context, new TransactionWatcher(context));
        NullTServerTabletClientHandler tch = new NullTServerTabletClientHandler();
        TMultiplexedProcessor muxProcessor = new TMultiplexedProcessor();
        muxProcessor.registerProcessor(ThriftClientTypes.CLIENT.getServiceName(), ThriftProcessorTypes.CLIENT.getTProcessor(ClientService.Processor.class, ClientService.Iface.class, (Object)csh, context));
        muxProcessor.registerProcessor(ThriftClientTypes.TABLET_SERVER.getServiceName(), ThriftProcessorTypes.TABLET_SERVER.getTProcessor(TabletClientService.Processor.class, TabletClientService.Iface.class, (Object)tch, context));
        muxProcessor.registerProcessor(ThriftProcessorTypes.TABLET_SERVER_SCAN.getServiceName(), ThriftProcessorTypes.TABLET_SERVER_SCAN.getTProcessor(TabletScanClientService.Processor.class, TabletScanClientService.Iface.class, (Object)tch, context));
        TServerUtils.startTServer((AccumuloConfiguration)context.getConfiguration(), (ThriftServerType)ThriftServerType.CUSTOM_HS_HA, (TProcessor)muxProcessor, (String)"NullTServer", (String)"null tserver", (int)2, (long)ThreadPools.DEFAULT_TIMEOUT_MILLISECS, (long)1000L, (long)0xA00000L, null, null, (long)-1L, (int)context.getConfiguration().getCount(Property.RPC_BACKLOG), (MetricsInfo)context.getMetricsInfo(), (boolean)false, (HostAndPort[])new HostAndPort[]{HostAndPort.fromParts((String)"0.0.0.0", (int)opts.port)});
        HostAndPort addr = HostAndPort.fromParts((String)InetAddress.getLocalHost().getHostName(), (int)opts.port);
        TableId tableId = context.getTableId(opts.tableName);
        Range tableRange = new KeyExtent(tableId, null, null).toMetaRange();
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        try (MetaDataTableScanner s = new MetaDataTableScanner((ClientContext)context, tableRange, MetadataTable.NAME);){
            long randomSessionID = opts.port;
            TServerInstance instance = new TServerInstance(addr, randomSessionID);
            while (s.hasNext()) {
                TabletLocationState next = s.next();
                assignments.add(new Assignment(next.extent, instance, next.last));
            }
        }
        TabletStateStore store = TabletStateStore.getStoreForLevel((Ample.DataLevel)Ample.DataLevel.USER, (ClientContext)context);
        store.setLocations(assignments);
        while (true) {
            UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-i", "--instance"}, description="instance name", required=true)
        String iname = null;
        @Parameter(names={"-z", "--keepers"}, description="comma-separated list of zookeeper host:ports", required=true)
        String keepers = null;
        @Parameter(names={"--table"}, description="table to adopt", required=true)
        String tableName = null;
        @Parameter(names={"--port"}, description="port number to use")
        int port = DefaultConfiguration.getInstance().getPort(Property.TSERV_CLIENTPORT)[0];

        Opts() {
        }
    }

    public static class NullTServerTabletClientHandler
    implements TabletClientService.Iface,
    TabletScanClientService.Iface {
        private long updateSession = 1L;

        public long startUpdate(TInfo tinfo, TCredentials credentials, TDurability durability) {
            return this.updateSession++;
        }

        public void applyUpdates(TInfo tinfo, long updateID, TKeyExtent keyExtent, List<TMutation> mutation) {
        }

        public UpdateErrors closeUpdate(TInfo tinfo, long updateID) {
            return new UpdateErrors(new HashMap(), new ArrayList(), new HashMap());
        }

        public boolean cancelUpdate(TInfo tinfo, long updateID) throws TException {
            return true;
        }

        public List<TKeyExtent> bulkImport(TInfo tinfo, TCredentials credentials, long tid, Map<TKeyExtent, Map<String, MapFileInfo>> files, boolean setTime) {
            return null;
        }

        public void loadFiles(TInfo tinfo, TCredentials credentials, long tid, String dir, Map<TKeyExtent, Map<String, MapFileInfo>> fileMap, boolean setTime) {
        }

        public void closeMultiScan(TInfo tinfo, long scanID) {
        }

        public void closeScan(TInfo tinfo, long scanID) {
        }

        public MultiScanResult continueMultiScan(TInfo tinfo, long scanID, long busyTimeout) {
            return null;
        }

        public ScanResult continueScan(TInfo tinfo, long scanID, long busyTimeout) {
            return null;
        }

        public void splitTablet(TInfo tinfo, TCredentials credentials, TKeyExtent extent, ByteBuffer splitPoint) {
        }

        public InitialMultiScan startMultiScan(TInfo tinfo, TCredentials credentials, Map<TKeyExtent, List<TRange>> batch, List<TColumn> columns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration tsc, long batchTimeOut, String context, Map<String, String> executionHints, long busyTimeout) {
            return null;
        }

        public InitialScan startScan(TInfo tinfo, TCredentials credentials, TKeyExtent extent, TRange range, List<TColumn> columns, int batchSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration tsc, long batchTimeOut, String classLoaderContext, Map<String, String> executionHints, long busyTimeout) {
            return null;
        }

        public void update(TInfo tinfo, TCredentials credentials, TKeyExtent keyExtent, TMutation mutation, TDurability durability) {
        }

        public TabletServerStatus getTabletServerStatus(TInfo tinfo, TCredentials credentials) {
            return null;
        }

        public List<TabletStats> getTabletStats(TInfo tinfo, TCredentials credentials, String tableId) {
            return null;
        }

        public TabletStats getHistoricalStats(TInfo tinfo, TCredentials credentials) {
            return null;
        }

        public void halt(TInfo tinfo, TCredentials credentials, String lock) {
        }

        public void fastHalt(TInfo tinfo, TCredentials credentials, String lock) {
        }

        public void loadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent extent) {
        }

        public void unloadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent extent, TUnloadTabletGoal goal, long requestTime) {
        }

        public List<ActiveScan> getActiveScans(TInfo tinfo, TCredentials credentials) {
            return new ArrayList<ActiveScan>();
        }

        public void chop(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent extent) {
        }

        public void flushTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent extent) {
        }

        public void compact(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) {
        }

        public void flush(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) {
        }

        public List<ActiveCompaction> getActiveCompactions(TInfo tinfo, TCredentials credentials) {
            return new ArrayList<ActiveCompaction>();
        }

        public TConditionalSession startConditionalUpdate(TInfo tinfo, TCredentials credentials, List<ByteBuffer> authorizations, String tableID, TDurability durability, String classLoaderContext) {
            return null;
        }

        public List<TCMResult> conditionalUpdate(TInfo tinfo, long sessID, Map<TKeyExtent, List<TConditionalMutation>> mutations, List<String> symbols) {
            return null;
        }

        public void invalidateConditionalUpdate(TInfo tinfo, long sessID) {
        }

        public void closeConditionalUpdate(TInfo tinfo, long sessID) {
        }

        public List<String> getActiveLogs(TInfo tinfo, TCredentials credentials) {
            return null;
        }

        public void removeLogs(TInfo tinfo, TCredentials credentials, List<String> filenames) {
        }

        public TSummaries startGetSummaries(TInfo tinfo, TCredentials credentials, TSummaryRequest request) {
            return null;
        }

        public TSummaries startGetSummariesForPartition(TInfo tinfo, TCredentials credentials, TSummaryRequest request, int modulus, int remainder) {
            return null;
        }

        public TSummaries startGetSummariesFromFiles(TInfo tinfo, TCredentials credentials, TSummaryRequest request, Map<String, List<TRowRange>> files) {
            return null;
        }

        public TSummaries contiuneGetSummaries(TInfo tinfo, long sessionId) {
            return null;
        }

        public List<TCompactionQueueSummary> getCompactionQueueInfo(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            return null;
        }

        public TExternalCompactionJob reserveCompactionJob(TInfo tinfo, TCredentials credentials, String queueName, long priority, String compactor, String externalCompactionId) throws ThriftSecurityException, TException {
            return null;
        }

        public void compactionJobFinished(TInfo tinfo, TCredentials credentials, String externalCompactionId, TKeyExtent extent, long fileSize, long entries) throws ThriftSecurityException, TException {
        }

        public void compactionJobFailed(TInfo tinfo, TCredentials credentials, String externalCompactionId, TKeyExtent extent) throws TException {
        }
    }
}

