/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.Timeout;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.miniclusterImpl.ZooKeeperBindException;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.replication.AccumuloReplicaSystem;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled(value="Replication ITs are not stable and not currently maintained")
@Tag(value="MiniClusterOnly")
@Deprecated
public class CyclicReplicationIT
extends AccumuloITBase {
    private static final Logger log = LoggerFactory.getLogger(CyclicReplicationIT.class);
    @RegisterExtension
    Timeout timeout = Timeout.from(() -> {
        long waitLonger = 1L;
        try {
            String timeoutString = System.getProperty("timeout.factor");
            if (timeoutString != null && !timeoutString.isEmpty()) {
                waitLonger = Long.parseLong(timeoutString);
            }
        }
        catch (NumberFormatException exception) {
            log.warn("Could not parse timeout.factor, not scaling timeout");
        }
        return Duration.ofMinutes(waitLonger * 10L);
    });

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    private File createTheTestDir(String name) {
        File baseDir = new File(System.getProperty("user.dir") + "/target/mini-tests");
        Assertions.assertTrue((baseDir.mkdirs() || baseDir.isDirectory() ? 1 : 0) != 0);
        File testDir = new File(baseDir, this.getClass().getName() + "_" + this.testName() + "_" + name);
        FileUtils.deleteQuietly((File)testDir);
        Assertions.assertTrue((boolean)testDir.mkdir());
        return testDir;
    }

    private void setCoreSite(MiniAccumuloClusterImpl cluster) throws Exception {
        File csFile = new File(cluster.getConfig().getConfDir(), "core-site.xml");
        if (csFile.exists()) {
            throw new RuntimeException(csFile + " already exist");
        }
        Configuration coreSite = new Configuration(false);
        coreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(cluster.getConfig().getConfDir(), "core-site.xml")));
        coreSite.writeXml((OutputStream)out);
        ((OutputStream)out).close();
    }

    private void updatePeerConfigFromPrimary(MiniAccumuloConfigImpl primaryCfg, MiniAccumuloConfigImpl peerCfg) {
        String credProvider;
        Map primarySiteConfig = primaryCfg.getSiteConfig();
        if ("true".equals(primarySiteConfig.get(Property.INSTANCE_RPC_SSL_ENABLED.getKey()))) {
            String truststorePassword;
            HashMap<String, String> peerSiteConfig = new HashMap<String, String>();
            peerSiteConfig.put(Property.INSTANCE_RPC_SSL_ENABLED.getKey(), "true");
            String keystorePath = (String)primarySiteConfig.get(Property.RPC_SSL_KEYSTORE_PATH.getKey());
            Assertions.assertNotNull((Object)keystorePath, (String)"Keystore Path was null");
            peerSiteConfig.put(Property.RPC_SSL_KEYSTORE_PATH.getKey(), keystorePath);
            String truststorePath = (String)primarySiteConfig.get(Property.RPC_SSL_TRUSTSTORE_PATH.getKey());
            Assertions.assertNotNull((Object)truststorePath, (String)"Truststore Path was null");
            peerSiteConfig.put(Property.RPC_SSL_TRUSTSTORE_PATH.getKey(), truststorePath);
            String keystorePassword = (String)primarySiteConfig.get(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey());
            if (keystorePassword != null) {
                peerSiteConfig.put(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey(), keystorePassword);
            }
            if ((truststorePassword = (String)primarySiteConfig.get(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey())) != null) {
                peerSiteConfig.put(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey(), truststorePassword);
            }
            System.out.println("Setting site configuration for peer " + peerSiteConfig);
            peerCfg.setSiteConfig(peerSiteConfig);
        }
        if ((credProvider = (String)primarySiteConfig.get(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey())) != null) {
            Map peerSiteConfig = peerCfg.getSiteConfig();
            peerSiteConfig.put(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey(), credProvider);
            peerCfg.setSiteConfig(peerSiteConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataIsNotOverReplicated() throws Exception {
        MiniAccumuloClusterImpl manager2Cluster;
        MiniAccumuloClusterImpl manager1Cluster;
        MiniAccumuloConfigImpl manager1Cfg;
        File manager1Dir = this.createTheTestDir("manager1");
        File manager2Dir = this.createTheTestDir("manager2");
        String password = "password";
        while (true) {
            manager1Cfg = new MiniAccumuloConfigImpl(manager1Dir, password);
            manager1Cfg.setNumTservers(1);
            manager1Cfg.setInstanceName("manager1");
            ConfigurableMacBase.configureForEnvironment(manager1Cfg, ConfigurableMacBase.getSslDir(manager1Dir));
            manager1Cfg.setProperty(Property.REPLICATION_NAME, manager1Cfg.getInstanceName());
            manager1Cfg.setProperty(Property.TSERV_WAL_MAX_SIZE, "5M");
            manager1Cfg.setProperty(Property.REPLICATION_THREADCHECK, "5m");
            manager1Cfg.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP, "1s");
            manager1Cfg.setProperty(Property.MANAGER_REPLICATION_SCAN_INTERVAL, "1s");
            manager1Cluster = new MiniAccumuloClusterImpl(manager1Cfg);
            this.setCoreSite(manager1Cluster);
            try {
                manager1Cluster.start();
            }
            catch (ZooKeeperBindException e) {
                log.warn("Failed to start ZooKeeper on {}, will retry", (Object)manager1Cfg.getZooKeeperPort());
                continue;
            }
            break;
        }
        while (true) {
            MiniAccumuloConfigImpl manager2Cfg = new MiniAccumuloConfigImpl(manager2Dir, password);
            manager2Cfg.setNumTservers(1);
            manager2Cfg.setInstanceName("manager2");
            this.updatePeerConfigFromPrimary(manager1Cfg, manager2Cfg);
            manager2Cfg.setProperty(Property.REPLICATION_NAME, manager2Cfg.getInstanceName());
            manager2Cfg.setProperty(Property.TSERV_WAL_MAX_SIZE, "5M");
            manager2Cfg.setProperty(Property.REPLICATION_THREADCHECK, "5m");
            manager2Cfg.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP, "1s");
            manager2Cfg.setProperty(Property.MANAGER_REPLICATION_SCAN_INTERVAL, "1s");
            manager2Cluster = new MiniAccumuloClusterImpl(manager2Cfg);
            this.setCoreSite(manager2Cluster);
            try {
                manager2Cluster.start();
            }
            catch (ZooKeeperBindException e) {
                log.warn("Failed to start ZooKeeper on {}, will retry", (Object)manager2Cfg.getZooKeeperPort());
                continue;
            }
            break;
        }
        try {
            Map.Entry<Key, Value> entry;
            AccumuloClient clientManager1 = manager1Cluster.createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)password));
            AccumuloClient clientManager2 = manager2Cluster.createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)password));
            String manager1UserName = "manager1";
            String manager1Password = "foo";
            String manager2UserName = "manager2";
            String manager2Password = "bar";
            String manager1Table = manager1Cluster.getInstanceName();
            String manager2Table = manager2Cluster.getInstanceName();
            clientManager1.securityOperations().createLocalUser(manager1UserName, new PasswordToken((CharSequence)manager1Password));
            clientManager2.securityOperations().createLocalUser(manager2UserName, new PasswordToken((CharSequence)manager2Password));
            clientManager1.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + manager2Cluster.getInstanceName(), manager2UserName);
            clientManager1.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + manager2Cluster.getInstanceName(), manager2Password);
            clientManager2.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + manager1Cluster.getInstanceName(), manager1UserName);
            clientManager2.instanceOperations().setProperty(Property.REPLICATION_PEER_PASSWORD.getKey() + manager1Cluster.getInstanceName(), manager1Password);
            clientManager1.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + manager2Cluster.getInstanceName(), ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)manager2Cluster.getInstanceName(), (String)manager2Cluster.getZooKeepers())));
            clientManager2.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + manager1Cluster.getInstanceName(), ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)manager1Cluster.getInstanceName(), (String)manager1Cluster.getZooKeepers())));
            clientManager1.tableOperations().create(manager1Table, new NewTableConfiguration().withoutDefaultIterators());
            String manager1TableId = (String)clientManager1.tableOperations().tableIdMap().get(manager1Table);
            Assertions.assertNotNull((Object)manager1TableId);
            clientManager2.tableOperations().create(manager2Table, new NewTableConfiguration().withoutDefaultIterators());
            String manager2TableId = (String)clientManager2.tableOperations().tableIdMap().get(manager2Table);
            Assertions.assertNotNull((Object)manager2TableId);
            clientManager1.tableOperations().setProperty(manager1Table, Property.TABLE_REPLICATION.getKey(), "true");
            clientManager1.tableOperations().setProperty(manager1Table, Property.TABLE_REPLICATION_TARGET.getKey() + manager2Cluster.getInstanceName(), manager2TableId);
            clientManager2.tableOperations().setProperty(manager2Table, Property.TABLE_REPLICATION.getKey(), "true");
            clientManager2.tableOperations().setProperty(manager2Table, Property.TABLE_REPLICATION_TARGET.getKey() + manager1Cluster.getInstanceName(), manager1TableId);
            clientManager1.securityOperations().grantTablePermission(manager1UserName, manager1Table, TablePermission.WRITE);
            clientManager2.securityOperations().grantTablePermission(manager2UserName, manager2Table, TablePermission.WRITE);
            IteratorSetting summingCombiner = new IteratorSetting(50, SummingCombiner.class);
            SummingCombiner.setEncodingType((IteratorSetting)summingCombiner, (LongCombiner.Type)LongCombiner.Type.STRING);
            SummingCombiner.setCombineAllColumns((IteratorSetting)summingCombiner, (boolean)true);
            clientManager1.tableOperations().attachIterator(manager1Table, summingCombiner);
            clientManager2.tableOperations().attachIterator(manager2Table, summingCombiner);
            try (BatchWriter bw = clientManager1.createBatchWriter(manager1Table);){
                Mutation m = new Mutation((CharSequence)"row");
                m.put((CharSequence)"count", (CharSequence)"", (CharSequence)"1");
                bw.addMutation(m);
            }
            Set files = clientManager1.replicationOperations().referencedFiles(manager1Table);
            log.info("Found {} that need replication from manager1", (Object)files);
            for (ProcessReference proc : (Collection)manager1Cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                manager1Cluster.killProcess(ServerType.TABLET_SERVER, proc);
            }
            manager1Cluster.exec(TabletServer.class, new String[0]);
            log.info("Restarted tserver on manager1");
            Thread.sleep(1000L);
            try (Scanner s = clientManager1.createScanner(manager1Table, Authorizations.EMPTY);){
                entry = this.getOnlyElement(s);
                Assertions.assertEquals((Object)"1", (Object)entry.getValue().toString());
                clientManager1.replicationOperations().drain(manager1Table, files);
                Thread.sleep(5000L);
            }
            s = clientManager2.createScanner(manager2Table, Authorizations.EMPTY);
            try {
                entry = this.getOnlyElement(s);
                Assertions.assertEquals((Object)"1", (Object)entry.getValue().toString());
                files = clientManager2.replicationOperations().referencedFiles(manager2Table);
                for (ProcessReference proc : (Collection)manager2Cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                    manager2Cluster.killProcess(ServerType.TABLET_SERVER, proc);
                }
                manager2Cluster.exec(TabletServer.class, new String[0]);
                Thread.sleep(1000L);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            s = clientManager2.createScanner(manager2Table, Authorizations.EMPTY);
            try {
                entry = this.getOnlyElement(s);
                Assertions.assertEquals((Object)"1", (Object)entry.getValue().toString());
                clientManager2.replicationOperations().drain(manager2Table, files);
                Thread.sleep(5000L);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            s = clientManager1.createScanner(manager1Table, Authorizations.EMPTY);
            try {
                entry = this.getOnlyElement(s);
                Assertions.assertEquals((Object)"1", (Object)entry.getValue().toString());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        finally {
            manager1Cluster.stop();
            manager2Cluster.stop();
        }
    }
}

