/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.protobuf.GeneratedMessageV3;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.manager.replication.FinishedWorkUpdater;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="Replication ITs are not stable and not currently maintained")
@Deprecated
public class FinishedWorkUpdaterIT
extends ConfigurableMacBase {
    private AccumuloClient client;
    private FinishedWorkUpdater updater;

    @BeforeEach
    public void configureUpdater() {
        this.client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        this.updater = new FinishedWorkUpdater(this.client);
    }

    @Test
    public void offlineReplicationTableFailsGracefully() {
        this.updater.run();
    }

    @Test
    public void recordsWithProgressUpdateBothTables() throws Exception {
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.READ);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.WRITE);
        ReplicationTable.setOnline((AccumuloClient)this.client);
        String file = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        Replication.Status stat = Replication.Status.newBuilder().setBegin(100L).setEnd(200L).setClosed(true).setInfiniteEnd(false).build();
        ReplicationTarget target = new ReplicationTarget("peer", "table1", TableId.of((String)"1"));
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        Mutation m = new Mutation((CharSequence)file);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)ProtobufUtil.toValue((GeneratedMessageV3)stat));
        bw.addMutation(m);
        bw.close();
        this.updater.run();
        try (Scanner s = ReplicationTable.getScanner((AccumuloClient)this.client);){
            s.setRange(Range.exact((CharSequence)file));
            ReplicationSchema.StatusSection.limit((ScannerBase)s);
            Map.Entry<Key, Value> entry = this.getOnlyElement(s);
            Assertions.assertEquals((Object)entry.getKey().getColumnFamily(), (Object)ReplicationSchema.StatusSection.NAME);
            Assertions.assertEquals((Object)entry.getKey().getColumnQualifier().toString(), (Object)target.getSourceTableId().canonical());
            Replication.Status actual = Replication.Status.parseFrom((byte[])entry.getValue().get());
            Assertions.assertEquals((long)stat.getBegin(), (long)actual.getBegin());
        }
    }

    @Test
    public void chooseMinimumBeginOffset() throws Exception {
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.READ);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.WRITE);
        ReplicationTable.setOnline((AccumuloClient)this.client);
        String file = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        Replication.Status stat1 = Replication.Status.newBuilder().setBegin(100L).setEnd(1000L).setClosed(true).setInfiniteEnd(false).build();
        Replication.Status stat2 = Replication.Status.newBuilder().setBegin(500L).setEnd(1000L).setClosed(true).setInfiniteEnd(false).build();
        Replication.Status stat3 = Replication.Status.newBuilder().setBegin(1L).setEnd(1000L).setClosed(true).setInfiniteEnd(false).build();
        ReplicationTarget target1 = new ReplicationTarget("peer1", "table1", TableId.of((String)"1"));
        ReplicationTarget target2 = new ReplicationTarget("peer2", "table2", TableId.of((String)"1"));
        ReplicationTarget target3 = new ReplicationTarget("peer3", "table3", TableId.of((String)"1"));
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        Mutation m = new Mutation((CharSequence)file);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target1.toText(), (Value)ProtobufUtil.toValue((GeneratedMessageV3)stat1));
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target2.toText(), (Value)ProtobufUtil.toValue((GeneratedMessageV3)stat2));
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target3.toText(), (Value)ProtobufUtil.toValue((GeneratedMessageV3)stat3));
        bw.addMutation(m);
        bw.close();
        this.updater.run();
        try (Scanner s = ReplicationTable.getScanner((AccumuloClient)this.client);){
            s.setRange(Range.exact((CharSequence)file));
            ReplicationSchema.StatusSection.limit((ScannerBase)s);
            Map.Entry<Key, Value> entry = this.getOnlyElement(s);
            Assertions.assertEquals((Object)entry.getKey().getColumnFamily(), (Object)ReplicationSchema.StatusSection.NAME);
            Assertions.assertEquals((Object)entry.getKey().getColumnQualifier().toString(), (Object)target1.getSourceTableId().canonical());
            Replication.Status actual = Replication.Status.parseFrom((byte[])entry.getValue().get());
            Assertions.assertEquals((long)1L, (long)actual.getBegin());
        }
    }

    @Test
    public void chooseMinimumBeginOffsetInfiniteEnd() throws Exception {
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.READ);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.WRITE);
        ReplicationTable.setOnline((AccumuloClient)this.client);
        String file = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        Replication.Status stat1 = Replication.Status.newBuilder().setBegin(100L).setEnd(1000L).setClosed(true).setInfiniteEnd(true).build();
        Replication.Status stat2 = Replication.Status.newBuilder().setBegin(1L).setEnd(1000L).setClosed(true).setInfiniteEnd(true).build();
        Replication.Status stat3 = Replication.Status.newBuilder().setBegin(500L).setEnd(1000L).setClosed(true).setInfiniteEnd(true).build();
        ReplicationTarget target1 = new ReplicationTarget("peer1", "table1", TableId.of((String)"1"));
        ReplicationTarget target2 = new ReplicationTarget("peer2", "table2", TableId.of((String)"1"));
        ReplicationTarget target3 = new ReplicationTarget("peer3", "table3", TableId.of((String)"1"));
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        Mutation m = new Mutation((CharSequence)file);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target1.toText(), (Value)ProtobufUtil.toValue((GeneratedMessageV3)stat1));
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target2.toText(), (Value)ProtobufUtil.toValue((GeneratedMessageV3)stat2));
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target3.toText(), (Value)ProtobufUtil.toValue((GeneratedMessageV3)stat3));
        bw.addMutation(m);
        bw.close();
        this.updater.run();
        try (Scanner s = ReplicationTable.getScanner((AccumuloClient)this.client);){
            s.setRange(Range.exact((CharSequence)file));
            ReplicationSchema.StatusSection.limit((ScannerBase)s);
            Map.Entry<Key, Value> entry = this.getOnlyElement(s);
            Assertions.assertEquals((Object)entry.getKey().getColumnFamily(), (Object)ReplicationSchema.StatusSection.NAME);
            Assertions.assertEquals((Object)entry.getKey().getColumnQualifier().toString(), (Object)target1.getSourceTableId().canonical());
            Replication.Status actual = Replication.Status.parseFrom((byte[])entry.getValue().get());
            Assertions.assertEquals((long)1L, (long)actual.getBegin());
        }
    }
}

