/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.manager.replication.SequentialWorkAssigner;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.test.functional.KerberosIT;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.replication.AccumuloReplicaSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled(value="Replication ITs are not stable and not currently maintained")
@Tag(value="MiniClusterOnly")
@Deprecated
public class KerberosReplicationIT
extends AccumuloITBase {
    private static final Logger log = LoggerFactory.getLogger(KerberosIT.class);
    private static TestingKdc kdc;
    private static String krbEnabledForITs;
    private static ClusterUser rootUser;
    private MiniAccumuloClusterImpl primary;
    private MiniAccumuloClusterImpl peer;
    private String PRIMARY_NAME = "primary";
    private String PEER_NAME = "peer";

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(3L);
    }

    @BeforeAll
    public static void startKdc() throws Exception {
        kdc = new TestingKdc();
        kdc.start();
        krbEnabledForITs = System.getProperty("org.apache.accumulo.test.functional.useKrbForIT");
        if (krbEnabledForITs == null || !Boolean.parseBoolean(krbEnabledForITs)) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", "true");
        }
        rootUser = kdc.getRootUser();
    }

    @AfterAll
    public static void stopKdc() {
        if (kdc != null) {
            kdc.stop();
        }
        if (krbEnabledForITs != null) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", krbEnabledForITs);
        }
    }

    private MiniClusterConfigurationCallback getConfigCallback(final String name) {
        return new MiniClusterConfigurationCallback(){

            @Override
            public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
                cfg.setNumTservers(1);
                cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
                cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
                cfg.setProperty(Property.TSERV_WAL_MAX_SIZE, "2M");
                cfg.setProperty(Property.GC_CYCLE_START, "1s");
                cfg.setProperty(Property.GC_CYCLE_DELAY, "5s");
                cfg.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP, "1s");
                cfg.setProperty(Property.MANAGER_REPLICATION_SCAN_INTERVAL, "1s");
                cfg.setProperty(Property.REPLICATION_NAME, name);
                cfg.setProperty(Property.REPLICATION_MAX_UNIT_SIZE, "8M");
                cfg.setProperty(Property.REPLICATION_WORK_ASSIGNER, SequentialWorkAssigner.class.getName());
                cfg.setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX, "1M");
                coreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
                coreSite.set("fs.defaultFS", "file:///");
            }
        };
    }

    @BeforeEach
    public void setup() throws Exception {
        MiniClusterHarness harness = new MiniClusterHarness();
        this.primary = harness.create(this.getClass().getName(), this.testName(), (AuthenticationToken)new PasswordToken((CharSequence)"unused"), this.getConfigCallback(this.PRIMARY_NAME), kdc);
        this.primary.start();
        this.peer = harness.create(this.getClass().getName(), this.testName() + "_peer", (AuthenticationToken)new PasswordToken((CharSequence)"unused"), this.getConfigCallback(this.PEER_NAME), kdc);
        this.peer.start();
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @AfterEach
    public void teardown() throws Exception {
        if (this.peer != null) {
            this.peer.stop();
        }
        if (this.primary != null) {
            this.primary.stop();
        }
        UserGroupInformation.setConfiguration((Configuration)new Configuration(false));
    }

    @Test
    public void dataReplicatedToCorrectTable() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().toURI().toString());
        ugi.doAs(() -> {
            log.info("testing {}", (Object)ugi);
            KerberosToken token = new KerberosToken();
            try (AccumuloClient primaryclient = this.primary.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)token);){
                Void void_;
                block37: {
                    AccumuloClient peerclient = this.peer.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)token);
                    try {
                        ClusterUser replicationUser = kdc.getClientPrincipal(0);
                        peerclient.securityOperations().createLocalUser(replicationUser.getPrincipal(), null);
                        primaryclient.instanceOperations().setProperty(Property.REPLICATION_PEER_USER.getKey() + this.PEER_NAME, replicationUser.getPrincipal());
                        primaryclient.instanceOperations().setProperty(Property.REPLICATION_PEER_KEYTAB.getKey() + this.PEER_NAME, replicationUser.getKeytab().getAbsolutePath());
                        ClientInfo info = ClientInfo.from((Properties)peerclient.properties());
                        primaryclient.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + this.PEER_NAME, ReplicaSystemFactory.getPeerConfigurationValue(AccumuloReplicaSystem.class, (String)AccumuloReplicaSystem.buildConfiguration((String)info.getInstanceName(), (String)info.getZooKeepers())));
                        String primaryTable1 = "primary";
                        String peerTable1 = "peer";
                        peerclient.tableOperations().create(peerTable1);
                        String peerTableId1 = (String)peerclient.tableOperations().tableIdMap().get(peerTable1);
                        Assertions.assertNotNull((Object)peerTableId1);
                        HashMap<Object, String> props = new HashMap<Object, String>();
                        props.put(Property.TABLE_REPLICATION.getKey(), "true");
                        props.put(Property.TABLE_REPLICATION_TARGET.getKey() + this.PEER_NAME, peerTableId1);
                        primaryclient.tableOperations().create(primaryTable1, new NewTableConfiguration().setProperties(props));
                        String managerTableId1 = (String)primaryclient.tableOperations().tableIdMap().get(primaryTable1);
                        Assertions.assertNotNull((Object)managerTableId1);
                        peerclient.securityOperations().grantTablePermission(replicationUser.getPrincipal(), peerTable1, TablePermission.WRITE);
                        long managerTable1Records = 0L;
                        try (BatchWriter bw = primaryclient.createBatchWriter(primaryTable1);){
                            for (int rows = 0; rows < 2500; ++rows) {
                                Mutation m = new Mutation((CharSequence)(primaryTable1 + rows));
                                for (int cols = 0; cols < 100; ++cols) {
                                    String value = Integer.toString(cols);
                                    m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                                    ++managerTable1Records;
                                }
                                bw.addMutation(m);
                            }
                        }
                        log.info("Wrote all data to primary cluster");
                        Set filesFor1 = primaryclient.replicationOperations().referencedFiles(primaryTable1);
                        for (ProcessReference proc : (Collection)this.primary.getProcesses().get(ServerType.TABLET_SERVER)) {
                            this.primary.killProcess(ServerType.TABLET_SERVER, proc);
                        }
                        this.primary.exec(TabletServer.class, new String[0]);
                        log.info("Restarted the tserver");
                        try (Scanner scanner = primaryclient.createScanner(primaryTable1, Authorizations.EMPTY);){
                            scanner.forEach((k, v) -> {});
                        }
                        log.info("Waiting for {} for {}", (Object)filesFor1, (Object)primaryTable1);
                        primaryclient.replicationOperations().drain(primaryTable1, filesFor1);
                        long countTable = 0L;
                        try (Scanner scanner = peerclient.createScanner(peerTable1, Authorizations.EMPTY);){
                            for (Map.Entry entry : scanner) {
                                ++countTable;
                                Assertions.assertTrue((boolean)((Key)entry.getKey()).getRow().toString().startsWith(primaryTable1), (String)("Found unexpected key-value" + ((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue()));
                            }
                        }
                        log.info("Found {} records in {}", (Object)countTable, (Object)peerTable1);
                        Assertions.assertEquals((long)managerTable1Records, (long)countTable);
                        void_ = null;
                        if (peerclient == null) break block37;
                    }
                    catch (Throwable throwable) {
                        if (peerclient != null) {
                            try {
                                peerclient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    peerclient.close();
                }
                return void_;
            }
        });
    }

    static {
        krbEnabledForITs = null;
    }
}

