/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled(value="Replication ITs are not stable and not currently maintained")
@Deprecated
public class MultiTserverReplicationIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(MultiTserverReplicationIT.class);

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.REPLICATION_NAME.getKey(), "test");
        cfg.setNumTservers(2);
    }

    @Test
    public void tserverReplicationServicePortsAreAdvertised() throws Exception {
        AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        ClientContext context = (ClientContext)client;
        client.tableOperations().create("foo");
        try (Scanner s = client.createScanner("foo", Authorizations.EMPTY);){
            Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)s));
            ZooReader zreader = context.getZooReader();
            HashSet tserverHost = new HashSet();
            tserverHost.addAll(zreader.getChildren(ZooUtil.getRoot((InstanceId)client.instanceOperations().getInstanceId()) + "/tservers"));
            HashSet<HostAndPort> replicationServices = new HashSet<HostAndPort>();
            for (String tserver : tserverHost) {
                try {
                    byte[] portData = zreader.getData(ZooUtil.getRoot((InstanceId)client.instanceOperations().getInstanceId()) + "/replication/tservers/" + tserver);
                    HostAndPort replAddress = HostAndPort.fromString((String)new String(portData, StandardCharsets.UTF_8));
                    replicationServices.add(replAddress);
                }
                catch (Exception e) {
                    log.error("Could not find port for {}", (Object)tserver, (Object)e);
                    Assertions.fail((String)("Did not find replication port advertisement for " + tserver));
                }
            }
            Assertions.assertEquals((int)tserverHost.size(), (int)replicationServices.size(), (String)"Expected an equal number of replication servicers and tservers");
        }
    }

    @Test
    public void managerReplicationServicePortsAreAdvertised() throws Exception {
        AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        ClientContext context = (ClientContext)client;
        client.tableOperations().create("foo");
        try (Scanner s = client.createScanner("foo", Authorizations.EMPTY);){
            Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)s));
            ZooReader zreader = context.getZooReader();
            Assertions.assertEquals((int)1, (int)context.getManagerLocations().size());
            String managerAddr = (String)this.getOnlyElement(context.getManagerLocations());
            String replCoordAddr = new String(zreader.getData(ZooUtil.getRoot((InstanceId)client.instanceOperations().getInstanceId()) + "/managers/repl_coord_addr"), StandardCharsets.UTF_8);
            Assertions.assertNotEquals((Object)managerAddr, (Object)replCoordAddr);
            Assertions.assertNotEquals((int)0, (int)HostAndPort.fromString((String)managerAddr).getPort());
            Assertions.assertNotEquals((int)0, (int)HostAndPort.fromString((String)replCoordAddr).getPort());
        }
    }
}

