/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.GeneratedMessageV3;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.manager.replication.RemoveCompleteReplicationRecords;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="Replication ITs are not stable and not currently maintained")
@Deprecated
public class RemoveCompleteReplicationRecordsIT
extends ConfigurableMacBase {
    private MockRemoveCompleteReplicationRecords rcrr;
    private AccumuloClient client;

    @BeforeEach
    public void initialize() throws Exception {
        this.client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        this.rcrr = new MockRemoveCompleteReplicationRecords(this.client);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.READ);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.WRITE);
        ReplicationTable.setOnline((AccumuloClient)this.client);
    }

    private TableId createTableId(int i) {
        return TableId.of((String)Integer.toString(i));
    }

    @Test
    public void notYetReplicationRecordsIgnored() throws Exception {
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        int numRecords = 3;
        for (int i = 0; i < numRecords; ++i) {
            String file = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
            Mutation m = new Mutation((CharSequence)file);
            ReplicationSchema.StatusSection.add((Mutation)m, (TableId)this.createTableId(i), (Value)StatusUtil.openWithUnknownLengthValue());
            bw.addMutation(m);
        }
        bw.close();
        Assertions.assertEquals((int)numRecords, (int)Iterables.size((Iterable)ReplicationTable.getScanner((AccumuloClient)this.client)));
        try (BatchScanner bs = ReplicationTable.getBatchScanner((AccumuloClient)this.client, (int)1);){
            bs.setRanges(Collections.singleton(new Range()));
            IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
            bs.addScanIterator(cfg);
            bw = (BatchWriter)EasyMock.createMock(BatchWriter.class);
            EasyMock.replay((Object[])new Object[]{bw});
            this.rcrr.removeCompleteRecords(this.client, bs, bw);
            Assertions.assertEquals((int)numRecords, (int)Iterables.size((Iterable)ReplicationTable.getScanner((AccumuloClient)this.client)));
        }
    }

    @Test
    public void partiallyReplicatedRecordsIgnored() throws Exception {
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        int numRecords = 3;
        Replication.Status.Builder builder = Replication.Status.newBuilder();
        builder.setClosed(false);
        builder.setEnd(10000L);
        builder.setInfiniteEnd(false);
        for (int i = 0; i < numRecords; ++i) {
            String file = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
            Mutation m = new Mutation((CharSequence)file);
            ReplicationSchema.StatusSection.add((Mutation)m, (TableId)this.createTableId(i), (Value)ProtobufUtil.toValue((GeneratedMessageV3)builder.setBegin((long)(1000 * (i + 1))).build()));
            bw.addMutation(m);
        }
        bw.close();
        Assertions.assertEquals((int)numRecords, (int)Iterables.size((Iterable)ReplicationTable.getScanner((AccumuloClient)this.client)));
        try (BatchScanner bs = ReplicationTable.getBatchScanner((AccumuloClient)this.client, (int)1);){
            bs.setRanges(Collections.singleton(new Range()));
            IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
            bs.addScanIterator(cfg);
            bw = (BatchWriter)EasyMock.createMock(BatchWriter.class);
            EasyMock.replay((Object[])new Object[]{bw});
            this.rcrr.removeCompleteRecords(this.client, bs, bw);
            Assertions.assertEquals((int)numRecords, (int)Iterables.size((Iterable)ReplicationTable.getScanner((AccumuloClient)this.client)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void replicatedClosedWorkRecordsAreNotRemovedWithoutClosedStatusRecords() throws Exception {
        BatchWriter replBw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        int numRecords = 3;
        Replication.Status.Builder builder = Replication.Status.newBuilder();
        builder.setClosed(false);
        builder.setEnd(10000L);
        builder.setInfiniteEnd(false);
        for (int i = 0; i < numRecords; ++i) {
            String file = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
            Mutation m = new Mutation((CharSequence)file);
            ReplicationSchema.StatusSection.add((Mutation)m, (TableId)this.createTableId(i), (Value)ProtobufUtil.toValue((GeneratedMessageV3)builder.setBegin((long)(1000 * (i + 1))).build()));
            replBw.addMutation(m);
        }
        String fileToRemove = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
        Mutation m = new Mutation((CharSequence)fileToRemove);
        ReplicationSchema.StatusSection.add((Mutation)m, (TableId)TableId.of((String)"5"), (Value)ProtobufUtil.toValue((GeneratedMessageV3)builder.setBegin(10000L).setEnd(10000L).setClosed(false).build()));
        replBw.addMutation(m);
        ++numRecords;
        fileToRemove = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
        m = new Mutation((CharSequence)fileToRemove);
        ReplicationSchema.StatusSection.add((Mutation)m, (TableId)TableId.of((String)"6"), (Value)ProtobufUtil.toValue((GeneratedMessageV3)builder.setBegin(10000L).setEnd(10000L).setClosed(false).build()));
        replBw.addMutation(m);
        replBw.flush();
        Assertions.assertEquals((int)(++numRecords), (int)Iterables.size((Iterable)ReplicationTable.getScanner((AccumuloClient)this.client)));
        try (BatchScanner bs = ReplicationTable.getBatchScanner((AccumuloClient)this.client, (int)1);){
            bs.setRanges(Collections.singleton(new Range()));
            IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
            bs.addScanIterator(cfg);
            try {
                Assertions.assertEquals((long)0L, (long)this.rcrr.removeCompleteRecords(this.client, bs, replBw));
            }
            finally {
                replBw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void replicatedClosedRowsAreRemoved() throws Exception {
        BatchWriter replBw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        int numRecords = 3;
        Replication.Status.Builder builder = Replication.Status.newBuilder();
        builder.setClosed(false);
        builder.setEnd(10000L);
        builder.setInfiniteEnd(false);
        long time = System.currentTimeMillis();
        for (int i = 0; i < numRecords; ++i) {
            builder.setCreatedTime(time++);
            String file = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
            Mutation m = new Mutation((CharSequence)file);
            Value v = ProtobufUtil.toValue((GeneratedMessageV3)builder.setBegin((long)(1000 * (i + 1))).build());
            ReplicationSchema.StatusSection.add((Mutation)m, (TableId)this.createTableId(i), (Value)v);
            replBw.addMutation(m);
            m = ReplicationSchema.OrderSection.createMutation((String)file, (long)time);
            ReplicationSchema.OrderSection.add((Mutation)m, (TableId)this.createTableId(i), (Value)v);
            replBw.addMutation(m);
        }
        HashSet<CallSite> filesToRemove = new HashSet<CallSite>();
        int finalNumRecords = numRecords *= 2;
        String fileToRemove = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
        filesToRemove.add((CallSite)((Object)fileToRemove));
        Mutation m = new Mutation((CharSequence)fileToRemove);
        ReplicationTarget target = new ReplicationTarget("peer1", "5", TableId.of((String)"5"));
        Value value = ProtobufUtil.toValue((GeneratedMessageV3)builder.setBegin(10000L).setEnd(10000L).setClosed(true).setCreatedTime(time).build());
        ReplicationSchema.StatusSection.add((Mutation)m, (TableId)TableId.of((String)"5"), (Value)value);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)value);
        replBw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)fileToRemove, (long)time);
        ReplicationSchema.OrderSection.add((Mutation)m, (TableId)TableId.of((String)"5"), (Value)value);
        replBw.addMutation(m);
        ++time;
        numRecords += 3;
        fileToRemove = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
        filesToRemove.add((CallSite)((Object)fileToRemove));
        m = new Mutation((CharSequence)fileToRemove);
        value = ProtobufUtil.toValue((GeneratedMessageV3)builder.setBegin(10000L).setEnd(10000L).setClosed(true).setCreatedTime(time).build());
        target = new ReplicationTarget("peer1", "6", TableId.of((String)"6"));
        ReplicationSchema.StatusSection.add((Mutation)m, (TableId)TableId.of((String)"6"), (Value)value);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)value);
        replBw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)fileToRemove, (long)time);
        ReplicationSchema.OrderSection.add((Mutation)m, (TableId)TableId.of((String)"6"), (Value)value);
        replBw.addMutation(m);
        ++time;
        replBw.flush();
        Assertions.assertEquals((int)(numRecords += 3), (int)Iterables.size((Iterable)ReplicationTable.getScanner((AccumuloClient)this.client)));
        try (BatchScanner bs = ReplicationTable.getBatchScanner((AccumuloClient)this.client, (int)1);){
            bs.setRanges(Collections.singleton(new Range()));
            ReplicationSchema.StatusSection.limit((ScannerBase)bs);
            ReplicationSchema.WorkSection.limit((ScannerBase)bs);
            IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
            bs.addScanIterator(cfg);
            try {
                Assertions.assertEquals((long)4L, (long)this.rcrr.removeCompleteRecords(this.client, bs, replBw));
            }
            finally {
                replBw.close();
            }
            int actualRecords = 0;
            try (Scanner scanner = ReplicationTable.getScanner((AccumuloClient)this.client);){
                for (Map.Entry entry : scanner) {
                    Assertions.assertFalse((boolean)filesToRemove.contains(((Key)entry.getKey()).getRow().toString()));
                    ++actualRecords;
                }
            }
            Assertions.assertEquals((int)finalNumRecords, (int)actualRecords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void partiallyReplicatedEntriesPrecludeRowDeletion() throws Exception {
        BatchWriter replBw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        int numRecords = 3;
        Replication.Status.Builder builder = Replication.Status.newBuilder();
        builder.setClosed(false);
        builder.setEnd(10000L);
        builder.setInfiniteEnd(false);
        for (int i = 0; i < numRecords; ++i) {
            String file = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
            Mutation m = new Mutation((CharSequence)file);
            ReplicationSchema.StatusSection.add((Mutation)m, (TableId)this.createTableId(i), (Value)ProtobufUtil.toValue((GeneratedMessageV3)builder.setBegin((long)(1000 * (i + 1))).build()));
            replBw.addMutation(m);
        }
        String fileToRemove = "/accumulo/wal/tserver+port/" + UUID.randomUUID();
        Mutation m = new Mutation((CharSequence)fileToRemove);
        ReplicationTarget target = new ReplicationTarget("peer1", "5", TableId.of((String)"5"));
        Value value = ProtobufUtil.toValue((GeneratedMessageV3)builder.setBegin(10000L).setEnd(10000L).setClosed(true).build());
        ReplicationSchema.StatusSection.add((Mutation)m, (TableId)TableId.of((String)"5"), (Value)value);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)value);
        target = new ReplicationTarget("peer2", "5", TableId.of((String)"5"));
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)value);
        target = new ReplicationTarget("peer3", "5", TableId.of((String)"5"));
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)target.toText(), (Value)ProtobufUtil.toValue((GeneratedMessageV3)builder.setClosed(false).build()));
        replBw.addMutation(m);
        replBw.flush();
        Assertions.assertEquals((int)(numRecords += 4), (int)Iterables.size((Iterable)ReplicationTable.getScanner((AccumuloClient)this.client)));
        try (BatchScanner bs = ReplicationTable.getBatchScanner((AccumuloClient)this.client, (int)1);){
            bs.setRanges(Collections.singleton(new Range()));
            IteratorSetting cfg = new IteratorSetting(50, WholeRowIterator.class);
            bs.addScanIterator(cfg);
            try {
                Assertions.assertEquals((long)0L, (long)this.rcrr.removeCompleteRecords(this.client, bs, replBw));
            }
            finally {
                replBw.close();
            }
        }
    }

    private static class MockRemoveCompleteReplicationRecords
    extends RemoveCompleteReplicationRecords {
        public MockRemoveCompleteReplicationRecords(AccumuloClient client) {
            super(client);
        }

        public long removeCompleteRecords(AccumuloClient client, BatchScanner bs, BatchWriter bw) {
            return super.removeCompleteRecords(client, bs, bw);
        }
    }
}

