/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iteratorsImpl.conf.ColumnSet;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.server.replication.StatusCombiner;
import org.apache.accumulo.server.replication.StatusFormatter;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.util.ReplicationTableUtil;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.replication.MockReplicaSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled(value="Replication ITs are not stable and not currently maintained")
@Deprecated
public class ReplicationIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(ReplicationIT.class);
    private static final long MILLIS_BETWEEN_REPLICATION_TABLE_ONLINE_CHECKS = 5000L;

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.MANAGER_REPLICATION_SCAN_INTERVAL, "1s");
        cfg.setProperty(Property.REPLICATION_WORK_ASSIGNMENT_SLEEP, "1s");
        cfg.setProperty(Property.TSERV_WAL_MAX_SIZE, "1M");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "0");
        cfg.setProperty(Property.REPLICATION_NAME, "manager");
        cfg.setProperty(Property.REPLICATION_WORK_PROCESSOR_DELAY, "1s");
        cfg.setProperty(Property.REPLICATION_WORK_PROCESSOR_PERIOD, "1s");
        cfg.setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX, "1M");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    private Multimap<String, TableId> getLogs(AccumuloClient client, ServerContext context) throws Exception {
        HashMultimap serverToTableID = HashMultimap.create();
        try (Scanner scanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            scanner.setRange(MetadataSchema.TabletsSection.getRange());
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            for (Map.Entry entry : scanner) {
                TServerInstance tServer = new TServerInstance((Value)entry.getValue(), ((Key)entry.getKey()).getColumnQualifier());
                TableId tableId = KeyExtent.fromMetaRow((Text)((Key)entry.getKey()).getRow()).tableId();
                serverToTableID.put((Object)tServer, (Object)tableId);
            }
            HashMultimap logs = HashMultimap.create();
            WalStateManager wals = new WalStateManager(context);
            for (Map.Entry entry : wals.getAllMarkers().entrySet()) {
                for (UUID id : (List)entry.getValue()) {
                    Pair state = wals.state((TServerInstance)entry.getKey(), id);
                    for (TableId tableId : serverToTableID.get((Object)((TServerInstance)entry.getKey()))) {
                        logs.put((Object)((Path)state.getSecond()).toString(), (Object)tableId);
                    }
                }
            }
            HashMultimap hashMultimap = logs;
            return hashMultimap;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Multimap<String, TableId> getAllLogs(AccumuloClient client, ServerContext context) throws Exception {
        Multimap<String, TableId> logs = this.getLogs(client, context);
        try (Scanner scanner = context.createScanner(ReplicationTable.NAME, Authorizations.EMPTY);){
            ReplicationSchema.StatusSection.limit((ScannerBase)scanner);
            Text buff = new Text();
            Iterator iterator = scanner.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    Multimap<String, TableId> multimap = logs;
                    return multimap;
                }
                ReplicationSchema.StatusSection.getFile((Key)((Key)entry.getKey()), (Text)buff);
                String file = buff.toString();
                TableId tableId = ReplicationSchema.StatusSection.getTableId((Key)((Key)entry.getKey()));
                logs.put((Object)file, (Object)tableId);
            }
            return logs;
        }
        catch (TableOfflineException e) {
            log.debug("Replication table isn't online yet");
        }
        return logs;
    }

    private void waitForGCLock(AccumuloClient client) throws InterruptedException {
        ZooCache zcache = ((ClientContext)client).getZooCache();
        ServiceLock.ServiceLockPath zkPath = ServiceLock.path((String)(ZooUtil.getRoot((InstanceId)client.instanceOperations().getInstanceId()) + "/gc/lock"));
        log.info("Looking for GC lock at {}", (Object)zkPath);
        byte[] data = ServiceLock.getLockData((ZooCache)zcache, (ServiceLock.ServiceLockPath)zkPath, null);
        while (data == null) {
            log.info("Waiting for GC ZooKeeper lock to be acquired");
            Thread.sleep(1000L);
            data = ServiceLock.getLockData((ZooCache)zcache, (ServiceLock.ServiceLockPath)zkPath, null);
        }
    }

    @Test
    public void replicationTableCreated() {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Assertions.assertTrue((boolean)client.tableOperations().exists(ReplicationTable.NAME));
            Assertions.assertEquals((Object)ReplicationTable.ID.canonical(), client.tableOperations().tableIdMap().get(ReplicationTable.NAME));
        }
    }

    @Test
    public void verifyReplicationTableConfig() throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            TableOperations tops = client.tableOperations();
            Map iterators = tops.listIterators(ReplicationTable.NAME);
            Assertions.assertEquals((int)1, (int)iterators.size());
            Assertions.assertTrue((boolean)iterators.containsKey("statuscombiner"));
            Assertions.assertTrue((boolean)((EnumSet)iterators.get("statuscombiner")).containsAll(EnumSet.allOf(IteratorUtil.IteratorScope.class)));
            for (IteratorUtil.IteratorScope scope : EnumSet.allOf(IteratorUtil.IteratorScope.class)) {
                IteratorSetting is = tops.getIteratorSetting(ReplicationTable.NAME, "statuscombiner", scope);
                Assertions.assertEquals((int)30, (int)is.getPriority());
                Assertions.assertEquals((Object)StatusCombiner.class.getName(), (Object)is.getIteratorClass());
                Assertions.assertEquals((int)1, (int)is.getOptions().size());
                Assertions.assertTrue((boolean)is.getOptions().containsKey("columns"));
                String cols = (String)is.getOptions().get("columns");
                IteratorSetting.Column statusSectionCol = new IteratorSetting.Column(ReplicationSchema.StatusSection.NAME);
                IteratorSetting.Column workSectionCol = new IteratorSetting.Column(ReplicationSchema.WorkSection.NAME);
                Assertions.assertEquals((Object)(ColumnSet.encodeColumns((Text)statusSectionCol.getColumnFamily(), (Text)statusSectionCol.getColumnQualifier()) + "," + ColumnSet.encodeColumns((Text)workSectionCol.getColumnFamily(), (Text)workSectionCol.getColumnQualifier())), (Object)cols);
            }
            boolean foundLocalityGroups = false;
            boolean foundLocalityGroupDef1 = false;
            boolean foundLocalityGroupDef2 = false;
            boolean foundFormatter = false;
            Collector<CharSequence, ?, String> joiner = Collectors.joining(",");
            for (Map.Entry p : tops.getProperties(ReplicationTable.NAME)) {
                String key = (String)p.getKey();
                String val = (String)p.getValue();
                if (key.equals(Property.TABLE_FORMATTER_CLASS.getKey()) && val.equals(StatusFormatter.class.getName())) {
                    foundFormatter = true;
                    continue;
                }
                if (key.equals(Property.TABLE_LOCALITY_GROUPS.getKey()) && val.equals(ReplicationTable.LOCALITY_GROUPS.keySet().stream().collect(joiner))) {
                    foundLocalityGroups = true;
                    continue;
                }
                if (!key.startsWith(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey())) continue;
                if (key.equals(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + ReplicationTable.STATUS_LG_NAME) && val.equals(ReplicationTable.STATUS_LG_COLFAMS.stream().map(Text::toString).collect(joiner))) {
                    foundLocalityGroupDef1 = true;
                    continue;
                }
                if (!key.equals(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + ReplicationTable.WORK_LG_NAME) || !val.equals(ReplicationTable.WORK_LG_COLFAMS.stream().map(Text::toString).collect(joiner))) continue;
                foundLocalityGroupDef2 = true;
            }
            Assertions.assertTrue((boolean)foundLocalityGroups);
            Assertions.assertTrue((boolean)foundLocalityGroupDef1);
            Assertions.assertTrue((boolean)foundLocalityGroupDef2);
            Assertions.assertTrue((boolean)foundFormatter);
        }
    }

    @Test
    public void correctRecordsCompleteFile() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String table = "table1";
            client.tableOperations().create(table, new NewTableConfiguration().setProperties(Collections.singletonMap(Property.TABLE_REPLICATION.getKey(), "true")));
            try (BatchWriter bw = client.createBatchWriter(table);){
                for (int i = 0; i < 10; ++i) {
                    Mutation m = new Mutation((CharSequence)Integer.toString(i));
                    m.put(new byte[0], new byte[0], new byte[0]);
                    bw.addMutation(m);
                }
            }
            while (!ReplicationTable.isOnline((AccumuloClient)client)) {
                UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            Assertions.assertTrue((boolean)ReplicationTable.isOnline((AccumuloClient)client), (String)"Replication table did not exist");
            for (int i = 0; i < 5 && !client.securityOperations().hasTablePermission("root", ReplicationTable.NAME, TablePermission.READ); ++i) {
                log.info("Could not read replication table, waiting and will retry");
                Thread.sleep(2000L);
            }
            Assertions.assertTrue((boolean)client.securityOperations().hasTablePermission("root", ReplicationTable.NAME, TablePermission.READ), (String)"'root' user could not read the replication table");
            HashSet<String> replRows = new HashSet<String>();
            int attempts = 5;
            while (replRows.isEmpty() && attempts > 0) {
                Scanner scanner = ReplicationTable.getScanner((AccumuloClient)client);
                try {
                    ReplicationSchema.StatusSection.limit((ScannerBase)scanner);
                    for (Map.Entry entry : scanner) {
                        Key k = (Key)entry.getKey();
                        String fileUri = k.getRow().toString();
                        try {
                            new URI(fileUri);
                        }
                        catch (URISyntaxException e) {
                            Assertions.fail((String)("Expected a valid URI: " + fileUri));
                        }
                        replRows.add(fileUri);
                    }
                }
                finally {
                    if (scanner == null) continue;
                    scanner.close();
                }
            }
            HashSet<String> wals = new HashSet<String>();
            for (attempts = 5; wals.isEmpty() && attempts > 0; --attempts) {
                WalStateManager markers = new WalStateManager(this.getServerContext());
                for (Map.Entry entry : markers.getAllState().entrySet()) {
                    wals.add(((Path)entry.getKey()).toString());
                }
            }
            Assertions.assertEquals((int)1, (int)replRows.size(), (String)("Rows found: " + replRows));
            replRows.removeAll(wals);
            Assertions.assertEquals((int)2, (int)wals.size());
            Assertions.assertEquals((int)0, (int)replRows.size());
        }
    }

    @Test
    public void noRecordsWithoutReplication() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ArrayList<CallSite> tables = new ArrayList<CallSite>();
            Assertions.assertFalse((boolean)ReplicationTable.isOnline((AccumuloClient)client));
            for (int i = 0; i < 5; ++i) {
                String string = "table" + i;
                tables.add((CallSite)((Object)string));
                client.tableOperations().create(string);
            }
            Assertions.assertFalse((boolean)ReplicationTable.isOnline((AccumuloClient)client));
            for (String string : tables) {
                this.writeSomeData(client, string, 5, 5);
            }
            Assertions.assertFalse((boolean)ReplicationTable.isOnline((AccumuloClient)client));
            for (String string : tables) {
                client.tableOperations().compact(string, null, null, true, true);
            }
            Assertions.assertFalse((boolean)ReplicationTable.isOnline((AccumuloClient)client));
            for (String string : tables) {
                client.tableOperations().delete(string);
            }
            Assertions.assertFalse((boolean)ReplicationTable.isOnline((AccumuloClient)client));
        }
    }

    @Test
    public void twoEntriesForTwoTables() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Map.Entry entry;
            String table1 = "table1";
            String table2 = "table2";
            Assertions.assertFalse((boolean)ReplicationTable.isOnline((AccumuloClient)client), (String)"Replication table already online at the beginning of the test");
            client.tableOperations().create(table1);
            client.tableOperations().create(table2);
            client.securityOperations().grantTablePermission("root", ReplicationTable.NAME, TablePermission.READ);
            Thread.sleep(5000L);
            client.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
            Assertions.assertFalse((boolean)ReplicationTable.isOnline((AccumuloClient)client));
            this.writeSomeData(client, table1, 50, 50);
            while (!ReplicationTable.isOnline((AccumuloClient)client)) {
                UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            Assertions.assertTrue((boolean)ReplicationTable.isOnline((AccumuloClient)client));
            try (Scanner s = ReplicationTable.getScanner((AccumuloClient)client);){
                ReplicationSchema.StatusSection.limit((ScannerBase)s);
                for (int i = 0; i < 5 && Iterators.size((Iterator)s.iterator()) != 1; ++i) {
                    Thread.sleep(1000L);
                }
                entry = (Map.Entry)Iterators.getOnlyElement((Iterator)s.iterator());
            }
            Assertions.assertEquals(client.tableOperations().tableIdMap().get(table1), (Object)((Key)entry.getKey()).getColumnQualifier().toString(), (String)("Expected to find replication entry for " + table1));
            client.tableOperations().setProperty(table2, Property.TABLE_REPLICATION.getKey(), "true");
            this.writeSomeData(client, table2, 50, 50);
            HashSet tableIds = Sets.newHashSet((Object[])new String[]{(String)client.tableOperations().tableIdMap().get(table1), (String)client.tableOperations().tableIdMap().get(table2)});
            HashSet tableIdsForMetadata = Sets.newHashSet((Iterable)tableIds);
            ArrayList<Map.Entry> records = new ArrayList<Map.Entry>();
            try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.setRange(MetadataSchema.ReplicationSection.getRange());
                for (Map.Entry metadata : s) {
                    records.add(metadata);
                    log.debug("Meta: {} => {}", (Object)((Key)metadata.getKey()).toStringNoTruncate(), metadata.getValue());
                }
                Assertions.assertEquals((int)2, (int)records.size(), (String)("Expected to find 2 records, but actually found " + records));
                for (Map.Entry metadata : records) {
                    Assertions.assertTrue((boolean)tableIdsForMetadata.remove(((Key)metadata.getKey()).getColumnQualifier().toString()), (String)("Expected record to be in metadata but wasn't " + ((Key)metadata.getKey()).toStringNoTruncate() + ", tableIds remaining " + tableIdsForMetadata));
                }
                Assertions.assertTrue((boolean)tableIdsForMetadata.isEmpty(), (String)("Expected that we had removed all metadata entries " + tableIdsForMetadata));
                Thread.sleep(5000L);
            }
            s = ReplicationTable.getScanner((AccumuloClient)client);
            try {
                ReplicationSchema.StatusSection.limit((ScannerBase)s);
                Iterator iter = s.iterator();
                Assertions.assertTrue((boolean)iter.hasNext(), (String)"Found no records in replication table");
                entry = (Map.Entry)iter.next();
                Assertions.assertTrue((boolean)tableIds.remove(((Key)entry.getKey()).getColumnQualifier().toString()), (String)"Expected to find element in replication table");
                Assertions.assertTrue((boolean)iter.hasNext(), (String)"Expected to find two elements in replication table, only found one ");
                entry = (Map.Entry)iter.next();
                Assertions.assertTrue((boolean)tableIds.remove(((Key)entry.getKey()).getColumnQualifier().toString()), (String)"Expected to find element in replication table");
                Assertions.assertFalse((boolean)iter.hasNext(), (String)"Expected to only find two elements in replication table");
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
    }

    private void writeSomeData(AccumuloClient client, String table, int rows, int cols) throws Exception {
        try (BatchWriter bw = client.createBatchWriter(table);){
            for (int row = 0; row < rows; ++row) {
                Mutation m = new Mutation((CharSequence)Integer.toString(row));
                for (int col = 0; col < cols; ++col) {
                    String value = Integer.toString(col);
                    m.put((CharSequence)value, (CharSequence)"", (CharSequence)value);
                }
                bw.addMutation(m);
            }
        }
    }

    @Test
    public void replicationEntriesPrecludeWalDeletion() throws Exception {
        ServerContext context = this.getServerContext();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String table1 = "table1";
            String table2 = "table2";
            String table3 = "table3";
            HashMultimap logs = HashMultimap.create();
            AtomicBoolean keepRunning = new AtomicBoolean(true);
            Thread t = new Thread(() -> this.lambda$replicationEntriesPrecludeWalDeletion$0(keepRunning, (Multimap)logs, client, context));
            t.start();
            HashMap<Object, String> replicate_props = new HashMap<Object, String>();
            replicate_props.put(Property.TABLE_REPLICATION.getKey(), "true");
            replicate_props.put(Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
            client.tableOperations().create(table1, new NewTableConfiguration().setProperties(replicate_props));
            Thread.sleep(2000L);
            this.writeSomeData(client, table1, 200, 500);
            client.tableOperations().create(table2, new NewTableConfiguration().setProperties(replicate_props));
            Thread.sleep(2000L);
            this.writeSomeData(client, table2, 200, 500);
            client.tableOperations().create(table3, new NewTableConfiguration().setProperties(replicate_props));
            Thread.sleep(2000L);
            this.writeSomeData(client, table3, 200, 500);
            for (String table : Arrays.asList(table1, table2, table3)) {
                client.tableOperations().flush(table, null, null, true);
            }
            keepRunning.set(false);
            t.join(5000L);
            Thread.sleep(5000L);
            Set<String> replFiles = this.getReferencesToFilesToBeReplicated(client);
            String replicationTableId = (String)client.tableOperations().tableIdMap().get(ReplicationTable.NAME);
            Iterator observedLogs = logs.entries().iterator();
            while (observedLogs.hasNext()) {
                Map.Entry observedLog = (Map.Entry)observedLogs.next();
                if (!replicationTableId.equals(((TableId)observedLog.getValue()).canonical())) continue;
                log.info("Removing {} because its tableId is for the replication table", (Object)observedLog);
                observedLogs.remove();
            }
            Assertions.assertTrue((boolean)logs.keySet().containsAll(replFiles), (String)("Metadata log distribution: " + (Multimap)logs + "replFiles " + replFiles));
            Assertions.assertTrue((logs.keySet().size() - replFiles.size() <= 1 ? 1 : 0) != 0, (String)"Difference between replication entries and current logs is bigger than one");
            Configuration conf = new Configuration();
            for (String replFile : replFiles) {
                Path p = new Path(replFile);
                FileSystem fs = p.getFileSystem(conf);
                if (fs.exists(p)) continue;
                Set<String> currentSet = this.getReferencesToFilesToBeReplicated(client);
                log.info("Current references {}", currentSet);
                log.info("Looking for reference to {}", (Object)replFile);
                log.info("Contains? {}", (Object)currentSet.contains(replFile));
                Assertions.assertTrue((!currentSet.contains(replFile) ? 1 : 0) != 0, (String)("File does not exist anymore, it was likely incorrectly garbage collected: " + p));
            }
        }
    }

    private Set<String> getReferencesToFilesToBeReplicated(AccumuloClient client) throws ReplicationTableOfflineException {
        try (Scanner s = ReplicationTable.getScanner((AccumuloClient)client);){
            ReplicationSchema.StatusSection.limit((ScannerBase)s);
            HashSet<String> replFiles = new HashSet<String>();
            for (Map.Entry entry : s) {
                replFiles.add(((Key)entry.getKey()).getRow().toString());
            }
            HashSet<String> hashSet = replFiles;
            return hashSet;
        }
    }

    @Test
    public void combinerWorksOnMetadata() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Replication.Status actual;
            client.securityOperations().grantTablePermission("root", MetadataTable.NAME, TablePermission.WRITE);
            ReplicationTableUtil.configureMetadataTable((AccumuloClient)client, (String)MetadataTable.NAME);
            Replication.Status stat1 = StatusUtil.fileCreated((long)100L);
            Replication.Status stat2 = StatusUtil.fileClosed();
            try (BatchWriter bw = client.createBatchWriter(MetadataTable.NAME);){
                Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + "file:/accumulo/wals/tserver+port/uuid"));
                m.put(MetadataSchema.ReplicationSection.COLF, new Text("1"), ProtobufUtil.toValue((GeneratedMessageV3)stat1));
                bw.addMutation(m);
            }
            try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.setRange(MetadataSchema.ReplicationSection.getRange());
                actual = Replication.Status.parseFrom((byte[])this.getOnlyElement(s).getValue().get());
                Assertions.assertEquals((Object)stat1, (Object)actual);
                try (BatchWriter bw = client.createBatchWriter(MetadataTable.NAME);){
                    Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + "file:/accumulo/wals/tserver+port/uuid"));
                    m.put(MetadataSchema.ReplicationSection.COLF, new Text("1"), ProtobufUtil.toValue((GeneratedMessageV3)stat2));
                    bw.addMutation(m);
                }
            }
            s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            try {
                s.setRange(MetadataSchema.ReplicationSection.getRange());
                actual = Replication.Status.parseFrom((byte[])this.getOnlyElement(s).getValue().get());
                Replication.Status expected = Replication.Status.newBuilder().setBegin(0L).setEnd(0L).setClosed(true).setInfiniteEnd(true).setCreatedTime(100L).build();
                Assertions.assertEquals((Object)expected, (Object)actual);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
    }

    @Test
    public void noDeadlock() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ReplicationTable.setOnline((AccumuloClient)client);
            client.securityOperations().grantTablePermission("root", ReplicationTable.NAME, TablePermission.WRITE);
            client.tableOperations().deleteRows(ReplicationTable.NAME, null, null);
            HashMap<Object, String> replicate_props = new HashMap<Object, String>();
            replicate_props.put(Property.TABLE_REPLICATION.getKey(), "true");
            replicate_props.put(Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
            String table1 = "table1";
            String table2 = "table2";
            String table3 = "table3";
            client.tableOperations().create(table1, new NewTableConfiguration().setProperties(replicate_props));
            client.tableOperations().create(table2, new NewTableConfiguration().setProperties(replicate_props));
            client.tableOperations().create(table3, new NewTableConfiguration().setProperties(replicate_props));
            this.writeSomeData(client, table1, 200, 500);
            this.writeSomeData(client, table2, 200, 500);
            this.writeSomeData(client, table3, 200, 500);
            for (String table : Arrays.asList(table1, table2, table3)) {
                client.tableOperations().flush(table, null, null, true);
            }
            for (String table : Arrays.asList(table1, table2, table3)) {
                client.tableOperations().flush(table, null, null, true);
            }
            for (String table : Arrays.asList(MetadataTable.NAME, table1, table2, table3)) {
                Scanner scanner = client.createScanner(table, Authorizations.EMPTY);
                try {
                    scanner.forEach((k, v) -> {});
                }
                finally {
                    if (scanner == null) continue;
                    scanner.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void filesClosedAfterUnused() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Mutation m;
            String table = "table";
            HashMap<Object, String> replicate_props = new HashMap<Object, String>();
            replicate_props.put(Property.TABLE_REPLICATION.getKey(), "true");
            replicate_props.put(Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
            client.tableOperations().create(table, new NewTableConfiguration().setProperties(replicate_props));
            TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(table)));
            Assertions.assertNotNull((Object)tableId);
            client.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + "cluster1", ReplicaSystemFactory.getPeerConfigurationValue(MockReplicaSystem.class, (String)"50000"));
            try (BatchWriter bw = client.createBatchWriter(table);){
                m = new Mutation((CharSequence)"one");
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                bw.addMutation(m);
            }
            bw = client.createBatchWriter(table);
            try {
                m = new Mutation((CharSequence)"three");
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                bw.addMutation(m);
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
            try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                Object bytes;
                s.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
                s.setRange(MetadataSchema.TabletsSection.getRange((TableId)tableId));
                HashSet<String> wals = new HashSet<String>();
                for (Map.Entry entry : s) {
                    LogEntry logEntry = LogEntry.fromMetaWalEntry((Map.Entry)entry);
                    wals.add(new Path(logEntry.filename).toString());
                }
                log.warn("Found wals {}", wals);
                try (BatchWriter bw = client.createBatchWriter(table);){
                    Mutation m2 = new Mutation((CharSequence)"three");
                    bytes = new byte[0x100000];
                    m2.put("1".getBytes(), new byte[0], (byte[])bytes);
                    m2.put("2".getBytes(), new byte[0], (byte[])bytes);
                    m2.put("3".getBytes(), new byte[0], (byte[])bytes);
                    m2.put("4".getBytes(), new byte[0], (byte[])bytes);
                    m2.put("5".getBytes(), new byte[0], (byte[])bytes);
                    bw.addMutation(m2);
                }
                client.tableOperations().flush(table, null, null, true);
                while (!ReplicationTable.isOnline((AccumuloClient)client)) {
                    UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                block46: for (int i = 0; i < 10; ++i) {
                    try (Scanner s2 = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                        s2.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
                        s2.setRange(MetadataSchema.TabletsSection.getRange((TableId)tableId));
                        bytes = s2.iterator();
                        while (bytes.hasNext()) {
                            Map.Entry entry = (Map.Entry)bytes.next();
                            log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), entry.getValue());
                        }
                    }
                    try {
                        Scanner s3;
                        block60: {
                            s3 = ReplicationTable.getScanner((AccumuloClient)client);
                            ReplicationSchema.StatusSection.limit((ScannerBase)s3);
                            Text buff = new Text();
                            boolean allReferencedLogsClosed = true;
                            int recordsFound = 0;
                            for (Map.Entry e : s3) {
                                Replication.Status stat;
                                ++recordsFound;
                                allReferencedLogsClosed = true;
                                ReplicationSchema.StatusSection.getFile((Key)((Key)e.getKey()), (Text)buff);
                                String file = buff.toString();
                                if (!wals.contains(file) || (stat = Replication.Status.parseFrom((byte[])((Value)e.getValue()).get())).getClosed()) continue;
                                log.info("{} wasn't closed", (Object)file);
                                allReferencedLogsClosed = false;
                            }
                            if (recordsFound <= 0 || !allReferencedLogsClosed) break block60;
                            if (s3 == null) return;
                            s3.close();
                            return;
                        }
                        try {
                            Thread.sleep(2000L);
                            continue;
                        }
                        finally {
                            if (s3 != null) {
                                s3.close();
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        Throwable cause = e.getCause();
                        if (!(cause instanceof AccumuloSecurityException)) continue;
                        AccumuloSecurityException ase = (AccumuloSecurityException)cause;
                        switch (ase.getSecurityErrorCode()) {
                            case PERMISSION_DENIED: {
                                Thread.sleep(2000L);
                                continue block46;
                            }
                            default: {
                                throw e;
                            }
                        }
                    }
                }
                Assertions.fail((String)"We had a file that was referenced but didn't get closed");
                return;
            }
        }
    }

    @Test
    public void singleTableWithSingleTarget() throws Exception {
        block72: {
            this.getCluster().getClusterControl().stop(ServerType.GARBAGE_COLLECTOR);
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
                String table1 = "table1";
                Assertions.assertFalse((boolean)ReplicationTable.isOnline((AccumuloClient)client));
                client.tableOperations().create(table1);
                int attempts = 10;
                while (attempts > 0) {
                    try {
                        client.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
                        client.tableOperations().setProperty(table1, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "4");
                        client.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + "cluster1", ReplicaSystemFactory.getPeerConfigurationValue(MockReplicaSystem.class, (String)"100000"));
                        break;
                    }
                    catch (Exception e) {
                        if (--attempts <= 0) {
                            throw e;
                        }
                        UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
                    }
                }
                this.writeSomeData(client, table1, 2000, 50);
                while (!ReplicationTable.isOnline((AccumuloClient)client)) {
                    UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                Assertions.assertTrue((boolean)ReplicationTable.isOnline((AccumuloClient)client), (String)"Replication table was never created");
                for (int i = 0; i < 10 && !client.tableOperations().listIterators(ReplicationTable.NAME).containsKey("statuscombiner"); ++i) {
                    UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
                }
                Assertions.assertTrue((boolean)client.tableOperations().listIterators(ReplicationTable.NAME).containsKey("statuscombiner"), (String)"Combiner was never set on replication table");
                client.tableOperations().flush(table1, null, null, true);
                try (Scanner s = ReplicationTable.getScanner((AccumuloClient)client);){
                    Replication.Status actual;
                    ReplicationSchema.StatusSection.limit((ScannerBase)s);
                    Map.Entry<Key, Value> entry = null;
                    Replication.Status expectedStatus = StatusUtil.openWithUnknownLength();
                    attempts = 10;
                    while (entry == null && attempts > 0) {
                        try {
                            entry = this.getOnlyElement(s);
                            actual = Replication.Status.parseFrom((byte[])entry.getValue().get());
                            if (actual.getInfiniteEnd() == expectedStatus.getInfiniteEnd()) continue;
                            entry = null;
                            Thread.sleep(1000L);
                        }
                        catch (NoSuchElementException e) {
                            entry = null;
                            Thread.sleep(500L);
                        }
                        catch (IllegalArgumentException e) {
                            Scanner s2 = ReplicationTable.getScanner((AccumuloClient)client);
                            try {
                                ReplicationSchema.StatusSection.limit((ScannerBase)s2);
                                for (Map.Entry content : s2) {
                                    log.info("{} => {}", (Object)((Key)content.getKey()).toStringNoTruncate(), content.getValue());
                                }
                                throw e;
                            }
                            catch (Throwable throwable) {
                                if (s2 != null) {
                                    try {
                                        s2.close();
                                    }
                                    catch (Throwable content) {
                                        throwable.addSuppressed(content);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            --attempts;
                        }
                    }
                    Assertions.assertNotNull(entry, (String)"Could not find expected entry in replication table");
                    actual = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                    Assertions.assertTrue((!actual.getClosed() && actual.getInfiniteEnd() ? 1 : 0) != 0, (String)("Expected to find a replication entry that is open with infinite length: " + ProtobufUtil.toString((GeneratedMessageV3)actual)));
                    boolean notFound = true;
                    for (int i = 0; i < 10 && notFound; ++i) {
                        try (Scanner s2 = ReplicationTable.getScanner((AccumuloClient)client);){
                            ReplicationSchema.WorkSection.limit((ScannerBase)s2);
                            int elementsFound = Iterables.size((Iterable)s2);
                            if (elementsFound > 0) {
                                Assertions.assertEquals((int)1, (int)elementsFound);
                                notFound = false;
                            }
                            Thread.sleep(500L);
                            continue;
                        }
                    }
                    if (notFound) {
                        try (Scanner s2 = ReplicationTable.getScanner((AccumuloClient)client);){
                            for (Map.Entry content : s2) {
                                log.info("{} => {}", (Object)((Key)content.getKey()).toStringNoTruncate(), content.getValue());
                            }
                            Assertions.assertFalse((boolean)notFound, (String)"Did not find the work entry for the status entry");
                        }
                    }
                    this.writeSomeData(client, table1, 3000, 50);
                    log.info("Issued compaction for table");
                    client.tableOperations().compact(table1, null, null, true, true);
                    log.info("Compaction completed");
                    Thread.sleep(5000L);
                    try (Scanner s2 = ReplicationTable.getScanner((AccumuloClient)client);){
                        ReplicationSchema.StatusSection.limit((ScannerBase)s2);
                        int numRecords = 0;
                        for (Map.Entry e : s2) {
                            ++numRecords;
                            log.info("Found status record {}\t{}", (Object)((Key)e.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessageV3)Replication.Status.parseFrom((byte[])((Value)e.getValue()).get())));
                        }
                        Assertions.assertEquals((int)2, (int)numRecords);
                    }
                    notFound = true;
                    for (int i = 0; i < 10 && notFound; ++i) {
                        try (Scanner s2 = ReplicationTable.getScanner((AccumuloClient)client);){
                            ReplicationSchema.WorkSection.limit((ScannerBase)s2);
                            int elementsFound = Iterables.size((Iterable)s2);
                            if (elementsFound == 2) {
                                notFound = false;
                            }
                            Thread.sleep(500L);
                            continue;
                        }
                    }
                    if (!notFound) break block72;
                    s2 = ReplicationTable.getScanner((AccumuloClient)client);
                    try {
                        for (Map.Entry content : s2) {
                            log.info("{} => {}", (Object)((Key)content.getKey()).toStringNoTruncate(), content.getValue());
                        }
                        Assertions.assertFalse((boolean)notFound, (String)"Did not find the work entries for the status entries");
                    }
                    finally {
                        if (s2 != null) {
                            s2.close();
                        }
                    }
                }
            }
        }
    }

    @Test
    public void correctClusterNameInWorkEntry() throws Exception {
        block36: {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
                String table1 = "table1";
                Assertions.assertFalse((boolean)ReplicationTable.isOnline((AccumuloClient)client));
                client.tableOperations().create(table1);
                int attempts = 5;
                while (attempts > 0) {
                    try {
                        client.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
                        client.tableOperations().setProperty(table1, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "4");
                        attempts = 0;
                    }
                    catch (Exception e) {
                        if (--attempts <= 0) {
                            throw e;
                        }
                        UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                }
                this.writeSomeData(client, table1, 2000, 50);
                client.tableOperations().flush(table1, null, null, true);
                TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(table1)));
                Assertions.assertNotNull((Object)tableId, (String)"Table ID was null");
                while (!ReplicationTable.isOnline((AccumuloClient)client)) {
                    UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                Assertions.assertTrue((boolean)ReplicationTable.isOnline((AccumuloClient)client), (String)"Replication table did not exist");
                for (int i = 0; i < 5 && !client.securityOperations().hasTablePermission("root", ReplicationTable.NAME, TablePermission.READ); ++i) {
                    Thread.sleep(1000L);
                }
                Assertions.assertTrue((boolean)client.securityOperations().hasTablePermission("root", ReplicationTable.NAME, TablePermission.READ));
                boolean notFound = true;
                for (int i = 0; i < 10 && notFound; ++i) {
                    try (Scanner s = ReplicationTable.getScanner((AccumuloClient)client);){
                        ReplicationSchema.WorkSection.limit((ScannerBase)s);
                        try {
                            Map.Entry<Key, Value> e = this.getOnlyElement(s);
                            Text expectedColqual = new ReplicationTarget("cluster1", "4", tableId).toText();
                            Assertions.assertEquals((Object)expectedColqual, (Object)e.getKey().getColumnQualifier());
                            notFound = false;
                        }
                        catch (NoSuchElementException e) {
                        }
                        catch (IllegalArgumentException e) {
                            try (Scanner s2 = ReplicationTable.getScanner((AccumuloClient)client);){
                                for (Map.Entry content : s2) {
                                    log.info("{} => {}", (Object)((Key)content.getKey()).toStringNoTruncate(), content.getValue());
                                }
                                Assertions.fail((String)"Found more than one work section entry");
                            }
                        }
                        Thread.sleep(500L);
                        continue;
                    }
                }
                if (!notFound) break block36;
                try (Scanner s = ReplicationTable.getScanner((AccumuloClient)client);){
                    for (Map.Entry content : s) {
                        log.info("{} => {}", (Object)((Key)content.getKey()).toStringNoTruncate(), content.getValue());
                    }
                    Assertions.assertFalse((boolean)notFound, (String)"Did not find the work entry for the status entry");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void replicationRecordsAreClosedAfterGarbageCollection() throws Exception {
        block54: {
            this.getCluster().getClusterControl().stop(ServerType.GARBAGE_COLLECTOR);
            ServerContext context = this.getServerContext();
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
                ReplicationTable.setOnline((AccumuloClient)client);
                client.securityOperations().grantTablePermission("root", ReplicationTable.NAME, TablePermission.WRITE);
                client.tableOperations().deleteRows(ReplicationTable.NAME, null, null);
                AtomicBoolean keepRunning = new AtomicBoolean(true);
                HashSet metadataWals = new HashSet();
                Thread t = new Thread(() -> {
                    while (keepRunning.get()) {
                        try {
                            metadataWals.addAll(this.getLogs(client, context).keySet());
                        }
                        catch (Exception e) {
                            log.error("Metadata table doesn't exist");
                        }
                    }
                });
                t.start();
                String table1 = "table1";
                String table2 = "table2";
                String table3 = "table3";
                HashMap<Object, String> replicate_props = new HashMap<Object, String>();
                replicate_props.put(Property.TABLE_REPLICATION.getKey(), "true");
                replicate_props.put(Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
                try {
                    client.tableOperations().create(table1, new NewTableConfiguration().setProperties(replicate_props));
                    client.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + "cluster1", ReplicaSystemFactory.getPeerConfigurationValue(MockReplicaSystem.class, null));
                    this.writeSomeData(client, table1, 200, 500);
                    client.tableOperations().create(table2, new NewTableConfiguration().setProperties(replicate_props));
                    this.writeSomeData(client, table2, 200, 500);
                    client.tableOperations().create(table3, new NewTableConfiguration().setProperties(replicate_props));
                    this.writeSomeData(client, table3, 200, 500);
                    for (String table : Arrays.asList(table1, table2, table3)) {
                        client.tableOperations().compact(table, null, null, true, true);
                    }
                }
                finally {
                    keepRunning.set(false);
                    t.join(5000L);
                    Assertions.assertFalse((boolean)t.isAlive());
                }
                this.cluster.getClusterControl().stop(ServerType.TABLET_SERVER);
                this.cluster.getClusterControl().start(ServerType.TABLET_SERVER);
                for (String table : Arrays.asList(table1, table2, table3)) {
                    Scanner scanner = client.createScanner(table, Authorizations.EMPTY);
                    try {
                        scanner.forEach((k, v) -> {});
                    }
                    finally {
                        if (scanner == null) continue;
                        scanner.close();
                    }
                }
                Process gc = this.cluster.exec(SimpleGarbageCollector.class, new String[0]).getProcess();
                this.waitForGCLock(client);
                Thread.sleep(1000L);
                log.info("GC is up and should have had time to run at least once by now");
                try {
                    Replication.Status status;
                    String wal;
                    Map.Entry entry;
                    long recordsFound;
                    Iterator iter;
                    Object s;
                    boolean allClosed = true;
                    for (int i = 0; i < 10; ++i) {
                        s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
                        try {
                            s.setRange(Range.prefix((CharSequence)MetadataSchema.ReplicationSection.getRowPrefix()));
                            iter = s.iterator();
                            recordsFound = 0L;
                            while (allClosed && iter.hasNext()) {
                                entry = (Map.Entry)iter.next();
                                wal = ((Key)entry.getKey()).getRow().toString();
                                if (!metadataWals.contains(wal)) continue;
                                status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                                log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessageV3)status));
                                allClosed &= status.getClosed();
                                ++recordsFound;
                            }
                            log.info("Found {} records from the metadata table", (Object)recordsFound);
                            if (allClosed) break;
                            UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
                            continue;
                        }
                        finally {
                            if (s != null) {
                                s.close();
                            }
                        }
                    }
                    if (!allClosed) {
                        try (Scanner s2 = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                            s2.setRange(Range.prefix((CharSequence)MetadataSchema.ReplicationSection.getRowPrefix()));
                            for (Map.Entry entry2 : s2) {
                                log.info("{} {}", (Object)((Key)entry2.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessageV3)Replication.Status.parseFrom((byte[])((Value)entry2.getValue()).get())));
                            }
                            Assertions.fail((String)"Expected all replication records in the metadata table to be closed");
                        }
                    }
                    for (int i = 0; i < 10; ++i) {
                        allClosed = true;
                        s = ReplicationTable.getScanner((AccumuloClient)client);
                        try {
                            iter = s.iterator();
                            recordsFound = 0L;
                            while (allClosed && iter.hasNext()) {
                                entry = (Map.Entry)iter.next();
                                wal = ((Key)entry.getKey()).getRow().toString();
                                if (!metadataWals.contains(wal)) continue;
                                status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                                log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessageV3)status));
                                allClosed &= status.getClosed();
                                ++recordsFound;
                            }
                            log.info("Found {} records from the replication table", (Object)recordsFound);
                            if (allClosed) break;
                            UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
                            continue;
                        }
                        finally {
                            if (s != null) {
                                s.close();
                            }
                        }
                    }
                    if (allClosed) break block54;
                    try (Scanner s3 = ReplicationTable.getScanner((AccumuloClient)client);){
                        ReplicationSchema.StatusSection.limit((ScannerBase)s3);
                        for (Map.Entry entry2 : s3) {
                            log.info("{} {}", (Object)((Key)entry2.getKey()).toStringNoTruncate(), (Object)TextFormat.shortDebugString((MessageOrBuilder)Replication.Status.parseFrom((byte[])((Value)entry2.getValue()).get())));
                        }
                        Assertions.fail((String)"Expected all replication records in the replication table to be closed");
                    }
                }
                finally {
                    gc.destroy();
                    gc.waitFor();
                }
            }
        }
    }

    @Test
    public void replicatedStatusEntriesAreDeleted() throws Exception {
        this.getCluster().getClusterControl().stop(ServerType.GARBAGE_COLLECTOR);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            log.info("Got client to MAC");
            String table1 = "table1";
            Assertions.assertFalse((boolean)ReplicationTable.isOnline((AccumuloClient)client));
            client.tableOperations().create(table1);
            int attempts = 5;
            while (attempts > 0) {
                try {
                    client.tableOperations().setProperty(table1, Property.TABLE_REPLICATION.getKey(), "true");
                    client.tableOperations().setProperty(table1, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "4");
                    client.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + "cluster1", ReplicaSystemFactory.getPeerConfigurationValue(MockReplicaSystem.class, (String)"1000"));
                    attempts = 0;
                }
                catch (Exception e) {
                    if (--attempts <= 0) {
                        throw e;
                    }
                    UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
            TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(table1)));
            Assertions.assertNotNull((Object)tableId, (String)("Could not determine table id for " + table1));
            this.writeSomeData(client, table1, 2000, 50);
            client.tableOperations().flush(table1, null, null, true);
            while (!ReplicationTable.isOnline((AccumuloClient)client)) {
                UtilWaitThread.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            Assertions.assertTrue((boolean)ReplicationTable.isOnline((AccumuloClient)client), (String)"Replication table did not exist");
            client.securityOperations().grantTablePermission("root", ReplicationTable.NAME, TablePermission.WRITE);
            log.info("Checking for replication entries in replication");
            HashSet<String> entries = new HashSet<String>();
            for (int i = 0; i < 5; ++i) {
                try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                    s.setRange(MetadataSchema.ReplicationSection.getRange());
                    entries.clear();
                    for (Map.Entry entry : s) {
                        entries.add(((Key)entry.getKey()).getRow().toString());
                        log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), entry.getValue());
                    }
                    if (!entries.isEmpty()) {
                        log.info("Replication entries {}", entries);
                        break;
                    }
                    Thread.sleep(1000L);
                    continue;
                }
            }
            Assertions.assertFalse((boolean)entries.isEmpty(), (String)"Did not find any replication entries in the replication table");
            boolean notFound = true;
            for (int i = 0; i < 10 && notFound; ++i) {
                try (Scanner s2 = ReplicationTable.getScanner((AccumuloClient)client);){
                    ReplicationSchema.WorkSection.limit((ScannerBase)s2);
                    Map.Entry<Key, Value> e = this.getOnlyElement(s2);
                    log.info("Found entry: {}", (Object)e.getKey().toStringNoTruncate());
                    Iterator expectedColqual = new ReplicationTarget("cluster1", "4", tableId).toText();
                    Assertions.assertEquals((Object)expectedColqual, (Object)e.getKey().getColumnQualifier());
                    notFound = false;
                }
                catch (NoSuchElementException s2) {
                }
                catch (IllegalArgumentException e) {
                    try (Scanner s3 = ReplicationTable.getScanner((AccumuloClient)client);){
                        for (Map.Entry content : s3) {
                            log.info("{} => {}", (Object)((Key)content.getKey()).toStringNoTruncate(), content.getValue());
                        }
                        Assertions.fail((String)"Found more than one work section entry");
                    }
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof AccumuloSecurityException) {
                        AccumuloSecurityException sec = (AccumuloSecurityException)cause;
                        switch (sec.getSecurityErrorCode()) {
                            case PERMISSION_DENIED: {
                                log.warn("Sleeping because permission was denied");
                                break;
                            }
                            default: {
                                throw e;
                            }
                        }
                    }
                    throw e;
                }
                Thread.sleep(2000L);
            }
            if (notFound) {
                try (Scanner s = ReplicationTable.getScanner((AccumuloClient)client);){
                    for (Map.Entry content : s) {
                        log.info("{} => {}", (Object)((Key)content.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessageV3)Replication.Status.parseFrom((byte[])((Value)content.getValue()).get())));
                    }
                    Assertions.assertFalse((boolean)notFound, (String)"Did not find the work entry for the status entry");
                }
            }
            log.info("Killing tserver");
            this.cluster.getClusterControl().stop(ServerType.TABLET_SERVER);
            log.info("Starting tserver");
            this.cluster.getClusterControl().start(ServerType.TABLET_SERVER);
            log.info("Waiting to read tables");
            UtilWaitThread.sleepUninterruptibly((long)6L, (TimeUnit)TimeUnit.SECONDS);
            for (Object table : new Scanner[]{MetadataTable.NAME, table1}) {
                try (Scanner scanner = client.createScanner((String)table, Authorizations.EMPTY);){
                    scanner.forEach((k, v) -> {});
                }
            }
            log.info("Recovered metadata:");
            try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                for (Map.Entry entry : s) {
                    log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), entry.getValue());
                }
            }
            this.cluster.getClusterControl().start(ServerType.GARBAGE_COLLECTOR);
            this.waitForGCLock(client);
            Thread.sleep(1000L);
            log.info("After GC");
            s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            try {
                for (Map.Entry entry : s) {
                    log.info("{}={}", (Object)((Key)entry.getKey()).toStringNoTruncate(), entry.getValue());
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
            log.info("Checking metadata table for replication entries");
            HashSet<String> remaining = new HashSet<String>();
            for (int i = 0; i < 10; ++i) {
                try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                    s.setRange(MetadataSchema.ReplicationSection.getRange());
                    remaining.clear();
                    for (Map.Entry e : s) {
                        remaining.add(((Key)e.getKey()).getRow().toString());
                    }
                    remaining.retainAll(entries);
                    if (remaining.isEmpty()) break;
                    log.info("remaining {}", remaining);
                    Thread.sleep(2000L);
                    log.info("");
                    continue;
                }
            }
            Assertions.assertTrue((boolean)remaining.isEmpty(), (String)"Replication status messages were not cleaned up from metadata table");
            int recordsFound = 0;
            for (int i = 0; i < 30; ++i) {
                try (Scanner s = ReplicationTable.getScanner((AccumuloClient)client);){
                    recordsFound = 0;
                    for (Map.Entry entry : s) {
                        ++recordsFound;
                        log.info("{} {}", (Object)((Key)entry.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessageV3)Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get())));
                    }
                    if (recordsFound <= 2) break;
                    Thread.sleep(1000L);
                    log.info("");
                    continue;
                }
            }
            Assertions.assertTrue((recordsFound <= 2 ? 1 : 0) != 0, (String)"Found unexpected replication records in the replication table");
        }
    }

    private /* synthetic */ void lambda$replicationEntriesPrecludeWalDeletion$0(AtomicBoolean keepRunning, Multimap logs, AccumuloClient client, ServerContext context) {
        while (keepRunning.get()) {
            try {
                logs.putAll(this.getAllLogs(client, context));
            }
            catch (Exception e) {
                log.error("Error getting logs", (Throwable)e);
            }
        }
    }
}

