/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.protobuf.GeneratedMessageV3;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="Replication ITs are not stable and not currently maintained")
@Deprecated
public class StatusCombinerMacIT
extends SharedMiniClusterBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testCombinerSetOnMetadata() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(StatusCombinerMacIT.getClientProps()).build();){
            TableOperations tops = client.tableOperations();
            Map iterators = tops.listIterators(MetadataTable.NAME);
            Assertions.assertTrue((boolean)iterators.containsKey("replcombiner"));
            EnumSet scopes = (EnumSet)iterators.get("replcombiner");
            Assertions.assertEquals((int)3, (int)scopes.size());
            Assertions.assertTrue((boolean)scopes.contains(IteratorUtil.IteratorScope.scan));
            Assertions.assertTrue((boolean)scopes.contains(IteratorUtil.IteratorScope.minc));
            Assertions.assertTrue((boolean)scopes.contains(IteratorUtil.IteratorScope.majc));
            Map config = tops.getConfiguration(MetadataTable.NAME);
            Map properties = Map.copyOf(config);
            for (IteratorUtil.IteratorScope scope : scopes) {
                String key = Property.TABLE_ITERATOR_PREFIX.getKey() + scope.name() + ".replcombiner.opt.columns";
                Assertions.assertTrue((boolean)properties.containsKey(key), (String)("Properties did not contain key : " + key));
                Assertions.assertEquals((Object)MetadataSchema.ReplicationSection.COLF.toString(), properties.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(StatusCombinerMacIT.getClientProps()).build();){
            Map.Entry<Key, Value> entry;
            ClusterUser user = this.getAdminUser();
            ReplicationTable.setOnline((AccumuloClient)client);
            client.securityOperations().grantTablePermission(user.getPrincipal(), ReplicationTable.NAME, TablePermission.WRITE);
            long createTime = System.currentTimeMillis();
            try (BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)client);){
                Mutation m = new Mutation((CharSequence)"file:/accumulo/wal/HW10447.local+56808/93cdc17e-7521-44fa-87b5-37f45bcb92d3");
                ReplicationSchema.StatusSection.add((Mutation)m, (TableId)TableId.of((String)"1"), (Value)StatusUtil.fileCreatedValue((long)createTime));
                bw.addMutation(m);
            }
            try (Scanner s = ReplicationTable.getScanner((AccumuloClient)client);){
                entry = this.getOnlyElement(s);
                Assertions.assertEquals((Object)StatusUtil.fileCreatedValue((long)createTime), (Object)entry.getValue());
                bw = ReplicationTable.getBatchWriter((AccumuloClient)client);
                try {
                    Mutation m = new Mutation((CharSequence)"file:/accumulo/wal/HW10447.local+56808/93cdc17e-7521-44fa-87b5-37f45bcb92d3");
                    ReplicationSchema.StatusSection.add((Mutation)m, (TableId)TableId.of((String)"1"), (Value)ProtobufUtil.toValue((GeneratedMessageV3)StatusUtil.replicated((long)Long.MAX_VALUE)));
                    bw.addMutation(m);
                }
                finally {
                    bw.close();
                }
            }
            s = ReplicationTable.getScanner((AccumuloClient)client);
            try {
                entry = this.getOnlyElement(s);
                Replication.Status stat = Replication.Status.parseFrom((byte[])entry.getValue().get());
                Assertions.assertEquals((long)Long.MAX_VALUE, (long)stat.getBegin());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
    }
}

