/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.manager.replication.StatusMaker;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.util.ReplicationTableUtil;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="Replication ITs are not stable and not currently maintained")
@Deprecated
public class StatusMakerIT
extends ConfigurableMacBase {
    private AccumuloClient client;
    private VolumeManager fs;

    @BeforeEach
    public void setupInstance() throws Exception {
        this.client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        ReplicationTable.setOnline((AccumuloClient)this.client);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.WRITE);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.READ);
        this.fs = (VolumeManager)EasyMock.mock(VolumeManager.class);
    }

    @Test
    public void statusRecordsCreated() throws Exception {
        String sourceTable = this.testName();
        this.client.tableOperations().create(sourceTable);
        ReplicationTableUtil.configureMetadataTable((AccumuloClient)this.client, (String)sourceTable);
        BatchWriter bw = this.client.createBatchWriter(sourceTable);
        String walPrefix = "hdfs://localhost:8020/accumulo/wals/tserver+port/";
        HashSet files = Sets.newHashSet((Object[])new String[]{walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID()});
        HashMap<String, Integer> fileToTableId = new HashMap<String, Integer>();
        int index = 1;
        long timeCreated = 0L;
        HashMap<String, Long> fileToTimeCreated = new HashMap<String, Long>();
        for (String file : files) {
            Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file));
            m.put(MetadataSchema.ReplicationSection.COLF, new Text(Integer.toString(index)), StatusUtil.fileCreatedValue((long)timeCreated));
            fileToTimeCreated.put(file, timeCreated);
            bw.addMutation(m);
            fileToTableId.put(file, index);
            ++index;
            ++timeCreated;
        }
        bw.close();
        StatusMaker statusMaker = new StatusMaker(this.client, this.fs);
        statusMaker.setSourceTableName(sourceTable);
        statusMaker.run();
        try (Scanner s = ReplicationTable.getScanner((AccumuloClient)this.client);){
            ReplicationSchema.StatusSection.limit((ScannerBase)s);
            Text file = new Text();
            for (Map.Entry entry : s) {
                ReplicationSchema.StatusSection.getFile((Key)((Key)entry.getKey()), (Text)file);
                TableId tableId = ReplicationSchema.StatusSection.getTableId((Key)((Key)entry.getKey()));
                Assertions.assertTrue((boolean)files.contains(file.toString()), (String)("Found unexpected file: " + file));
                Assertions.assertEquals((Integer)((Integer)fileToTableId.get(file.toString())), (Integer)Integer.valueOf(tableId.canonical()));
                timeCreated = (Long)fileToTimeCreated.get(file.toString());
                Assertions.assertNotNull((Object)timeCreated);
                Assertions.assertEquals((Object)StatusUtil.fileCreated((long)timeCreated), (Object)Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get()));
            }
        }
    }

    @Test
    public void openMessagesAreNotDeleted() throws Exception {
        String sourceTable = this.testName();
        this.client.tableOperations().create(sourceTable);
        ReplicationTableUtil.configureMetadataTable((AccumuloClient)this.client, (String)sourceTable);
        BatchWriter bw = this.client.createBatchWriter(sourceTable);
        String walPrefix = "hdfs://localhost:8020/accumulo/wals/tserver+port/";
        HashSet files = Sets.newHashSet((Object[])new String[]{walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID()});
        HashMap<String, Integer> fileToTableId = new HashMap<String, Integer>();
        int index = 1;
        long timeCreated = 0L;
        for (String file : files) {
            Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file));
            m.put(MetadataSchema.ReplicationSection.COLF, new Text(Integer.toString(index)), StatusUtil.fileCreatedValue((long)timeCreated));
            bw.addMutation(m);
            fileToTableId.put(file, index);
            ++index;
            ++timeCreated;
        }
        bw.close();
        StatusMaker statusMaker = new StatusMaker(this.client, this.fs);
        statusMaker.setSourceTableName(sourceTable);
        statusMaker.run();
        try (Scanner s = this.client.createScanner(sourceTable, Authorizations.EMPTY);){
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            Assertions.assertEquals((int)files.size(), (int)Iterables.size((Iterable)s));
        }
    }

    @Test
    public void closedMessagesAreDeleted() throws Exception {
        String sourceTable = this.testName();
        this.client.tableOperations().create(sourceTable);
        ReplicationTableUtil.configureMetadataTable((AccumuloClient)this.client, (String)sourceTable);
        BatchWriter bw = this.client.createBatchWriter(sourceTable);
        String walPrefix = "hdfs://localhost:8020/accumulo/wals/tserver+port/";
        HashSet files = Sets.newHashSet((Object[])new String[]{walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID()});
        HashMap<String, Integer> fileToTableId = new HashMap<String, Integer>();
        Replication.Status stat = Replication.Status.newBuilder().setBegin(0L).setEnd(0L).setInfiniteEnd(true).setClosed(true).setCreatedTime(System.currentTimeMillis()).build();
        int index = 1;
        for (String file : files) {
            Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file));
            m.put(MetadataSchema.ReplicationSection.COLF, new Text(Integer.toString(index)), ProtobufUtil.toValue((GeneratedMessageV3)stat));
            bw.addMutation(m);
            fileToTableId.put(file, index);
            ++index;
        }
        bw.close();
        StatusMaker statusMaker = new StatusMaker(this.client, this.fs);
        statusMaker.setSourceTableName(sourceTable);
        statusMaker.run();
        try (Scanner s = this.client.createScanner(sourceTable, Authorizations.EMPTY);){
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            for (Map.Entry e : s) {
                System.out.println(((Key)e.getKey()).toStringNoTruncate() + " " + e.getValue());
            }
        }
        s = this.client.createScanner(sourceTable, Authorizations.EMPTY);
        try {
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)s));
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    @Test
    public void closedMessagesCreateOrderRecords() throws Exception {
        Iterator<String> expectedFiles;
        Iterator iter;
        String sourceTable = this.testName();
        this.client.tableOperations().create(sourceTable);
        ReplicationTableUtil.configureMetadataTable((AccumuloClient)this.client, (String)sourceTable);
        BatchWriter bw = this.client.createBatchWriter(sourceTable);
        String walPrefix = "hdfs://localhost:8020/accumulo/wals/tserver+port/";
        List<String> files = Arrays.asList(walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID());
        HashMap<String, Integer> fileToTableId = new HashMap<String, Integer>();
        Replication.Status.Builder statBuilder = Replication.Status.newBuilder().setBegin(0L).setEnd(0L).setInfiniteEnd(true).setClosed(true);
        int index = 1;
        long time = System.currentTimeMillis();
        for (String file : files) {
            statBuilder.setCreatedTime(time++);
            Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file));
            m.put(MetadataSchema.ReplicationSection.COLF, new Text(Integer.toString(index)), ProtobufUtil.toValue((GeneratedMessageV3)statBuilder.build()));
            bw.addMutation(m);
            fileToTableId.put(file, index);
            ++index;
        }
        bw.close();
        StatusMaker statusMaker = new StatusMaker(this.client, this.fs);
        statusMaker.setSourceTableName(sourceTable);
        statusMaker.run();
        try (Scanner s = this.client.createScanner(sourceTable, Authorizations.EMPTY);){
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)s));
        }
        s = ReplicationTable.getScanner((AccumuloClient)this.client);
        try {
            ReplicationSchema.OrderSection.limit((ScannerBase)s);
            iter = s.iterator();
            Assertions.assertTrue((boolean)iter.hasNext(), (String)"Found no order records in replication table");
            expectedFiles = files.iterator();
            Text buff = new Text();
            while (expectedFiles.hasNext() && iter.hasNext()) {
                String file = expectedFiles.next();
                Map.Entry entry = (Map.Entry)iter.next();
                Assertions.assertEquals((Object)file, (Object)ReplicationSchema.OrderSection.getFile((Key)((Key)entry.getKey()), (Text)buff));
                ReplicationSchema.OrderSection.getTableId((Key)((Key)entry.getKey()), (Text)buff);
                Assertions.assertEquals((int)((Integer)fileToTableId.get(file)), (int)Integer.parseInt(buff.toString()));
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        Assertions.assertFalse((boolean)expectedFiles.hasNext(), (String)"Found more files unexpectedly");
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Found more entries in replication table unexpectedly");
    }

    @Test
    public void orderRecordsCreatedWithNoCreatedTime() throws Exception {
        Replication.Status status;
        Map.Entry entry;
        String file;
        String sourceTable = this.testName();
        this.client.tableOperations().create(sourceTable);
        ReplicationTableUtil.configureMetadataTable((AccumuloClient)this.client, (String)sourceTable);
        BatchWriter bw = this.client.createBatchWriter(sourceTable);
        String walPrefix = "hdfs://localhost:8020/accumulo/wals/tserver+port/";
        List<String> files = Arrays.asList(walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID(), walPrefix + UUID.randomUUID());
        HashMap<String, Long> fileToTableId = new HashMap<String, Long>();
        Replication.Status.Builder statBuilder = Replication.Status.newBuilder().setBegin(0L).setEnd(0L).setInfiniteEnd(true).setClosed(true);
        HashMap<String, Long> statuses = new HashMap<String, Long>();
        long index = 1L;
        for (String file2 : files) {
            Mutation m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file2));
            m.put(MetadataSchema.ReplicationSection.COLF, new Text(Long.toString(index)), ProtobufUtil.toValue((GeneratedMessageV3)statBuilder.build()));
            bw.addMutation(m);
            fileToTableId.put(file2, index);
            FileStatus status2 = (FileStatus)EasyMock.mock(FileStatus.class);
            EasyMock.expect((Object)status2.getModificationTime()).andReturn((Object)index);
            EasyMock.replay((Object[])new Object[]{status2});
            statuses.put(file2, index);
            EasyMock.expect((Object)this.fs.exists(new Path(file2))).andReturn((Object)true);
            EasyMock.expect((Object)this.fs.getFileStatus(new Path(file2))).andReturn((Object)status2);
            ++index;
        }
        EasyMock.replay((Object[])new Object[]{this.fs});
        bw.close();
        StatusMaker statusMaker = new StatusMaker(this.client, this.fs);
        statusMaker.setSourceTableName(sourceTable);
        statusMaker.run();
        Scanner s = this.client.createScanner(sourceTable, Authorizations.EMPTY);
        s.setRange(MetadataSchema.ReplicationSection.getRange());
        s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)s));
        s = ReplicationTable.getScanner((AccumuloClient)this.client);
        ReplicationSchema.OrderSection.limit((ScannerBase)s);
        Iterator iter = s.iterator();
        Assertions.assertTrue((boolean)iter.hasNext(), (String)"Found no order records in replication table");
        Iterator<String> expectedFiles = files.iterator();
        Text buff = new Text();
        while (expectedFiles.hasNext() && iter.hasNext()) {
            file = expectedFiles.next();
            entry = (Map.Entry)iter.next();
            Assertions.assertEquals((Object)file, (Object)ReplicationSchema.OrderSection.getFile((Key)((Key)entry.getKey()), (Text)buff));
            ReplicationSchema.OrderSection.getTableId((Key)((Key)entry.getKey()), (Text)buff);
            Assertions.assertEquals((int)((Long)fileToTableId.get(file)).intValue(), (int)Integer.parseInt(buff.toString()));
            status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
            Assertions.assertTrue((boolean)status.hasCreatedTime());
            Assertions.assertEquals((long)((Long)statuses.get(file)), (long)status.getCreatedTime());
        }
        Assertions.assertFalse((boolean)expectedFiles.hasNext(), (String)"Found more files unexpectedly");
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Found more entries in replication table unexpectedly");
        s = this.client.createScanner(sourceTable, Authorizations.EMPTY);
        s.setRange(MetadataSchema.ReplicationSection.getRange());
        s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)s));
        s = ReplicationTable.getScanner((AccumuloClient)this.client);
        s.setRange(MetadataSchema.ReplicationSection.getRange());
        iter = s.iterator();
        Assertions.assertTrue((boolean)iter.hasNext(), (String)"Found no stat records in replication table");
        Collections.sort(files);
        expectedFiles = files.iterator();
        while (expectedFiles.hasNext() && iter.hasNext()) {
            file = expectedFiles.next();
            entry = (Map.Entry)iter.next();
            status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
            Assertions.assertTrue((boolean)status.hasCreatedTime());
            Assertions.assertEquals((long)((Long)statuses.get(file)), (long)status.getCreatedTime());
        }
        Assertions.assertFalse((boolean)expectedFiles.hasNext(), (String)"Found more files unexpectedly");
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Found more entries in replication table unexpectedly");
    }
}

