/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.GeneratedMessageV3;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.replication.MockReplicaSystem;
import org.apache.accumulo.tserver.logger.LogEvents;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="Replication ITs are not stable and not currently maintained")
@Deprecated
public class UnusedWalDoesntCloseReplicationStatusIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
        cfg.setNumTservers(1);
    }

    @Test
    public void test() throws Exception {
        File accumuloDir = this.getCluster().getConfig().getAccumuloDir();
        AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        String tableName = this.getUniqueNames(1)[0];
        client.securityOperations().grantTablePermission("root", MetadataTable.NAME, TablePermission.WRITE);
        client.tableOperations().create(tableName);
        TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableName)));
        int numericTableId = Integer.parseInt(tableId.canonical());
        int fakeTableId = numericTableId + 1;
        Assertions.assertNotNull((Object)tableId, (String)"Did not find table ID");
        client.tableOperations().setProperty(tableName, Property.TABLE_REPLICATION.getKey(), "true");
        client.tableOperations().setProperty(tableName, Property.TABLE_REPLICATION_TARGET.getKey() + "cluster1", "1");
        client.instanceOperations().setProperty(Property.REPLICATION_PEERS.getKey() + "cluster1", ReplicaSystemFactory.getPeerConfigurationValue(MockReplicaSystem.class, (String)"50000"));
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        File tserverWalDir = new File(accumuloDir, "wal/faketserver+port");
        File tserverWal = new File(tserverWalDir, UUID.randomUUID().toString());
        fs.mkdirs(new Path(tserverWalDir.getAbsolutePath()));
        FSDataOutputStream out = fs.create(new Path(tserverWal.getAbsolutePath()));
        out.write("--- Log File Header (v4) ---".getBytes(StandardCharsets.UTF_8));
        DataOutputStream dos = new DataOutputStream((OutputStream)out);
        dos.writeUTF("NullCryptoModule");
        LogFileKey key = new LogFileKey();
        LogFileValue value = new LogFileValue();
        key.event = LogEvents.OPEN;
        key.tserverSession = tserverWal.getAbsolutePath();
        key.filename = tserverWal.getAbsolutePath();
        key.write((DataOutput)out);
        value.write((DataOutput)out);
        key.event = LogEvents.DEFINE_TABLET;
        key.tablet = new KeyExtent(TableId.of((String)Integer.toString(fakeTableId)), null, null);
        key.seq = 1L;
        key.tabletId = 1;
        key.write((DataOutput)dos);
        value.write((DataOutput)dos);
        key.tablet = null;
        key.event = LogEvents.MUTATION;
        key.filename = tserverWal.getAbsolutePath();
        value.mutations = Arrays.asList(new ServerMutation(new Text("row")));
        key.write((DataOutput)dos);
        value.write((DataOutput)dos);
        key.event = LogEvents.COMPACTION_START;
        key.filename = accumuloDir.getAbsolutePath() + "/tables/" + fakeTableId + "/t-000001/A000001.rf";
        value.mutations = Collections.emptyList();
        key.write((DataOutput)dos);
        value.write((DataOutput)dos);
        key.event = LogEvents.COMPACTION_FINISH;
        value.mutations = Collections.emptyList();
        key.write((DataOutput)dos);
        value.write((DataOutput)dos);
        dos.close();
        try (BatchWriter bw = client.createBatchWriter(tableName);){
            Mutation m = new Mutation((CharSequence)"m");
            m.put((CharSequence)"m", (CharSequence)"m", (CharSequence)"M");
            bw.addMutation(m);
        }
        log.info("State of metadata table after inserting a record");
        try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            s.setRange(MetadataSchema.TabletsSection.getRange((TableId)tableId));
            for (Map.Entry entry : s) {
                System.out.println(((Key)entry.getKey()).toStringNoTruncate() + " " + entry.getValue());
            }
        }
        s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
        try {
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            for (Map.Entry entry : s) {
                System.out.println(((Key)entry.getKey()).toStringNoTruncate() + " " + ProtobufUtil.toString((GeneratedMessageV3)Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get())));
            }
            log.info("Offline'ing table");
            client.tableOperations().offline(tableName, true);
            String walUri = tserverWal.toURI().toString();
            KeyExtent extent = new KeyExtent(tableId, null, null);
            try (BatchWriter bw = client.createBatchWriter(MetadataTable.NAME);){
                Mutation m = new Mutation(extent.toMetaRow());
                m.put(MetadataSchema.TabletsSection.LogColumnFamily.NAME, new Text("localhost:12345/" + walUri), new Value((CharSequence)(walUri + "|1")));
                bw.addMutation(m);
                m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + new Path(walUri)));
                m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId.canonical()), new Value(StatusUtil.fileCreated((long)System.currentTimeMillis()).toByteArray()));
                bw.addMutation(m);
            }
            log.info("State of metadata after injecting WAL manually");
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
        try {
            s.setRange(MetadataSchema.TabletsSection.getRange((TableId)tableId));
            for (Map.Entry entry : s) {
                log.info("{} {}", (Object)((Key)entry.getKey()).toStringNoTruncate(), entry.getValue());
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
        try {
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            for (Map.Entry entry : s) {
                log.info("{} {}", (Object)((Key)entry.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessageV3)Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get())));
            }
            log.info("Bringing table online");
            client.tableOperations().online(tableName, true);
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)client.createScanner(tableName, Authorizations.EMPTY)));
            log.info("Table has performed recovery, state of metadata:");
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
        try {
            s.setRange(MetadataSchema.TabletsSection.getRange((TableId)tableId));
            for (Map.Entry entry : s) {
                log.info("{} {}", (Object)((Key)entry.getKey()).toStringNoTruncate(), entry.getValue());
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
        try {
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            for (Map.Entry entry : s) {
                Replication.Status status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                log.info("{} {}", (Object)((Key)entry.getKey()).toStringNoTruncate(), (Object)ProtobufUtil.toString((GeneratedMessageV3)status));
                Assertions.assertFalse((boolean)status.getClosed(), (String)"Status record was closed and it should not be");
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }
}

