/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.manager.replication.WorkMaker;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="Replication ITs are not stable and not currently maintained")
@Deprecated
public class WorkMakerIT
extends ConfigurableMacBase {
    private AccumuloClient client;

    @BeforeEach
    public void setupInstance() throws Exception {
        this.client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();
        ReplicationTable.setOnline((AccumuloClient)this.client);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.WRITE);
        this.client.securityOperations().grantTablePermission(this.client.whoami(), ReplicationTable.NAME, TablePermission.READ);
    }

    @Test
    public void singleUnitSingleTarget() throws Exception {
        ReplicationTarget expected;
        String table = this.testName();
        this.client.tableOperations().create(table);
        TableId tableId = TableId.of((String)((String)this.client.tableOperations().tableIdMap().get(table)));
        String file = "hdfs://localhost:8020/accumulo/wal/123456-1234-1234-12345678";
        long timeCreated = System.currentTimeMillis();
        Mutation m = new Mutation((CharSequence)new Path(file).toString());
        m.put(ReplicationSchema.StatusSection.NAME, new Text(tableId.canonical()), StatusUtil.fileCreatedValue((long)timeCreated));
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        bw.addMutation(m);
        bw.flush();
        try (Scanner s = ReplicationTable.getScanner((AccumuloClient)this.client);){
            ReplicationSchema.StatusSection.limit((ScannerBase)s);
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)s));
            MockWorkMaker workMaker = new MockWorkMaker(this.client);
            expected = new ReplicationTarget("remote_cluster_1", "4", tableId);
            workMaker.setBatchWriter(bw);
            workMaker.addWorkRecord(new Text(file), StatusUtil.fileCreatedValue((long)timeCreated), Map.of("remote_cluster_1", "4"), tableId);
        }
        s = ReplicationTable.getScanner((AccumuloClient)this.client);
        try {
            ReplicationSchema.WorkSection.limit((ScannerBase)s);
            Map.Entry<Key, Value> workEntry = this.getOnlyElement(s);
            Key workKey = workEntry.getKey();
            ReplicationTarget actual = ReplicationTarget.from((Text)workKey.getColumnQualifier());
            Assertions.assertEquals((Object)file, (Object)workKey.getRow().toString());
            Assertions.assertEquals((Object)ReplicationSchema.WorkSection.NAME, (Object)workKey.getColumnFamily());
            Assertions.assertEquals((Object)expected, (Object)actual);
            Assertions.assertEquals((Object)workEntry.getValue(), (Object)StatusUtil.fileCreatedValue((long)timeCreated));
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    @Test
    public void singleUnitMultipleTargets() throws Exception {
        String table = this.testName();
        this.client.tableOperations().create(table);
        TableId tableId = TableId.of((String)((String)this.client.tableOperations().tableIdMap().get(table)));
        String file = "hdfs://localhost:8020/accumulo/wal/123456-1234-1234-12345678";
        Mutation m = new Mutation((CharSequence)new Path(file).toString());
        m.put(ReplicationSchema.StatusSection.NAME, new Text(tableId.canonical()), StatusUtil.fileCreatedValue((long)System.currentTimeMillis()));
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        bw.addMutation(m);
        bw.flush();
        HashSet<ReplicationTarget> expectedTargets = new HashSet<ReplicationTarget>();
        try (Scanner s = ReplicationTable.getScanner((AccumuloClient)this.client);){
            ReplicationSchema.StatusSection.limit((ScannerBase)s);
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)s));
            MockWorkMaker workMaker = new MockWorkMaker(this.client);
            Map<String, String> targetClusters = Map.of("remote_cluster_1", "4", "remote_cluster_2", "6", "remote_cluster_3", "8");
            for (Map.Entry<String, String> cluster : targetClusters.entrySet()) {
                expectedTargets.add(new ReplicationTarget(cluster.getKey(), cluster.getValue(), tableId));
            }
            workMaker.setBatchWriter(bw);
            workMaker.addWorkRecord(new Text(file), StatusUtil.fileCreatedValue((long)System.currentTimeMillis()), targetClusters, tableId);
        }
        s = ReplicationTable.getScanner((AccumuloClient)this.client);
        try {
            ReplicationSchema.WorkSection.limit((ScannerBase)s);
            HashSet<ReplicationTarget> actualTargets = new HashSet<ReplicationTarget>();
            for (Map.Entry entry : s) {
                Assertions.assertEquals((Object)file, (Object)((Key)entry.getKey()).getRow().toString());
                Assertions.assertEquals((Object)ReplicationSchema.WorkSection.NAME, (Object)((Key)entry.getKey()).getColumnFamily());
                ReplicationTarget target = ReplicationTarget.from((Text)((Key)entry.getKey()).getColumnQualifier());
                actualTargets.add(target);
            }
            for (ReplicationTarget expected : expectedTargets) {
                Assertions.assertTrue((boolean)actualTargets.contains(expected), (String)("Did not find expected target: " + expected));
                actualTargets.remove(expected);
            }
            Assertions.assertTrue((boolean)actualTargets.isEmpty(), (String)("Found extra replication work entries: " + actualTargets));
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    @Test
    public void dontCreateWorkForEntriesWithNothingToReplicate() throws Exception {
        String table = this.testName();
        this.client.tableOperations().create(table);
        String tableId = (String)this.client.tableOperations().tableIdMap().get(table);
        String file = "hdfs://localhost:8020/accumulo/wal/123456-1234-1234-12345678";
        Mutation m = new Mutation((CharSequence)new Path(file).toString());
        m.put(ReplicationSchema.StatusSection.NAME, new Text(tableId), StatusUtil.fileCreatedValue((long)System.currentTimeMillis()));
        BatchWriter bw = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
        bw.addMutation(m);
        bw.flush();
        try (Scanner s = ReplicationTable.getScanner((AccumuloClient)this.client);){
            ReplicationSchema.StatusSection.limit((ScannerBase)s);
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)s));
            MockWorkMaker workMaker = new MockWorkMaker(this.client);
            this.client.tableOperations().setProperty(ReplicationTable.NAME, Property.TABLE_REPLICATION_TARGET.getKey() + "remote_cluster_1", "4");
            workMaker.setBatchWriter(bw);
            workMaker.run();
        }
        s = ReplicationTable.getScanner((AccumuloClient)this.client);
        try {
            ReplicationSchema.WorkSection.limit((ScannerBase)s);
            Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)s));
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    private static class MockWorkMaker
    extends WorkMaker {
        public MockWorkMaker(AccumuloClient client) {
            super(null, client);
        }

        public void setBatchWriter(BatchWriter bw) {
            super.setBatchWriter(bw);
        }

        public void addWorkRecord(Text file, Value v, Map<String, String> targets, TableId sourceTableId) {
            super.addWorkRecord(file, v, targets, sourceTableId);
        }

        public boolean shouldCreateWork(Replication.Status status) {
            return super.shouldCreateWork(status);
        }
    }
}

