/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.rpc;

import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;

public class Mocket {
    private final TTransport clientTransport;
    private final TServerTransport serverTransport;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public Mocket() {
        Buffer serverQueue = new Buffer();
        Buffer clientQueue = new Buffer();
        this.clientTransport = new MocketTransport(clientQueue, serverQueue);
        this.serverTransport = new MocketServerTransport(new MocketTransport(serverQueue, clientQueue));
    }

    public TServerTransport getServerTransport() {
        return this.serverTransport;
    }

    public TTransport getClientTransport() {
        return this.clientTransport;
    }

    private boolean isMocketClosed() {
        return this.closed.get();
    }

    private void closeMocket() {
        this.closed.set(true);
    }

    private class Buffer {
        private final LinkedBlockingQueue<Integer> queue = new LinkedBlockingQueue();

        private Buffer() {
        }

        public void write(int b) {
            this.queue.add(b);
        }

        public void write(byte[] buf, int off, int len) {
            Objects.requireNonNull(buf);
            Objects.checkFromToIndex(off, off + len, buf.length);
            if (len == 0) {
                return;
            }
            for (int i = 0; i < len; ++i) {
                this.write(buf[off + i]);
            }
        }

        public int read() {
            while (!Mocket.this.isMocketClosed()) {
                Integer item;
                try {
                    item = this.queue.poll(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Mocket.this.closeMocket();
                    return -1;
                }
                if (item == null) continue;
                return item;
            }
            return -1;
        }

        public int read(byte[] buf, int off, int len) {
            int i;
            Objects.requireNonNull(buf);
            Objects.checkFromToIndex(off, off + len, buf.length);
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            buf[off] = (byte)c;
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                buf[off + i] = (byte)c;
            }
            return i;
        }
    }

    private class MocketTransport
    extends TTransport {
        private final Buffer input;
        private final Buffer output;

        private MocketTransport(Buffer input, Buffer output) {
            this.input = input;
            this.output = output;
        }

        public void write(byte[] buf, int off, int len) {
            this.output.write(buf, off, len);
        }

        public TConfiguration getConfiguration() {
            return null;
        }

        public void updateKnownMessageSize(long size) {
        }

        public void checkReadBytesAvailable(long numBytes) {
        }

        public int read(byte[] buf, int off, int len) {
            return this.input.read(buf, off, len);
        }

        public void open() {
        }

        public boolean isOpen() {
            return !Mocket.this.isMocketClosed();
        }

        public void close() {
            Mocket.this.closeMocket();
        }
    }

    private static class MocketServerTransport
    extends TServerTransport {
        private final MocketTransport servTrans;

        public MocketServerTransport(MocketTransport mocketTransport) {
            this.servTrans = mocketTransport;
        }

        public void listen() {
        }

        public TTransport accept() {
            return this.servTrans;
        }

        public void close() {
            this.servTrans.close();
        }

        public void interrupt() {
            this.close();
        }
    }
}

