/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.rpc;

import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.test.rpc.Mocket;
import org.apache.accumulo.test.rpc.SimpleThriftServiceHandler;
import org.apache.accumulo.test.rpc.thrift.SimpleThriftService;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TSimpleServer;

public class SimpleThriftServiceRunner {
    private SimpleThriftServiceHandler handler = new SimpleThriftServiceHandler();
    private final Mocket mocket = new Mocket();
    private final Thread serviceThread;
    private final TServer server = this.createServer();

    public SimpleThriftServiceRunner(String threadName) {
        this.serviceThread = new Thread(() -> ((TServer)this.server).serve(), threadName);
    }

    public void startService() {
        this.serviceThread.start();
    }

    public SimpleThriftServiceHandler handler() {
        return this.handler;
    }

    public SimpleThriftService.Client client() {
        return new SimpleThriftService.Client((TProtocol)new TBinaryProtocol(this.mocket.getClientTransport()));
    }

    private TServer createServer() {
        TServer.Args args = new TServer.Args(this.mocket.getServerTransport());
        SimpleThriftService.Iface actualHandler = (SimpleThriftService.Iface)TraceUtil.wrapService((Object)this.handler);
        args.processor(new SimpleThriftService.Processor<SimpleThriftService.Iface>(actualHandler));
        args.protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory());
        return new TSimpleServer((TServer.AbstractServerArgs)args);
    }

    public void stopService() {
        this.server.stop();
        try {
            this.serviceThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

