/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.rpc;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.harness.WithTestNames;
import org.apache.accumulo.test.rpc.SimpleThriftServiceHandler;
import org.apache.accumulo.test.rpc.SimpleThriftServiceRunner;
import org.apache.accumulo.test.rpc.thrift.SimpleThriftService;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Tag(value="SunnyDay")
@Timeout(value=5L, unit=TimeUnit.SECONDS)
public class ThriftBehaviorIT
extends WithTestNames {
    private SimpleThriftService.Client client;
    private SimpleThriftServiceHandler handler;
    private SimpleThriftServiceRunner serviceRunner;
    private String propName;
    private static final String KITTY_MSG = "\ud83d\udc08 Kitty! \ud83d\udc08";

    @BeforeEach
    public void createClientAndServer() {
        String threadName = ThriftBehaviorIT.class.getSimpleName() + "." + this.testName();
        this.serviceRunner = new SimpleThriftServiceRunner(threadName);
        this.serviceRunner.startService();
        this.client = this.serviceRunner.client();
        this.handler = this.serviceRunner.handler();
        this.propName = this.testName();
        if (this.propName.endsWith("Handler")) {
            this.propName = this.propName.substring(0, this.propName.length() - 7);
        }
        this.propName = SimpleThriftServiceHandler.class.getSimpleName() + "." + this.propName;
        System.setProperty(this.propName, "-");
        Assertions.assertEquals((Object)"-", (Object)System.getProperty(this.propName));
    }

    @AfterEach
    public void shutdownServer() {
        this.serviceRunner.stopService();
        Assertions.assertEquals((Object)KITTY_MSG, (Object)System.getProperty(this.propName));
    }

    @Test
    public void echoFailHandler() throws TException {
        TException e = (TException)Assertions.assertThrows(TException.class, () -> this.handler.echoFail(KITTY_MSG));
        Assertions.assertTrue((boolean)(e.getCause() instanceof UnsupportedOperationException));
    }

    @Test
    public void echoFail() throws TException {
        Assertions.assertThrows(TApplicationException.class, () -> this.client.echoFail(KITTY_MSG));
        this.echoPass();
    }

    @Test
    public void echoRuntimeFailHandler() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.handler.echoRuntimeFail(KITTY_MSG));
    }

    @Test
    public void echoRuntimeFail() throws TException {
        Assertions.assertThrows(TApplicationException.class, () -> this.client.echoRuntimeFail(KITTY_MSG));
        this.echoPass();
    }

    @Test
    public void echoPassHandler() {
        Assertions.assertEquals((Object)KITTY_MSG, (Object)this.handler.echoPass(KITTY_MSG));
    }

    @Test
    public void echoPass() throws TException {
        Assertions.assertEquals((Object)KITTY_MSG, (Object)this.client.echoPass(KITTY_MSG));
    }

    @Test
    public void onewayFailHandler() throws TException {
        TException e = (TException)Assertions.assertThrows(TException.class, () -> this.handler.onewayFail(KITTY_MSG));
        Assertions.assertTrue((boolean)(e.getCause() instanceof UnsupportedOperationException));
    }

    @Test
    public void onewayFail() throws TException {
        this.client.onewayFail(KITTY_MSG);
        this.echoPass();
    }

    @Test
    public void onewayRuntimeFailHandler() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.handler.onewayRuntimeFail(KITTY_MSG));
    }

    @Test
    public void onewayRuntimeFail() throws TException {
        this.client.onewayRuntimeFail(KITTY_MSG);
        this.echoPass();
    }

    @Test
    public void onewayPassHandler() {
        this.handler.onewayPass(KITTY_MSG);
    }

    @Test
    public void onewayPass() throws TException {
        this.client.onewayPass(KITTY_MSG);
        this.echoPass();
    }
}

