/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.server.security;

import java.time.Duration;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SystemCredentialsIT
extends ConfigurableMacBase {
    private static final int SCAN_FAILED = 7;
    private static final int AUTHENICATION_FAILED = 8;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Test
    public void testSystemCredentials() throws Exception {
        Assertions.assertEquals((int)0, (int)this.exec(SystemCredentialsIT.class, "good", this.getCluster().getZooKeepers()).waitFor());
        Assertions.assertEquals((int)8, (int)this.exec(SystemCredentialsIT.class, "bad", this.getCluster().getZooKeepers()).waitFor());
        Assertions.assertEquals((int)8, (int)this.exec(SystemCredentialsIT.class, "bad_password", this.getCluster().getZooKeepers()).waitFor());
    }

    public static void main(String[] args) throws AccumuloException, TableNotFoundException {
        SiteConfiguration siteConfig = SiteConfiguration.auto();
        try (ServerContext context = new ServerContext(siteConfig);){
            SystemCredentials creds;
            InstanceId badInstanceID = InstanceId.of((String)SystemCredentials.class.getName());
            if (args.length < 2) {
                throw new RuntimeException("Incorrect usage; expected to be run by test only");
            }
            switch (args[0]) {
                case "bad": {
                    creds = SystemCredentials.get((InstanceId)badInstanceID, (SiteConfiguration)siteConfig);
                    break;
                }
                case "good": {
                    creds = SystemCredentials.get((InstanceId)context.getInstanceID(), (SiteConfiguration)siteConfig);
                    break;
                }
                case "bad_password": {
                    creds = new SystemCredentials(badInstanceID, "!SYSTEM", (AuthenticationToken)new PasswordToken((CharSequence)"fake"));
                    break;
                }
                default: {
                    throw new RuntimeException("Incorrect usage; expected to be run by test only");
                }
            }
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(context.getProperties()).as((CharSequence)creds.getPrincipal(), creds.getToken()).build();){
                client.securityOperations().authenticateUser(creds.getPrincipal(), creds.getToken());
                try (Scanner scan = client.createScanner(RootTable.NAME, Authorizations.EMPTY);){
                    scan.forEach((k, v) -> {});
                }
                catch (RuntimeException e) {
                    e.printStackTrace(System.err);
                    System.exit(7);
                }
            }
            catch (AccumuloSecurityException e) {
                e.printStackTrace(System.err);
                System.exit(8);
            }
        }
    }
}

