/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.shell;

import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="MiniClusterOnly")
public class ConfigSetIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(ConfigSetIT.class);

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void setInvalidJson() throws Exception {
        log.debug("Starting setInvalidJson test ------------------");
        String validJson = "[{'name':'small','type':'internal','maxSize':'64M','numThreads':2},{'name':'huge','type':'internal','numThreads':2}]".replaceAll("'", "\"");
        String invalidJson = "notJson";
        try (AccumuloClient client = ConfigSetIT.getCluster().createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)ConfigSetIT.getRootPassword()));){
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_ROOT_EXECUTORS.getKey(), validJson);
            Assertions.assertThrows(AccumuloException.class, () -> client.instanceOperations().setProperty(Property.MONITOR_RESOURCES_EXTERNAL.getKey(), invalidJson));
        }
    }
}

