/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.shell;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.test.shell.ErrorMessageCallback;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.DumbTerminal;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockShell {
    private static final Logger shellLog = LoggerFactory.getLogger(MockShell.class);
    private static final ErrorMessageCallback noop = new ErrorMessageCallback();
    final TestOutputStream output;
    final StringInputStream input;
    public Shell shell;
    public LineReader reader;
    public Terminal terminal;

    MockShell(String user, String rootPass, String instanceName, String zookeepers, File configFile) throws IOException {
        ClientInfo info = ClientInfo.from((Path)configFile.toPath());
        this.output = new TestOutputStream();
        this.input = new StringInputStream();
        this.terminal = new DumbTerminal((InputStream)this.input, (OutputStream)this.output);
        this.terminal.setSize(new Size(80, 24));
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).build();
        this.shell = new Shell(this.reader);
        this.shell.setLogErrorsToConsole();
        if (info.saslEnabled()) {
            this.shell.config(new String[]{"-u", user, "-z", instanceName, zookeepers, "--config-file", configFile.getAbsolutePath()});
        } else {
            this.shell.config(new String[]{"-u", user, "-p", rootPass, "-z", instanceName, zookeepers, "--config-file", configFile.getAbsolutePath()});
        }
        this.exec("quit", true);
        this.shell.start();
        this.shell.setExit(false);
    }

    String exec(String cmd) {
        this.output.clear();
        this.shell.execCommand(cmd, true, true);
        return this.output.get();
    }

    String exec(String cmd, boolean expectGoodExit) {
        return this.exec(cmd, expectGoodExit, noop);
    }

    String exec(String cmd, boolean expectGoodExit, ErrorMessageCallback callback) {
        String result = this.exec(cmd);
        if (expectGoodExit) {
            this.assertGoodExit("", true, callback);
        } else {
            this.assertBadExit("", true, callback);
        }
        return result;
    }

    String exec(String cmd, boolean expectGoodExit, String expectString) throws IOException {
        return this.exec(cmd, expectGoodExit, expectString, noop);
    }

    String exec(String cmd, boolean expectGoodExit, String expectString, ErrorMessageCallback callback) throws IOException {
        return this.exec(cmd, expectGoodExit, expectString, true, callback);
    }

    String exec(String cmd, boolean expectGoodExit, String expectString, boolean stringPresent) throws IOException {
        return this.exec(cmd, expectGoodExit, expectString, stringPresent, noop);
    }

    String exec(String cmd, boolean expectGoodExit, String expectString, boolean stringPresent, ErrorMessageCallback callback) {
        String result = this.exec(cmd);
        if (expectGoodExit) {
            this.assertGoodExit(expectString, stringPresent, callback);
        } else {
            this.assertBadExit(expectString, stringPresent, callback);
        }
        return result;
    }

    void assertGoodExit(String s, boolean stringPresent, ErrorMessageCallback callback) {
        shellLog.debug("Shell Output: '{}'", (Object)this.output.get());
        if (this.shell.getExitCode() != 0) {
            String errorMsg = callback.getErrorMessage();
            Assertions.assertEquals((int)0, (int)this.shell.getExitCode(), (String)errorMsg);
        }
        if (!s.isEmpty()) {
            Assertions.assertEquals((Object)stringPresent, (Object)this.output.get().contains(s), (String)(s + " present in " + this.output.get() + " was not " + stringPresent));
        }
    }

    void assertBadExit(String s, boolean stringPresent, ErrorMessageCallback callback) {
        shellLog.debug(this.output.get());
        if (this.shell.getExitCode() == 0) {
            String errorMsg = callback.getErrorMessage();
            Assertions.assertTrue((this.shell.getExitCode() > 0 ? 1 : 0) != 0, (String)errorMsg);
        }
        if (!s.isEmpty()) {
            Assertions.assertEquals((Object)stringPresent, (Object)this.output.get().contains(s), (String)(s + " present in " + this.output.get() + " was not " + stringPresent));
        }
        this.shell.resetExitCode();
    }

    void writeToHistory(String cmd) {
        this.input.set(cmd);
        this.reader.readLine();
    }

    static class TestOutputStream
    extends OutputStream {
        StringBuilder sb = new StringBuilder();

        TestOutputStream() {
        }

        @Override
        public void write(int b) {
            this.sb.append((char)(0xFF & b));
        }

        public String get() {
            return this.sb.toString();
        }

        public void clear() {
            this.sb.setLength(0);
        }
    }

    static class StringInputStream
    extends InputStream {
        private String source = "";
        private int offset = 0;

        StringInputStream() {
        }

        @Override
        public int read() {
            if (this.offset == this.source.length()) {
                return 10;
            }
            return this.source.charAt(this.offset++);
        }

        public void set(String other) {
            this.source = other;
            this.offset = 0;
        }
    }
}

