/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TimeZone;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.test.shell.ShellIT;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.DumbTerminal;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ShellAuthenticatorIT
extends SharedMiniClusterBase {
    private ShellIT.StringInputStream input;
    private ShellIT.TestOutputStream output;
    private Shell shell;
    public LineReader reader;
    public Terminal terminal;

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @BeforeEach
    public void setupShell() throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        this.output = new ShellIT.TestOutputStream();
        this.input = new ShellIT.StringInputStream();
        this.terminal = new DumbTerminal((InputStream)this.input, (OutputStream)this.output);
        this.terminal.setSize(new Size(80, 24));
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).build();
    }

    @AfterEach
    public void tearDownShell() {
        if (this.shell != null) {
            this.shell.shutdown();
        }
    }

    @Test
    public void testClientPropertiesFile() throws IOException {
        this.shell = new Shell(this.reader);
        this.shell.setLogErrorsToConsole();
        Assertions.assertTrue((boolean)this.shell.config(new String[]{"--config-file", ShellAuthenticatorIT.getCluster().getClientPropsPath()}));
    }

    @Test
    public void testClientProperties() throws IOException {
        this.shell = new Shell(this.reader);
        this.shell.setLogErrorsToConsole();
        Assertions.assertTrue((boolean)this.shell.config(new String[]{"-u", ShellAuthenticatorIT.getAdminPrincipal(), "-p", ShellAuthenticatorIT.getRootPassword(), "-zi", ShellAuthenticatorIT.getCluster().getInstanceName(), "-zh", ShellAuthenticatorIT.getCluster().getZooKeepers()}));
    }

    @Test
    public void testClientPropertiesBadPassword() throws IOException {
        this.shell = new Shell(this.reader);
        this.shell.setLogErrorsToConsole();
        Assertions.assertFalse((boolean)this.shell.config(new String[]{"-u", ShellAuthenticatorIT.getAdminPrincipal(), "-p", "BADPW", "-zi", ShellAuthenticatorIT.getCluster().getInstanceName(), "-zh", ShellAuthenticatorIT.getCluster().getZooKeepers()}));
    }

    @Test
    public void testAuthTimeoutPropertiesFile() throws IOException, InterruptedException {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        this.output = new ShellIT.TestOutputStream();
        this.input = new ShellIT.StringInputStream();
        this.terminal = new DumbTerminal((InputStream)this.input, (OutputStream)this.output);
        this.terminal.setSize(new Size(80, 24));
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).build();
        this.shell = new Shell(this.reader);
        this.shell.setLogErrorsToConsole();
        Assertions.assertTrue((boolean)this.shell.config(new String[]{"--auth-timeout", "1", "--config-file", ShellAuthenticatorIT.getCluster().getClientPropsPath()}));
        Thread.sleep(90000L);
        this.shell.execCommand("whoami", false, false);
        Assertions.assertTrue((boolean)this.output.get().contains("root"));
    }
}

