/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.shell;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.harness.conf.StandaloneAccumuloClusterConfiguration;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.FairVolumeChooser;
import org.apache.accumulo.test.VolumeChooserIT;
import org.apache.accumulo.test.shell.MockShell;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ShellConfigIT
extends AccumuloClusterHarness {
    private String origPropValue;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(30L);
    }

    @BeforeEach
    public void checkProperty() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellConfigIT.getClientProps()).build();){
            this.origPropValue = (String)client.instanceOperations().getSystemConfiguration().get(VolumeChooserIT.PERTABLE_CHOOSER_PROP);
            client.instanceOperations().setProperty(VolumeChooserIT.PERTABLE_CHOOSER_PROP, FairVolumeChooser.class.getName());
        }
    }

    @AfterEach
    public void resetProperty() throws Exception {
        if (this.origPropValue != null) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellConfigIT.getClientProps()).build();){
                client.instanceOperations().setProperty(VolumeChooserIT.PERTABLE_CHOOSER_PROP, this.origPropValue);
            }
        }
    }

    @Test
    public void experimentalPropTest() throws Exception {
        AuthenticationToken token = ShellConfigIT.getAdminToken();
        File clientPropsFile = null;
        switch (ShellConfigIT.getClusterType()) {
            case MINI: {
                MiniAccumuloClusterImpl mac = (MiniAccumuloClusterImpl)ShellConfigIT.getCluster();
                clientPropsFile = mac.getConfig().getClientPropsFile();
                break;
            }
            case STANDALONE: {
                StandaloneAccumuloClusterConfiguration standaloneConf = (StandaloneAccumuloClusterConfiguration)ShellConfigIT.getClusterConfiguration();
                clientPropsFile = standaloneConf.getClientPropsFile();
                break;
            }
            default: {
                Assertions.fail((String)"Unknown cluster type");
            }
        }
        Assertions.assertNotNull(clientPropsFile);
        MockShell ts = null;
        if (token instanceof PasswordToken) {
            String passwd = new String(((PasswordToken)token).getPassword(), StandardCharsets.UTF_8);
            ts = new MockShell(ShellConfigIT.getAdminPrincipal(), passwd, ShellConfigIT.getCluster().getInstanceName(), ShellConfigIT.getCluster().getZooKeepers(), clientPropsFile);
        } else if (token instanceof KerberosToken) {
            ts = new MockShell(ShellConfigIT.getAdminPrincipal(), null, ShellConfigIT.getCluster().getInstanceName(), ShellConfigIT.getCluster().getZooKeepers(), clientPropsFile);
        } else {
            Assertions.fail((String)"Unknown token type");
        }
        Assertions.assertTrue((boolean)Property.TABLE_CRYPTO_PREFIX.isExperimental());
        Assertions.assertTrue((boolean)Property.TABLE_CRYPTO_SENSITIVE_PREFIX.isExperimental());
        Assertions.assertTrue((boolean)Property.INSTANCE_CRYPTO_FACTORY.isExperimental());
        Assertions.assertTrue((boolean)Property.INSTANCE_CRYPTO_PREFIX.isExperimental());
        Assertions.assertTrue((boolean)Property.INSTANCE_CRYPTO_SENSITIVE_PREFIX.isExperimental());
        String configOutput = ts.exec("config");
        Assertions.assertTrue((boolean)configOutput.contains(VolumeChooserIT.PERTABLE_CHOOSER_PROP));
    }
}

