/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.shell;

import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.shell.MockShell;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;

@Tags(value={@Tag(value="MiniClusterOnly"), @Tag(value="SunnyDay")})
public class ShellCreateNamespaceIT
extends SharedMiniClusterBase {
    private MockShell ts;

    @BeforeAll
    public static void setupMiniCluster() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new SSCTITCallback());
    }

    @BeforeEach
    public void setupShell() throws Exception {
        this.ts = new MockShell(ShellCreateNamespaceIT.getPrincipal(), ShellCreateNamespaceIT.getRootPassword(), ShellCreateNamespaceIT.getCluster().getConfig().getInstanceName(), ShellCreateNamespaceIT.getCluster().getConfig().getZooKeepers(), ShellCreateNamespaceIT.getCluster().getConfig().getClientPropsFile());
    }

    @AfterAll
    public static void tearDownAfterAll() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @AfterEach
    public void tearDownShell() {
        this.ts.shell.shutdown();
    }

    @Test
    public void createSimpleTest() throws Exception {
        String namespace = this.getUniqueNames(1)[0];
        this.ts.exec("createnamespace " + namespace, true);
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ShellCreateNamespaceIT.getClientProps()).build();){
            Assertions.assertTrue((boolean)accumuloClient.namespaceOperations().exists(namespace));
            this.ts.exec("deletenamespace -f " + namespace);
        }
    }

    @Test
    public void copyConfigTest() throws Exception {
        String sysPropName = "table.custom.my_sys_prop";
        String sysPropVal1 = "sys_v1";
        String sysPropVal2 = "sys_v2";
        String nsPropName = "table.custom.my_ns_prop";
        String nsPropVal1 = "ns_v1";
        String[] names = this.getUniqueNames(2);
        String ns1 = names[0];
        String ns2 = names[1];
        this.ts.exec("createnamespace " + ns1, true);
        this.ts.exec("config -s table.custom.my_sys_prop=sys_v1");
        this.ts.exec("config -s table.custom.my_ns_prop=ns_v1 -ns " + ns1);
        this.ts.exec("createnamespace -cc " + ns1 + " " + ns2, true);
        this.ts.exec("config -s table.custom.my_sys_prop=sys_v2");
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ShellCreateNamespaceIT.getClientProps()).build();){
            Assertions.assertTrue((boolean)accumuloClient.namespaceOperations().exists(ns1));
            Assertions.assertTrue((boolean)accumuloClient.namespaceOperations().exists(ns2));
            Map p1 = accumuloClient.namespaceOperations().getNamespaceProperties(ns1);
            Assertions.assertNull(p1.get("table.custom.my_sys_prop"));
            Assertions.assertEquals((Object)"ns_v1", p1.get("table.custom.my_ns_prop"));
            Map p2 = accumuloClient.namespaceOperations().getNamespaceProperties(ns2);
            Assertions.assertEquals((Object)"sys_v1", p2.get("table.custom.my_sys_prop"));
            Assertions.assertTrue((p2.size() > p1.size() ? 1 : 0) != 0);
            this.ts.exec("deletenamespace -f " + ns1);
            this.ts.exec("deletenamespace -f " + ns2);
        }
    }

    @Test
    public void copyPropertiesTest() throws Exception {
        String sysPropName = "table.custom.my_sys_prop";
        String sysPropVal1 = "sys_v1";
        String sysPropVal2 = "sys_v2";
        String nsPropName = "table.custom.my_ns_prop";
        String nsPropVal1 = "ns_v1";
        String[] names = this.getUniqueNames(2);
        String srcNs = names[0];
        String destNs = names[1];
        this.ts.exec("createnamespace " + srcNs, true);
        this.ts.exec("config -s table.custom.my_sys_prop=sys_v1");
        this.ts.exec("config -s table.custom.my_ns_prop=ns_v1 -ns " + srcNs);
        this.ts.exec("createnamespace --exclude-parent-properties -cc " + srcNs + " " + destNs, true);
        this.ts.exec("config -s table.custom.my_sys_prop=sys_v2");
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ShellCreateNamespaceIT.getClientProps()).build();){
            Assertions.assertTrue((boolean)accumuloClient.namespaceOperations().exists(srcNs));
            Assertions.assertTrue((boolean)accumuloClient.namespaceOperations().exists(destNs));
            Map srcProps = accumuloClient.namespaceOperations().getNamespaceProperties(srcNs);
            Assertions.assertNull(srcProps.get("table.custom.my_sys_prop"));
            Assertions.assertEquals((Object)"ns_v1", srcProps.get("table.custom.my_ns_prop"));
            Map copiedProps = accumuloClient.namespaceOperations().getNamespaceProperties(destNs);
            Assertions.assertNull(copiedProps.get("table.custom.my_sys_prop"));
            Assertions.assertEquals((Object)"ns_v1", copiedProps.get("table.custom.my_ns_prop"));
            Assertions.assertEquals((Object)copiedProps, (Object)srcProps);
            Map config = accumuloClient.namespaceOperations().getConfiguration(destNs);
            Assertions.assertEquals((Object)"sys_v2", config.get("table.custom.my_sys_prop"));
            this.ts.exec("deletenamespace -f " + srcNs);
            this.ts.exec("deletenamespace -f " + destNs);
        }
    }

    @Test
    public void copyTablePropsInvalidOptsTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        this.ts.exec("createnamespace " + names[0]);
        this.ts.exec("createnamespace " + names[1]);
        this.ts.exec("createnamespace --exclude-parent-properties " + names[0] + " " + names[1], false);
    }

    @Test
    public void missingSrcCopyPropsTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        this.ts.exec("createnamespace -cp " + names[0] + " " + names[1], false);
    }

    @Test
    public void missingSrcCopyConfigTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        this.ts.exec("createnamespace -cc " + names[0] + " " + names[1], false);
    }

    @Test
    public void destExistsTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        this.ts.exec("createnamespace " + names[0]);
        this.ts.exec("createnamespace " + names[1]);
        this.ts.exec("createnamespace -cp " + names[0] + " " + names[1], false);
    }

    @Test
    public void duplicateNamespaceTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        this.ts.exec("createnamespace " + names[0]);
        this.ts.exec("createnamespace " + names[0], false);
    }

    private static class SSCTITCallback
    implements MiniClusterConfigurationCallback {
        private SSCTITCallback() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumTservers(1);
            Map siteConf = cfg.getSiteConfig();
            cfg.setSiteConfig(siteConf);
        }
    }
}

