/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.shell;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.PropStore;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.test.shell.MockShell;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;

@Tags(value={@Tag(value="MiniClusterOnly"), @Tag(value="SunnyDay")})
public class ShellCreateTableIT
extends SharedMiniClusterBase {
    private MockShell ts;

    @BeforeAll
    public static void setupMiniCluster() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new SSCTITCallback());
    }

    @BeforeEach
    public void setupShell() throws Exception {
        this.ts = new MockShell(ShellCreateTableIT.getPrincipal(), ShellCreateTableIT.getRootPassword(), ShellCreateTableIT.getCluster().getConfig().getInstanceName(), ShellCreateTableIT.getCluster().getConfig().getZooKeepers(), ShellCreateTableIT.getCluster().getConfig().getClientPropsFile());
    }

    @AfterAll
    public static void tearDownAfterAll() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @AfterEach
    public void tearDownShell() {
        this.ts.shell.shutdown();
    }

    @Test
    public void testCreateTableWithLocalityGroups() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table + " -l locg1=fam1,fam2", true);
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            Map lMap = accumuloClient.tableOperations().getLocalityGroups(table);
            Set<Text> expectedColFams = Set.of(new Text("fam1"), new Text("fam2"));
            for (Map.Entry entry : lMap.entrySet()) {
                Assertions.assertEquals((Object)"locg1", entry.getKey());
                Assertions.assertTrue((boolean)((Set)entry.getValue()).containsAll(expectedColFams));
            }
            this.ts.exec("deletetable -f " + table);
        }
    }

    @Test
    public void testCreateTableWithMultipleLocalityGroups() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table + " -l locg1=fam1,fam2 locg2=colfam1", true);
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            Map lMap = accumuloClient.tableOperations().getLocalityGroups(table);
            Assertions.assertTrue((boolean)lMap.containsKey("locg1"));
            Assertions.assertTrue((boolean)lMap.containsKey("locg2"));
            Set<Text> expectedColFams1 = Set.of(new Text("fam1"), new Text("fam2"));
            Set<Text> expectedColFams2 = Set.of(new Text("colfam1"));
            Assertions.assertTrue((boolean)((Set)lMap.get("locg1")).containsAll(expectedColFams1));
            Assertions.assertTrue((boolean)((Set)lMap.get("locg2")).containsAll(expectedColFams2));
            this.ts.exec("deletetable -f " + table);
        }
    }

    @Test
    public void testCreateTableWithLocalityGroupsBadArguments() throws IOException {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table + " -l locg1 fam1,fam2", false);
        this.ts.exec("createtable " + table + "-l", false);
        this.ts.exec("createtable " + table + " -l locg1 = fam1,fam2", false);
        this.ts.exec("createtable " + table + " -l locg1=fam1 ,fam2", false);
        this.ts.exec("createtable " + table + " -l locg1=fam1,fam2 locg1=fam3,fam4", false);
        this.ts.exec("createtable " + table + " -l locg1=fam1,fam2 locg2=fam1", false);
        this.ts.exec("createtable " + table + " -l locg1", false);
        this.ts.exec("createtable " + table + " group=fam1", false);
        this.ts.exec("createtable " + table + "-l fam1,fam2", false);
    }

    @Test
    public void testCreateTableWithIterators() throws Exception {
        String tmpTable = "tmpTable";
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable tmpTable", true);
        String output = this.ts.exec("tables");
        Assertions.assertTrue((boolean)output.contains("tmpTable"));
        this.ts.input.set("\n5000\n\n");
        this.ts.exec("setshelliter -n itname -p 10 -pn profile1 -ageoff", true);
        output = this.ts.exec("listshelliter");
        Assertions.assertTrue((boolean)output.contains("Profile : profile1"));
        this.ts.exec("createtable " + table + " -i profile1:scan,minc", true);
        this.ts.exec("insert foo a b c", true);
        this.ts.exec("scan", true, "foo a:b []\tc");
        this.ts.exec("sleep 6", true);
        this.ts.exec("scan", true, "", true);
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("deletetable -f tmpTable");
    }

    @Test
    public void testCreateTableWithMultipleIterators() throws Exception {
        String tmpTable = "tmpTable";
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable tmpTable", true);
        String output = this.ts.exec("tables");
        Assertions.assertTrue((boolean)output.contains("tmpTable"));
        this.ts.input.set("\n5000\n\n");
        this.ts.exec("setshelliter -n itname -p 10 -pn profile1 -ageoff", true);
        output = this.ts.exec("listshelliter");
        Assertions.assertTrue((boolean)output.contains("Profile : profile1"));
        this.ts.input.set("2\n");
        this.ts.exec("setshelliter -n iter2 -p 11 -pn profile2 -vers", true);
        output = this.ts.exec("listshelliter");
        Assertions.assertTrue((boolean)output.contains("Profile : profile2"));
        this.ts.exec("createtable " + table + " -i profile1:scan,minc profile2:all ", true);
        this.ts.exec("insert foo a b c", true);
        this.ts.exec("scan", true, "foo a:b []\tc");
        this.ts.exec("sleep 6", true);
        this.ts.exec("scan", true, "", true);
        output = this.ts.exec("listiter -t " + table + " -all");
        Assertions.assertTrue((boolean)output.contains("Iterator itname, scan scope options"));
        Assertions.assertTrue((boolean)output.contains("Iterator itname, minc scope options"));
        Assertions.assertFalse((boolean)output.contains("Iterator itname, majc scope options"));
        Assertions.assertTrue((boolean)output.contains("Iterator iter2, scan scope options"));
        Assertions.assertTrue((boolean)output.contains("Iterator iter2, minc scope options"));
        Assertions.assertTrue((boolean)output.contains("Iterator iter2, majc scope options"));
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("deletetable -f tmpTable");
    }

    @Test
    public void testCreateTableWithIteratorsBadArguments() throws IOException {
        String tmpTable = "tmpTable";
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable tmpTable", true);
        String output = this.ts.exec("tables");
        Assertions.assertTrue((boolean)output.contains("tmpTable"));
        this.ts.input.set("\n5000\n\n");
        this.ts.exec("setshelliter -n itname -p 10 -pn profile1 -ageoff", true);
        output = this.ts.exec("listshelliter");
        Assertions.assertTrue((boolean)output.contains("Profile : profile1"));
        this.ts.exec("createtable " + table + " -i noprofile:scan,minc", false);
        this.ts.exec("createtable " + table + " -i profile1:scan,minc,all,majc", false);
        this.ts.exec("createtable " + table + " -i profile1:scan,all,majc", false);
        this.ts.exec("createtable " + table + " -i profile1:scan,min,majc", false);
        this.ts.exec("createtable " + table + " -i profile1:scan,max,all", false);
        this.ts.exec("createtable " + table + " -i profile1:", false);
        this.ts.exec("createtable " + table + " -i profile1: ", false);
        this.ts.exec("createtable " + table + " -i profile1:-scan", false);
        this.ts.exec("createtable " + table + " profile1:majc", false);
        this.ts.exec("createtable " + table + " -i profile1: all", false);
        this.ts.exec("createtable " + table + " -i profile1: All", false);
        this.ts.exec("createtable " + table + " -i profile1: scan", false);
        this.ts.exec("createtable " + table + " -i profile1:minc scan", false);
        this.ts.exec("createtable " + table + " -i profile1:minc,Scan", false);
        this.ts.exec("createtable " + table + " -i profile1:minc, scan", false);
        this.ts.exec("createtable " + table + " -i profile1:minc,,scan", false);
        this.ts.exec("createtable " + table + " -i profile1:minc,minc", false);
        this.ts.exec("createtable " + table + " -i profile1:minc,Minc", false);
        this.ts.exec("createtable " + table + " -i profile1:minc, ,scan", false);
        this.ts.exec("createtable " + table + "-i", false);
        this.ts.exec("createtable " + table + "-i ", false);
        this.ts.exec("deletetable -f tmpTable");
    }

    @Test
    public void testCreateTableOffline() throws IOException {
        String tableName = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + tableName + " -o", true);
        String output = this.ts.exec("tables");
        Assertions.assertTrue((boolean)output.contains(tableName));
        output = this.ts.exec("scan -t " + tableName, false, "is offline", true);
        Assertions.assertTrue((boolean)output.contains("TableOfflineException"));
        this.ts.exec("table " + tableName, true);
        this.ts.exec("online", true);
        this.ts.exec("scan", true);
        this.ts.exec("deletetable -f " + tableName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithSplitsFile1() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 1000, 12, false, false, true, false, false);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithSplitsFile2() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 300, 12, false, false, false, false, false);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithSplitsFile3() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 100, 23, false, true, true, false, false);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithSplitsFile4() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 100, 31, false, false, true, true, false);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithSplitsFile5() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 100, 32, false, false, true, false, true);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithSplitsFile6() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 100, 12, false, false, false, true, true);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithSplitsFile7() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 100, 12, false, false, true, true, true);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithEmptySplitFile() throws IOException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 0, 0, false, false, false, false, false);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, false);
            Assertions.assertThrows(TableNotFoundException.class, () -> client.tableOperations().listSplits(tableName));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    @Test
    public void testCreateTableWithCopySplitsFromOtherTable() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            String[] tableNames = this.getUniqueNames(2);
            String tableName0 = tableNames[0];
            String tableName2 = tableNames[1];
            this.ts.exec("createtable " + tableName0, true);
            String output = this.ts.exec("tables", true);
            Assertions.assertTrue((boolean)output.contains(tableName0));
            this.ts.exec("table " + tableName0, true);
            ArrayList<Text> splits = new ArrayList<Text>();
            splits.add(new Text("ccccc"));
            splits.add(new Text("fffff"));
            splits.add(new Text("mmmmm"));
            splits.add(new Text("sssss"));
            this.ts.exec("addsplits " + splits.get(0) + " " + splits.get(1) + " " + splits.get(2) + " " + splits.get(3), true);
            this.ts.exec("createtable " + tableName2 + " --copy-splits " + tableName0, true);
            this.ts.exec("table " + tableName0, true);
            String tablesOutput = this.ts.exec("tables", true);
            Assertions.assertTrue((boolean)tablesOutput.contains(tableName2));
            Collection createdSplits = client.tableOperations().listSplits(tableName2);
            Assertions.assertEquals(new TreeSet(splits), new TreeSet(createdSplits));
            this.ts.exec("deletetable -f " + tableName0, true);
            this.ts.exec("deletetable -f " + tableName2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithBinarySplitsFile1() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 200, 12, true, true, true, false, false);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithBinarySplitsFile2() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 300, 12, true, true, false, false, false);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithBinarySplitsFile3() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 100, 23, true, true, true, false, false);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithBinarySplitsFile4() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 100, 31, true, true, true, true, false);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithBinarySplitsFile5() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 100, 32, true, true, true, false, true);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithBinarySplitsFile6() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 100, 12, true, true, false, true, true);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithBinarySplitsFile7() throws IOException, AccumuloSecurityException, TableNotFoundException, AccumuloException {
        String splitsFile = System.getProperty("user.dir") + "/target/splitFile";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            this.generateSplitsFile(splitsFile, 100, 12, true, true, true, true, true);
            SortedSet<Text> expectedSplits = this.readSplitsFromFile(splitsFile);
            String tableName = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + tableName + " -sf " + splitsFile, true);
            Collection createdSplits = client.tableOperations().listSplits(tableName);
            Assertions.assertEquals(expectedSplits, new TreeSet(createdSplits));
        }
        finally {
            Files.delete(Paths.get(splitsFile, new String[0]));
        }
    }

    private SortedSet<Text> readSplitsFromFile(String splitsFile) throws IOException {
        TreeSet<Text> splits = new TreeSet<Text>();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(splitsFile, new String[0]));){
            String split;
            while ((split = reader.readLine()) != null) {
                Text unencodedString = this.decode(split);
                if (unencodedString == null) continue;
                splits.add(unencodedString);
            }
        }
        return splits;
    }

    private void generateSplitsFile(String splitsFile, int numItems, int len, boolean binarySplits, boolean encoded, boolean sort, boolean addBlankLine, boolean repeat) throws IOException {
        Path splitsPath = Paths.get(splitsFile, new String[0]);
        int insertAt = len % 2 == 0 ? len / 2 : (len + 1) / 2;
        TreeSet<Text> sortedSplits = null;
        Collection<Text> randomSplits = binarySplits ? this.generateBinarySplits(numItems, len) : this.generateNonBinarySplits(numItems, len);
        if (sort) {
            sortedSplits = new TreeSet<Text>(randomSplits);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(splitsPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            int cnt = 0;
            Collection<Text> splits = sort ? sortedSplits : randomSplits;
            for (Text text : splits) {
                if (addBlankLine && cnt++ == insertAt) {
                    writer.write(10);
                }
                writer.write(ShellCreateTableIT.encode(text, encoded) + "\n");
                if (!repeat) continue;
                writer.write(ShellCreateTableIT.encode(text, encoded) + "\n");
            }
        }
    }

    @Test
    public void copyConfigOptionsTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        String srcNS = "ns1";
        String srcTable = srcNS + ".src_table_" + names[1];
        String destTable = srcNS + ".dest_table_" + names[1];
        String sysPropName = "table.custom.my_sys_prop";
        String sysPropValue1 = "sys_value1";
        String sysPropValue2 = "sys_value2";
        String nsPropName = "table.custom.my_ns_prop";
        String nsPropValue1 = "ns_value1";
        String nsPropValue2 = "ns_value2";
        this.ts.exec("config -s table.custom.my_sys_prop=sys_value1");
        this.ts.exec("createnamespace " + srcNS);
        this.ts.exec("config -s table.custom.my_ns_prop=ns_value1 -ns " + srcNS);
        this.ts.exec("createtable " + srcTable);
        this.ts.exec("createtable -cc " + srcTable + " " + destTable);
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            Map tids = accumuloClient.tableOperations().tableIdMap();
            PropStore propStore = ShellCreateTableIT.getCluster().getServerContext().getPropStore();
            TableId destId = TableId.of((String)((String)accumuloClient.tableOperations().tableIdMap().get(destTable)));
            VersionedProperties vp1 = propStore.get((PropStoreKey)TablePropKey.of((ServerContext)ShellCreateTableIT.getCluster().getServerContext(), (TableId)destId));
            Assertions.assertEquals((Object)"sys_value1", vp1.asMap().get("table.custom.my_sys_prop"));
            Assertions.assertEquals((Object)"ns_value1", vp1.asMap().get("table.custom.my_ns_prop"));
            Map tableEffective = accumuloClient.tableOperations().getTableProperties(destTable);
            Assertions.assertEquals((Object)"sys_value1", tableEffective.get("table.custom.my_sys_prop"));
            Assertions.assertEquals((Object)"ns_value1", tableEffective.get("table.custom.my_ns_prop"));
            this.ts.exec("config -s table.custom.my_sys_prop=sys_value2");
            this.ts.exec("config -s table.custom.my_ns_prop=ns_value2 -ns " + srcNS);
            VersionedProperties vp2 = propStore.get((PropStoreKey)TablePropKey.of((ServerContext)ShellCreateTableIT.getCluster().getServerContext(), (TableId)TableId.of((String)((String)tids.get(srcTable)))));
            Assertions.assertNull(vp2.asMap().get("table.custom.my_sys_prop"));
            Assertions.assertNull(vp2.asMap().get("table.custom.my_ns_prop"));
            VersionedProperties vp3 = propStore.get((PropStoreKey)TablePropKey.of((ServerContext)ShellCreateTableIT.getCluster().getServerContext(), (TableId)TableId.of((String)((String)tids.get(destTable)))));
            Assertions.assertEquals((Object)"sys_value1", vp3.asMap().get("table.custom.my_sys_prop"));
            Assertions.assertEquals((Object)"ns_value1", vp3.asMap().get("table.custom.my_ns_prop"));
            tableEffective = accumuloClient.tableOperations().getConfiguration(srcTable);
            Assertions.assertEquals((Object)"sys_value2", tableEffective.get("table.custom.my_sys_prop"));
            Assertions.assertEquals((Object)"ns_value2", tableEffective.get("table.custom.my_ns_prop"));
            tableEffective = accumuloClient.tableOperations().getConfiguration(destTable);
            Assertions.assertEquals((Object)"sys_value1", tableEffective.get("table.custom.my_sys_prop"));
            Assertions.assertEquals((Object)"ns_value1", tableEffective.get("table.custom.my_ns_prop"));
        }
    }

    @Test
    public void copyTablePropsOnlyOptionsTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        String srcNS = "src_ns_" + names[0];
        String srcTable = srcNS + ".src_table_" + names[1];
        String destTable = srcNS + ".dest_table_" + names[1];
        String sysPropName = "table.custom.my_sys_prop";
        String sysPropValue1 = "sys_value1";
        String sysPropValue2 = "sys_value2";
        String nsPropName = "table.custom.my_ns_prop";
        String nsPropValue1 = "ns_value1";
        String nsPropValue2 = "ns_value2";
        this.ts.exec("config -s table.custom.my_sys_prop=sys_value1");
        this.ts.exec("createnamespace " + srcNS);
        this.ts.exec("config -s table.custom.my_ns_prop=ns_value1 -ns " + srcNS);
        this.ts.exec("createtable " + srcTable);
        this.ts.exec("createtable --exclude-parent-properties --copy-config " + srcTable + " " + destTable, true);
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ShellCreateTableIT.getClientProps()).build();){
            Map tids = accumuloClient.tableOperations().tableIdMap();
            VersionedProperties vp1 = ShellCreateTableIT.getCluster().getServerContext().getPropStore().get((PropStoreKey)TablePropKey.of((ServerContext)ShellCreateTableIT.getCluster().getServerContext(), (TableId)TableId.of((String)((String)tids.get(destTable)))));
            Assertions.assertNull(vp1.asMap().get("table.custom.my_sys_prop"));
            Assertions.assertNull(vp1.asMap().get("table.custom.my_ns_prop"));
            Map tableEffective = accumuloClient.tableOperations().getConfiguration(destTable);
            Assertions.assertEquals((Object)"sys_value1", tableEffective.get("table.custom.my_sys_prop"));
            Assertions.assertEquals((Object)"ns_value1", tableEffective.get("table.custom.my_ns_prop"));
            this.ts.exec("config -s table.custom.my_sys_prop=sys_value2");
            this.ts.exec("config -s table.custom.my_ns_prop=ns_value2 -ns " + srcNS);
            VersionedProperties vp2 = ShellCreateTableIT.getCluster().getServerContext().getPropStore().get((PropStoreKey)TablePropKey.of((ServerContext)ShellCreateTableIT.getCluster().getServerContext(), (TableId)TableId.of((String)((String)tids.get(srcTable)))));
            Assertions.assertNull(vp2.asMap().get("table.custom.my_sys_prop"));
            Assertions.assertNull(vp2.asMap().get("table.custom.my_ns_prop"));
            VersionedProperties vp3 = ShellCreateTableIT.getCluster().getServerContext().getPropStore().get((PropStoreKey)TablePropKey.of((ServerContext)ShellCreateTableIT.getCluster().getServerContext(), (TableId)TableId.of((String)((String)tids.get(destTable)))));
            Assertions.assertNull(vp3.asMap().get("table.custom.my_sys_prop"));
            Assertions.assertNull(vp3.asMap().get("table.custom.my_ns_prop"));
            tableEffective = accumuloClient.tableOperations().getConfiguration(destTable);
            Assertions.assertEquals((Object)"sys_value2", tableEffective.get("table.custom.my_sys_prop"));
            Assertions.assertEquals((Object)"ns_value2", tableEffective.get("table.custom.my_ns_prop"));
        }
    }

    @Test
    public void copyTablePropsInvalidOptsTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        this.ts.exec("createtable " + names[0]);
        this.ts.exec("createtable " + names[1]);
        this.ts.exec("createtable --exclude-parent " + names[0] + "dest", false);
    }

    @Test
    public void missingSrcCopyPropsTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        this.ts.exec("createtable --exclude-parent -cc " + names[0] + " " + names[1], false);
    }

    @Test
    public void missingSrcCopyConfigTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        this.ts.exec("createtable -cc " + names[0] + " " + names[1], false);
    }

    @Test
    public void destExistsTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        this.ts.exec("createtable " + names[0]);
        this.ts.exec("createtable " + names[1]);
        this.ts.exec("createtable -cc " + names[0] + " " + names[1], false);
    }

    @Test
    public void optionOrderingTest() throws Exception {
        String[] names = this.getUniqueNames(3);
        this.ts.exec("createtable " + names[0]);
        this.ts.exec("createtable --exclude-parent --copy-config " + names[0] + " " + names[1], true);
        this.ts.exec("createtable --copy-config " + names[0] + " --exclude-parent " + names[2], true);
    }

    private Collection<Text> generateNonBinarySplits(int numItems, int len) {
        HashSet<Text> splits = new HashSet<Text>();
        for (int i = 0; i < numItems; ++i) {
            splits.add(this.getRandomText(len));
        }
        return splits;
    }

    private Collection<Text> generateBinarySplits(int numItems, int len) {
        HashSet<Text> splits = new HashSet<Text>();
        for (int i = 0; i < numItems; ++i) {
            byte[] split = new byte[len];
            random.nextBytes(split);
            splits.add(new Text(split));
        }
        return splits;
    }

    private Text getRandomText(int len) {
        int desiredLen = Math.min(len, 32);
        return new Text(String.valueOf(UUID.randomUUID()).replaceAll("-", "").substring(0, desiredLen - 1));
    }

    private static String encode(Text text, boolean encode) {
        if (text.toString().isBlank()) {
            return null;
        }
        return encode ? Base64.getEncoder().encodeToString(TextUtil.getBytes((Text)text)) : text.toString();
    }

    private Text decode(String text) {
        if (Objects.requireNonNull(text).isBlank()) {
            return null;
        }
        return new Text(text);
    }

    private static class SSCTITCallback
    implements MiniClusterConfigurationCallback {
        private SSCTITCallback() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumTservers(1);
            Map siteConf = cfg.getSiteConfig();
            cfg.setSiteConfig(siteConf);
        }
    }
}

