/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.shell;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.shell.Shell;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.DumbTerminal;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={@Tag(value="MiniClusterOnly"), @Tag(value="SunnyDay")})
public class ShellIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(ShellIT.class);
    private StringInputStream input;
    private TestOutputStream output;
    private Shell shell;
    private File config;
    public LineReader reader;
    public Terminal terminal;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(3L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    void execExpectList(String cmd, boolean expecteGoodExit, List<String> expectedStrings) throws IOException {
        this.exec(cmd);
        if (expecteGoodExit) {
            this.assertGoodExit("", true);
        } else {
            this.assertBadExit("", true);
        }
        for (String expectedString : expectedStrings) {
            Assertions.assertTrue((boolean)this.output.get().contains(expectedString), (String)(expectedString + " was not present in " + this.output.get()));
        }
    }

    void exec(String cmd) throws IOException {
        this.output.clear();
        this.shell.execCommand(cmd, true, true);
    }

    void exec(String cmd, boolean expectGoodExit) throws IOException {
        this.exec(cmd);
        if (expectGoodExit) {
            this.assertGoodExit("", true);
        } else {
            this.assertBadExit("", true);
        }
    }

    void exec(String cmd, boolean expectGoodExit, String expectString) throws IOException {
        this.exec(cmd, expectGoodExit, expectString, true);
    }

    void exec(String cmd, boolean expectGoodExit, String expectString, boolean stringPresent) throws IOException {
        this.exec(cmd);
        if (expectGoodExit) {
            this.assertGoodExit(expectString, stringPresent);
        } else {
            this.assertBadExit(expectString, stringPresent);
        }
    }

    @BeforeEach
    public void setupShell() throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        this.output = new TestOutputStream();
        this.input = new StringInputStream();
        this.config = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        this.terminal = new DumbTerminal((InputStream)this.input, (OutputStream)this.output);
        this.terminal.setSize(new Size(80, 24));
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).build();
        this.shell = new Shell(this.reader);
        this.shell.setLogErrorsToConsole();
        this.shell.config(new String[]{"--config-file", this.config.toString(), "-u", "root", "-p", ShellIT.getRootPassword(), "-zi", ShellIT.getCluster().getInstanceName(), "-zh", ShellIT.getCluster().getZooKeepers()});
    }

    @AfterEach
    public void teardownShell() {
        if (this.config.exists() && !this.config.delete()) {
            log.error("Unable to delete {}", (Object)this.config);
        }
        this.shell.shutdown();
    }

    void assertGoodExit(String s, boolean stringPresent) {
        Shell.log.debug("{}", (Object)this.output.get());
        Assertions.assertEquals((int)this.shell.getExitCode(), (int)0);
        if (!s.isEmpty()) {
            Assertions.assertEquals((Object)stringPresent, (Object)this.output.get().contains(s), (String)(s + " present in " + this.output.get() + " was not " + stringPresent));
        }
    }

    void assertBadExit(String s, boolean stringPresent) {
        Shell.log.debug("{}", (Object)this.output.get());
        Assertions.assertTrue((this.shell.getExitCode() > 0 ? 1 : 0) != 0);
        if (!s.isEmpty()) {
            Assertions.assertEquals((Object)stringPresent, (Object)this.output.get().contains(s), (String)(s + " present in " + this.output.get() + " was not " + stringPresent));
        }
        this.shell.resetExitCode();
    }

    @Test
    public void aboutTest() throws IOException {
        Shell.log.debug("Starting about test -----------------------------------");
        this.exec("about", true, "Shell - Apache Accumulo Interactive Shell");
        this.exec("about -v", true, "Current user:");
        this.exec("about arg", false, "java.lang.IllegalArgumentException: Expected 0 arguments");
    }

    @Test
    public void addGetSplitsTest() throws IOException {
        Shell.log.debug("Starting addGetSplits test ----------------------------");
        this.exec("addsplits arg", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("createtable test", true);
        this.exec("addsplits 1 \\x80", true);
        this.exec("getsplits", true, "1\n\\x80");
        this.exec("getsplits -m 1", true, "1");
        this.exec("getsplits -b64", true, "MQ==\ngA==");
        this.exec("deletetable test -f", true, "Table: [test] has been deleted");
    }

    @Test
    public void insertDeleteScanTest() throws IOException {
        Shell.log.debug("Starting insertDeleteScan test ------------------------");
        this.exec("insert r f q v", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("delete r f q", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("createtable test", true);
        this.exec("insert r f q v", true);
        this.exec("scan", true, "r f:q []\tv");
        this.exec("delete r f q", true);
        this.exec("scan", true, "r f:q []\tv", false);
        this.exec("insert \\x90 \\xa0 \\xb0 \\xc0\\xd0\\xe0\\xf0", true);
        this.exec("scan", true, "\\x90 \\xA0:\\xB0 []\t\\xC0\\xD0");
        this.exec("scan -f 2", true, "\\x90 \\xA0:\\xB0 []\t\\xC0\\xD0");
        this.exec("scan -f 2", true, "\\x90 \\xA0:\\xB0 []\t\\xC0\\xD0\\xE0", false);
        this.exec("scan -b \\x90 -e \\x90 -c \\xA0", true, "\\x90 \\xA0:\\xB0 []\t\\xC0");
        this.exec("scan -b \\x90 -e \\x90 -c \\xA0:\\xB0", true, "\\x90 \\xA0:\\xB0 []\t\\xC0");
        this.exec("scan -b \\x90 -be", true, "\\x90 \\xA0:\\xB0 []\t\\xC0", false);
        this.exec("scan -e \\x90 -ee", true, "\\x90 \\xA0:\\xB0 []\t\\xC0", false);
        this.exec("scan -b \\x90\\x00", true, "\\x90 \\xA0:\\xB0 []\t\\xC0", false);
        this.exec("scan -e \\x8f", true, "\\x90 \\xA0:\\xB0 []\t\\xC0", false);
        this.exec("delete \\x90 \\xa0 \\xb0", true);
        this.exec("scan", true, "\\x90 \\xA0:\\xB0 []\t\\xC0", false);
        this.exec("deletetable test -f", true, "Table: [test] has been deleted");
        this.exec("createtable test2", true);
        this.exec("notable", true);
        this.exec("insert r f q v", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("insert r1 f1 q1 v1 -t test2", true);
        this.exec("insert r2 f2 q2 v2 --table test2", true);
        this.exec("delete r1 f1 q1 -t", false, "org.apache.commons.cli.MissingArgumentException: Missing argument for option:");
        this.exec("delete r1 f1 q1 -t  test3", false, "org.apache.accumulo.core.client.TableNotFoundException:");
        this.exec("scan -t test2", true, "r1 f1:q1 []\tv1\nr2 f2:q2 []\tv2");
        this.exec("delete r1 f1 q1 -t test2", true);
        this.exec("scan -t test2", true, "r1 f1:q1 []\tv1", false);
        this.exec("scan -t test2", true, "r2 f2:q2 []\tv2", true);
        this.exec("delete r2 f2 q2 --table test2", true);
        this.exec("scan -t test2", true, "r1 f1:q1 []\tv1", false);
        this.exec("scan -t test2", true, "r2 f2:q2 []\tv2", false);
        this.exec("deletetable test2 -f", true, "Table: [test2] has been deleted");
    }

    @Test
    public void insertIntoSpecifiedTableTest() throws IOException {
        Shell.log.debug("Starting insertIntoSpecifiedTableTest -----------------");
        this.exec("createtable tab1", true);
        this.exec("createtable tab2", true);
        this.exec("insert row1 f q tab2", true);
        this.exec("insert row2 f q tab2 --table tab2", true);
        this.exec("insert row3 f q tab2 -t tab2", true);
        this.exec("notable", true);
        this.exec("insert row1 f q tab1", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("insert row1 f q tab1 --table tab1", true);
        this.exec("insert row4 f q tab2 -t tab2", true);
        this.exec("table tab2", true);
        this.exec("insert row2 f q tab1 -t tab1", true);
        this.exec("notable", true);
        this.exec("insert row5 f q tab5 --table", false, "org.apache.commons.cli.MissingArgumentException: Missing argument for option:");
        this.exec("insert row5 f q tab5 --t", false, "org.apache.commons.cli.AmbiguousOptionException: Ambiguous option: '--t'");
        this.exec("scan -t tab1", true, "row1 f:q []\ttab1\nrow2 f:q []\ttab1");
        this.exec("scan -t tab2", true, "row1 f:q []\ttab2\nrow2 f:q []\ttab2\nrow3 f:q []\ttab2\nrow4 f:q []\ttab2");
        this.exec("createtable tab3", true);
        this.exec("table tab3", true);
        this.exec("insert row1 f1 q1 tab3", true);
        this.exec("insert row2 f2 q2 tab3 --table idontexist", false, "org.apache.accumulo.core.client.TableNotFoundException:");
        this.exec("insert row2 f2 q2 tab3 -t idontexist", false, "org.apache.accumulo.core.client.TableNotFoundException:");
        this.exec("insert row3 f3 q3 tab3", true);
        this.exec("scan", true, "row1 f1:q1 []\ttab3\nrow3 f3:q3 []\ttab3");
        this.exec("deletetable tab1 -f", true, "Table: [tab1] has been deleted");
        this.exec("deletetable tab2 -f", true, "Table: [tab2] has been deleted");
        this.exec("deletetable tab3 -f", true, "Table: [tab3] has been deleted");
    }

    @Test
    public void deleteManyTest() throws IOException {
        this.exec("deletemany", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("createtable test", true);
        this.exec("deletemany", true, "\n");
        this.exec("insert 0 0 0 0 -ts 0");
        this.exec("insert 0 0 0 0 -l 0 -ts 0");
        this.exec("insert 1 1 1 1 -ts 1");
        this.exec("insert 2 2 2 2 -ts 2");
        this.exec("deletemany", true, "[SKIPPED] 0 0:0 []");
        this.exec("deletemany -r 0", true, "[SKIPPED] 0 0:0 []");
        this.exec("deletemany -r 0 -f", true, "[DELETED] 0 0:0 []");
        this.exec("setauths -s 0");
        this.exec("deletemany -r 0 -f", true, "[DELETED] 0 0:0 [0]");
        this.exec("deletemany -r 1 -f -st", true, "[DELETED] 1 1:1 [] 1");
        this.exec("deletemany -r 2 -f -st -fm org.apache.accumulo.core.util.format.DateStringFormatter", true, "[DELETED] 2 2:2 [] 2");
        this.exec("setauths -c ", true);
        this.exec("deletetable test -f", true, "Table: [test] has been deleted");
    }

    @Test
    public void authsTest() throws Exception {
        Shell.log.debug("Starting auths test --------------------------");
        this.exec("setauths x,y,z", false, "Missing required option");
        this.exec("setauths -s x,y,z -u notauser", false, "user does not exist");
        this.exec("setauths -s y,z,x", true);
        this.exec("getauths -u notauser", false, "user does not exist");
        this.execExpectList("getauths", true, Arrays.asList("x", "y", "z"));
        this.exec("addauths -u notauser", false, "Missing required option");
        this.exec("addauths -u notauser -s foo", false, "user does not exist");
        this.exec("addauths -s a", true);
        this.execExpectList("getauths", true, Arrays.asList("x", "y", "z", "a"));
        this.exec("setauths -c", true);
    }

    @Test
    public void userExistsTest() throws IOException {
        Shell.log.debug("Starting user test --------------------------");
        String user = this.testName();
        this.exec("createuser root", false, "user exists");
        this.exec("createuser " + user, true);
        this.exec("createuser " + user, false, "user exists");
        this.exec("deleteuser " + user + " -f", true);
    }

    @Test
    public void duContextTest() throws Exception {
        Shell.log.debug("Starting du context test --------------------------");
        this.exec("createtable t", true);
        this.exec("du", true, "0 [t]");
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
    }

    @Test
    public void duTest() throws IOException {
        Shell.log.debug("Starting DU test --------------------------");
        this.exec("createtable t", true);
        this.exec("du t", true, "0 [t]");
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
    }

    @Test
    public void duPatternTest() throws IOException {
        Shell.log.debug("Starting DU with pattern test --------------------------");
        this.exec("createtable t", true);
        this.exec("createtable tt", true);
        this.exec("du -p t.*", true, "0 [t, tt]");
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
        this.exec("deletetable tt -f", true, "Table: [tt] has been deleted");
    }

    @Test
    public void scanTimestampTest() throws IOException {
        String name = this.getUniqueNames(1)[0];
        Shell.log.debug("Starting scanTimestamp test ------------------------");
        this.exec("createtable " + name, true);
        this.exec("insert r f q v -ts 0", true);
        this.exec("scan -st", true, "r f:q [] 0\tv");
        this.exec("scan -st -f 0", true, " : [] 0\t");
        this.exec("deletemany -f", true);
        this.exec("deletetable " + name + " -f", true, "Table: [" + name + "] has been deleted");
    }

    @Test
    public void scanFewTest() throws IOException {
        Shell.log.debug("Starting scanFew test ------------------------");
        String name = this.getUniqueNames(1)[0];
        this.exec("createtable " + name, true);
        this.exec("insert 1 123 123456 -l '12345678' -ts 123456789 1234567890", true);
        this.exec("setauths -s 12345678", true);
        String expected = "1 123:123456 [12345678] 123456789\t1234567890";
        String expectedFew = "1 123:12345 [12345678] 123456789\t12345";
        this.exec("scan -st", true, expected);
        this.exec("scan -st -f 5", true, expectedFew);
        this.exec("scan -st -fm org.apache.accumulo.core.util.format.BinaryFormatter", true, expected);
        this.exec("scan -st -f 5 -fm org.apache.accumulo.core.util.format.BinaryFormatter", true, expectedFew);
        this.exec("setauths -c", true);
        this.exec("deletetable " + name + " -f", true, "Table: [" + name + "] has been deleted");
    }

    @Test
    public void scanDateStringFormatterTest() throws IOException {
        Shell.log.debug("Starting scan dateStringFormatter test --------------------------");
        this.exec("createtable t", true);
        this.exec("insert r f q v -ts 0", true);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        String expected = String.format("r f:q [] %s\tv", dateFormat.format(new Date(0L)));
        String expectedNoTimestamp = "r f:q []\tv";
        this.exec("scan -fm org.apache.accumulo.core.util.format.DateStringFormatter -st", true, expected);
        this.exec("scan -fm org.apache.accumulo.core.util.format.DateStringFormatter -st -f 1000", true, expected);
        this.exec("scan -fm org.apache.accumulo.core.util.format.DateStringFormatter -st -f 5", true, expected);
        this.exec("scan -fm org.apache.accumulo.core.util.format.DateStringFormatter", true, expectedNoTimestamp);
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
    }

    @Test
    public void grepTest() throws IOException {
        Shell.log.debug("Starting grep test --------------------------");
        this.exec("grep", false, "java.lang.IllegalStateException: Not in a table context");
        this.exec("createtable t", true);
        this.exec("setauths -s vis", true);
        this.exec("insert r f q v -ts 0 -l vis", true);
        String expected = "r f:q [vis]\tv";
        String expectedTimestamp = "r f:q [vis] 0\tv";
        this.exec("grep", false, "No terms specified");
        this.exec("grep vis", true, expected);
        this.exec("grep non_matching_string", true, "");
        this.exec("grep r", true, expected);
        this.exec("grep r -f 1", true, expected);
        this.exec("grep r -st", true, expectedTimestamp);
        this.exec("grep r -st -f 1", true, expectedTimestamp);
        this.exec("setauths -c", true);
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void configPropertyTest() throws IOException {
        String table = "testtable";
        String filterProperty = "config -t testtable -f ";
        String setProperty = "config -t testtable -s ";
        ArrayList<String> expectedStrings = new ArrayList<String>();
        try {
            this.exec("createtable testtable");
            this.exec("config -t testtable -f table.iterator.scan.vers.opt.maxVersions", true, "table      | table.iterator.scan.vers.opt.maxVersions .. | 1\n");
            this.exec("config -t testtable -s table.iterator.scan.vers.opt.maxVersions=2", true);
            this.exec("config -t testtable -f table.iterator.scan.vers.opt.maxVersions", true, "table      | table.iterator.scan.vers.opt.maxVersions .. | 2\n");
            this.exec("config -t testtable -s table.iterator.scan.vers.opt.maxVersions=", true);
            this.exec("config -t testtable -f table.iterator.scan.vers.opt.maxVersions", true, "table      | table.iterator.scan.vers.opt.maxVersions .. | \n");
            this.exec("config -t testtable -f table.bloom.enabled", true, "default    | table.bloom.enabled ....................... | false\n");
            this.exec("config -t testtable -s table.bloom.enabled=true", true);
            expectedStrings.add("default    | table.bloom.enabled ....................... | false\n");
            expectedStrings.add("table      |    @override .............................. | true\n");
            this.execExpectList("config -t testtable -f table.bloom.enabled", true, expectedStrings);
            this.exec("config -t testtable -s table.bloom.enabled=failsSinceNotABoolean", false);
            this.exec("config -t testtable -f table.file.compress.type", true, "default    | table.file.compress.type .................. | gz\n");
            this.exec("config -t testtable -s table.file.compress.type=zippy", true);
            expectedStrings.clear();
            expectedStrings.add("default    | table.file.compress.type .................. | gz\n");
            expectedStrings.add("table      |    @override .............................. | zippy");
            this.execExpectList("config -t testtable -f table.file.compress.type", true, expectedStrings);
            this.exec("config -t testtable -s table.file.compress.type=", true);
            expectedStrings.clear();
            expectedStrings.add("default    | table.file.compress.type .................. | gz\n");
            expectedStrings.add("table      |    @override .............................. | \n");
            this.execExpectList("config -t testtable -f table.file.compress.type", true, expectedStrings);
        }
        finally {
            this.exec("deletetable testtable -f", true);
        }
    }

    @Test
    void configTest() throws IOException {
        Shell.log.debug("Starting config property type test -------------------------");
        String testTable = "test";
        this.exec("createtable " + testTable, true);
        block17: for (Property property : Property.values()) {
            String invalidValue;
            PropertyType propertyType = property.getType();
            String validValue = property.getDefaultValue();
            if (!Property.isValidZooPropertyKey((String)property.getKey())) {
                Shell.log.debug("Property {} with type {} cannot be modified by shell", (Object)property.getKey(), (Object)propertyType);
                continue;
            }
            switch (propertyType) {
                case PATH: 
                case PREFIX: 
                case STRING: 
                case JSON: {
                    Shell.log.debug("Skipping " + propertyType + " Property Types");
                    continue block17;
                }
                case TIMEDURATION: {
                    invalidValue = "1h30min";
                    break;
                }
                case BYTES: {
                    invalidValue = "1M500k";
                    break;
                }
                case MEMORY: {
                    invalidValue = "1.5G";
                    break;
                }
                case HOSTLIST: {
                    invalidValue = ":1000";
                    break;
                }
                case PORT: {
                    invalidValue = "65539";
                    break;
                }
                case COUNT: {
                    invalidValue = "-1";
                    break;
                }
                case FRACTION: {
                    invalidValue = "10Percent";
                    break;
                }
                case ABSOLUTEPATH: {
                    invalidValue = "~/foo";
                    break;
                }
                case CLASSNAME: {
                    Shell.log.debug("CLASSNAME properties currently fail this test");
                    Shell.log.debug("Regex used for CLASSNAME property types may need to be modified");
                    continue block17;
                }
                case CLASSNAMELIST: {
                    invalidValue = "String,Object";
                    break;
                }
                case DURABILITY: {
                    invalidValue = "rinse";
                    break;
                }
                case GC_POST_ACTION: {
                    invalidValue = "expand";
                    break;
                }
                case BOOLEAN: {
                    invalidValue = "fooFalse";
                    break;
                }
                case URI: {
                    invalidValue = "12///\\{}:;123!";
                    break;
                }
                default: {
                    Shell.log.debug("Property Type: " + propertyType + " has no defined test case");
                    invalidValue = "foo";
                }
            }
            Object setCommand = property.isDeprecated() ? "config --force -s " : "config -s ";
            if (Property.isValidTablePropertyKey((String)property.getKey())) {
                setCommand = property.isDeprecated() ? "config --force -t " + testTable + " -s " : "config -t " + testTable + " -s ";
            }
            Shell.log.debug("Testing Property {} with Type {}", (Object)property.getKey(), (Object)propertyType);
            Shell.log.debug("Invalid property value of \"{}\"", (Object)invalidValue);
            this.exec((String)setCommand + property.getKey() + "=" + invalidValue, false, "ThriftPropertyException(property:" + property.getKey() + ", value:" + invalidValue + ", description:");
            this.exec((String)setCommand + property.getKey() + "=" + validValue, true);
        }
        this.exec("deletetable " + testTable + " -f", true);
    }

    @Test
    public void commentTest() throws IOException {
        Shell.log.debug("Starting comment test --------------------------");
        this.exec("#", true, "Unknown command", false);
        this.exec("# foo", true, "Unknown command", false);
        this.exec("- foo", true, "Unknown command", true);
    }

    @Test
    public void execFileTest() throws IOException {
        Shell.log.debug("Starting exec file test --------------------------");
        this.shell.config(new String[]{"--config-file", this.config.toString(), "-u", "root", "-p", ShellIT.getRootPassword(), "-zi", ShellIT.getCluster().getInstanceName(), "-zh", ShellIT.getCluster().getZooKeepers(), "-f", "src/main/resources/org/apache/accumulo/test/shellit.shellit"});
        Assertions.assertEquals((int)0, (int)this.shell.start());
        this.assertGoodExit("Unknown command", false);
    }

    @Test
    public void setIterTest() throws IOException {
        Shell.log.debug("Starting setiter test --------------------------");
        this.exec("createtable t", true);
        String cmdJustClass = "setiter -class VersioningIterator -p 1";
        this.exec(cmdJustClass, false, "java.lang.IllegalArgumentException", false);
        this.exec(cmdJustClass, false, "fully qualified package name", true);
        String cmdFullPackage = "setiter -class o.a.a.foo -p 1";
        this.exec(cmdFullPackage, false, "java.lang.IllegalArgumentException", false);
        this.exec(cmdFullPackage, false, "class not found", true);
        String cmdNoOption = "setiter -class java.lang.String -p 1";
        this.exec(cmdNoOption, false, "loaded successfully but does not implement SortedKeyValueIterator", true);
        this.input.set("\n\n");
        this.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30 -name foo", true);
        this.input.set("bar\nname value\n");
        this.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 31", true);
        this.exec("deletetable t -f", true, "Table: [t] has been deleted");
    }

    @Test
    public void testGetSplitsScanRange() throws Exception {
        Map idMap;
        Shell.log.debug("Starting testGetSplitsScanRange test ------------------");
        int idCycleLen = 36;
        int postModifier = 0;
        int maxLoopcnt = 10;
        int loopCnt = 0;
        String[] tables = new String[2];
        while (loopCnt++ < maxLoopcnt && !this.findIds(tables, idMap = this.shell.getAccumuloClient().tableOperations().tableIdMap())) {
            this.createTables(idCycleLen, postModifier++);
        }
        if (loopCnt >= maxLoopcnt) {
            Shell.log.warn("Warning: Unable to find needed tables...exiting test without verifying.");
            return;
        }
        this.exec("addsplits -t " + tables[0] + " a c e", true);
        this.exec("addsplits -t " + tables[1] + " g i t", true);
        this.exec("getsplits -v -t " + tables[0], true, "(e, +inf) Default Tablet", true);
        this.exec("getsplits -v -t " + tables[0], true, "(t, +inf) Default Tablet", false);
    }

    private boolean findIds(String[] tables, Map<String, String> idMap) {
        String ids = "0123456789abcdefghijklmnopqrstuvwxyz";
        for (int i = 0; i < ids.length(); ++i) {
            String id = ids.substring(i, i + 1);
            if (!idMap.containsValue(id) || !idMap.containsValue(id + "0")) continue;
            tables[0] = this.getTableNameFromId(idMap, id);
            tables[1] = this.getTableNameFromId(idMap, id + "0");
            Shell.log.debug("Found tables: " + tables[0] + ":" + id + ", " + tables[1] + ":" + id + "0");
            return true;
        }
        return false;
    }

    private String getTableNameFromId(Map<String, String> map, String value) {
        return map.entrySet().stream().filter(entry -> value.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElseThrow();
    }

    private void createTables(int limit, int modifier) throws IOException {
        String tableModifier = "x" + modifier;
        for (int i = 0; i < limit; ++i) {
            this.exec("createtable tabx" + i + tableModifier);
        }
    }

    @Test
    public void testMaxSplitsOption() throws Exception {
        Shell.log.debug("Starting testMaxSplits test ------------------");
        this.exec("createtable maxtab", true);
        this.exec("addsplits 0 1 2 3 4 5 6 7 8 9 a b c d e f g h i j k l m n o p q r s t", true);
        this.exec("getsplits -m 31", true, "0\n1\n2\n3\n4\n5\n6\n7\n8\n9\na\nb\nc\nd\ne\nf\ng\nh\ni\nj\nk\nl\nm\nn\no\np\nq\nr\ns\nt\n");
        this.exec("getsplits -m 30", true, "0\n1\n2\n3\n4\n5\n6\n7\n8\n9\na\nb\nc\nd\ne\nf\ng\nh\ni\nj\nk\nl\nm\nn\no\np\nq\nr\ns\nt\n");
        this.exec("getsplits -m 29", true, "1\n2\n3\n4\n5\n6\n7\n8\n9\na\nb\nc\nd\ne\nf\ng\nh\ni\nj\nk\nl\nm\nn\no\np\nq\nr\ns\nt\n");
        this.exec("getsplits -m 15", true, "1\n3\n5\n7\n9\nb\nd\nf\ng\ni\nk\nm\no\nq\ns\n");
        this.exec("getsplits -m 10", true, "2\n5\n8\na\nd\ng\nj\nl\no\nr\n");
        this.exec("getsplits -m 5", true, "5\na\nf\nk\np\n");
        this.exec("getsplits -m 3", true, "7\nf\nm\n");
        this.exec("getsplits -m 1", true, "f\n");
        this.exec("getsplits -m 0", true, "0\n1\n2\n3\n4\n5\n6\n7\n8\n9\na\nb\nc\nd\ne\nf\ng\nh\ni\nj\nk\nl\nm\nn\no\np\nq\nr\ns\nt\n");
    }

    public static class TestOutputStream
    extends OutputStream {
        StringBuilder sb = new StringBuilder();

        @Override
        public void write(int b) {
            this.sb.append((char)(0xFF & b));
        }

        public String get() {
            return this.sb.toString();
        }

        public void clear() {
            this.sb.setLength(0);
        }
    }

    public static class StringInputStream
    extends InputStream {
        private String source = "";
        private int offset = 0;

        @Override
        public int read() {
            if (this.offset == this.source.length()) {
                return 10;
            }
            return this.source.charAt(this.offset++);
        }

        public void set(String other) {
            this.source = other;
            this.offset = 0;
        }
    }
}

