/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.shell;

import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.sample.RowColumnSampler;
import org.apache.accumulo.core.client.sample.RowSampler;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.client.summary.summarizers.DeletesSummarizer;
import org.apache.accumulo.core.client.summary.summarizers.FamilySummarizer;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.compaction.TestCompactionStrategy;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.accumulo.test.shell.ErrorMessageCallback;
import org.apache.accumulo.test.shell.MockShell;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.tools.DistCp;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={@Tag(value="MiniClusterOnly"), @Tag(value="SunnyDay")})
public class ShellServerIT
extends SharedMiniClusterBase {
    private static final Property VFS_CONTEXT_CLASSPATH_PROPERTY = Property.VFS_CONTEXT_CLASSPATH_PROPERTY;
    private static final Logger log = LoggerFactory.getLogger(ShellServerIT.class);
    private MockShell ts;
    private static String rootPath;
    private final SecureRandom random = new SecureRandom();
    private static final String FAKE_CONTEXT = "FAKE";
    private static final String FAKE_CONTEXT_CLASSPATH;
    private static final String REAL_CONTEXT = "REAL";
    private static final String REAL_CONTEXT_CLASSPATH;
    private static final String VALUE_REVERSING_ITERATOR = "org.apache.accumulo.test.functional.ValueReversingIterator";
    private static final String SUMMING_COMBINER_ITERATOR = "org.apache.accumulo.core.iterators.user.SummingCombiner";
    private static final String COLUMN_FAMILY_COUNTER_ITERATOR = "org.apache.accumulo.core.iterators.ColumnFamilyCounter";

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @BeforeAll
    public static void setupMiniCluster() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new ShellServerITConfigCallback());
        rootPath = ShellServerIT.getMiniClusterDir().getAbsolutePath();
        String userDir = System.getProperty("user.dir");
        System.setProperty("HOME", rootPath);
        System.setProperty("hadoop.tmp.dir", userDir + "/target/hadoop-tmp");
    }

    @BeforeEach
    public void setupShell() throws Exception {
        this.ts = new MockShell(ShellServerIT.getPrincipal(), ShellServerIT.getRootPassword(), ShellServerIT.getCluster().getConfig().getInstanceName(), ShellServerIT.getCluster().getConfig().getZooKeepers(), ShellServerIT.getCluster().getConfig().getClientPropsFile());
    }

    @AfterAll
    public static void tearDownAfterAll() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @AfterEach
    public void tearDownShell() {
        this.ts.shell.shutdown();
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public void exporttableImporttable() throws Exception {
        try (AccumuloClient client = ShellServerIT.getCluster().createAccumuloClient(ShellServerIT.getPrincipal(), (AuthenticationToken)new PasswordToken((CharSequence)ShellServerIT.getRootPassword()));){
            client.securityOperations().grantNamespacePermission(ShellServerIT.getPrincipal(), "", NamespacePermission.ALTER_NAMESPACE);
            String tableBase = this.getUniqueNames(1)[0];
            String table = tableBase + "_export_src";
            String table2 = tableBase + "_import_tgt";
            this.ts.exec("createtable " + table + " -evc", true);
            this.make10();
            this.ts.exec("addsplits row5", true);
            this.ts.exec("config -t " + table + " -s table.split.threshold=345M", true);
            this.ts.exec("offline " + table, true);
            File exportDir = new File(rootPath, "ShellServerIT.export");
            String exportUri = "file://" + exportDir;
            String localTmp = "file://" + new File(rootPath, "ShellServerIT.tmp");
            this.ts.exec("exporttable -t " + table + " " + exportUri, true);
            DistCp cp = new DistCp(new Configuration(false), null);
            String import_ = "file://" + new File(rootPath, "ShellServerIT.import");
            ClientInfo info = ClientInfo.from((Properties)ShellServerIT.getCluster().getClientProperties());
            if (info.saslEnabled()) {
                FileSystem fs = ShellServerIT.getCluster().getFileSystem();
                LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration(false));
                Path localTmpPath = new Path(localTmp);
                localFs.mkdirs(localTmpPath);
                Path importDir = new Path(import_);
                fs.mkdirs(importDir);
                try (BufferedReader reader = new BufferedReader(new FileReader(new File(exportDir, "distcp.txt"), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Path exportedFile = new Path(line);
                        log.info("Copying {} to {}", (Object)line, (Object)localTmpPath);
                        fs.copyToLocalFile(exportedFile, localTmpPath);
                        Path tmpFile = new Path(localTmpPath, exportedFile.getName());
                        log.info("Moving {} to the import directory {}", (Object)tmpFile, (Object)importDir);
                        fs.moveFromLocalFile(tmpFile, importDir);
                    }
                }
            } else {
                Object[] distCpArgs = new String[]{"-f", exportUri + "/distcp.txt", import_};
                Assertions.assertEquals((int)0, (int)cp.run((String[])distCpArgs), (String)("Failed to run distcp: " + Arrays.toString(distCpArgs)));
            }
            Thread.sleep(20L);
            this.ts.exec("importtable " + table2 + " " + import_, true);
            this.ts.exec("config -t " + table2 + " -np", true, "345M", true);
            this.ts.exec("getsplits -t " + table2, true, "row5", true);
            this.ts.exec("constraint --list -t " + table2, true, "VisibilityConstraint=2", true);
            this.ts.exec("online " + table, true);
            this.ts.exec("deletetable -f " + table, true);
            this.ts.exec("deletetable -f " + table2, true);
        }
    }

    @Test
    public void propStressTest() throws Exception {
        try (AccumuloClient client = ShellServerIT.getCluster().createAccumuloClient(ShellServerIT.getPrincipal(), (AuthenticationToken)new PasswordToken((CharSequence)ShellServerIT.getRootPassword()));){
            client.securityOperations().grantNamespacePermission(ShellServerIT.getPrincipal(), "", NamespacePermission.ALTER_NAMESPACE);
            String table = this.getUniqueNames(1)[0];
            this.ts.exec("createtable " + table + " -evc", true);
            this.make10();
            this.ts.exec("addsplits row5", true);
            this.ts.exec("config -t " + table + " -s table.split.threshold=345M", true);
            for (int i = 0; i < 50; ++i) {
                String expected = 100 + i + "M";
                this.ts.exec("config -t " + table + " -s table.split.threshold=" + expected, true);
                this.ts.exec("config -t " + table + " -np -f table.split.threshold", true, expected, true);
                this.ts.exec("config -t " + table + " -s table.scan.max.memory=" + expected, true);
                this.ts.exec("config -t " + table + " -np -f table.scan.max.memory", true, expected, true);
                String bExpected = i % 2 == 0 ? "true" : "false";
                this.ts.exec("config -t " + table + " -s table.bloom.enabled=" + bExpected, true);
                this.ts.exec("config -t " + table + " -np -f table.bloom.enabled", true, bExpected, true);
            }
        }
    }

    @Test
    public void setscaniterDeletescaniter() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.input.set("true\n\n\n\nSTRING");
        this.ts.exec("setscaniter -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -n name", true);
        this.ts.exec("scan", true, "3", true);
        this.ts.exec("deletescaniter -n name", true);
        this.ts.exec("scan", true, "1", true);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public void execfile() throws Exception {
        File file = File.createTempFile("ShellServerIT.execfile", ".conf", new File(rootPath));
        PrintWriter writer = new PrintWriter(file.getAbsolutePath());
        writer.println("about");
        writer.close();
        this.ts.exec("execfile " + file.getAbsolutePath(), true, "2.1.3", true);
    }

    @Test
    public void egrep() {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        this.make10();
        String lines = this.ts.exec("egrep row[123]", true);
        Assertions.assertEquals((int)3, (int)(lines.split("\n").length - 1));
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void du() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("notable", true);
        this.ts.output.clear();
        this.ts.exec("du", true, "", true);
        this.ts.output.clear();
        this.ts.exec("createtable " + table);
        this.make10();
        this.ts.exec("flush -t " + table + " -w");
        this.ts.exec("du " + table, true, " [" + table + "]", true);
        this.ts.output.clear();
        this.ts.shell.execCommand("du -h", false, false);
        String o = this.ts.output.get();
        ShellServerIT.assertMatches(o, ".*[1-9][0-9][0-9]\\s\\[" + table + "]\\n");
        this.ts.exec("deletetable -f " + table);
    }

    @Deprecated(since="2.0.0")
    @Test
    public void debug() throws Exception {
        String expectMsg = "The debug command is deprecated";
        this.ts.exec("debug", false, expectMsg);
        this.ts.exec("debug on", false, expectMsg);
        this.ts.exec("debug", false, expectMsg);
        this.ts.exec("debug off", false, expectMsg);
        this.ts.exec("debug", false, expectMsg);
        this.ts.exec("debug debug", false, expectMsg);
        this.ts.exec("debug debug debug", false, expectMsg);
    }

    @Test
    public void user() throws Exception {
        String table = this.getUniqueNames(1)[0];
        boolean kerberosEnabled = ShellServerIT.getToken() instanceof KerberosToken;
        if (!kerberosEnabled) {
            this.ts.input.set("secret\nsecret\n");
        }
        this.ts.exec("createuser xyzzy", true);
        this.ts.exec("users", true, "xyzzy", true);
        String perms = this.ts.exec("userpermissions -u xyzzy", true);
        Assertions.assertTrue((boolean)perms.contains("Table permissions (" + MetadataTable.NAME + "): Table.READ"));
        this.ts.exec("grant -u xyzzy -s System.CREATE_TABLE", true);
        perms = this.ts.exec("userpermissions -u xyzzy", true);
        Assertions.assertTrue((boolean)perms.contains(""));
        this.ts.exec("grant -u " + ShellServerIT.getPrincipal() + " -t " + MetadataTable.NAME + " Table.WRITE", true);
        this.ts.exec("grant -u " + ShellServerIT.getPrincipal() + " -t " + MetadataTable.NAME + " Table.GOOFY", false);
        this.ts.exec("grant -u " + ShellServerIT.getPrincipal() + " -s foo", false);
        this.ts.exec("grant -u xyzzy -t " + MetadataTable.NAME + " foo", false);
        if (!kerberosEnabled) {
            this.ts.input.set("secret\nsecret\n");
            this.ts.exec("user xyzzy", true);
            this.ts.exec("createtable " + table, true, "xyzzy@", true);
            this.ts.exec("insert row1 cf cq 1", true);
            this.ts.exec("scan", true, "row1", true);
            this.ts.exec("droptable -f " + table, true);
            this.ts.input.set(ShellServerIT.getRootPassword() + "\n" + ShellServerIT.getRootPassword() + "\n");
            this.ts.exec("user root", true);
        }
        this.ts.exec("deleteuser " + ShellServerIT.getPrincipal(), false, "delete yourself", true);
        this.ts.exec("revoke -u xyzzy -s System.CREATE_TABLE", true);
        this.ts.exec("revoke -u xyzzy -s System.GOOFY", false);
        this.ts.exec("revoke -u xyzzy -s foo", false);
        this.ts.exec("revoke -u xyzzy -t " + MetadataTable.NAME + " Table.WRITE", true);
        this.ts.exec("revoke -u xyzzy -t " + MetadataTable.NAME + " Table.GOOFY", false);
        this.ts.exec("revoke -u xyzzy -t " + MetadataTable.NAME + " foo", false);
        this.ts.exec("deleteuser xyzzy", true, "deleteuser { xyzzy } (yes|no)?", true);
        this.ts.exec("deleteuser -f xyzzy", true);
        this.ts.exec("users", true, "xyzzy", false);
    }

    @Test
    public void durability() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        this.ts.exec("insert -d none a cf cq randomGunkaASDFWEAQRd");
        this.ts.exec("insert -d foo a cf cq2 2", false, "foo", true);
        this.ts.exec("scan -r a", true, "randomGunkaASDFWEAQRd", true);
        this.ts.exec("scan -r a", true, "foo", false);
    }

    @Test
    public void iter() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.input.set("true\n\n\n\nSTRING\n");
        this.ts.exec("setshelliter -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -pn sum -n name", true);
        this.ts.exec("setshelliter -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 11 -pn sum -n name", false);
        this.ts.exec("setshelliter -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -pn sum -n other", false);
        this.ts.input.set("true\n\n\n\nSTRING\n");
        this.ts.exec("setshelliter -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 11 -pn sum -n xyzzy", true);
        this.ts.exec("scan -pn sum", true, "3", true);
        this.ts.exec("listshelliter", true, "Iterator name", true);
        this.ts.exec("listshelliter", true, "Iterator xyzzy", true);
        this.ts.exec("listshelliter", true, "Profile : sum", true);
        this.ts.exec("deleteshelliter -pn sum -n name", true);
        this.ts.exec("listshelliter", true, "Iterator name", false);
        this.ts.exec("listshelliter", true, "Iterator xyzzy", true);
        this.ts.exec("deleteshelliter -pn sum -a", true);
        this.ts.exec("listshelliter", true, "Iterator xyzzy", false);
        this.ts.exec("listshelliter", true, "Profile : sum", false);
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("createtable " + table);
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.input.set("true\n\n\n\nSTRING\n");
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -n name", true);
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 11 -n name", false);
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -n other", false);
        this.ts.input.set("true\n\n\n\nSTRING\n");
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 11 -n xyzzy", true);
        this.ts.exec("scan", true, "3", true);
        this.ts.exec("listiter -scan", true, "Iterator name", true);
        this.ts.exec("listiter -scan", true, "Iterator xyzzy", true);
        this.ts.exec("listiter -minc", true, "Iterator name", false);
        this.ts.exec("listiter -minc", true, "Iterator xyzzy", false);
        this.ts.exec("deleteiter -scan -n name", true);
        this.ts.exec("listiter -scan", true, "Iterator name", false);
        this.ts.exec("listiter -scan", true, "Iterator xyzzy", true);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void setIterOptionPrompt() {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellServerIT.getClientProps()).build();){
            String[] tableNames = this.getUniqueNames(4);
            String tableName0 = tableNames[0];
            this.ts.exec("createtable " + tableName0);
            this.ts.input.set("\n\n");
            this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30", false);
            this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30 -name cfcounter", true);
            String expectedKey = "table.iterator.scan.cfcounter";
            String expectedValue = "30,org.apache.accumulo.core.iterators.ColumnFamilyCounter";
            this.checkTableForProperty(client, tableName0, expectedKey, expectedValue);
            this.ts.exec("deletetable " + tableName0, true);
            String tableName1 = tableNames[1];
            this.ts.exec("createtable " + tableName1, true);
            this.ts.input.set("customcfcounter\n\n");
            this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30", true);
            expectedKey = "table.iterator.scan.customcfcounter";
            expectedValue = "30,org.apache.accumulo.core.iterators.ColumnFamilyCounter";
            this.checkTableForProperty(client, tableName1, expectedKey, expectedValue);
            this.ts.exec("deletetable " + tableName1, true);
            String tableName2 = tableNames[2];
            this.ts.exec("createtable " + tableName2, true);
            this.ts.input.set("customcfcounter\nname1 value1\nname2 value2\n\n");
            this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30", true);
            expectedKey = "table.iterator.scan.customcfcounter";
            expectedValue = "30,org.apache.accumulo.core.iterators.ColumnFamilyCounter";
            this.checkTableForProperty(client, tableName2, expectedKey, expectedValue);
            expectedKey = "table.iterator.scan.customcfcounter.opt.name1";
            expectedValue = "value1";
            this.checkTableForProperty(client, tableName2, expectedKey, expectedValue);
            expectedKey = "table.iterator.scan.customcfcounter.opt.name2";
            expectedValue = "value2";
            this.checkTableForProperty(client, tableName2, expectedKey, expectedValue);
            this.ts.exec("deletetable " + tableName2, true);
            String tableName3 = tableNames[3];
            this.ts.exec("createtable " + tableName3, true);
            this.ts.input.set("\nname1 value1.1,value1.2,value1.3\nname2 value2\n\n");
            this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30 -name cfcounter", true);
            expectedKey = "table.iterator.scan.cfcounter";
            expectedValue = "30,org.apache.accumulo.core.iterators.ColumnFamilyCounter";
            this.checkTableForProperty(client, tableName3, expectedKey, expectedValue);
            expectedKey = "table.iterator.scan.cfcounter.opt.name1";
            expectedValue = "value1.1,value1.2,value1.3";
            this.checkTableForProperty(client, tableName3, expectedKey, expectedValue);
            expectedKey = "table.iterator.scan.cfcounter.opt.name2";
            expectedValue = "value2";
            this.checkTableForProperty(client, tableName3, expectedKey, expectedValue);
            this.ts.exec("deletetable " + tableName3, true);
        }
    }

    protected void checkTableForProperty(AccumuloClient client, String tableName, String expectedKey, String expectedValue) {
        Wait.waitFor(() -> ((String)client.tableOperations().getConfiguration(tableName).get(expectedKey)).equals(expectedValue), 5000L, 500L, "Failed to find expected value for key: " + expectedKey);
    }

    @Test
    public void notable() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table, true);
        this.ts.exec("scan", true, " " + table + ">", true);
        Assertions.assertTrue((boolean)this.ts.output.get().contains(" " + table + ">"));
        this.ts.exec("notable", true);
        this.ts.exec("scan", false, "Not in a table context.", true);
        Assertions.assertFalse((boolean)this.ts.output.get().contains(" " + table + ">"));
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void sleep() throws Exception {
        long now = System.currentTimeMillis();
        this.ts.exec("sleep 0.2", true);
        long diff = System.currentTimeMillis() - now;
        Assertions.assertTrue((diff >= 200L ? 1 : 0) != 0, (String)("Diff was actually " + diff));
        Assertions.assertTrue((diff < 600L ? 1 : 0) != 0, (String)("Diff was actually " + diff));
    }

    @Test
    public void addauths() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table + " -evc");
        boolean success = false;
        while (!success) {
            try {
                this.ts.exec("insert a b c d -l foo", false, "does not have authorization", true, new ErrorMessageCallback(ShellServerIT.getClientProps()));
                success = true;
            }
            catch (AssertionError e) {
                Thread.sleep(500L);
            }
        }
        this.ts.exec("addauths -s foo,bar", true);
        boolean passed = false;
        while (!passed) {
            try {
                this.ts.exec("getauths", true, "foo", true);
                this.ts.exec("getauths", true, "bar", true);
                passed = true;
            }
            catch (AssertionError | Exception e) {
                UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        Assertions.assertTrue((boolean)passed, (String)"Could not successfully see updated authoriations");
        this.ts.exec("insert a b c d -l foo");
        this.ts.exec("scan", true, "[foo]");
        this.ts.exec("scan -s bar", true, "[foo]", false);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void getAuths() throws Exception {
        Assumptions.assumeFalse((boolean)(ShellServerIT.getToken() instanceof KerberosToken), (String)"test skipped for kerberos");
        for (int i = 1; i <= 2; ++i) {
            String userName = this.testName() + "user" + i;
            String password = "password" + i;
            String auths = "auth" + i + "A,auth" + i + "B";
            this.ts.exec("createuser " + userName, true);
            this.ts.exec(password, true);
            this.ts.exec("addauths -u " + userName + " -s " + auths, true);
        }
        this.ts.exec("getauths -u getAuthsuser1", true, "auth1A", true);
        this.ts.exec("getauths -u getAuthsuser1", true, "auth1B", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2A", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2B", true);
        this.ts.exec("grant -u getAuthsuser1 -s System.ALTER_USER", true);
        this.ts.exec("user getAuthsuser1", true);
        this.ts.exec("password1", true);
        this.ts.exec("getauths -u getAuthsuser1", true, "auth1A", true);
        this.ts.exec("getauths -u getAuthsuser1", true, "auth1B", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2A", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2B", true);
        this.ts.exec("user getAuthsuser2", true);
        this.ts.exec("password2", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2A", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2B", true);
        this.ts.exec("getauths -u getAuthsuser1", false, "PERMISSION_DENIED", true);
        this.ts.exec("getauths -u getAuthsuser1", false, "PERMISSION_DENIED", true);
    }

    @Test
    public void byeQuitExit() {
        for (String cmd : "bye quit exit".split(" ")) {
            Assertions.assertFalse((boolean)this.ts.shell.getExit());
            this.ts.exec(cmd);
            Assertions.assertTrue((boolean)this.ts.shell.getExit());
            this.ts.shell.setExit(false);
        }
    }

    @Test
    public void classpath() throws Exception {
        this.ts.exec("classpath", true, "Level: 2, Name: app, class: jdk.internal.loader.ClassLoaders$AppClassLoader: configuration not inspectable", true);
    }

    @Test
    public void clearCls() throws Exception {
        if (!"dumb".equalsIgnoreCase(this.ts.shell.getTerminal().getType())) {
            this.ts.exec("cls", true, "[1;1H");
            this.ts.exec("clear", true, "[2J");
        } else {
            this.ts.exec("cls", false, "does not support");
            this.ts.exec("clear", false, "does not support");
        }
    }

    @Test
    public void clonetable() throws Exception {
        try (AccumuloClient client = ShellServerIT.getCluster().createAccumuloClient(ShellServerIT.getPrincipal(), (AuthenticationToken)new PasswordToken((CharSequence)ShellServerIT.getRootPassword()));){
            client.securityOperations().grantNamespacePermission(ShellServerIT.getPrincipal(), "", NamespacePermission.ALTER_NAMESPACE);
        }
        String table = this.getUniqueNames(1)[0];
        String clone = table + "_clone";
        this.ts.exec("createtable " + table + " -evc");
        this.ts.exec("config -t " + table + " -s table.split.threshold=123M", true);
        this.ts.exec("addsplits -t " + table + " a b c", true);
        this.ts.exec("insert a b c value");
        this.ts.exec("scan", true, "value", true);
        this.ts.exec("clonetable " + table + " " + clone);
        this.ts.exec("table " + clone);
        this.ts.exec("scan", true, "value", true);
        this.ts.exec("constraint --list -t " + clone, true, "VisibilityConstraint=2", true);
        this.ts.exec("config -t " + clone + " -np", true, "123M", true);
        this.ts.exec("getsplits -t " + clone, true, "a\nb\nc\n");
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("deletetable -f " + clone);
    }

    @Test
    public void clonetableOffline() throws Exception {
        try (AccumuloClient client = ShellServerIT.getCluster().createAccumuloClient(ShellServerIT.getPrincipal(), (AuthenticationToken)new PasswordToken((CharSequence)ShellServerIT.getRootPassword()));){
            client.securityOperations().grantNamespacePermission(ShellServerIT.getPrincipal(), "", NamespacePermission.ALTER_NAMESPACE);
        }
        String table = this.getUniqueNames(1)[0];
        String clone = table + "_clone";
        this.ts.exec("createtable " + table + " -evc");
        this.ts.exec("config -t " + table + " -s table.split.threshold=123M", true);
        this.ts.exec("addsplits -t " + table + " a b c", true);
        this.ts.exec("insert a b c value");
        this.ts.exec("scan", true, "value", true);
        this.ts.exec("clonetable " + table + " " + clone + " -o");
        this.ts.exec("table " + clone);
        this.ts.exec("scan", false, "TableOfflineException", true);
        this.ts.exec("constraint --list -t " + clone, true, "VisibilityConstraint=2", true);
        this.ts.exec("config -t " + clone + " -np", true, "123M", true);
        this.ts.exec("getsplits -t " + clone, true, "a\nb\nc\n");
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("deletetable -f " + clone);
    }

    @Test
    public void createTableWithProperties() throws Exception {
        String table = this.getUniqueNames(1)[0];
        String testProp = "table.custom.description=description,table.custom.testProp=testProp," + Property.TABLE_SPLIT_THRESHOLD.getKey() + "=10K";
        this.ts.exec("createtable " + table + " -prop " + testProp, true);
        this.ts.exec("insert a b c value", true);
        this.ts.exec("scan", true, "value", true);
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ShellServerIT.getClientProps()).build();){
            accumuloClient.tableOperations().getConfiguration(table).forEach((key, value) -> {
                if (key.equals("table.custom.description")) {
                    Assertions.assertEquals((Object)"description", (Object)value, (String)"Initial property was not set correctly");
                }
                if (key.equals("table.custom.testProp")) {
                    Assertions.assertEquals((Object)"testProp", (Object)value, (String)"Initial property was not set correctly");
                }
                if (key.equals(Property.TABLE_SPLIT_THRESHOLD.getKey())) {
                    Assertions.assertEquals((Object)"10K", (Object)value, (String)"Initial property was not set correctly");
                }
            });
        }
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void testCompactions() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        String tableId = this.getTableId(table);
        this.ts.exec("insert a b c d");
        this.ts.exec("flush -w");
        this.ts.exec("insert x y z v");
        this.ts.exec("flush -w");
        int oldCount = this.countFiles(tableId);
        this.ts.exec("compact -t " + table + " -w");
        Assertions.assertTrue((this.countFiles(tableId) < oldCount ? 1 : 0) != 0);
        this.ts.exec("addsplits -t " + table + " f");
        this.ts.exec("insert m 1 2 3");
        this.ts.exec("flush -w");
        this.ts.exec("insert n 1 2 v901");
        this.ts.exec("flush -w");
        List<String> oldFiles = this.getFiles(tableId);
        Assertions.assertEquals((int)4, (int)oldFiles.size(), (String)("Files that were found: " + oldFiles));
        this.ts.exec("compact -b g -e z -w");
        Assertions.assertEquals((int)2, (int)this.countFiles(tableId));
        this.ts.exec("compact -w");
        Assertions.assertEquals((int)2, (int)this.countFiles(tableId));
        this.ts.exec("merge --all -t " + table);
        this.ts.exec("compact -w");
        Assertions.assertEquals((int)1, (int)this.countFiles(tableId));
        this.ts.exec("insert z 1 2 v900");
        this.ts.exec("compact -w -s " + TestCompactionStrategy.class.getName() + " -sc inputPrefix=F,dropPrefix=A");
        Assertions.assertEquals((int)1, (int)this.countFiles(tableId));
        this.ts.exec("scan", true, "v900", true);
        this.ts.exec("scan", true, "v901", false);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void testCompactionSelection() throws Exception {
        String table = this.getUniqueNames(1)[0];
        String clone = table + "_clone";
        this.ts.exec("createtable " + table);
        this.ts.exec("insert a b c d");
        this.ts.exec("flush -w");
        this.ts.exec("insert x y z v");
        this.ts.exec("flush -w");
        this.ts.exec("clonetable -s " + Property.TABLE_MAJC_RATIO.getKey() + "=10 " + table + " " + clone);
        this.ts.exec("table " + clone);
        this.ts.exec("insert m n l o");
        this.ts.exec("flush -w");
        String tableId = this.getTableId(table);
        String cloneId = this.getTableId(clone);
        Assertions.assertEquals((int)3, (int)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-epath .*tables/" + tableId + ".*");
        Assertions.assertEquals((int)2, (int)this.countFiles(cloneId));
        this.ts.exec("insert r s t u");
        this.ts.exec("flush -w");
        Assertions.assertEquals((int)3, (int)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-ename F.*");
        Assertions.assertEquals((int)2, (int)this.countFiles(cloneId));
        StringBuilder sb = new StringBuilder("insert b v q ");
        this.random.ints(10000L, 0, 26).forEach(i -> sb.append(97 + i));
        this.ts.exec(sb.toString());
        this.ts.exec("flush -w");
        this.ts.exec(sb.toString());
        this.ts.exec("flush -w");
        Assertions.assertEquals((int)4, (int)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-lt-esize 1000");
        Assertions.assertEquals((int)3, (int)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-gt-esize 1K --min-files 3");
        Assertions.assertEquals((int)3, (int)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-gt-esize 1K --min-files 2");
        Assertions.assertEquals((int)2, (int)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --min-files 3");
        Assertions.assertEquals((int)2, (int)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --min-files 2");
        Assertions.assertEquals((int)1, (int)this.countFiles(cloneId));
        this.ts.exec(sb.toString());
        this.ts.exec("flush -w");
        this.ts.exec("insert m n l o");
        this.ts.exec("flush -w");
        this.ts.exec("insert m n l o");
        this.ts.exec("flush -w");
        Assertions.assertEquals((int)4, (int)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-ename F.* --sf-lt-esize 1K");
        Assertions.assertEquals((int)3, (int)this.countFiles(cloneId));
        String clone2 = table + "_clone_2";
        this.ts.exec("clonetable -s table.sampler.opt.hasher=murmur3_32,table.sampler.opt.modulus=7,table.sampler=" + RowSampler.class.getName() + " " + clone + " " + clone2);
        String clone2Id = this.getTableId(clone2);
        Assertions.assertEquals((int)3, (int)this.countFiles(clone2Id));
        this.ts.exec("table " + clone2);
        this.ts.exec("insert v n l o");
        this.ts.exec("flush -w");
        this.ts.exec("insert x n l o");
        this.ts.exec("flush -w");
        Assertions.assertEquals((int)5, (int)this.countFiles(clone2Id));
        this.ts.exec("compact -t " + clone2 + " -w --sf-no-sample");
        Assertions.assertEquals((int)3, (int)this.countFiles(clone2Id));
    }

    @Test
    public void testCompactionSelectionAndStrategy() {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        this.ts.exec("compact -t " + table + " -w --sf-ename F.* -s " + TestCompactionStrategy.class.getName() + " -sc inputPrefix=F,dropPrefix=A", false);
    }

    @Test
    public void testScanSample() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        this.ts.exec("insert 9255 doc content 'abcde'");
        this.ts.exec("insert 9255 doc url file://foo.txt");
        this.ts.exec("insert 8934 doc content 'accumulo scales'");
        this.ts.exec("insert 8934 doc url file://accumulo_notes.txt");
        this.ts.exec("insert 2317 doc content 'milk, eggs, bread, parmigiano-reggiano'");
        this.ts.exec("insert 2317 doc url file://groceries/9.txt");
        this.ts.exec("insert 3900 doc content 'EC2 ate my homework'");
        this.ts.exec("insert 3900 doc uril file://final_project.txt");
        String clone1 = table + "_clone_1";
        this.ts.exec("clonetable -s table.sampler.opt.hasher=murmur3_32,table.sampler.opt.modulus=3,table.sampler=" + RowSampler.class.getName() + " " + table + " " + clone1);
        this.ts.exec("compact -t " + clone1 + " -w --sf-no-sample");
        this.ts.exec("table " + clone1);
        this.ts.exec("scan --sample", true, "parmigiano-reggiano", true);
        this.ts.exec("grep --sample reg", true, "parmigiano-reggiano", true);
        this.ts.exec("scan --sample", true, "accumulo", false);
        this.ts.exec("grep --sample acc", true, "accumulo", false);
        String clone2 = table + "_clone_2";
        this.ts.exec("clonetable -s table.sampler.opt.hasher=murmur3_32,table.sampler.opt.modulus=2,table.sampler=" + RowSampler.class.getName() + " " + clone1 + " " + clone2);
        this.ts.exec("table " + clone2);
        this.ts.exec("scan --sample", false, "SampleNotPresentException", true);
        this.ts.exec("grep --sample reg", false, "SampleNotPresentException", true);
        this.ts.exec("compact -t " + clone2 + " -w --sf-no-sample");
        for (String expected : Arrays.asList("2317", "3900", "9255")) {
            this.ts.exec("scan --sample", true, expected, true);
            this.ts.exec("grep --sample " + expected.substring(0, 2), true, expected, true);
        }
        this.ts.exec("scan --sample", true, "8934", false);
        this.ts.exec("grep --sample 89", true, "8934", false);
    }

    @Test
    public void testScanSampleOptions() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        this.ts.exec("insert 9255 doc content 'abcde'");
        this.ts.exec("insert 9255 doc url file://foo.txt");
        this.ts.exec("insert 8934 doc content 'accumulo scales'");
        this.ts.exec("insert 8934 doc url file://accumulo_notes.txt");
        this.ts.exec("insert 5454 image size 2024,800");
        this.ts.exec("insert 7000 image metadata '2023/01/02 12:34:43'");
        this.ts.exec("insert 7000 image uri file://image1.jpg");
        this.ts.exec("insert 2317 doc content 'milk, eggs, bread, parmigiano-reggiano'");
        this.ts.exec("insert 2317 doc url file://groceries/9.txt");
        this.ts.exec("insert 3900 doc content 'EC2 ate my homework'");
        this.ts.exec("insert 3900 doc url file://final_project.txt");
        String clone1 = table + "_clone_1";
        this.ts.exec("clonetable -s table.sampler.opt.hasher=murmur3_32,table.sampler.opt.modulus=3,table.sampler.opt.qualifier=true,table.sampler=" + RowColumnSampler.class.getName() + " " + table + " " + clone1);
        this.ts.exec("compact -t " + clone1 + " -w --sf-no-sample");
        this.ts.exec("table " + clone1);
        this.ts.exec("scan --sample", true);
        for (String string : Arrays.asList("groceries", "final_project", "accumulo_notes", "foo.txt")) {
            this.ts.exec("scan --sample", true, string, true);
            this.ts.exec("grep --sample " + string.substring(0, 2), true, string, true);
        }
        for (String string : Arrays.asList("bread", "homework", "scales", "abcde", "1024", "2023", "image1")) {
            this.ts.exec("scan --sample", true, string, false);
            this.ts.exec("grep --sample " + string.substring(0, 2), true, string, false);
        }
        String clone2 = table + "_clone_2";
        this.ts.exec("clonetable -s table.sampler.opt.hasher=murmur3_32,table.sampler.opt.qualifier=true,table.sampler=" + RowColumnSampler.class.getName() + " " + table + " " + clone2);
        this.ts.exec("compact -t " + clone2 + " -w --sf-no-sample");
        this.ts.exec("table " + clone2, true);
        this.ts.exec("config -t " + clone2 + " -f sampler", true);
        this.ts.exec("scan --sample", true);
        for (String notExpected : Arrays.asList("2317", "3900", "5454", "7000", "8934", "9255")) {
            this.ts.exec("scan --sample", true, notExpected, false);
            this.ts.exec("grep --sample " + notExpected.substring(0, 3), true, notExpected, false);
        }
        String string = table + "_clone_3";
        this.ts.exec("clonetable -s table.sampler.opt.hasher=murmur3_32,table.sampler.opt.modulus=5,table.sampler.opt.qualifier=true,table.sampler.opt.badprop=42,table.sampler=" + RowColumnSampler.class.getName() + " " + table + " " + string);
        this.ts.exec("compact -t " + string + " -w --sf-no-sample");
        this.ts.exec("table " + string, true);
        this.ts.exec("scan --sample", true);
        for (String expected : Arrays.asList("2317", "3900", "5454", "7000", "8934", "9255")) {
            this.ts.exec("scan --sample", true, expected, false);
            this.ts.exec("grep --sample " + expected.substring(0, 3), true, expected, false);
        }
    }

    @Test
    public void constraint() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("constraint -l -t " + MetadataTable.NAME, true, "MetadataConstraints=1", true);
        this.ts.exec("createtable " + table + " -evc");
        this.getTableId(table);
        this.ts.exec("constraint -l -t " + table, true, "VisibilityConstraint=2", true);
        this.ts.exec("constraint -t " + table + " -d 2", true, "Removed constraint 2 from table " + table);
        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.ts.exec("constraint -l -t " + table, true, "VisibilityConstraint=2", false);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void deletemany() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        this.make10();
        Assertions.assertEquals((int)10, (int)this.countkeys(table));
        this.ts.exec("deletemany -f -b row8");
        Assertions.assertEquals((int)8, (int)this.countkeys(table));
        this.ts.exec("scan -t " + table + " -np", true, "row8", false);
        this.make10();
        this.ts.exec("deletemany -f -b row4 -e row5");
        Assertions.assertEquals((int)8, (int)this.countkeys(table));
        this.make10();
        this.ts.exec("deletemany -f -c cf:col4,cf:col5");
        Assertions.assertEquals((int)8, (int)this.countkeys(table));
        this.make10();
        this.ts.exec("deletemany -f -r row3");
        Assertions.assertEquals((int)9, (int)this.countkeys(table));
        this.make10();
        this.ts.exec("deletemany -f -r row3");
        Assertions.assertEquals((int)9, (int)this.countkeys(table));
        this.make10();
        this.ts.exec("deletemany -f -b row3 -be -e row5 -ee");
        Assertions.assertEquals((int)9, (int)this.countkeys(table));
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void deleterows() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        String tableId = this.getTableId(table);
        int base = this.countFiles(tableId);
        Assertions.assertEquals((int)0, (int)base);
        log.info("Adding 2 splits");
        this.ts.exec("addsplits row5 row7");
        log.info("Writing 10 records");
        this.make10();
        log.info("Flushing table");
        this.ts.exec("flush -w -t " + table);
        log.info("Table flush completed");
        List<String> files = this.getFiles(tableId);
        if (files.size() > 3) {
            log.info("More than 3 files were found, compacting before proceeding");
            this.ts.exec("compact -w -t " + table);
            files = this.getFiles(tableId);
            Assertions.assertEquals((int)3, (int)files.size(), (String)("Expected to only find 3 files after compaction: " + files));
        }
        Assertions.assertNotNull(files);
        Assertions.assertEquals((int)3, (int)files.size(), (String)("Found the following files: " + files));
        this.ts.exec("deleterows -t " + table + " -b row5 -e row7");
        Assertions.assertEquals((int)2, (int)this.countFiles(tableId));
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void groups() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        this.ts.exec("setgroups -t " + table + " alpha=a,b,c num=3,2,1");
        this.ts.exec("getgroups -t " + table, true, "alpha=a,b,c", true);
        this.ts.exec("getgroups -t " + table, true, "num=1,2,3", true);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void formatter() {
        this.ts.exec("createtable formatter_test", true);
        this.ts.exec("table formatter_test", true);
        this.ts.exec("insert row cf cq 1234abcd", true);
        this.ts.exec("insert row cf1 cq1 9876fedc", true);
        this.ts.exec("insert row2 cf cq 13579bdf", true);
        this.ts.exec("insert row2 cf1 cq 2468ace", true);
        ArrayList<String> expectedDefault = new ArrayList<String>(4);
        expectedDefault.add("row cf:cq []\t1234abcd");
        expectedDefault.add("row cf1:cq1 []\t9876fedc");
        expectedDefault.add("row2 cf:cq []\t13579bdf");
        expectedDefault.add("row2 cf1:cq []\t2468ace");
        ArrayList<String> actualDefault = new ArrayList<String>(4);
        boolean isFirst = true;
        for (String s : this.ts.exec("scan -np", true).split("[\n\r]+")) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            actualDefault.add(s);
        }
        ArrayList<String> expectedFormatted = new ArrayList<String>(4);
        expectedFormatted.add("row cf:cq []\t0x31 0x32 0x33 0x34 0x61 0x62 0x63 0x64");
        expectedFormatted.add("row cf1:cq1 []\t0x39 0x38 0x37 0x36 0x66 0x65 0x64 0x63");
        expectedFormatted.add("row2 cf:cq []\t0x31 0x33 0x35 0x37 0x39 0x62 0x64 0x66");
        expectedFormatted.add("row2 cf1:cq []\t0x32 0x34 0x36 0x38 0x61 0x63 0x65");
        this.ts.exec("formatter -t formatter_test -f " + HexFormatter.class.getName(), true);
        ArrayList<String> actualFormatted = new ArrayList<String>(4);
        isFirst = true;
        for (String s : this.ts.exec("scan -np", true).split("[\n\r]+")) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            actualFormatted.add(s);
        }
        this.ts.exec("deletetable -f formatter_test", true);
        Assertions.assertTrue((boolean)Iterables.elementsEqual(expectedDefault, new ArrayList(actualDefault)));
        Assertions.assertTrue((boolean)Iterables.elementsEqual(expectedFormatted, new ArrayList(actualFormatted)));
    }

    @Test
    public void extensions() throws Exception {
        String extName = "ExampleShellExtension";
        this.ts.exec("help", true, extName, false);
        this.ts.exec("extensions -l", true, extName, false);
        this.ts.exec("extensions -e", true);
        this.ts.exec("extensions -l", true, extName, true);
        this.ts.exec("help", true, extName, true);
        this.ts.exec(extName + "::debug", true, "This is a test", true);
        this.ts.exec("extensions -d", true);
        this.ts.exec("extensions -l", true, extName, false);
        this.ts.exec("help", true, extName, false);
        this.ts.exec(extName + "::debug", true, "Unknown command", true);
    }

    @Test
    public void grep() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table, true);
        this.make10();
        this.ts.exec("grep row[123]", true, "row1", false);
        this.ts.exec("grep row5", true, "row5", true);
        this.ts.exec("deletetable -f " + table, true);
    }

    @Test
    public void help() throws Exception {
        this.ts.exec("help -np", true, "Help Commands", true);
        this.ts.exec("?", true, "Help Commands", true);
        for (String c : "bye exit quit about help info ? deleteiter deletescaniter listiter setiter setscaniter grant revoke systempermissions tablepermissions userpermissions execfile history authenticate cls clear notable sleep table user whoami clonetable config createtable deletetable droptable du exporttable importtable offline online renametable tables addsplits compact constraint flush getgropus getsplits merge setgroups addauths createuser deleteuser dropuser getauths passwd setauths users delete deletemany deleterows egrep formatter interpreter grep importdirectory insert maxrow scan".split(" ")) {
            this.ts.exec("help " + c, true);
        }
    }

    @Test
    public void history() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.writeToHistory("foo");
        this.ts.exec("history", true, "foo", true);
        this.ts.exec("history -c", true);
        this.ts.exec("history", true, "foo", false);
        this.ts.exec("history", true, table, false);
        this.ts.exec("history", true, "createtable", false);
        this.ts.exec("history", true, "deletetable", false);
        this.ts.writeToHistory("createtable " + table);
        this.ts.writeToHistory("deletetable -f " + table);
        this.ts.exec("history", true, "createtable " + table, true);
        this.ts.exec("history", true, "deletetable -f " + table, true);
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public void importDirectoryOld() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        File errorsDir = new File(rootPath, "errors_" + table);
        Assertions.assertTrue((boolean)errorsDir.mkdir());
        fs.mkdirs(new Path(errorsDir.toString()));
        String nonce = this.generateNonce();
        File importDir = this.createRFiles(conf, fs, table, nonce);
        this.ts.exec("createtable " + table, true);
        this.ts.exec("importdirectory " + importDir + " " + errorsDir + " true", true);
        this.ts.exec("scan -r 00000000", true, "0-->" + nonce, true);
        this.ts.exec("scan -r 00000099", true, "99-->" + nonce, true);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void importDirectory() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Configuration conf = new Configuration();
        String nonce = this.generateNonce();
        FileSystem fs = FileSystem.get((Configuration)conf);
        File importDir = this.createRFiles(conf, fs, table, nonce);
        this.ts.exec("createtable " + table, true);
        this.ts.exec("importdirectory " + importDir + " true", true);
        this.ts.exec("scan -r 00000000", true, "0-->" + nonce, true);
        this.ts.exec("scan -r 00000099", true, "99-->" + nonce, true);
        this.ts.exec("scan -r 00000099", true, "99-->" + nonce + nonce, false);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public void importDirectoryWithOptions() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Configuration conf = new Configuration();
        String nonce = this.generateNonce();
        FileSystem fs = FileSystem.get((Configuration)conf);
        File importDir = this.createRFiles(conf, fs, table, nonce);
        this.ts.exec("createtable " + table, true);
        this.ts.exec("notable", true);
        this.ts.exec("importdirectory -t " + table + " -i " + importDir + " true", true);
        this.ts.exec("scan -t " + table + " -np -b 0 -e 2", true, "0-->" + nonce, true);
        this.ts.exec("scan -t " + table + " -b 00000098 -e 00000100", true, "99-->" + nonce, true);
        this.ts.exec("importdirectory -t " + table + " " + importDir + " true", false);
        this.ts.exec("importdirectory -t " + table + " -i " + importDir + " true", true);
        this.ts.exec("scan -t " + table + " -r 00000000", true, "0-->" + nonce, true);
        this.ts.exec("scan -t " + table + " -r 00000099", true, "99-->" + nonce, true);
        this.ts.exec("scan -t " + table + " -r 00000201", true, nonce, false);
        this.ts.exec("deletetable -f " + table);
    }

    private File createRFiles(Configuration conf, FileSystem fs, String postfix, String nonce) throws IOException {
        File importDir = new File(rootPath, "import_" + postfix);
        Assertions.assertTrue((boolean)importDir.mkdir());
        String even = new File(importDir, "even.rf").toString();
        String odd = new File(importDir, "odd.rf").toString();
        DefaultConfiguration aconf = DefaultConfiguration.getInstance();
        FileSKVWriter evenWriter = FileOperations.getInstance().newWriterBuilder().forFile(even, fs, conf, NoCryptoServiceFactory.NONE).withTableConfiguration((AccumuloConfiguration)aconf).build();
        evenWriter.startDefaultLocalityGroup();
        FileSKVWriter oddWriter = FileOperations.getInstance().newWriterBuilder().forFile(odd, fs, conf, NoCryptoServiceFactory.NONE).withTableConfiguration((AccumuloConfiguration)aconf).build();
        oddWriter.startDefaultLocalityGroup();
        long timestamp = System.currentTimeMillis();
        Text cf = new Text("cf");
        Text cq = new Text("cq");
        for (int i = 0; i < 100; i += 2) {
            Key key = new Key(new Text(String.format("%08d", i)), cf, cq, timestamp);
            Value value = new Value((CharSequence)(i + "-->" + nonce));
            evenWriter.append(key, value);
            key = new Key(new Text(String.format("%08d", i + 1)), cf, cq, timestamp);
            value = new Value((CharSequence)(i + 1 + "-->" + nonce));
            oddWriter.append(key, value);
        }
        evenWriter.close();
        oddWriter.close();
        Assertions.assertEquals((int)0, (int)this.ts.shell.getExitCode());
        return importDir;
    }

    @Test
    public void info() throws Exception {
        this.ts.exec("info", true, "2.1.3", true);
    }

    @Test
    public void interpreter() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table, true);
        this.ts.exec("interpreter -l", true, "HexScan", false);
        this.ts.exec("insert \\x02 cf cq value", true);
        this.ts.exec("scan -b 02", true, "value", false);
        this.ts.exec("interpreter -i org.apache.accumulo.core.util.interpret.HexScanInterpreter", true);
        UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
        this.ts.exec("interpreter -l", true, "HexScan", true);
        this.ts.exec("scan -b 02", true, "value", true);
        this.ts.exec("deletetable -f " + table, true);
    }

    @Test
    public void listcompactions() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table, true);
        this.ts.exec("config -t " + table + " -s table.iterator.minc.slow=30,org.apache.accumulo.test.functional.SlowIterator", true);
        this.ts.exec("config -t " + table + " -s table.iterator.minc.slow.opt.sleepTime=1000", true);
        this.ts.exec("insert a cf cq value", true);
        this.ts.exec("insert b cf cq value", true);
        this.ts.exec("insert c cf cq value", true);
        this.ts.exec("insert d cf cq value", true);
        this.ts.exec("flush -t " + table, true);
        this.ts.exec("sleep 0.2", true);
        this.ts.exec("listcompactions", true, "default_tablet");
        String[] lines = this.ts.output.get().split("\n");
        String last = lines[lines.length - 1];
        String[] parts = last.split("\\|");
        Assertions.assertEquals((int)12, (int)parts.length);
        this.ts.exec("deletetable -f " + table, true);
    }

    @Test
    public void maxrow() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table, true);
        this.ts.exec("insert a cf cq value", true);
        this.ts.exec("insert b cf cq value", true);
        this.ts.exec("insert ccc cf cq value", true);
        this.ts.exec("insert zzz cf cq value", true);
        this.ts.exec("maxrow", true, "zzz", true);
        this.ts.exec("delete zzz cf cq", true);
        this.ts.exec("maxrow", true, "ccc", true);
        this.ts.exec("deletetable -f " + table, true);
    }

    @Test
    public void merge() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table);
        this.ts.exec("addsplits a m z");
        this.ts.exec("getsplits", true, "z", true);
        this.ts.exec("merge --all", true);
        this.ts.exec("getsplits", true, "z", false);
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("getsplits -t " + MetadataTable.NAME, true);
        Assertions.assertEquals((int)2, (int)this.ts.output.get().split("\n").length);
        this.ts.exec("getsplits -t accumulo.root", true);
        Assertions.assertEquals((int)1, (int)this.ts.output.get().split("\n").length);
        this.ts.exec("merge --all -t " + MetadataTable.NAME);
        this.ts.exec("getsplits -t " + MetadataTable.NAME, true);
        Assertions.assertEquals((int)1, (int)this.ts.output.get().split("\n").length);
    }

    @Test
    public void ping() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.ts.exec("ping", true, "OK", true);
            if (this.ts.output.get().split("\n").length == 3) break;
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        Assertions.assertEquals((int)2, (int)this.ts.output.get().split("\n").length);
    }

    @Test
    public void renametable() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String table = tableNames[0];
        String rename = tableNames[1];
        this.ts.exec("createtable " + table);
        this.ts.exec("insert this is a value");
        this.ts.exec("renametable " + table + " " + rename);
        this.ts.exec("tables", true, rename, true);
        this.ts.exec("tables", true, table, false);
        this.ts.exec("scan -t " + rename, true, "value", true);
        this.ts.exec("deletetable -f " + rename, true);
    }

    @Test
    public void tables() throws Exception {
        String table = this.getUniqueNames(1)[0];
        String table1 = table + "_z";
        String table2 = table + "_a";
        this.ts.exec("createtable " + table1);
        this.ts.exec("createtable " + table2);
        this.ts.exec("notable");
        String lst = this.ts.exec("tables -l");
        Assertions.assertTrue((lst.indexOf(table2) < lst.indexOf(table1) ? 1 : 0) != 0);
        lst = this.ts.exec("tables -l -s");
        Assertions.assertTrue((lst.indexOf(table1) < lst.indexOf(table2) ? 1 : 0) != 0);
    }

    @Test
    public void systempermission() {
        this.ts.exec("systempermissions");
        Assertions.assertEquals((int)12, (int)(this.ts.output.get().split("\n").length - 1));
        this.ts.exec("tablepermissions", true);
        Assertions.assertEquals((int)7, (int)(this.ts.output.get().split("\n").length - 1));
    }

    @Test
    public void listscans() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table, true);
        for (int i = 0; i < 6; ++i) {
            this.ts.exec("insert " + i + " cf cq value", true);
        }
        try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(ShellServerIT.getClientProps()).build();
             Scanner s = accumuloClient.createScanner(table, Authorizations.EMPTY);){
            IteratorSetting cfg = new IteratorSetting(30, SlowIterator.class);
            SlowIterator.setSleepTime(cfg, 500L);
            s.addScanIterator(cfg);
            Thread thread = new Thread(() -> s.forEach((k, v) -> {}));
            thread.start();
            ArrayList<String> scans = new ArrayList<String>();
            for (int i = 0; i < 50 && scans.isEmpty(); ++i) {
                String currentScans = this.ts.exec("listscans", true);
                log.info("Got output from listscans:\n{}", (Object)currentScans);
                String[] lines = currentScans.split("\n");
                for (int scanOffset = 2; scanOffset < lines.length; ++scanOffset) {
                    String currentScan = lines[scanOffset];
                    if (currentScan.contains(table)) {
                        log.info("Retaining scan: {}", (Object)currentScan);
                        scans.add(currentScan);
                        continue;
                    }
                    log.info("Ignoring scan because of wrong table: {}", (Object)currentScan);
                }
                UtilWaitThread.sleepUninterruptibly((long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            thread.join();
            Assertions.assertFalse((boolean)scans.isEmpty(), (String)("Could not find any active scans over table " + table));
            for (String scan : scans) {
                if (!scan.contains("RUNNING")) {
                    log.info("Ignoring scan because it doesn't contain 'RUNNING': {}", (Object)scan);
                    continue;
                }
                Object[] parts = scan.split("\\|");
                Assertions.assertEquals((int)14, (int)parts.length, (String)("Expected 14 colums, but found " + parts.length + " instead for '" + Arrays.toString(parts) + "'"));
                String tserver = ((String)parts[0]).trim();
                String hostPortPattern = ".+:\\d+";
                ShellServerIT.assertMatches(tserver, hostPortPattern);
                Assertions.assertTrue((boolean)accumuloClient.instanceOperations().getTabletServers().contains(tserver));
                String client = ((String)parts[1]).trim();
                ShellServerIT.assertMatches(client, hostPortPattern);
                Long r = Long.parseLong(((String)parts[11]).trim());
                Assertions.assertNotNull((Object)r);
            }
        }
        this.ts.exec("deletetable -f " + table, true);
    }

    @Test
    public void testPerTableClasspathLegacyJar() throws Exception {
        String table = this.getUniqueNames(1)[0];
        File fooConstraintJar = this.initJar("/org/apache/accumulo/test/FooConstraint.jar", "FooContraint", rootPath);
        this.verifyPerTableClasspath(table, fooConstraintJar);
    }

    @Test
    public void testPerTableClasspath_2_1_Jar() throws Exception {
        String table = this.getUniqueNames(1)[0];
        File fooConstraintJar = this.initJar("/org/apache/accumulo/test/FooConstraint_2_1.jar", "FooConstraint_2_1", rootPath);
        this.verifyPerTableClasspath(table, fooConstraintJar);
    }

    public void verifyPerTableClasspath(String table, File fooConstraintJar) throws IOException {
        File fooFilterJar = this.initJar("/org/apache/accumulo/test/FooFilter.jar", "FooFilter", rootPath);
        this.ts.exec("config -s " + VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + "cx1=" + fooFilterJar.toURI() + "," + fooConstraintJar.toURI(), true);
        this.ts.exec("createtable " + table, true);
        this.ts.exec("config -t " + table + " -s " + Property.TABLE_CLASSLOADER_CONTEXT.getKey() + "=cx1", true);
        UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.ts.exec("config -t " + table + " -s " + Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.foo=10,org.apache.accumulo.test.FooFilter");
        UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.ts.exec("insert foo f q v", true);
        UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.ts.exec("scan -np", true, "foo", false);
        this.ts.exec("constraint -a FooConstraint", true);
        this.ts.exec("offline -w " + table);
        this.ts.exec("online -w " + table);
        this.ts.exec("table " + table, true);
        this.ts.exec("insert foo f q v", false);
        this.ts.exec("insert ok foo q v", true);
        this.ts.exec("deletetable -f " + table, true);
        this.ts.exec("config -d " + VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + "cx1");
    }

    @Test
    public void badLogin() {
        Assumptions.assumeTrue((boolean)(ShellServerIT.getToken() instanceof PasswordToken));
        this.ts.input.set(ShellServerIT.getRootPassword() + "\n");
        String err = this.ts.exec("user NoSuchUser", false);
        Assertions.assertTrue((boolean)err.contains("BAD_CREDENTIALS for user NoSuchUser"));
    }

    @Test
    public void namespaces() throws Exception {
        String[] names = this.getUniqueNames(5);
        String tableName = names[0];
        String ns_1 = names[1];
        String ns_2 = names[2];
        String ns_3 = names[3];
        String ns_4 = names[4];
        this.ts.exec("namespaces", true, "\"\"", true);
        this.ts.exec("namespaces", true, Namespace.ACCUMULO.name(), true);
        this.ts.exec("createnamespace " + ns_1, true);
        String namespaces = this.ts.exec("namespaces");
        Assertions.assertTrue((boolean)namespaces.contains(ns_1));
        this.ts.exec("renamenamespace " + ns_1 + " " + ns_2);
        namespaces = this.ts.exec("namespaces");
        Assertions.assertTrue((boolean)namespaces.contains(ns_2));
        Assertions.assertFalse((boolean)namespaces.contains(ns_1));
        this.ts.exec("createtable " + ns_2 + "." + tableName, true);
        this.ts.exec("deletenamespace " + ns_2);
        this.ts.exec("y");
        this.ts.exec("namespaces", true, ns_2, true);
        this.ts.exec("du -ns " + ns_2, true, ns_2 + "." + tableName, true);
        this.ts.exec("offline -ns " + ns_2, true);
        this.ts.exec("online -ns " + ns_2, true);
        this.ts.exec("flush -ns " + ns_2, true);
        this.ts.exec("compact -ns " + ns_2, true);
        this.ts.exec("createnamespace " + ns_3, true);
        this.ts.exec("createtable " + ns_3 + ".1", true);
        this.ts.exec("createtable " + ns_3 + ".2", true);
        this.ts.exec("deletetable -ns " + ns_3 + " -f", true);
        this.ts.exec("tables", true, ns_3 + ".1", false);
        this.ts.exec("namespaces", true, ns_3, true);
        this.ts.exec("deletenamespace " + ns_3 + " -f", true);
        this.ts.input.set("true\n\n\n\nSTRING\n");
        this.ts.exec("setiter -ns " + ns_2 + " -scan -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -n name", true);
        this.ts.exec("listiter -ns " + ns_2 + " -scan", true, "Summing", true);
        this.ts.exec("deleteiter -ns " + ns_2 + " -n name -scan", true);
        this.ts.exec("createuser dude");
        this.ts.exec("pass");
        this.ts.exec("pass");
        this.ts.exec("grant Namespace.CREATE_TABLE -ns " + ns_2 + " -u dude", true);
        this.ts.exec("revoke Namespace.CREATE_TABLE -ns " + ns_2 + " -u dude", true);
        this.ts.exec("config -ns " + ns_2 + " -s table.file.max=44444", true);
        this.ts.exec("config -ns " + ns_2, true, "44444", true);
        this.ts.exec("config -t " + ns_2 + "." + tableName, true, "44444", true);
        this.ts.exec("config -t " + ns_2 + "." + tableName + " -s table.file.max=55555", true);
        this.ts.exec("config -t " + ns_2 + "." + tableName, true, "55555", true);
        this.ts.exec("createnamespace " + ns_4 + " -cc " + ns_2, true);
        this.ts.exec("config -ns " + ns_4, true, "44444", true);
        this.ts.exec("deletenamespace -f " + ns_2, true);
        this.ts.exec("namespaces", true, ns_2, false);
        this.ts.exec("tables", true, ns_2 + "." + tableName, false);
        Thread.sleep(250L);
        this.ts.exec("constraint -ns " + ns_4 + " -a org.apache.accumulo.test.constraints.NumericValueConstraint", true);
        this.ts.exec("createtable " + ns_4 + ".constrained", true);
        this.ts.exec("table " + ns_4 + ".constrained", true);
        this.ts.exec("constraint -d 1");
        this.ts.exec("constraint -l", true, "NumericValueConstraint", true);
        this.ts.exec("insert r cf cq abc", false);
        this.ts.exec("constraint -ns " + ns_4 + " -d 1");
        this.ts.exec("sleep 3");
        this.ts.exec("insert r cf cq abc", true);
    }

    private int countkeys(String table) {
        this.ts.exec("scan -np -t " + table);
        return this.ts.output.get().split("\n").length - 1;
    }

    @Test
    public void scans() throws Exception {
        this.ts.exec("createtable t");
        this.make10();
        String result = this.ts.exec("scan -np -b row1 -e row1");
        Assertions.assertEquals((int)2, (int)result.split("\n").length);
        result = this.ts.exec("scan -np -b row3 -e row5");
        Assertions.assertEquals((int)4, (int)result.split("\n").length);
        result = this.ts.exec("scan -np -r row3");
        Assertions.assertEquals((int)2, (int)result.split("\n").length);
        result = this.ts.exec("scan -np -b row:");
        Assertions.assertEquals((int)1, (int)result.split("\n").length);
        result = this.ts.exec("scan -np -b row");
        Assertions.assertEquals((int)11, (int)result.split("\n").length);
        result = this.ts.exec("scan -np -e row:");
        Assertions.assertEquals((int)11, (int)result.split("\n").length);
        this.ts.exec("deletetable -f t");
    }

    @Test
    public void scansWithColon() throws Exception {
        this.ts.exec("createtable twithcolontest");
        this.ts.exec("insert row c:f cq value");
        this.ts.exec("scan -r row -cf c:f", true, "value");
        this.ts.exec("scan -b row -cf c:f  -cq cq -e row", true, "value");
        this.ts.exec("scan -b row -c cf -cf c:f  -cq cq -e row", false, "mutually exclusive");
        this.ts.exec("scan -b row -cq col1 -e row", false, "Option -cf is required when using -cq");
        this.ts.exec("deletetable -f twithcolontest");
    }

    @Test
    public void scansWithClassLoaderContext() throws IOException {
        Assertions.assertThrows(ClassNotFoundException.class, () -> Class.forName(VALUE_REVERSING_ITERATOR), (String)"ValueReversingIterator already on the classpath");
        String tableName = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + tableName);
        String result = this.ts.exec("setiter -scan -n reverse -t " + tableName + " -p 21 -class org.apache.accumulo.test.functional.ValueReversingIterator");
        Assertions.assertTrue((boolean)result.contains("class not found"));
        this.make10();
        this.setupFakeContextPath();
        result = this.ts.exec("config -s " + VFS_CONTEXT_CLASSPATH_PROPERTY + "FAKE=" + FAKE_CONTEXT_CLASSPATH);
        Assertions.assertEquals((Object)("root@miniInstance " + tableName + "> config -s " + VFS_CONTEXT_CLASSPATH_PROPERTY + "FAKE=" + FAKE_CONTEXT_CLASSPATH + "\n"), (Object)result);
        result = this.ts.exec("config -t " + tableName + " -s " + Property.TABLE_CLASSLOADER_CONTEXT.getKey() + "=FAKE");
        Assertions.assertEquals((Object)("root@miniInstance " + tableName + "> config -t " + tableName + " -s " + Property.TABLE_CLASSLOADER_CONTEXT.getKey() + "=FAKE\n"), (Object)result);
        result = this.ts.exec("setshelliter -pn baz -n reverse -p 21 -class org.apache.accumulo.test.functional.ValueReversingIterator");
        Assertions.assertTrue((boolean)result.contains("The iterator class does not implement OptionDescriber"));
        result = this.ts.exec("scan -pn baz -np -b row1 -e row1");
        Assertions.assertEquals((int)2, (int)result.split("\n").length);
        Assertions.assertTrue((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -b row3 -e row5");
        Assertions.assertEquals((int)4, (int)result.split("\n").length);
        Assertions.assertTrue((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -r row3");
        Assertions.assertEquals((int)2, (int)result.split("\n").length);
        Assertions.assertTrue((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -b row:");
        Assertions.assertEquals((int)1, (int)result.split("\n").length);
        result = this.ts.exec("scan -pn baz -np -b row");
        Assertions.assertEquals((int)11, (int)result.split("\n").length);
        Assertions.assertTrue((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -e row:");
        Assertions.assertEquals((int)11, (int)result.split("\n").length);
        Assertions.assertTrue((boolean)result.contains("value"));
        this.setupRealContextPath();
        result = this.ts.exec("config -s " + VFS_CONTEXT_CLASSPATH_PROPERTY + "REAL=" + REAL_CONTEXT_CLASSPATH);
        Assertions.assertEquals((Object)("root@miniInstance " + tableName + "> config -s " + VFS_CONTEXT_CLASSPATH_PROPERTY + "REAL=" + REAL_CONTEXT_CLASSPATH + "\n"), (Object)result);
        result = this.ts.exec("scan -pn baz -np -b row1 -e row1 -cc REAL");
        Assertions.assertEquals((int)2, (int)result.split("\n").length);
        Assertions.assertTrue((boolean)result.contains("eulav"));
        Assertions.assertFalse((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -b row3 -e row5 -cc REAL");
        Assertions.assertEquals((int)4, (int)result.split("\n").length);
        Assertions.assertTrue((boolean)result.contains("eulav"));
        Assertions.assertFalse((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -r row3 -cc REAL");
        Assertions.assertEquals((int)2, (int)result.split("\n").length);
        Assertions.assertTrue((boolean)result.contains("eulav"));
        Assertions.assertFalse((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -b row: -cc REAL");
        Assertions.assertEquals((int)1, (int)result.split("\n").length);
        result = this.ts.exec("scan -pn baz -np -b row -cc REAL");
        Assertions.assertEquals((int)11, (int)result.split("\n").length);
        Assertions.assertTrue((boolean)result.contains("eulav"));
        Assertions.assertFalse((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -e row: -cc REAL");
        Assertions.assertEquals((int)11, (int)result.split("\n").length);
        Assertions.assertTrue((boolean)result.contains("eulav"));
        Assertions.assertFalse((boolean)result.contains("value"));
        this.ts.exec("deletetable -f " + tableName);
    }

    @Test
    public void testScanTableWithIterSetWithoutProfile() throws Exception {
        String table = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + table, true);
        this.ts.exec("insert foo a b c", true);
        this.ts.exec("scan", true, "foo a:b []\tc");
        this.ts.input.set("\n1000\n\n");
        this.ts.exec("setiter -scan -n itname -p 10 -ageoff", true);
        this.ts.exec("sleep 2", true);
        this.ts.exec("scan", true, "", true);
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("createtable " + table, true);
        this.ts.exec("insert foo a b c", true);
        this.ts.exec("notable");
        this.ts.exec("scan -t " + table, true, "foo a:b []\tc");
        this.ts.input.set("\n1000\n\n");
        this.ts.exec("setiter -scan -n itname -p 10 -ageoff -t " + table, true);
        this.ts.exec("sleep 2", true);
        this.ts.exec("scan -t " + table, true, "", true);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void importDirectoryCmdFmt() throws Exception {
        String table = this.getUniqueNames(1)[0];
        File importDir = new File(rootPath, "import_" + table);
        Assertions.assertTrue((boolean)importDir.mkdir());
        File errorsDir = new File(rootPath, "errors_" + table);
        Assertions.assertTrue((boolean)errorsDir.mkdir());
        this.ts.exec(String.format("importdirectory -t %s %s %s false", table, importDir, errorsDir), false, "TableNotFoundException");
        this.ts.exec(String.format("table %s", table), false, "TableNotFoundException");
        this.ts.exec("createtable " + table, true);
        this.ts.exec(String.format("importdirectory -t %s %s %s false", table, importDir, errorsDir), true);
        this.ts.exec(String.format("importdirectory -t %s %s %s false", table, importDir, errorsDir), true);
        this.ts.exec(String.format("importdirectory -t %s %s false", table, importDir), false);
        this.ts.exec(String.format("importdirectory -t %s %s false -i", table, importDir), true);
        this.ts.exec(String.format("table %s", table), true);
        this.ts.exec(String.format("importdirectory %s %s false", importDir, errorsDir), true);
        this.ts.exec("importdirectory false", false, "Expected 2 or 3 arguments. There was 1.");
        this.ts.exec("notable", true);
        this.ts.exec(String.format("importdirectory %s %s false", importDir, errorsDir), false, "java.lang.IllegalStateException: Not in a table context.");
    }

    private void setupRealContextPath() throws IOException {
        Path baseDir = new Path(System.getProperty("user.dir"));
        Path targetDir = new Path(baseDir, "target");
        Path jarPath = new Path(targetDir, "TestJar-Iterators.jar");
        Path dstPath = new Path(REAL_CONTEXT_CLASSPATH);
        FileSystem fs = SharedMiniClusterBase.getCluster().getFileSystem();
        fs.copyFromLocalFile(jarPath, dstPath);
    }

    private void setupFakeContextPath() throws IOException {
        Path baseDir = new Path(System.getProperty("user.dir"));
        Path jarPath = new Path(baseDir + "/target/classes/org/apache/accumulo/test", "ShellServerIT-iterators.jar");
        Path dstPath = new Path(FAKE_CONTEXT_CLASSPATH);
        FileSystem fs = SharedMiniClusterBase.getCluster().getFileSystem();
        fs.copyFromLocalFile(jarPath, dstPath);
    }

    @Test
    public void whoami() throws Exception {
        AuthenticationToken token = ShellServerIT.getToken();
        Assertions.assertTrue((boolean)this.ts.exec("whoami", true).contains(ShellServerIT.getPrincipal()));
        if (token instanceof PasswordToken) {
            this.ts.input.set("secret\nsecret\n");
        }
        this.ts.exec("createuser test_user");
        this.ts.exec("setauths -u test_user -s 12,3,4");
        String auths = this.ts.exec("getauths -u test_user");
        Assertions.assertTrue((auths.contains("3") && auths.contains("12") && auths.contains("4") ? 1 : 0) != 0);
        if (token instanceof PasswordToken) {
            this.ts.input.set("secret\n");
            this.ts.exec("user test_user", true);
            Assertions.assertTrue((boolean)this.ts.exec("whoami", true).contains("test_user"));
            this.ts.input.set(ShellServerIT.getRootPassword() + "\n");
            this.ts.exec("user root", true);
        }
    }

    private void make10() {
        for (int i = 0; i < 10; ++i) {
            this.ts.exec(String.format("insert row%d cf col%d value", i, i));
        }
    }

    private List<String> getFiles(String tableId) {
        this.ts.output.clear();
        this.ts.exec("scan -t " + MetadataTable.NAME + " -np -c file -b " + tableId + " -e " + tableId + "~");
        log.debug("countFiles(): {}", (Object)this.ts.output.get());
        String[] lines = this.ts.output.get().split("\n");
        this.ts.output.clear();
        if (lines.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(Arrays.copyOfRange(lines, 1, lines.length));
    }

    private int countFiles(String tableId) {
        return this.getFiles(tableId).size();
    }

    private String getTableId(String tableName) throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ShellServerIT.getClientProps()).build();){
            for (int i = 0; i < 5; ++i) {
                Map nameToId = client.tableOperations().tableIdMap();
                if (nameToId.containsKey(tableName)) {
                    String string = (String)nameToId.get(tableName);
                    return string;
                }
                Thread.sleep(1000L);
            }
            Assertions.fail((String)("Could not find ID for table: " + tableName));
            String string = null;
            return string;
        }
    }

    private static void assertMatches(String output, String pattern) {
        Predicate<String> p = Pattern.compile(pattern).asMatchPredicate();
        Assertions.assertTrue((boolean)p.test(output), (String)("Pattern " + pattern + " did not match output : " + output));
    }

    private static void assertNotContains(String output, String subsequence) {
        Assertions.assertFalse((boolean)output.contains(subsequence), (String)("Expected '" + subsequence + "' would not occur in output : " + output));
    }

    @Test
    public void testSummaries() {
        String tableName = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + tableName);
        this.ts.exec("config -t " + tableName + " -s table.summarizer.del=" + DeletesSummarizer.class.getName());
        this.ts.exec("config -t " + tableName + " -s table.summarizer.fam=" + FamilySummarizer.class.getName());
        this.ts.exec("addsplits -t " + tableName + " r1 r2");
        this.ts.exec("insert r1 f1 q1 v1");
        this.ts.exec("insert r2 f2 q1 v3");
        this.ts.exec("insert r2 f2 q2 v4");
        this.ts.exec("insert r3 f3 q1 v5");
        this.ts.exec("insert r3 f3 q2 v6");
        this.ts.exec("insert r3 f3 q3 v7");
        this.ts.exec("flush -t " + tableName + " -w");
        String output = this.ts.exec("summaries");
        ShellServerIT.assertMatches(output, "(?sm).*^.*deletes\\s+=\\s+0.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*total\\s+=\\s+6.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f1\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f2\\s+=\\s+2.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f3\\s+=\\s+3.*$.*");
        this.ts.exec("delete r1 f1 q2");
        this.ts.exec("delete r2 f2 q1");
        this.ts.exec("flush -t " + tableName + " -w");
        output = this.ts.exec("summaries");
        ShellServerIT.assertMatches(output, "(?sm).*^.*deletes\\s+=\\s+2.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*total\\s+=\\s+8.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f1\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f2\\s+=\\s+2.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f3\\s+=\\s+3.*$.*");
        output = this.ts.exec("summaries -e r2");
        ShellServerIT.assertMatches(output, "(?sm).*^.*deletes\\s+=\\s+2.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*total\\s+=\\s+5.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f1\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f2\\s+=\\s+2.*$.*");
        ShellServerIT.assertNotContains(output, "c:f3");
        output = this.ts.exec("summaries -b r2");
        ShellServerIT.assertMatches(output, "(?sm).*^.*deletes\\s+=\\s+0.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*total\\s+=\\s+3.*$.*");
        ShellServerIT.assertNotContains(output, "c:f1");
        ShellServerIT.assertNotContains(output, "c:f2");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f3\\s+=\\s+3.*$.*");
        output = this.ts.exec("summaries -b r1 -e r2");
        ShellServerIT.assertMatches(output, "(?sm).*^.*deletes\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*total\\s+=\\s+3.*$.*");
        ShellServerIT.assertNotContains(output, "c:f1");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f2\\s+=\\s+2.*$.*");
        ShellServerIT.assertNotContains(output, "c:f3");
        output = this.ts.exec("summaries -sr .*Family.*");
        ShellServerIT.assertNotContains(output, "deletes ");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f1\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f2\\s+=\\s+2.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f3\\s+=\\s+3.*$.*");
        output = this.ts.exec("summaries -b r1 -e r2 -sr .*Family.*");
        ShellServerIT.assertNotContains(output, "deletes ");
        ShellServerIT.assertNotContains(output, "c:f1");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f2\\s+=\\s+2.*$.*");
        ShellServerIT.assertNotContains(output, "c:f3");
    }

    @Test
    public void testSummarySelection() {
        String tableName = this.getUniqueNames(1)[0];
        this.ts.exec("createtable " + tableName);
        this.ts.exec("config -t " + tableName + " -s " + Property.TABLE_MAJC_RATIO + "=10");
        this.ts.exec("insert r1 f1 q1 v1");
        this.ts.exec("insert r2 f2 q1 v2");
        this.ts.exec("flush -t " + tableName + " -w");
        this.ts.exec("config -t " + tableName + " -s table.summarizer.fam=" + FamilySummarizer.class.getName());
        this.ts.exec("insert r1 f2 q1 v3");
        this.ts.exec("insert r3 f3 q1 v4");
        this.ts.exec("flush -t " + tableName + " -w");
        String output = this.ts.exec("summaries");
        ShellServerIT.assertNotContains(output, "c:f1");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f2\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f3\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*total[:]2[,]\\s+missing[:]1[,]\\s+extra[:]0.*$.*");
        this.ts.exec("compact -t " + tableName + " --sf-no-summary -w");
        output = this.ts.exec("summaries");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f1\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f2\\s+=\\s+2.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f3\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*total[:]2[,]\\s+missing[:]0[,]\\s+extra[:]0.*$.*");
        this.ts.exec("addsplits -t " + tableName + " r2");
        output = this.ts.exec("summaries -e r2");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f1\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f2\\s+=\\s+2.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f3\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*total[:]2[,]\\s+missing[:]0[,]\\s+extra[:]1.*$.*");
        this.ts.exec("compact -t " + tableName + " --sf-extra-summary -w");
        output = this.ts.exec("summaries -e r2");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f1\\s+=\\s+1.*$.*");
        ShellServerIT.assertMatches(output, "(?sm).*^.*c:f2\\s+=\\s+2.*$.*");
        ShellServerIT.assertNotContains(output, "c:f3");
        ShellServerIT.assertMatches(output, "(?sm).*^.*total[:]2[,]\\s+missing[:]0[,]\\s+extra[:]0.*$.*");
    }

    @Test
    public void testFateCommandWithSlowCompaction() throws Exception {
        String table = this.getUniqueNames(1)[0];
        String orgProps = System.getProperty("accumulo.properties");
        System.setProperty("accumulo.properties", "file://" + ShellServerIT.getCluster().getConfig().getAccumuloPropsFile().getCanonicalPath());
        this.ts.exec("createtable " + table);
        this.ts.exec("config -t " + table + " -s table.iterator.majc.slow=1,org.apache.accumulo.test.functional.SlowIterator");
        this.ts.exec("config -t " + table + " -s table.iterator.majc.slow.opt.sleepTime=10000");
        this.ts.exec("insert a1 b c v_a1");
        this.ts.exec("insert a2 b c v_a2");
        this.ts.exec("flush -w");
        this.ts.exec("insert x1 b c v_x1");
        this.ts.exec("insert x2 b c v_x2");
        this.ts.exec("flush -w");
        this.ts.exec("fate -print", true, "0 transactions", true);
        this.ts.exec("compact -t " + table);
        Thread.sleep(1000L);
        this.ts.exec("compact -t " + table);
        Thread.sleep(3000L);
        log.info("Calling fate print for table = {}", (Object)table);
        String result = this.ts.exec("fate -print", true, "txid:", true);
        String[] resultParts = result.split("txid: ");
        String[] parts = resultParts[1].split(" ");
        String txid = parts[0];
        this.ts.exec("fate -print -t IN_PROGRESS", true, "2 transactions", true);
        this.ts.exec("fate -print " + txid + " -t IN_PROGRESS", true, "1 transactions", true);
        this.ts.exec("fate -print " + txid + " -t FAILED", true, "0 transactions", true);
        this.ts.exec("fate -print -t NEW", true, "0 transactions", true);
        this.ts.exec("fate -print 1234", true, "0 transactions", true);
        this.ts.exec("fate -print FATE[aaa] 1 2 3", true, "0 transactions", true);
        this.ts.exec("deletetable -f " + table);
        if (orgProps != null) {
            System.setProperty("accumulo.properties", orgProps);
        }
    }

    @Test
    public void failOnInvalidClassloaderContestTest() throws Exception {
        String[] names = this.getUniqueNames(3);
        String table1 = names[0];
        String namespace1 = names[1];
        String table2 = namespace1 + "." + names[2];
        this.ts.exec("createtable " + table1, true);
        this.ts.exec("createnamespace " + namespace1, true);
        this.ts.exec("createtable " + table2, true);
        this.ts.exec("config -s table.class.loader.context=invalid", false, AccumuloException.class.getName(), true);
        this.ts.exec("config -s table.class.loader.context=invalid -ns " + namespace1, false, AccumuloException.class.getName(), true);
        this.ts.exec("config -s table.class.loader.context=invalid -t " + table1, false, AccumuloException.class.getName(), true);
        this.ts.exec("config -s table.class.loader.context=invalid -t " + table2, false, AccumuloException.class.getName(), true);
    }

    public String generateNonce() {
        byte[] r = new byte[16];
        this.random.nextBytes(r);
        return new String(Base64.getEncoder().encode(r), StandardCharsets.UTF_8);
    }

    static {
        FAKE_CONTEXT_CLASSPATH = "file://" + System.getProperty("user.dir") + "/target/" + ShellServerIT.class.getSimpleName() + "-fake-iterators.jar";
        REAL_CONTEXT_CLASSPATH = "file://" + System.getProperty("user.dir") + "/target/" + ShellServerIT.class.getSimpleName() + "-real-iterators.jar";
    }

    private static class ShellServerITConfigCallback
    implements MiniClusterConfigurationCallback {
        private ShellServerITConfigCallback() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumTservers(1);
            Map siteConf = cfg.getSiteConfig();
            cfg.setSiteConfig(siteConf);
        }
    }

    public static class HexFormatter
    implements Formatter {
        private Iterator<Map.Entry<Key, Value>> iter = null;
        private FormatterConfig config;
        private static final String tab = "\t";
        private static final String newline = "\n";

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public String next() {
            Map.Entry<Key, Value> entry = this.iter.next();
            String key = this.config.willPrintTimestamps() ? entry.getKey().toString() : entry.getKey().toStringNoTime();
            Value v = entry.getValue();
            StringBuilder sb = new StringBuilder(key.length() + v.getSize() * 5);
            sb.append(key).append(tab);
            for (byte b : v.get()) {
                if ((b < 48 || b > 57) && (b < 97 || b > 102)) continue;
                sb.append(String.format("0x%x ", b));
            }
            return sb.toString().trim() + newline;
        }

        public void remove() {
        }

        public void initialize(Iterable<Map.Entry<Key, Value>> scanner, FormatterConfig config) {
            this.iter = scanner.iterator();
            this.config = new FormatterConfig(config);
        }
    }
}

