/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.start;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.accumulo.compactor.CompactorExecutable;
import org.apache.accumulo.coordinator.CoordinatorExecutable;
import org.apache.accumulo.core.file.rfile.CreateEmpty;
import org.apache.accumulo.core.file.rfile.GenerateSplits;
import org.apache.accumulo.core.file.rfile.PrintInfo;
import org.apache.accumulo.core.file.rfile.SplitLarge;
import org.apache.accumulo.core.util.CreateToken;
import org.apache.accumulo.core.util.Help;
import org.apache.accumulo.core.util.Version;
import org.apache.accumulo.gc.GCExecutable;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.manager.ManagerExecutable;
import org.apache.accumulo.manager.MasterExecutable;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.minicluster.MiniAccumuloRunner;
import org.apache.accumulo.miniclusterImpl.MiniClusterExecutable;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.MonitorExecutable;
import org.apache.accumulo.server.conf.CheckCompactionConfig;
import org.apache.accumulo.server.conf.CheckServerConfig;
import org.apache.accumulo.server.conf.util.ConfigPropertyUpgrader;
import org.apache.accumulo.server.conf.util.ZooInfoViewer;
import org.apache.accumulo.server.conf.util.ZooPropEditor;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.server.util.ConvertConfig;
import org.apache.accumulo.server.util.DumpZookeeper;
import org.apache.accumulo.server.util.ECAdmin;
import org.apache.accumulo.server.util.Info;
import org.apache.accumulo.server.util.LoginProperties;
import org.apache.accumulo.server.util.ZooKeeperMain;
import org.apache.accumulo.server.util.ZooZap;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.accumulo.tserver.ScanServerExecutable;
import org.apache.accumulo.tserver.TServerExecutable;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.logger.LogReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="SunnyDay")
public class KeywordStartIT {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    private Map<String, KeywordExecutable> getKeywordExecutables() {
        Map all = Main.getExecutables((ClassLoader)ClassLoader.getSystemClassLoader());
        Assumptions.assumeTrue((!all.isEmpty() ? 1 : 0) != 0);
        return all;
    }

    @Test
    public void testKeywordsMatch() {
        this.getKeywordExecutables().forEach((k, v) -> Assertions.assertEquals((Object)k, (Object)v.keyword()));
    }

    @Test
    public void testCheckDuplicates() {
        NoOp one = new NoOp("one");
        NoOp anotherOne = new NoOp("another");
        NoOp two = new NoOp("two");
        NoOp three = new NoOp("three");
        List<NoOp> services = Arrays.asList(one, three, two, two, three, three, anotherOne);
        Assertions.assertEquals((int)7, (int)services.size());
        Map results = Main.checkDuplicates(services);
        Assertions.assertTrue((boolean)results.containsKey(one.keyword()));
        Assertions.assertTrue((boolean)results.containsKey(anotherOne.keyword()));
        Assertions.assertFalse((boolean)results.containsKey(two.keyword()));
        Assertions.assertFalse((boolean)results.containsKey(three.keyword()));
        Assertions.assertEquals((int)2, (int)results.size());
    }

    @Test
    public void testExpectedClasses() {
        Assumptions.assumeTrue((boolean)new File(System.getProperty("user.dir") + "/src").exists());
        TreeMap<String, Class> expectSet = new TreeMap<String, Class>();
        expectSet.put("admin", Admin.class);
        expectSet.put("check-compaction-config", CheckCompactionConfig.class);
        expectSet.put("check-server-config", CheckServerConfig.class);
        expectSet.put("compaction-coordinator", CoordinatorExecutable.class);
        expectSet.put("compactor", CompactorExecutable.class);
        expectSet.put("config-upgrade", ConfigPropertyUpgrader.class);
        expectSet.put("convert-config", ConvertConfig.class);
        expectSet.put("create-empty", CreateEmpty.class);
        expectSet.put("create-token", CreateToken.class);
        expectSet.put("dump-zoo", DumpZookeeper.class);
        expectSet.put("ec-admin", ECAdmin.class);
        expectSet.put("gc", GCExecutable.class);
        expectSet.put("generate-splits", GenerateSplits.class);
        expectSet.put("help", Help.class);
        expectSet.put("info", Info.class);
        expectSet.put("init", Initialize.class);
        expectSet.put("login-info", LoginProperties.class);
        expectSet.put("manager", ManagerExecutable.class);
        expectSet.put("minicluster", MiniClusterExecutable.class);
        expectSet.put("monitor", MonitorExecutable.class);
        expectSet.put("rfile-info", PrintInfo.class);
        expectSet.put("shell", Shell.class);
        expectSet.put("split-large", SplitLarge.class);
        expectSet.put("sserver", ScanServerExecutable.class);
        expectSet.put("tserver", TServerExecutable.class);
        expectSet.put("version", Version.class);
        expectSet.put("wal-info", LogReader.class);
        expectSet.put("zoo-info-viewer", ZooInfoViewer.class);
        expectSet.put("zoo-prop-editor", ZooPropEditor.class);
        expectSet.put("zoo-zap", ZooZap.class);
        expectSet.put("zookeeper", ZooKeeperMain.class);
        Class<MasterExecutable> masterExecutableClass = MasterExecutable.class;
        expectSet.put("master", masterExecutableClass);
        Iterator expectIter = expectSet.entrySet().iterator();
        TreeMap<String, KeywordExecutable> actualSet = new TreeMap<String, KeywordExecutable>(this.getKeywordExecutables());
        Iterator<Map.Entry<String, KeywordExecutable>> actualIter = actualSet.entrySet().iterator();
        while (expectIter.hasNext() && actualIter.hasNext()) {
            Map.Entry expected = expectIter.next();
            Map.Entry<String, KeywordExecutable> actual = actualIter.next();
            Assertions.assertEquals(expected.getKey(), (Object)actual.getKey());
            Assertions.assertEquals(expected.getValue(), actual.getValue().getClass());
        }
        boolean moreExpected = expectIter.hasNext();
        if (moreExpected) {
            while (expectIter.hasNext()) {
                this.log.warn("Missing class for keyword '{}'", expectIter.next());
            }
        }
        Assertions.assertFalse((boolean)moreExpected, (String)"Missing expected classes");
        boolean moreActual = actualIter.hasNext();
        if (moreActual) {
            while (actualIter.hasNext()) {
                this.log.warn("Extra class found with keyword '{}'", actualIter.next());
            }
        }
        Assertions.assertFalse((boolean)moreActual, (String)"Found additional unexpected classes");
    }

    @Test
    public void checkHasMain() {
        Assertions.assertFalse((boolean)KeywordStartIT.hasMain(this.getClass()), (String)"Sanity check for test failed. Somehow the test class has a main method");
        HashSet<Class> expectSet = new HashSet<Class>();
        expectSet.add(Admin.class);
        expectSet.add(CheckCompactionConfig.class);
        expectSet.add(CheckServerConfig.class);
        expectSet.add(ConfigPropertyUpgrader.class);
        expectSet.add(ConvertConfig.class);
        expectSet.add(CreateEmpty.class);
        expectSet.add(CreateToken.class);
        expectSet.add(DumpZookeeper.class);
        expectSet.add(ECAdmin.class);
        expectSet.add(GenerateSplits.class);
        expectSet.add(Info.class);
        expectSet.add(Initialize.class);
        expectSet.add(LogReader.class);
        expectSet.add(LoginProperties.class);
        expectSet.add(MiniAccumuloRunner.class);
        expectSet.add(Monitor.class);
        expectSet.add(PrintInfo.class);
        expectSet.add(Shell.class);
        expectSet.add(SimpleGarbageCollector.class);
        expectSet.add(SplitLarge.class);
        expectSet.add(TabletServer.class);
        expectSet.add(ZooKeeperMain.class);
        expectSet.add(ZooZap.class);
        Class<Master> masterClass = Master.class;
        expectSet.add(masterClass);
        expectSet.forEach(c -> Assertions.assertTrue((boolean)KeywordStartIT.hasMain(c), (String)("Class " + c.getName() + " is missing a main method!")));
        Set<Class> all = this.getKeywordExecutables().values().stream().map(Object::getClass).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)all.removeAll(expectSet));
        Assertions.assertNotEquals((int)0, (int)all.size());
        all.forEach(c -> Assertions.assertFalse((boolean)KeywordStartIT.hasMain(c), (String)("Class " + c.getName() + " has an unexpected main method!")));
    }

    private static boolean hasMain(Class<?> classToCheck) {
        Method main;
        try {
            main = classToCheck.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return Modifier.isPublic(main.getModifiers()) && Modifier.isStatic(main.getModifiers());
    }

    private static class NoOp
    implements KeywordExecutable {
        private final String kw;

        public NoOp(String kw) {
            this.kw = kw;
        }

        public String keyword() {
            return this.kw;
        }

        public String description() {
            return this.kw;
        }

        public void execute(String[] args) {
        }
    }
}

