/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.upgrade;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.impl.ZooPropStore;
import org.apache.accumulo.server.conf.util.ConfigPropertyUpgrader;
import org.apache.accumulo.test.conf.store.PropStoreZooKeeperIT;
import org.apache.accumulo.test.conf.util.LegacyPropData;
import org.apache.accumulo.test.zookeeper.ZooKeeperTestingServer;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="ZooKeeperTestingServer")
public class ConfigPropertyUpgraderIT {
    private static final Logger log = LoggerFactory.getLogger(PropStoreZooKeeperIT.class);
    private static ZooKeeperTestingServer testZk = null;
    private static ZooKeeper zooKeeper;
    private static ZooReaderWriter zrw;
    private InstanceId instanceId = null;
    @TempDir
    private static File tempDir;

    @BeforeAll
    public static void setupZk() {
        testZk = new ZooKeeperTestingServer(tempDir);
        zooKeeper = testZk.getZooKeeper();
        ZooUtil.digestAuth((ZooKeeper)zooKeeper, (String)"secret");
        zrw = testZk.getZooReaderWriter();
    }

    @AfterAll
    public static void shutdownZK() throws Exception {
        testZk.close();
    }

    @BeforeEach
    public void setupZnodes() throws Exception {
        this.instanceId = InstanceId.of((UUID)UUID.randomUUID());
        testZk.initPaths(ZooUtil.getRoot((InstanceId)this.instanceId));
        ServerContext context = (ServerContext)EasyMock.createNiceMock(ServerContext.class);
        EasyMock.expect((Object)context.getZooReaderWriter()).andReturn((Object)zrw).anyTimes();
        EasyMock.expect((Object)context.getZooKeepersSessionTimeOut()).andReturn((Object)zooKeeper.getSessionTimeout()).anyTimes();
        EasyMock.expect((Object)context.getInstanceID()).andReturn((Object)this.instanceId).anyTimes();
        List<LegacyPropData.PropNode> nodes = LegacyPropData.getData(this.instanceId);
        for (LegacyPropData.PropNode node : nodes) {
            zrw.putPersistentData(node.getPath(), node.getData(), ZooUtil.NodeExistsPolicy.SKIP);
        }
        try {
            zrw.putPersistentData(ZooUtil.getRoot((InstanceId)this.instanceId) + "/config", new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (KeeperException ex) {
            log.trace("Issue during zk initialization, skipping", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted during zookeeper path initialization", ex);
        }
    }

    @AfterEach
    public void cleanupZnodes() {
        try {
            ZKUtil.deleteRecursive((ZooKeeper)zooKeeper, (String)"/accumulo");
        }
        catch (InterruptedException | KeeperException ex) {
            throw new IllegalStateException("Failed to clean-up test zooKeeper nodes.", ex);
        }
    }

    @Test
    void doUpgrade() {
        ConfigPropertyUpgrader upgrader = new ConfigPropertyUpgrader();
        upgrader.doUpgrade(this.instanceId, zrw);
        ZooPropStore propStore = ZooPropStore.initialize((InstanceId)this.instanceId, (ZooReaderWriter)zrw);
        SystemPropKey sysKey = SystemPropKey.of((InstanceId)this.instanceId);
        log.info("PropStore: {}", (Object)propStore.get((PropStoreKey)sysKey));
        VersionedProperties vProps = propStore.get((PropStoreKey)sysKey);
        if (vProps == null) {
            Assertions.fail((String)("unexpected null returned from prop store get for " + sysKey));
            return;
        }
        Map props = vProps.asMap();
        Assertions.assertEquals((int)5, (int)props.size());
        Assertions.assertEquals((Object)"4", props.get("manager.bulk.retries"));
        Assertions.assertEquals((Object)"10m", props.get("manager.bulk.timeout"));
        Assertions.assertEquals((Object)"10", props.get("manager.bulk.rename.threadpool.size"));
        Assertions.assertEquals((Object)"4", props.get("manager.bulk.threadpool.size"));
        Assertions.assertEquals((Object)"true", props.get("table.bloom.enabled"));
    }
}

