/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.upgrade;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.manager.upgrade.Upgrader9to10;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessNotFoundException;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.server.gc.AllVolumesDirectory;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GCUpgrade9to10TestIT
extends ConfigurableMacBase {
    private static final String OUR_SECRET = "itsreallysecret";
    private static final String OLDDELPREFIX = "~del";
    private static final Upgrader9to10 upgrader = new Upgrader9to10();

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(5L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.INSTANCE_SECRET, OUR_SECRET);
        cfg.setProperty(Property.GC_CYCLE_START, "1000");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    private void killMacGc() throws ProcessNotFoundException, InterruptedException, KeeperException {
        this.getCluster().killProcess(ServerType.GARBAGE_COLLECTOR, (ProcessReference)((Collection)this.getCluster().getProcesses().get(ServerType.GARBAGE_COLLECTOR)).iterator().next());
        ServiceLock.ServiceLockPath path = ServiceLock.path((String)(this.getServerContext().getZooKeeperRoot() + "/gc/lock"));
        ZooReaderWriter zk = this.getServerContext().getZooReaderWriter();
        try {
            ServiceLock.deleteLock((ZooReaderWriter)zk, (ServiceLock.ServiceLockPath)path);
        }
        catch (IllegalStateException e) {
            log.error("Unable to delete ZooLock for mini accumulo-gc", (Throwable)e);
        }
        Assertions.assertNull(this.getCluster().getProcesses().get(ServerType.GARBAGE_COLLECTOR));
    }

    @Test
    public void gcUpgradeRootTableDeletesIT() throws Exception {
        this.gcUpgradeDeletesTest(Ample.DataLevel.METADATA, 3);
    }

    @Test
    public void gcUpgradeMetadataTableDeletesIT() throws Exception {
        this.gcUpgradeDeletesTest(Ample.DataLevel.USER, 3);
    }

    @Test
    public void gcUpgradeNoDeletesIT() throws Exception {
        this.gcUpgradeDeletesTest(Ample.DataLevel.METADATA, 0);
    }

    @Test
    public void gcUpgradeOutofMemoryTest() throws Exception {
        this.killMacGc();
        int numberOfEntries = 100000;
        String longpathname = StringUtils.repeat((String)"abcde", (int)100);
        Assertions.assertEquals((int)500, (int)longpathname.length());
        Assertions.assertEquals((long)4000000L, (long)4000000L);
        long numBatches = (long)(numberOfEntries * longpathname.length()) / 4000000L;
        Assertions.assertTrue((numBatches > 10L && numBatches < 15L ? 1 : 0) != 0, (String)("Expected numBatches between 10 and 15, but was " + numBatches));
        Ample.DataLevel level = Ample.DataLevel.USER;
        log.info("Filling metadata table with lots of bogus delete flags");
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Map<String, String> expected = this.addEntries(c, level.metaTable(), numberOfEntries, longpathname);
            Assertions.assertEquals((int)(numberOfEntries + numberOfEntries / 10), (int)expected.size());
            Range range = MetadataSchema.DeletesSection.getRange();
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            try (Scanner scanner = c.createScanner(level.metaTable(), Authorizations.EMPTY);){
                HashMap actualOldStyle = new HashMap();
                scanner.setRange(range);
                scanner.forEach(entry -> {
                    String strKey = ((Key)entry.getKey()).getRow().toString();
                    String strValue = ((Value)entry.getValue()).toString();
                    actualOldStyle.put(strKey, strValue);
                });
                Assertions.assertEquals((int)expected.size(), (int)actualOldStyle.size());
                Assertions.assertTrue((boolean)Collections.disjoint(expected.keySet(), actualOldStyle.keySet()));
            }
            upgrader.upgradeFileDeletes(this.getServerContext(), level);
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            scanner = c.createScanner(level.metaTable(), Authorizations.EMPTY);
            try {
                HashMap actualNewStyle = new HashMap();
                scanner.setRange(range);
                scanner.forEach(entry -> {
                    String strKey = ((Key)entry.getKey()).getRow().toString();
                    String expectedValue = (String)expected.get(strKey);
                    Assertions.assertNotNull((Object)expectedValue);
                    String strValue = ((Value)entry.getValue()).toString();
                    Assertions.assertEquals((Object)expectedValue, (Object)strValue);
                    actualNewStyle.put(strKey, strValue);
                });
                Assertions.assertEquals((int)expected.size(), (int)actualNewStyle.size());
                Assertions.assertEquals(expected, actualNewStyle);
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
    }

    private void gcUpgradeDeletesTest(Ample.DataLevel level, int count) throws Exception {
        this.killMacGc();
        log.info("Testing delete upgrades for {}", (Object)level.metaTable());
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            HashMap actual;
            Map<String, String> expected = this.addEntries(c, level.metaTable(), count, "somefile");
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            upgrader.upgradeFileDeletes(this.getServerContext(), level);
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            Range range = MetadataSchema.DeletesSection.getRange();
            try (Scanner scanner = c.createScanner(level.metaTable(), Authorizations.EMPTY);){
                actual = new HashMap();
                scanner.setRange(range);
                scanner.forEach(entry -> actual.put(((Key)entry.getKey()).getRow().toString(), ((Value)entry.getValue()).toString()));
                Assertions.assertEquals(expected, actual);
            }
            upgrader.upgradeFileDeletes(this.getServerContext(), level);
            scanner = c.createScanner(level.metaTable(), Authorizations.EMPTY);
            try {
                actual = new HashMap();
                scanner.setRange(range);
                scanner.forEach(entry -> actual.put(((Key)entry.getKey()).getRow().toString(), ((Value)entry.getValue()).toString()));
                Assertions.assertEquals(expected, actual);
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
    }

    private Mutation createOldDelMutation(String path, String cf, String cq, String val) {
        Text row = new Text(OLDDELPREFIX + path);
        Mutation delFlag = new Mutation(row);
        delFlag.put((CharSequence)cf, (CharSequence)cq, (CharSequence)val);
        return delFlag;
    }

    private Map<String, String> addEntries(AccumuloClient client, String table, int count, String filename) throws Exception {
        client.securityOperations().grantTablePermission(client.whoami(), table, TablePermission.WRITE);
        TreeMap<String, String> expected = new TreeMap<String, String>();
        try (BatchWriter bw = client.createBatchWriter(table);){
            for (int i = 0; i < count; ++i) {
                String longpath = String.format("hdfs://localhost:8020/accumulo/tables/5a/t-%08x/%s", i, filename);
                Mutation delFlag = this.createOldDelMutation(longpath, "", "", "");
                bw.addMutation(delFlag);
                expected.put(MetadataSchema.DeletesSection.encodeRow((String)longpath), Upgrader9to10.UPGRADED.toString());
            }
            TableId tableId = TableId.of((String)"5a");
            for (int i = 0; i < count; i += 10) {
                String dirName = String.format("t-%08x", i);
                String longpath = String.format("hdfs://localhost:8020/accumulo/tables/%s/%s", tableId, dirName);
                Mutation delFlag = this.createOldDelMutation(longpath, "", "", "");
                bw.addMutation(delFlag);
                expected.put(MetadataSchema.DeletesSection.encodeRow((String)new AllVolumesDirectory(tableId, dirName).getMetadataEntry()), Upgrader9to10.UPGRADED.toString());
            }
            TreeMap<String, String> treeMap = expected;
            return treeMap;
        }
    }
}

