/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.Objects;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationUtil {
    private static final Logger log = LoggerFactory.getLogger(SerializationUtil.class);

    private SerializationUtil() {
    }

    public static <E> E subclassNewInstance(String classname, Class<E> parentClass) {
        Class<E> cm;
        Class<?> c;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't find class: " + classname, e);
        }
        try {
            cm = c.asSubclass(parentClass);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(classname + " is not a subclass of " + parentClass.getName(), e);
        }
        try {
            return cm.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("can't instantiate new instance of " + cm.getName(), e);
        }
    }

    public static String serializeWritableBase64(Writable writable) {
        byte[] b = SerializationUtil.serializeWritable(writable);
        return Base64.getEncoder().encodeToString(b);
    }

    public static void deserializeWritableBase64(Writable writable, String str) {
        byte[] b = Base64.getDecoder().decode(str);
        SerializationUtil.deserializeWritable(writable, b);
    }

    public static String serializeBase64(Serializable obj) {
        byte[] b = SerializationUtil.serialize(obj);
        return Base64.getEncoder().encodeToString(b);
    }

    public static Object deserializeBase64(String str) {
        byte[] b = Base64.getDecoder().decode(str);
        return SerializationUtil.deserialize(b);
    }

    public static byte[] serializeWritable(Writable writable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SerializationUtil.serializeWritable(writable, baos);
        return baos.toByteArray();
    }

    public static void serializeWritable(Writable obj, OutputStream outputStream) {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(outputStream);
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(outputStream);
            obj.write((DataOutput)out);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error("cannot close", (Throwable)e);
                }
            }
        }
    }

    public static void deserializeWritable(Writable writable, InputStream inputStream) {
        Objects.requireNonNull(writable);
        Objects.requireNonNull(inputStream);
        DataInputStream in = null;
        try {
            in = new DataInputStream(inputStream);
            writable.readFields((DataInput)in);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("cannot close", (Throwable)e);
                }
            }
        }
    }

    public static void deserializeWritable(Writable writable, byte[] objectData) {
        Objects.requireNonNull(objectData);
        SerializationUtil.deserializeWritable(writable, new ByteArrayInputStream(objectData));
    }

    public static void serialize(Serializable obj, OutputStream outputStream) {
        Objects.requireNonNull(outputStream);
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(obj);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error("cannot close", (Throwable)e);
                }
            }
        }
    }

    public static byte[] serialize(Serializable obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SerializationUtil.serialize(obj, baos);
        return baos.toByteArray();
    }

    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"}, justification="okay for test")
    public static Object deserialize(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(inputStream);
            Object object = in.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("cannot close", (Throwable)e);
                }
            }
        }
    }

    public static Object deserialize(byte[] objectData) {
        Objects.requireNonNull(objectData);
        return SerializationUtil.deserialize(new ByteArrayInputStream(objectData));
    }
}

